package client.gongqi.designer.got.node.map;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.tool.GOTHelp;

public class MapRelationItem extends Inner{
	
	public MapRelationItem(){
		super();
	}
	
	
	@SuppressWarnings("unchecked")
	private void doAfterPropertyModifieldTableRelated(Element property, String...args){
		if(property.elementText("Name").equals("Field")){
			Element entityXML = NodeGOT.getEntity(xml);
			java.util.List<Element> tablePro = GOTHelp.getPPAttElementList(entityXML, "Name", "Table");
			if(!tablePro.get(0).elementText("Value").equals("")){
				if(property.elementText("Value").equals("")){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					return ;
				}else{
					String mapFieldName = property.elementText("Value");
					String xpath = "MapFields/MapField[@name='" + mapFieldName + "']";
					List<Element> mapField = entityXML.selectNodes(xpath);
					if(mapField.size()!= 1)
						throw new Error("由MapRelationItem找到了数量不正确的MapField");
					List<Element> extendsPro = GOTHelp.getPPAttElementList(mapField.get(0), "Name", "Extends");
					property.addAttribute("refentityid", extendsPro.get(0).attributeValue("refentityid"));
					property.addAttribute("refinnerid", extendsPro.get(0).attributeValue("refinnerid"));
					doPropertyTrigger(property);
					return;
				}
			}
		}
		
		super.doAfterPropertyModified(property,args);
	}
	
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		String origValue = args[0];
		List<Element> fieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Field");
		List<Element> fieldValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldValue");
		List<Element> relatedFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedField");
		List<Element> relatedValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedValue");
		
		String fieldProValue = fieldPro.get(0).elementText("Value");
		String fieldValueProValue = fieldValuePro.get(0).elementText("Value");
		String relatedFieldProValue = relatedFieldPro.get(0).elementText("Value");
		String relatedValueProValue = relatedValuePro.get(0).elementText("Value");
		
		
		if(!fieldProValue.equals("") && fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		if(!fieldProValue.equals("") && !fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		if(!fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && relatedFieldProValue.equals("") && relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		if(fieldProValue.equals("") && fieldValueProValue.equals("")  && !relatedFieldProValue.equals("") && !relatedValueProValue.equals("")){
			doAfterPropertyModifieldTableRelated(property,args);
			return ;
		}
		
		property.element("Value").setText(origValue);
	}
	
	@Override
	protected void doPropertyTrigger(Element property){
		Element parent = xml.getParent();
		List<Element> parentTablePro = GOTHelp.getPPAttElementList(parent, "Name", "Table");
		List<Element> fieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Field");
		List<Element> relatedFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedField");
		List<Element> fieldValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldValue");
		List<Element> relatedFieldValuePro = GOTHelp.getPPAttElementList(this.xml, "Name", "RelatedValue");
		
		if(relatedFieldPro.get(0).elementText("Value").equals("") && fieldPro.get(0).elementText("Value").equals(""))
			return ;
		if(relatedFieldPro.get(0).elementText("Value").equals("")){
			this.xml.addAttribute("name", fieldPro.get(0).elementText("Value") + "==" + fieldValuePro.get(0).elementText("Value"));
		}else if(fieldPro.get(0).elementText("Value").equals("")){
			String name = parentTablePro.get(0).elementText("Value") + "." + relatedFieldPro.get(0).elementText("Value") + "==" + relatedFieldValuePro.get(0).elementText("Value");
			this.xml.addAttribute("name", name);
		}else{
			String name = "this." + fieldPro.get(0).elementText("Value") + "==" + parentTablePro.get(0).elementText("Value") + "." + relatedFieldPro.get(0).elementText("Value");
			this.xml.addAttribute("name", name);
		}
		
		String name = this.xml.attributeValue("name");
		List<Element> keyFieldPro = GOTHelp.getPPAttElementList(xml, "Name", "KeyField");
		if(keyFieldPro.get(0).elementText("Value").equals("true"))
			this.xml.addAttribute("name",  "(*)" + name);
	}

	
	
	
	
	
}
