package client.gongqi.designer.got.node.menu;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;

public class MenuRefMenu extends Inner{

	public MenuRefMenu(){
		super();
	}
	
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		String origValue = args[0];
		if(property.elementText("Name").equals("Menu")){
			if(isDeadLock(property.elementText("Value"),property.elementText("Value"))){
				GOTMessageDialog.alert("存在循环引用");
				property.element("Value").setText(origValue);
				return ;
			}
		}
		super.doAfterPropertyModified(property,args);
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getParent() == null || this.xml.getParent() == null){
			return false;
		}
		if(srcItem.getParent().asXML().equals(this.xml.getParent().asXML()) && srcItem.getName().equals(this.xml.getName()))
			return true;
		return false;
	}
	
	@SuppressWarnings("unchecked")
	private Boolean isDeadLock(String srcName, String extendsName){	
		if(extendsName.equals("")){
			return false ;
		}
		
//		String xpath = "Menus/Menu[@name='" + extendsName + "']";
//		Element item = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
		Element item = GotXmlDto.getInstance().currentElements("Menus", "name", extendsName).get(0);
		String xpath = "./MenuRefMenu/Properties/Property/Name";
		List<Element> elements = item.selectNodes(xpath);
		List<Element> loopList = new ArrayList<>();
		for (Element element : elements) {
			if(element.getText().equals("Menu")){
				loopList.add(element);
			}
		}
		
		String loopName;
		for (Element loop : loopList){
			loopName = loop.elementText("Value") ;
			
			if(loopName.equals(srcName)){
				return true ;
			}
			
			if(isDeadLock(srcName, loopName))
				return true ;
		}
		
		return false ;
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(srcItem.getName().equals("Menu")){
				return "Menu不允许被拖放到自身";
		}
			
		return "true";
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		
		if(src.getName().equals("Menu")){
			//新建一个MenuRefMenu 设置好属性 返回
			node = super.doAccpDragNew("MenuRefMenu", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}else if(src.getName().equals("MenuItem")){
			node = super.doAccpDragNew("MenuRefMenuItem", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node ;
			
		}else{
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			Element srcXML = src.createCopy();
			srcXML.addAttribute("createdLayer", lay);
			srcXML.addAttribute("modifiedLayer", lay);
			node = NodeFactory.getNode(srcXML);
			return node;
		}
		
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		
		if(node.getName().equals("MenuRefMenu")){
			GOTXMLHelper.setProperty(node,"Menu",fieldName,true);
		}else if(node.getName().equals("MenuRefMenuItem")){
			GOTXMLHelper.setProperty(node,"MenuItem",fieldName,true);
		}
		
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	public void doAfterDragDroped(){
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Menu"),"");
		this.setInnerUniqueName(this.xml);
	}
	
	
}
