package client.gongqi.designer.got.node.query;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.DragAllowManager;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import info.gongqi.got.tool.GOTHelp;

public class QueryWhereItem extends Inner{

	public QueryWhereItem(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("TableField")){
			node = super.doAccpDragNew("QueryOrderByItem", "");
			this.doAccpDragNewAfter(src,node.xml);
			return node;
		}
		
		return null ;
	}
	
	private void doAccpDragNewAfter(Element src, Element node){
		String fieldName = src.attributeValue("name");
		GOTXMLHelper.setProperty(node,"Field",fieldName,true);	
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public String validateAccpDragNew(Element srcItem){
		//被拖动的多个肯定是在同一级的 这样只拿其中一个做判断就可以了
		String sid = NodeGOT.getEntity(DragAllowManager.dragSourceItem).attributeValue("id") ;
		Element tablePro = GOTHelp.getPPAttElement(this.xml.getParent().getParent(), "Name", "Table");
		String tid = tablePro.attributeValue("refentityid");
		if(sid.equals(tid)){
			String newFieldName = srcItem.attributeValue("name");
			
			List<Element> brotherList = this.xml.getParent().elements("QueryAggregation");
			
			for (Element element : brotherList){
				String value = GOTHelp.getPPAttValue(element, "Name", "Field");
				if(value.equals(newFieldName)){
					return "the Property Field must be unique";
				}
			}
			return "true";
		}else{
			return "该字段所在表不被当前查询所引用";
		}
	}
	
	@Override
	public void doAfterDragDroped(){
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Field"));
	}
	
	
	
}
