package client.gongqi.designer.got.node.report;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import com.alibaba.fastjson.JSONObject;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTHelper;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class ReportField extends Inner{

	public ReportField(){
		
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("DataType") ){
			node = super.doAccpDragNew("ReportField", "");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}else if(src.getName().equals("Enum")){
			node = super.doAccpDragNew("ReportField","Enum");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}
		return null;
	}
	
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRuglar, Element baseXML){
		if(this.xml.attributeValue("type").equals("Enum") && propertyName.equals("Extends")){
			if(GOTHelp.getPPAttValue(xml, "Name", "Source").equals("Enum")){
//				Element element = NodeGOT.gotXML.element("DataDictionary").element("Enums");
				Element element = GotXmlDto.getInstance().getCurrentElements("Enums");
				return super.getPropertyItemEditorArray(propertyName,"Enum", element);
			}else{
//				NodeGOT.gotXML.element("DataDictionary").element("DataTypes")
				Element element = GotXmlDto.getInstance().getCurrentElements("DataTypes");
				return super.getPropertyItemEditorArray(propertyName,"DataType[@type='Enum']", element);
			}
		}else if(propertyName.equals("Default") && this.xml.attributeValue("type").equals("Enum")){
			List<String> result = GOTHelper.getDataSourceByTableField(xml);
			List<String> ar = new ArrayList<>();
			for (String item : result){
				JSONObject jsonObject = JSONObject.parseObject(item);
				ar.add(jsonObject.getString("label"));
			}
			
			return ar.size()!=0?ar:super.getPropertyItemEditorArray(propertyName,"",null);
		}else{
			return super.getPropertyItemEditorArray(propertyName, "", null);
		}
	}
	
	private void doAccpDragNewAfer(Element src,Element node){
		String extendName = src.attributeValue("name");
		
		GOTXMLHelper.setProperty(node,"Extends",extendName,true);
		
		node.addAttribute("name", extendName);

		if(node.attributeValue("type").equals("Enum")){
			if(src.getName().equals("Enum")){
				GOTXMLHelper.setProperty(node,"Source","Enum",true);
			}else{
				GOTXMLHelper.setProperty(node,"Source","DataType",true);
			}
		}
		
	}
	
	@Override
	public void doAfterDragDroped(){ 	
		this.doAfterPropertyModified(gongqi.designer.utils.GOTHelper.getProperty(this.xml, "Extends"));
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		if(property.elementText("Name").equals("Source")){
			List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
			extendsPro.get(0).element("Value").setText("");
			doAfterPropertyModified(extendsPro.get(0));
			return;
		}

		String extendName = property.elementText("Value") ;
		
		if(property.elementText("Name").equals("Extends")){
			if(rNode.getInfoValue("Type").equals("Enum")){
				if(extendName.equals("")){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
				}else{
					String source = GOTHelp.getPPAttValue(this.xml, "Name", "Source");
					Element extendNode ;
					if(source.equals("Enum")){
//						String xpath = "DataDictionary/Enums/Enum[@name='" + extendName +"']";
//						extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						extendNode = GotXmlDto.getInstance().currentElements("Enums", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));
					}else if(source.equals("DataType")){
//						String xpath = "DataDictionary/DataTypes/Enum[@DataType='" + extendName +"']";
//						extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						extendNode = GotXmlDto.getInstance().currentElements("DataTypes", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));			
					}
					
				}
			}
		}
		
		super.doAfterPropertyModified(property,args);
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	protected Boolean isIfExtendsRelated(String proName){
		if(proName!= null && proName.equals("Extends"))
			return true;
		
		return false;
	}
	
	
	
}
