package client.gongqi.designer.got.node.table;

import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.Dom4jUtils;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.NumCore;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class Table extends Entity{

	private static String maySqlKeys = "ADD ALL ALTER ANALYZE AND AS ASC ASENSITIVE BEFORE BETWEEN BIGINT BINARY BLOB BOTH BY CALL CASCADE CASE CHANGE CHAR CHARACTER CHECK COLLATE COLUMN CONDITION CONNECTION CONSTRAINT CONTINUE CONVERT CREATE CROSS CURRENT_DATE CURRENT_TIME CURRENT_TIMESTAMP CURRENT_USER CURSOR DATABASE DATABASES DAY_HOUR DAY_MICROSECOND DAY_MINUTE DAY_SECOND DEC DECIMAL DECLARE DEFAULT DELAYED DELETE" +
	"DESC DESCRIBE DETERMINISTIC DISTINCT DISTINCTROW DIV DOUBLE DROP DUAL EACH ELSE ELSEIF ENCLOSED ESCAPED EXISTS EXIT EXPLAIN FALSE FETCH FLOAT FLOAT4 FLOAT8 FOR FORCE FOREIGN FROM FULLTEXT GOTO GRANT GROUP HAVING HIGH_PRIORITY HOUR_MICROSECOND HOUR_MINUTE HOUR_SECOND IF IGNORE IN INDEX INFILE INNER INOUT INSENSITIVE INSERT INT INT1 INT2 INT3 INT4 INT8 INTEGER INTERVAL INTO IS ITERATE JOIN KEY KEYS KILL LABEL LEADING LEAVE LEFT LIKE LIMIT LINEAR" +
	"LINES LOAD LOCALTIME LOCALTIMESTAMP LOCK LONG LONGBLOB LONGTEXT LOOP LOW_PRIORITY MATCH MEDIUMBLOB MEDIUMINT MEDIUMTEXT MIDDLEINT MINUTE_MICROSECOND MINUTE_SECOND MOD MODIFIES NATURAL NOT NO_WRITE_TO_BINLOG NULL NUMERIC ON OPTIMIZE OPTION OPTIONALLY OR ORDER OUT OUTER OUTFILE PRECISION PRIMARY PROCEDURE PURGE RAID0 RANGE READ READS REAL REFERENCES REGEXP RELEASE RENAME REPEAT REPLACE REQUIRE RESTRICT RETURN REVOKE RIGHT RLIKE SCHEMA SCHEMAS SECOND_MICROSECOND SELECT SENSITIVE SEPARATOR SET SHOW SMALLINT SPATIAL SPECIFIC SQL SQLEXCEPTION SQLSTATE SQLWARNING SQL_BIG_RESULT SQL_CALC_FOUND_ROWS SQL_SMALL_RESULT"+
	"SSL STARTING STRAIGHT_JOIN TABLE TERMINATED THEN TINYBLOB TINYINT TINYTEXT TO TRAILING TRIGGER TRUE UNDO UNION UNIQUE UNLOCK UNSIGNED UPDATE USAGE USE USING UTC_DATE UTC_TIME UTC_TIMESTAMP VALUES VARBINARY VARCHAR VARCHARACTER VARYING WHEN WHERE WHILE WITH WRITE X59 XOR YEAR_MONTH ZEROFILL UID ABSTRACT";
	
//	private static Element recIdDataTypeCache = null;
//	private static Element recVersionDataTypeCache = null;
//	
//	private static String recIdDataTypeId;
//	private static String recVersionDataTypeId;
	
	public Table(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doBeforeInsert(){
		
		Element tableFields = xml.element("TableFields");
		
		Element tableIndexs = xml.element("TableIndexes");
		
		Element tableGroupRecordCM = (Element) xml.element("TableFieldGroups").elements("TableFieldGroup").get(1);
		
		this.addLayerForAutoTableItems();
		
		List<Element> elements = GOTXMLHelper.autoTableFields.createCopy().elements("TableField");
		for (Element element : elements) {
			tableFields.add(element.detach());
		}
		
		tableIndexs.add(GOTXMLHelper.autoRecIdxTableIndex.createCopy().detach());
		
		elements = GOTXMLHelper.autoTableFieldGroupItems.createCopy().elements("TableFieldGroupItem");
		for (Element element : elements) {
			tableGroupRecordCM.add(element.detach());
		}
		
/*		Element primaryIndex = GOTHelp.getPPAttElement(this.xml, "Name", "PrimaryIndex");
		
		if(primaryIndex.element("Value") == null ){
			primaryIndex.addElement("Value", "RecIdx");
		}else{
			primaryIndex.element("Value").setText("RecIdx");
		}
		primaryIndex.addAttribute("innerid", "14");*/
		
		super.doBeforeInsert();
	}
	
	@SuppressWarnings("unchecked")
	private void addLayerForAutoTableItems(){
		List<Element> elements = GOTXMLHelper.autoTableFields.elements("TableField");
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
 		for(Element child : elements){
			child.addAttribute("createdLayer", lay);
			child.addAttribute("modifiedLayer", lay);
		}
		
		GOTXMLHelper.autoRecIdxTableIndex.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoRecIdxTableIndex.addAttribute("modifiedLayer", lay);
		GOTXMLHelper.autoRecIdxTableIndex.element("TableIndexItem").addAttribute("createdLayer", lay);
		GOTXMLHelper.autoRecIdxTableIndex.element("TableIndexItem").addAttribute("modifiedLayer", lay);
		List<Element> elements2 = GOTXMLHelper.autoTableFieldGroupItems.elements("TableFieldGroupItem");
		for (Element child : elements2){
			child.addAttribute("createdLayer", lay);
			child.addAttribute("modifiedLayer", lay);
		}
	}
	
	@Override
	public void doAfterInsert(){
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		String unique = this.rNode.getAttributeValue("name","Unique");
		if(unique.equals("brother")){
			setBrotherUniqueName(xml);
		}else if(unique.equals("inner")){
			setInnerUniqueName(xml);	
		}
		setInnerId();
		xml.remove(xml.attribute("saved"));
		this.setUnsaved();
		xml.addAttribute("createdLayer", lay);
	}
	
	@SuppressWarnings("unchecked")
	private void setInnerId(){
		List<Element> tableFieldGroups = xml.element("TableFieldGroups").elements("TableFieldGroup");
		int nextInnerId = 26;
		int base = ObjectContainer.getInstance(LayerLevelManager.class).getLayerLevel(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())*10000;
		for (Element tableFieldGroup : tableFieldGroups)
		{
			tableFieldGroup.addAttribute("id", String.valueOf(base+nextInnerId));
			nextInnerId ++;
			//ZSG新增后（包含拖动新增）遍历所有的TableFieldGroupItem TableFieldGroup硬编码XML的 id需要变为当前层计算的id
			List<Element> tableFieldGroupItems = tableFieldGroup.elements("TableFieldGroupItem");
			for(Element tableFieldGroupItem : tableFieldGroupItems)
			{
				String idStr = tableFieldGroupItem.attributeValue("id");
				int _id = Integer.parseInt(idStr);
				tableFieldGroupItem.attribute("id").setValue(String.valueOf(base+_id));
				
				List<Element> properties = tableFieldGroupItem.element("Properties").elements("Property");
				for(Element property : properties)
				{
					Attribute attr = property.attribute("innerid");
					if(attr != null)
					{
						String innerId = attr.getValue();
						int iid = Integer.parseInt(innerId);
						attr.setValue(String.valueOf(base+iid));
					}
				}
			}
		}
		//ZSG 新增后（包含拖动新增）遍历所有的TableField、TableIndex、TableIndexItem 以及其下面的带有innerid的Property硬编码XML的 id需要变为当前层计算的id
		if(base>0)
		{
			List<Element> tableFields = xml.element("TableFields").elements("TableField");
			for(Element tableField : tableFields)
			{
				String idStr = tableField.attributeValue("id");
				int _id = Integer.parseInt(idStr);
				tableField.attribute("id").setValue(String.valueOf(base+_id));
			}
			
			List<Element> tableIndexes = xml.element("TableIndexes").elements("TableIndex");
			for(Element tableIndex : tableIndexes)
			{
				String idStr = tableIndex.attributeValue("id");
				int _id = Integer.parseInt(idStr);
				tableIndex.attribute("id").setValue(String.valueOf(base+_id));
				
				List<Element> tableIndexItems = tableIndex.elements("TableIndexItem");
				for(Element tableIndexItem : tableIndexItems)
				{
					String _idStr = tableIndexItem.attributeValue("id");
					int __id = Integer.parseInt(_idStr);
					tableIndexItem.attribute("id").setValue(String.valueOf(base+__id));
					
					List<Element> properties = tableIndexItem.element("Properties").elements("Property");
					for(Element property : properties)
					{
						Attribute attr = property.attribute("innerid");
						if(attr != null)
						{
							String innerId = attr.getValue();
							int iid = Integer.parseInt(innerId);
							attr.setValue(String.valueOf(base+iid));
						}
					}
					
				}
			}
		}
		
		Attribute attr = this.xml.attribute("nextInnerId");
		attr.setValue(String.valueOf(base+nextInnerId));
	}
	
	private void addRecordCMDTB(Element tableGroupRecordCM, String isSessionExist){
		
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
	
		GOTXMLHelper.autoCreatedByTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoCreatedByTableFieldGroupItem.addAttribute("modifiedLayer", lay);
		
		GOTXMLHelper.autoCreatedTimeTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoCreatedTimeTableFieldGroupItem.addAttribute("modifiedLayer", lay);
		
		GOTXMLHelper.autoCreatedDateTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoCreatedDateTableFieldGroupItem.addAttribute("modifiedLayer", lay);
		
		GOTXMLHelper.autoModifiedByTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoModifiedByTableFieldGroupItem.addAttribute("modifiedLayer", lay);
		
		GOTXMLHelper.autoModifiedTimeTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoModifiedTimeTableFieldGroupItem.addAttribute("createdLayer", lay);
		
		GOTXMLHelper.autoModifiedDateTableFieldGroupItem.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoModifiedDateTableFieldGroupItem.addAttribute("modifiedLayer", lay);
		
		tableGroupRecordCM.add(GOTXMLHelper.autoCreatedDateTableFieldGroupItem.createCopy().detach());
		tableGroupRecordCM.add(GOTXMLHelper.autoCreatedTimeTableFieldGroupItem.createCopy().detach());
		tableGroupRecordCM.add(GOTXMLHelper.autoCreatedByTableFieldGroupItem.createCopy().detach());
		tableGroupRecordCM.add(GOTXMLHelper.autoModifiedDateTableFieldGroupItem.createCopy().detach());
		tableGroupRecordCM.add(GOTXMLHelper.autoModifiedTimeTableFieldGroupItem.createCopy().detach());
		tableGroupRecordCM.add(GOTXMLHelper.autoModifiedByTableFieldGroupItem.createCopy().detach());
	}
	
	private void removeRecordCMDTB(Element tableGroupRecordCM){
		String xpath = "TableFieldGroupItem[@name='CreatedDate']" ;
		Element element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
		xpath = "TableFieldGroupItem[@name='CreatedTime']" ;
		element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
		xpath = "TableFieldGroupItem[@name='CreatedBy']" ;
		element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
		xpath = "TableFieldGroupItem[@name='ModifiedDate']" ;
		element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
		xpath = "TableFieldGroupItem[@name='ModifiedTime']" ;
		element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
		xpath = "TableFieldGroupItem[@name='ModifiedBy']" ;
		element = (Element) tableGroupRecordCM.selectNodes(xpath).get(0);
		tableGroupRecordCM.remove(element);
		
	}
	
	private void addRecordDTB(Element tableFields, String isSessionExist){
		
		Element createdSessionId;
		
		Element modifiedSessionId;
		
		Element recVersion ;
		
		this.addExtendIdAndLayerForRecordDTB();
		String xpath = "";
		if(isSessionExist.equals("true")){
			xpath = "TableField[@name='CreatedSessionId']" ;
			createdSessionId = (Element) tableFields.selectNodes(xpath).get(0);
			
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedByTableField.createCopy(),createdSessionId);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedTimeTableField.createCopy(),createdSessionId);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedDateTableField.createCopy(),createdSessionId);
			
			xpath = "TableField[@name='ModifiedSessionId']" ;
			modifiedSessionId = (Element) tableFields.selectNodes(xpath).get(0);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedByTableField.createCopy(),modifiedSessionId);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedTimeField.createCopy(),modifiedSessionId);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedDateTableField.createCopy(),modifiedSessionId);
			
		}else{
			xpath = "TableField[@name='RecVersion']" ;
			recVersion = (Element) tableFields.selectNodes(xpath).get(0);
			
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedDateTableField.createCopy(),recVersion);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedTimeTableField.createCopy(),recVersion);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoCreatedByTableField.createCopy(),recVersion);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedDateTableField.createCopy(),recVersion);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedTimeField.createCopy(),recVersion);
			GOTHelp.insertChildAfter(tableFields, GOTXMLHelper.autoModifiedByTableField.createCopy(),recVersion);
			
		}
		
	}
	
	private void removeRecordDTB(Element tableFields){
		
		String xpath = "TableField[@name='CreatedDate']" ;
		Element element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='CreatedTime']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='CreatedBy']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='ModifiedDate']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='ModifiedTime']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='ModifiedBy']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
	}
	
	@SuppressWarnings("unused")
	private void addRecordSession(Element tableFields, String isDTBExist){
		Element modifiedDate ;
		Element createdDate ;
		Element recVersion;
		
		this.addExtendIdAndLayerForRecordSession();
		
		String xpath = "";
		if(isDTBExist.equals("true")){
			xpath = "TableField[@name='CreatedDate']";
			createdDate = (Element) tableFields.selectNodes(xpath).get(0);
			GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.autoCreatedSessionIdTableField.createCopy(),createdDate);
			xpath = "TableField[@name='ModifiedDate']";
			modifiedDate = (Element) tableFields.selectNodes(xpath).get(0);
			GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.autoModifiedSessionIdTableField.createCopy(), createdDate);
		}else{
			xpath = "TableField[@name='RecVersion']";
			recVersion = (Element) tableFields.selectNodes(xpath).get(0);
			GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.autoCreatedSessionIdTableField.createCopy(), recVersion);
			GOTHelp.insertChildBefore(tableFields, GOTXMLHelper.autoModifiedSessionIdTableField.createCopy(), recVersion);
			
		}
	}
	
	private void removeRecordSession(Element tableFields){
		String xpath = "TableField[@name='CreatedSessionId']" ;
		Element element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
		
		xpath = "TableField[@name='ModifiedSessionId']" ;
		element = (Element) tableFields.selectNodes(xpath).get(0);
		tableFields.remove(element);
	}
	
	private void addExtendIdAndLayerForRecordDTB(){
		List<Element> array = new ArrayList<>();

		array.add(GOTXMLHelper.autoCreatedByTableField);
		array.add(GOTXMLHelper.autoCreatedDateTableField);
		array.add(GOTXMLHelper.autoCreatedTimeTableField);
		array.add(GOTXMLHelper.autoModifiedByTableField);
		array.add(GOTXMLHelper.autoModifiedDateTableField);
		array.add(GOTXMLHelper.autoModifiedTimeField);
		
		Element property ;
		String id;
		String dataTypeValue;
		Element dataType ;
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		for (Element tableField : array){
			property = GOTHelp.getPPAttElement(tableField, "Name", "Extends");
			dataTypeValue = property.elementText("Value") ;
//			String xpath = "DataTypes/DataType[@name=" + dataTypeValue + "]" ;
//			dataType = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
			dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", dataTypeValue).get(0);
			id = dataType.attributeValue("id");
			property.addAttribute("refentityid", id);
			tableField.addAttribute("createdLayer", lay);
			tableField.addAttribute("modifiedLayer", lay);
		}
		
	}
	
	private void addExtendIdAndLayerForRecordSession(){
		Element property ;
		Element dataType ;
		property = GOTHelp.getPPAttElement(GOTXMLHelper.autoCreatedSessionIdTableField, "Name", "Extends");
//		String xpath = ".//DataTypes/DataType[@name='CreatedSessionId']" ;
//		dataType = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
		dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", "CreatedSessionId").get(0);
		property.addAttribute("refentityid", dataType.attributeValue("id"));
		property = GOTHelp.getPPAttElement(GOTXMLHelper.autoModifiedSessionIdTableField, "Name", "Extends");
//		xpath = ".//DataTypes/DataType[@name='ModifiedSessionId']" ;
//		dataType = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
		dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", "ModifiedSessionId").get(0);
		property.addAttribute("refentityid", dataType.attributeValue("id"));
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		GOTXMLHelper.autoCreatedSessionIdTableField.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoCreatedSessionIdTableField.addAttribute("modifiedLayer", lay);
		
		GOTXMLHelper.autoModifiedSessionIdTableField.addAttribute("createdLayer", lay);
		GOTXMLHelper.autoModifiedSessionIdTableField.addAttribute("modifiedLayer", lay);
	}
	
//	private void addExtendIdForRec(){
//		
//	}
	
	@Override
	public void doAfterPropertyModified(Element property, String...args){	
		super.doAfterPropertyModified(property,args);
		
		String isDTBExist;
		String isSessionExist;
		
		if(property.elementText("Name").equals("RecordDTB")){
			isSessionExist = GOTHelp.getPPAttValue(this.xml, "Name", "RecordSession");
			if(property.elementText("Value").equals("true")){
				this.addRecordDTB(xml.element("TableFields"), isSessionExist);
				Element element = (Element) xml.element("TableFieldGroups").elements("TableFieldGroup").get(2);
				this.addRecordCMDTB(element,isSessionExist);
			}else
				if(property.elementText("Value").equals("false")){
					this.removeRecordDTB(xml.element("TableFields"));
					Element element = (Element) xml.element("TableFieldGroups").elements("TableFieldGroup").get(2);
					this.removeRecordCMDTB(element);
				}
		}else if(property.elementText("Name").equals("RecordSession") ){
			if(property.elementText("Value").equals("true")){
				isDTBExist = GOTHelp.getPPAttValue(this.xml, "Name", "RecordDTB");
				this.addRecordSession(xml.element("TableFields"),isDTBExist);
				
			}else if(property.elementText("Value").equals("false")){
				this.removeRecordSession(xml.element("TableFields"));
			}
		}else if(property.elementText("Name").equals("LineNumFilter") ){
			String value = property.elementText("Value");
			if(value.equals("SysLineNum")){
				return;
			}
			Element tablePP = GOTHelp.getProperty(this.xml, "Temporary");
			if(tablePP.elementText("Value").equals("true")){
				return;
			}
			
			//新值需要加索引
			String lineNumIndexName = "SysLineNumIdx";
			Element linNumIndexElement = (Element) this.xml.selectSingleNode(
					String.format("./TableIndexes/TableIndex[@name='%s']", lineNumIndexName));
			if(linNumIndexElement != null){
				//原来有值改成无值，需要删除索引
				if(StringUtils.isNotBlank(args[0])){
					String xpath = "./TableIndexItem[@name='" + args[0] + "']";
					Element item = (Element) linNumIndexElement.selectSingleNode(xpath);
					if(item != null){
						TreeItem treeItem_item = FormDataSyn.getTreeItrmByElement(item, FormDataSyn.currentTreeUi);
						linNumIndexElement.remove(item);
						if(treeItem_item != null){
							FormDataSyn.deleteOneTreeItem(treeItem_item);
						}
					}
				}
				
				if(value.equals("")){
					return;
				}
				
				Element tarField = (Element) this.xml.selectSingleNode(
						String.format("./TableFields/TableField[@name='%s']", value));
				
				long nextInnerId = Long.parseLong(this.xml.attributeValue("nextInnerId"));
				String layerName = this.xml.attributeValue("modifiedLayer");
				String TableIndexItem =  "<TableIndexItem name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\">"
						+ "<Properties>"
						+ "<Property innerid=\"\">"
							+ "<Name>Field</Name>"
							+ "<Value/>"
						+ "</Property>"
						+ "<Property>"
							+ "<Name>ArrayItem</Name>"
							+ "<Value/>"
						+ "</Property>"
						+ "<Property>"
							+ "<Name>SortOrder</Name>"
							+ "<Value>ASC</Value>"
						+ "</Property>"
						+ "</Properties>"
					+ "</TableIndexItem>";
				Element tableIndexItemElement = Dom4jUtils.parserElement(TableIndexItem);
				tableIndexItemElement.addAttribute("id", Long.toString(nextInnerId++));
				tableIndexItemElement.addAttribute("name", value);
				tableIndexItemElement.addAttribute("createdLayer", layerName);
				tableIndexItemElement.addAttribute("modifiedLayer", layerName);
				Element fieldProperty = GOTHelp.getProperty(tableIndexItemElement, "Field");
				fieldProperty.addAttribute("innerid", tarField.attributeValue("id"));
				fieldProperty.element("Value").setText(tarField.attributeValue("name"));
				GOTHelp.insertChildBefore(linNumIndexElement, (Element)linNumIndexElement.elements().get(0), tableIndexItemElement);
//				linNumIndexElement.add(tableIndexItemElement.detach());
				TreeItem treeItem = FormDataSyn.getTreeItrmByElement(linNumIndexElement, FormDataSyn.currentTreeUi);
				FormDataSyn.actionSyn(treeItem, NumCore.getId(), tableIndexItemElement, null, 0, "new");

			}
			
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateOther(){
		List<Element> indexList = this.xml.element("TableIndexes").elements("TableIndex");
		for (Element index : indexList){
			if(index.elements("TableIndexItem").size() == 0){
				return "false" + index.attributeValue("name") + ":" + index.getName() + "  应该至少有一个Item" ;
			}
			
			List<Element> elements = index.elements("TableIndexItem");
			for (Element tableIndexItem :  elements){
				String arrayItemProperty = GOTHelper.getPropertyValue(tableIndexItem,"ArrayItem");
				if(arrayItemProperty == null || arrayItemProperty.equals("")){
					Element fieldPro = GOTHelper.getProperty(tableIndexItem,"Field");
					if(fieldPro.attribute("innerid") == null){
						String innerId = fieldPro.attributeValue("innerid");
						String xpath = "TableFields/TableField[@id=" + innerId + "]";
						List<Element> tableFields = this.xml.selectNodes(xpath);
						if(tableFields.size()>0){
							Element tableField = tableFields.get(0);
							if(tableField.attributeValue("type").equals("Component")){
								return "false:" + tableIndexItem.attributeValue("name") + "-->由于其引用了Component字段 所以ArrayItem属性一定要有值";
							}
						}
					}
				}
			}
			
			if(index.attributeValue("id").equals("14")){
//				String xmls = index.asXML();//
				String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
				Element tmp1 = GOTXMLHelper.recIdTableIndex;
				tmp1.addAttribute("createdLayer", lay);
				tmp1.addAttribute("modifiedLayer", lay);
				
				tmp1.element("TableIndexItem").addAttribute("createdLayer", lay);
				tmp1.element("TableIndexItem").addAttribute("modifiedLayer", lay);
				
				Element tmp2 = GOTXMLHelper.recIdTableIndexHelper;
				
				tmp2.addAttribute("createdLayer", lay);
				tmp2.addAttribute("modifiedLayer", lay);
				
				tmp2.element("TableIndexItem").addAttribute("createdLayer", lay);
				tmp2.element("TableIndexItem").addAttribute("modifiedLayer", lay);

			}
		}
		
		String name = xml.attributeValue("name");
		if(name != null && name.indexOf(".") != -1){
			int lastIndex = name.lastIndexOf(".");
			name = name.substring(lastIndex+1);
		}
		
		if(maySqlKeys.contains(name.trim()))
			return "false:" + name + "为关键字";
		char num = name.charAt(0);
		if(num<65 || num>90)
			return "false:" + name + "-->字段名必须以大写字母开头";
		List<Element> tableFields = xml.element("TableFields").elements("TableField");;
		for(Element tableField : tableFields){
			name = tableField.attributeValue("name");
			if(name != null && name.indexOf(".") != -1){
				int lastIndex = name.lastIndexOf(".");
				name = name.substring(lastIndex+1);
			}
			if(maySqlKeys.contains(name.trim()))
				return "false:" + name + "为关键字";
			num = name.charAt(0);
			if(num<65 || num>90)
				return "false:" + name + "-->字段名必须以大写字母开头";
		}
		return "true";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateAttributes(){
		List<Element> tableFields = this.xml.element("TableFields").elements("TableField");
		List<Element> compTableFields = new ArrayList<>();
		for (Element tableField : tableFields){
			if(tableField.attribute("editOnCreate") != null )
				tableField.remove(tableField.attribute("editOnCreate"));
			String _type = tableField.attributeValue("type");
			if(_type.equals("Time")){
				String _name = tableField.attributeValue("name");
				if(_name.indexOf(_type)==-1)
					return "false:"+_name+"必须包含Time（Time类型的TableField其名称必须包含Time）";
			}
			if(tableField.attribute("type") != null && "Component".equals(tableField.attributeValue("type"))){
				compTableFields.add(tableField);
			}
		}
		
		for (Element compTableField : compTableFields){
			Element extendsPro = GOTHelper.getProperty(compTableField,"Extends");
			String entityId = extendsPro.attributeValue("refentityid");
//			String xpath = "DataDictionary/DataTypes/DataType[@id=" + entityId + "]";
//			Element extendsCompDataType = (Element) gotXML.selectNodes(xpath).get(0);
			Element extendsCompDataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", entityId);
			if(extendsCompDataType == null)
				return "false:" + xml.attributeValue("name") + "."+ compTableField.attributeValue("name") + " 为Component类型，其Extends" + Macros.ERROR_PROPERTIES_NULL;
			List<Element> datatypearrayitems = extendsCompDataType.selectNodes(".//DataTypeArrayItem");
			for(Element item : datatypearrayitems){
//				Element refPro = GOTHelper.getProperty(item,"RefDataType");
				String _name = compTableField.attributeValue("name") + "_" + item.attributeValue("name");
				for (Element item2 : tableFields){
					if(item2.attributeValue("name").toLowerCase().equals(_name.toLowerCase()))
						return "false:"+Macros.ERROR_VALUE_NONUNIQUE;
				}
			}
		}
		return "true";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateProperties(Element nodeBeValidated){
		String result = super.validateProperties(nodeBeValidated);
		if(result.equals("true")){
			String xpath = "TableFields/TableField[@type='Enum']";
			List<Element> enums = nodeBeValidated.selectNodes(xpath);
			for (Element _enum : enums){
				Element extendsPro = GOTHelper.getProperty(_enum , "Extends");
				
				if(extendsPro.attribute("refentityid") != null){
					String regular = GOTHelper.getPropertyValue(_enum,"Regular");
					if(!regular.equals(""))
						return "false:Regular与Extends不能同时有值";
				}
			}
		}
		
		String xpath = "TableFields/TableField/Properties/Properties[@innerid]";
		//由于TableField可以复制 所以只检查TableField的所有具有innerId的属性关联是否存在
		List<Element> allInnerIdProperties = nodeBeValidated.selectNodes(xpath);
		for(Element innerIdProperty : allInnerIdProperties){
			String innerId = innerIdProperty.attributeValue("innerid");
			String _name = innerIdProperty.elementText("Value");
			//目前innerId只有可能是TableField
			xpath = "TableFields/TableField[@id='" + innerId + "'][@name='" + _name + "']" ;
			List<Element> tableFields = nodeBeValidated.selectNodes(xpath);
			if(tableFields.size()<=0)
				return "false属性" + innerIdProperty.elementText("Name") + "关联的字段不存在";
		}
		
		xpath = "TableIndexes/TableIndex";
		List<Element> tableIndexes = nodeBeValidated.selectNodes(xpath);
		
		for (Element tableIndex : tableIndexes){
			List<Element> tableIndexItems = tableIndex.elements("TableIndexItem");
			for (Element tableIndexItem : tableIndexItems){
//				String field = GOTHelper.getPropertyValue(tableIndexItem,"Field");
				String _name = tableIndexItem.attributeValue("name");
				
				List<Element> results = tableIndexItem.selectNodes("TableIndexItem[@name='" + _name + "']");
				if(results.size()>1){
					return "false"+ tableIndex.attributeValue("name") + "下有多个名称为:" + _name + "的TableIndexItem";
				}
			}
		}
		
		return "true";
	}
	
	@Override
	public String allowPropertyEdit(String propertyName){
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		if(propertyName.equals("RecordSession") || propertyName.equals("RecordDTB")){
			if(!this.xml.attributeValue("createdLayer").equals(lay))
				return Macros.INFO_FALSE;
		}
		
		if(propertyName.equals("PrimaryIndex")){
			return Macros.INFO_FALSE;
		}
		return super.allowPropertyEdit(propertyName);
	}
	
}
