package client.gongqi.designer.got.node.table;

import gongqi.designer.services.LayerService;
import gongqi.designer.utils.Dom4jUtils;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.datatype.GongqiDataType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.event.MouseRightMenuEvent;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTHelper;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

import com.alibaba.fastjson.JSONObject;

public class TableField extends Inner{

	public TableField(){
		super();
	}
	
	@Override
	protected void addRelation(Element property){
		super.addRelation(property);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		if(property.elementText("Name").equals("Source")){
			List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
			extendsPro.get(0).element("Value").setText("");
			doAfterPropertyModified(extendsPro.get(0));
			return;
		}
			
		String extendName = property.elementText("Value") ;
		if(property.elementText("Name").equals("Extends")){
			if(rNode.getInfoValue("Type").equals("Enum")){
				if(extendName.equals("")){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
				
				}else{
					String source = GOTHelp.getPPAttValue(this.xml, "Name", "Source");

					if(source.equals("Enum")){
//						String xpath = "DataDictionary/Enums/Enum[@name='" + extendName + "']";
//						Element extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						Element extendNode = GotXmlDto.getInstance().currentElements("Enums", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));
						
					}else if(source.equals("DataType")){
//						String xpath = "DataDictionary/DataTypes/DataType[@name='" + extendName + "']";
//						Element extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						Element extendNode = GotXmlDto.getInstance().currentElements("DataTypes", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));
						
					}
				
				}
			}
			
			if (GongqiDataType.TypeDecimal.getValue().equals(rNode.getInfoValue("Type"))) {
				List<Element> list = GotXmlDto.getInstance().currentElements("DataTypes", "name", extendName);
				if(!list.isEmpty()){
					Element extendNode = list.get(0);
					if ("DataType".equals(extendNode.getName()) && "SysLineNum".equals(extendNode.attributeValue("name"))) {
						Element tableFieldElement = property.getParent().getParent();
						Element tableEntity = getEntity(property);
						
						Element indexes = tableEntity.element("TableIndexes");
						TreeItem treeItem = FormDataSyn.getTreeItrmByElement(indexes, null);
						
						String lineNumIndexName = "SysLineNumIdx";
						Element linNumIndexElement = (Element) tableEntity.selectSingleNode(
								String.format("./TableIndexes/TableIndex[@name='%s']", lineNumIndexName));
						if (linNumIndexElement == null) {
							String layerName = tableFieldElement.attributeValue("modifiedLayer");
							long nextInnerId = Long.parseLong(tableEntity.attributeValue("nextInnerId"));
							String tableIndexTemplate = 
									"<TableIndex name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\">"
									+ "<Properties>"
										+ "<Property>"
											+ "<Name>Unique</Name>"
											+ "<Value>false</Value>"
										+ "</Property>"
									+ "</Properties>"
									+ "<TableIndexItem name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\">"
										+ "<Properties>"
											+ "<Property innerid=\"\">"
												+ "<Name>Field</Name>"
												+ "<Value/>"
											+ "</Property>"
											+ "<Property>"
												+ "<Name>ArrayItem</Name>"
												+ "<Value/>"
											+ "</Property>"
											+ "<Property>"
												+ "<Name>SortOrder</Name>"
												+ "<Value>ASC</Value>"
											+ "</Property>"
											+ "</Properties>"
										+ "</TableIndexItem>"
									+ "</TableIndex>";
							Element tableIndexElement = Dom4jUtils.parserElement(tableIndexTemplate);
							tableIndexElement.addAttribute("id", Long.toString(nextInnerId++));
							tableIndexElement.addAttribute("name", lineNumIndexName);
							tableIndexElement.addAttribute("createdLayer", layerName);
							tableIndexElement.addAttribute("modifiedLayer", layerName);
							Element tableIndexItemElement = tableIndexElement.element("TableIndexItem");
							tableIndexItemElement.addAttribute("id", Long.toString(nextInnerId++));
							tableIndexItemElement.addAttribute("name", tableFieldElement.attributeValue("name"));
							tableIndexItemElement.addAttribute("createdLayer", layerName);
							tableIndexItemElement.addAttribute("modifiedLayer", layerName);
							Element fieldProperty = GOTHelp.getProperty(tableIndexItemElement, "Field");
							fieldProperty.addAttribute("innerid", tableFieldElement.attributeValue("id"));
							fieldProperty.element("Value").setText(tableFieldElement.attributeValue("name"));
							tableEntity.element("TableIndexes").add(tableIndexElement.createCopy());
							tableEntity.addAttribute("nextInnerId", Long.toString(nextInnerId));
							if(treeItem != null){
								FormDataSyn.restore(treeItem, tableEntity.element("TableIndexes"), false);
							}
						}
					}
				}
			}
		}
		super.doAfterPropertyModified(property,args);
	}
	
	@Override
	protected String getPropertyStrict(String propertyName){
		String _type = this.xml.attributeValue("type");
		if(_type.equals("Long") && propertyName.equals("Default")){
			return "0-9";
		}else if(_type.equals("Decimal") && propertyName.equals("Default")){
			return ".0-9";
		}
		return null;
	}
	
	//覆写了protected方法 它只在Node内部被调用
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRuglar, Element baseXML){
		if(this.xml.attributeValue("type").equals("Enum") && propertyName.equals("Extends")){
			if(GOTHelp.getPPAttValue(xml, "Name", "Source").equals("Enum")){
//				Element element = (Element) NodeGOT.gotXML.element("DataDictionary").elements("Enums").get(0);
				Element element = GotXmlDto.getInstance().getCurrentElements("Enums");
				return super.getPropertyItemEditorArray(propertyName,"Enum", element);
			}else{
//				Element element = (Element) NodeGOT.gotXML.element("DataDictionary").elements("DataTypes").get(0);
				Element element = GotXmlDto.getInstance().getCurrentElements("DataTypes");
				return super.getPropertyItemEditorArray(propertyName,"DataType[@type='Enum']", element);
			}
		}else if(propertyName.equals("Default") && this.xml.attributeValue("type").equals("Enum")){
			List<String> result = GOTHelper.getDataSourceByTableField(xml);
			List<String> ar = new ArrayList<>();
			for(String item : result){
				JSONObject jsonObject = JSONObject.parseObject(item);
				ar.add(jsonObject.getString("label"));
			}
			
			return ar.size()!=0?ar:super.getPropertyItemEditorArray(propertyName, "", null);
		}else if(propertyName.equals("Default") && this.xml.attributeValue("type").equals("Boolean")){
			List<String> lists = new ArrayList<>();
			lists.add("true");
			lists.add("false");
			return lists;
		}else{
			return super.getPropertyItemEditorArray(propertyName, "", null);
		}
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getParent() == null){
			return false;
		}
		if(srcItem.getParent().asXML().equals(this.xml.getParent().asXML()) && srcItem.getName().equals(this.xml.getName()))
			return true;
		return false;
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("Enum")){
			node = super.doAccpDragNew("TableField","Enum");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
			
		}else if(src.getName().equals("DataType")){
			node = super.doAccpDragNew("TableField",src.attributeValue("type"));
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}else if(src.getName().equals("TableField")){
			Element srcTableField = src.createCopy();
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			srcTableField.addAttribute("createdLayer", lay);
			srcTableField.addAttribute("modifiedLayer", lay);
			node = NodeFactory.getNode(srcTableField);
			return node;
		}
		
		return null;
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		String extendName = src.attributeValue("name");
		
		GOTXMLHelper.setProperty(node,"Extends",extendName,true);
		
		if(extendName.contains(".")){
			String[] name = extendName.split("\\.");
			extendName = name[name.length - 1];
		}
		
		node.addAttribute("name", extendName);
		
		if(node.attributeValue("type").equals("Enum")){
			if(src.getName().equals("Enum")){
				GOTXMLHelper.setProperty(node,"Source","Enum",true);
			}else{
				GOTXMLHelper.setProperty(node,"Source","DataType",true);
			}
		}else if(node.attributeValue("type").equals("Component")){
			node.addAttribute("editOnCreate", "true");
		}
	}
	
	@Override
	public Element getInsertChildBefore(Element parent){
		Element entityTable = parent.getParent();
		//ZSG 根据新的属性 来计算原RecordDTB和RecordSession
		String isDTBExist = GOTHelp.getPPAttValue(entityTable, "Name", "RecordCM");//GOTHelp.getPPAttValue(entityTable, "Name", "RecordDTB");
		if("None".equals(isDTBExist))
			return null;
		String isSessionExist = "false";
		if("DateTimeBy".equals(isDTBExist))
		{
			isSessionExist = "false";isDTBExist = "true";
		}
		else if("Session".equals(isDTBExist))
		{
			isSessionExist = "true";isDTBExist = "false";
		}
		else
		{
			isSessionExist = "true";isDTBExist = "true";
		}
		//String isSessionExist = GOTHelp.getPPAttValue(entityTable, "Name", "RecordSession");
		if(isDTBExist.equals("true") && isSessionExist.equals("true") ){
			Element element = (Element) parent.selectNodes("/TableField[@name='CreatedSessionId']").get(0);
			return element;
			
		}else if(isDTBExist.equals("true")){
			List<?> elList = parent.selectNodes("TableField[@name='CreatedDate']");
			if(elList.isEmpty()){
				return null;
			}else{
				return (Element) elList.get(0);
			}
		}else if(isSessionExist.equals("true")){
			List<?> elList = parent.selectNodes("/TableField[@name='CreatedSessionId']");
			if(elList.isEmpty()){
				return null;
			}else{
				return (Element) elList.get(0);
			}
			
		}else{
			List<?> elList = parent.selectNodes("/TableField[@name='RecVersion']");
			if(elList.isEmpty()){
				return null;
			}else{
				return (Element) elList.get(0);
			}
		}
	}
	
	@Override
	public void doAfterDragDroped(){
		//此处代码会大大延长拖拽后的处理时间，此处现在是调用的统一方法 
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Extends"));
	}
	
	@Override
	public String allowPropertyEdit(String propertyName){
		if(propertyName.equals("NotNull") && rNode.getInfoValue("Type").equals("Component")){
			return Macros.INFO_FALSE ;
		}
		
		if(propertyName.equals("Extends") && this.xml.attributeValue("type").equals("Component")){
			if(this.xml.attribute("editOnCreate") != null )
				return Macros.INFO_TRUE;
			return Macros.INFO_FALSE;
		}
		if("NumOfDecimals".equals(propertyName) || "StringSize".equals(propertyName) || "ChangeCase".equals(propertyName) ||
				"Trim".equals(propertyName)) {
			Element extendsPro = GOTHelper.getProperty(this.xml, "Extends");
			if (StringUtils.isNotBlank(extendsPro.attributeValue("refentityid"))) {
				return Macros.INFO_FALSE;
			}
			/*if(!"".equals(extendsPro.attributeValue("refentityid")))
			{
				return Macros.INFO_FALSE;
			}*/
		}
		return super.allowPropertyEdit(propertyName) ;
	}
	
	@Override
	public String allowEdit(){
		String superresult = super.allowEdit();
		if(!superresult.equals("true")){
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if(this.xml.attribute("createdLayer") != null  && !this.xml.attributeValue("createdLayer").equals(lay))
				superresult = "该节点不属于当前层,不允许编辑";		
		}
		return superresult;
	}
	
	@Override
	protected Boolean isIfExtendsRelated(String proName){
		if(proName != null  && proName.equals("Extends"))
			return true;
		return false;
	}
	
	@Override
	public Boolean editOnCreate(){
		if(this.xml.attributeValue("type").equals("Component")){
			return true;
		}
		return false;
	}
	
	@Override
	public Boolean validateNewName(String newName){
		String key = NodeGOT.getEntity(this.xml).attributeValue("id");
		List<String> nv = MouseRightMenuEvent.deletedNodesCache.get(key);
		if(nv != null){
			for (String n :  nv){
				if(n.equals(newName))
					return false;
			}
		}
		String _type = this.xml.attributeValue("type");

		if(_type.equals("Date")){
			if(newName.indexOf("Time") != -1)
				return false;
		}
		
		if(validateNewNameString.toLowerCase().contains(newName.toLowerCase())){
			return false;
		}
		
		return super.validateNewName(newName);
	}
	
	
}
