package client.gongqi.designer.got.node.table;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;

public class TableFieldGroup extends Inner{

	public TableFieldGroup(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		
		if(src.getName().equals("TableField")){
			String type = "";
			if(this.xml.attributeValue("type").equals("AutoLookup"))
				type = "AutoLookup";
			
			node = super.doAccpDragNew("TableFieldGroupItem",type);
			this.doAccpDragNewAfer(src,node);
			return node;
		}else{
			GOTMessageDialog.alert("TableIndex 不允许非TableField的拖拽放置");
		}
		return null ;
	}
	
	private void doAccpDragNewAfer(Element src, NodeGOT node){
		String fieldName = src.attributeValue("name") ;
		
		GOTXMLHelper.setProperty(node.xml,"Field",fieldName,true);
		
		node.xml.addAttribute("name", fieldName) ;
	}
	
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(!srcItem.getName().equals("TableField")){
			return "excepted a TableField Node in same Entity";	
		}
		
		if(this.xml.attributeValue("name").equals("RecordCM")){
			return "don't place here";
		}
		
		if(srcItem.attributeValue("type").equals("Component") ){
			return Macros.ERROR_DRAG_COMPONENT;
		}
		
		String newFieldName = srcItem.attributeValue("name");
		
		List<Element> brotherList = this.xml.elements("TableFieldGroupItem"); 
		
		for (Element element : brotherList){
			if(GOTHelp.getPPAttValue(element, "Name", "Field").equals(newFieldName)){
				return "the value of Property Field must be unique";
			}
		}
		
		return "true";
	}
	
	
	
}
