package client.gongqi.designer.got.node.table;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;

public class TableIndexItem extends Inner{

	public TableIndexItem(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		
		if(src.getName().equals("TableField")){
			node = super.doAccpDragNew("TableIndexItem", "");
			this.doAccpDragNewAfer(src,node);
			return node;
		}else{
			GOTMessageDialog.alert("TableIndex 不允许非TableField的拖拽放置");
		}
		return null ;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		//ZSG 此处根据zyf描述 下面这段逻辑可以使用解析器描述？但是看以下逻辑解析器描述不了 再确认一下
		if(propertyName.equals("ArrayItem")){
			Element fieldPro = GOTHelper.getProperty(this.xml,"Field");
			if(fieldPro.attribute("innerid") != null ){
				String innerId = fieldPro.attributeValue("innerid");
				Element table = NodeGOT.getEntity(this.xml);
				String xpath = "TableFields/TableField[@id='" + innerId + "']";
				List<Element> tableFields = table.selectNodes(xpath);
				if(tableFields.size()>0){
					Element tableField = tableFields.get(0);
					if(tableField.attributeValue("type").equals("Component")){
						Element extendsPro = GOTHelper.getProperty(tableField,"Extends");
						if(extendsPro.attribute("refentityid") != null ){
							String entityId= extendsPro.attributeValue("refentityid");
//							xpath = "DataDictionary/DataTypes/DataType[@id='" + entityId + "']";
//							List<Element> dataTypes = NodeGOT.gotXML.selectNodes(xpath);
							Element dataTypes = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", entityId);
							if(dataTypes != null){
								Element dataType = dataTypes;
								List<Element> dataTypeArrayItems = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
								List<String> array = new ArrayList<>();
								for(Element dataTypeArrayItem : dataTypeArrayItems){
									array.add(dataTypeArrayItem.attributeValue("name"));
								}
								return array ;
							}
						}
					}
				}
			}
		}
		
		return super.getPropertyItemEditorArray(propertyName,fixedRegular,fixedBaseXML);
	}
	
	private void doAccpDragNewAfer(Element src, NodeGOT node){
		String fieldName = src.attributeValue("name") ;
		
		GOTXMLHelper.setProperty(node.xml,"Field",fieldName,true);
		
		node.xml.addAttribute("name", fieldName) ;
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(srcItem.getName().equals("TableField")){
			return "excepted a TableField Node in same Entity";	
		}
		
		return "true";
	}
	
	public void doAfterDragDroped(){
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Field"));
	}
	
	public void doAfterPropertyModified(Element property, String...args){
		String qname = property.elementText("Name");
		if(qname.equals("ArrayItem")){
			String fieldProValue = GOTHelper.getPropertyValue(this.xml,"Field");
			this.xml.addAttribute("name", fieldProValue + "." + property.elementText("Value"));
			return;
		}
		super.doAfterPropertyModified(property,args);
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public String allowPropertyEdit(String propertyName){
		if(propertyName.equals("ArrayItem")){
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			//ZSG 由attribute改成了attributeValue
			if(this.xml.attributeValue("createdLayer") != null  && !this.xml.attributeValue("createdLayer").equals(lay))
				return Macros.INFO_FALSE;
			
			Element fieldPro = GOTHelper.getProperty(this.xml,"Field");
			if(fieldPro.attribute("innerid") != null ){
				String innerId = fieldPro.attributeValue("innerid") ;
				Element table = NodeGOT.getEntity(this.xml);
				String xpath = "TableFields/TableField[@id='" + innerId + "']";
				List<Element> tableFields = table.selectNodes(xpath);
				if(tableFields.size()>0){
					Element tableField = tableFields.get(0);
					if(tableField.attributeValue("type").equals("Component")){
						return Macros.INFO_TRUE;
					}
				}
			}
			return Macros.INFO_FALSE;
		}
		return super.allowPropertyEdit(propertyName);
	}
	
	
	
}
