package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;

public class ResolverValidatorAttrMatch extends ResolverValidator{

	public  ResolverValidatorAttrMatch(){
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<Object> validateResolver(Element item, String url){
		ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
		List<Attribute> attrs = item.attributes();
		List<Element> rAttrs = rNode.getAttributes();
		List<Object> result = new ArrayList<>();
		for (Attribute attr : attrs){
			if(matchAttrRedundant(attr,rAttrs)){
				result.add(url + ":多出ATTR:" +attr.getName());
			}
		}
		
		for (Element rAttr : rAttrs){
			if("required".equals(rAttr.elementText("Use"))){
				if(matchAttrLack(rAttr,attrs)){
					result.add(url + ":缺少ATTR:" +rAttr.elementText("Name"));
				}
			}
		}
		
		if("FormItem".equals(item.getName()) && "FieldGroup".equals(item.attributeValue("type"))){
			String refInfo = matchATTRFieldGroup(item);
			if(refInfo != ""){
				result.add(0,url + refInfo);
			}
		}
		
		return result;
	}
}
