package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;

public class ResolverValidatorModify extends ResolverValidator{

	
	public ResolverValidatorModify(){
		super();
	}
	
	@Override
    @SuppressWarnings("unchecked")
	public List<Object> validateResolver(Element item, String url){
    	ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
		
		List<Element> propertyList = item.element("Properties").elements("Property");
		
		List<Element> rPropertyList = rNode.getProperties();
		
		List<Object> result = new ArrayList<>();
		
		Boolean modified = false;
		
		for (Element property : propertyList){
			if(matchPropertyRedundant(property,rPropertyList)){
				result.add(url + ":多出:Property:" + property.elementText("Name") + ":已修改");
				GOTXMLHelper.deletePropery(item, property.elementText("Name"));
				modified = true;
			}
		}
		
		for (Element rProperty : rPropertyList){
			if(matchPropertyLack(rProperty,propertyList)){
				result.add(url + ":缺少:Property:" + rProperty.elementText("Name") + ":已修改");
				//ZSG
				if(!extendsValue(propertyList) && "ifExtends".equals(rProperty.elementText("Nonblank"))){
					//有继承并且Nonblank是ifExtends的
					GOTXMLHelper.addPropertyUnCheck(item, rProperty.elementText("Name"), "");
				}else{
					GOTXMLHelper.addPropertyUnCheck(item, rProperty.elementText("Name"), rProperty.elementText("Default"));
				}
				modified = true;
			}
		}
		
		if(modified){
			final Element entity = getEntity(item);
			Display.getDefault().syncExec(new Runnable() {
				@Override
				public void run() {
					TreeItem treeItem = FormDataSyn.getTreeItrmByElement(entity, null);
					if(treeItem != null){
						GotXmlDto.getInstance().updateEntityElement(entity);
						FormDataSyn.setUnSave(treeItem);
					}
				}
			});
		}
			
		
		return result;
	}
	
	//是否有继承
	private boolean extendsValue(List<Element> propertyList){
		for (Element element : propertyList) {
			String ex = element.elementText("Extends");
			if(ex != null && !"".equals(ex)){
				return true;
			}
		}
		return false;
	}
}
