package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;

public class ResolverValidatorPrompt extends ResolverValidator{

	public ResolverValidatorPrompt(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<Object> validateResolver(Element item, String url){
		ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
		
		List<Element> propertyList = item.element("Properties").elements("Property");
		
		List<Element> rPropertyList = rNode.getProperties();
		
		List<Object> result = new ArrayList<>();
		
		for(Element property : propertyList){
			if(matchPropertyRedundant(property,rPropertyList)){
				result.add(url + ":多出:Property:" + property.elementText("Name"));
			}
		}
		
		for (Element rProperty : rPropertyList){
			if(matchPropertyLack(rProperty,propertyList)){
				result.add(url + ":缺少:Property:" + rProperty.elementText("Name"));
			}
		}
		
		if(item.attribute("version") != null){
			String dtbInfo = matchDTB(item);
			if(!dtbInfo.equals("") ){
				result.add(0, url + dtbInfo);
			}
		}
		return result;
	}
	
}
