package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;

public class ResolverValidatorSequence extends ResolverValidator{

	public ResolverValidatorSequence(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<Object> validateResolver(Element item, String url){
		ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
		
		List<Element> propertyList = item.element("Properties").elements("Property");
		
		List<Element> rPropertyList = rNode.getProperties();
		
		List<Object> result = new ArrayList<>();
		
		Boolean isMatch = true;
		
		for (Element property : propertyList){
			if(matchPropertyRedundant(property,rPropertyList)){
				result.add(url + ":多出Property:" + property.elementText("Name"));
				isMatch = false;
				break;
			}
		}
		
		for (Element rProperty : rPropertyList){
			if(matchPropertyLack(rProperty,propertyList)){
				result.add(url + ":缺少Property:" +rProperty.elementText("Name"));
				isMatch = false;
				break;
			}
		}
		
		if(!isMatch){
			result.add(0,url + ":该节点与解析器不匹配，请先执行匹配操作");
		}else{
			if(!isSequenceMatch(propertyList,rPropertyList))
				result.add(url + ":顺序不一致");
		}
		
		return result;
	}
}
