package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;

public class ResolverValidatorSort extends ResolverValidator{

	public ResolverValidatorSort(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<Object> validateResolver(Element item, String url){
		ResolverNode rNode = ResolverNodeFactory.getRNodeByItem(item);
		
		List<Element> propertyList = item.element("Properties").elements("Property");
		
		List<Element> rPropertyList = rNode.getProperties();
		
		List<Object> result = new ArrayList<>();
		
		Boolean isMatch = true;
		
		for (Element property : propertyList){
			if(matchPropertyRedundant(property,rPropertyList)){
				result.add(url + ":多出Property:" + property.elementText("Name"));
				isMatch = false;
				break;
			}
		}
		
		for (Element rProperty : rPropertyList){
			if(matchPropertyLack(rProperty,propertyList)){
				result.add(url + ":缺少Property:" +rProperty.elementText("Name"));
				isMatch = false;
				break;
			}
		}
		
		if(!isMatch){
			result.add(0, url + ":该节点与解析器不匹配，请先执行匹配操作");
		}else{
			if(!isSequenceMatch(propertyList,rPropertyList)){
				item.remove(item.element("Properties"));
				Element p = DocumentHelper.createElement("Properties");
				if(item.elements().size() > 0){
					GOTHelp.insertChildBefore(item, (Element)item.elements().get(0), p);
				}else{
					item.add(p);
				}

				Element base = item.element("Properties");
				for(Element rProperty : rPropertyList){
					Element property = null;
					for (Element propertys : propertyList){
						if(propertys.elementText("Name").equals(rProperty.elementText("Name"))){
							property = propertys;
							break;
						}
					}
					if(property != null){
						base.add(property.detach());
					}
				}
				if(NodeGOT.isEntity(item)){
					supplyDTB(base,propertyList);
				}
				result.add(url + "已调整顺序");
				
				final Element entity = getEntity(item);
				if(entity != null){
					entity.addAttribute("saved", "0");
					GotXmlDto.getInstance().updateEntityElement(entity);
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							TreeItem treeItem = FormDataSyn.getTreeItrmByElement(entity, null);
							FormDataSyn.setUnSave(treeItem);
						}
					});
				}
			}
		}
		
		return result;
	}
	
	private void supplyDTB(Element base, List<Element>propertyList){
		Element propertyDTB = getElementByNameText(propertyList, "CreatedDate");
		base.add(propertyDTB.detach());
		propertyDTB = getElementByNameText(propertyList, "CreatedTime");
		base.add(propertyDTB.detach());
		propertyDTB = getElementByNameText(propertyList, "CreatedBy");
		base.add(propertyDTB.detach());
		propertyDTB = getElementByNameText(propertyList, "ModifiedDate");
		base.add(propertyDTB.detach());
		propertyDTB = getElementByNameText(propertyList, "ModifiedTime");
		base.add(propertyDTB.detach());
		propertyDTB = getElementByNameText(propertyList, "ModifiedBy");
		base.add(propertyDTB.detach());
	}
	
	private Element getElementByNameText(List<Element>propertyList, String value){
		for (Element element : propertyList) {
			if(element.elementText("Name").equals(value)){
				return element;
			}
		}
		return null;
	}
}
