package client.gongqi.designer.got.validate;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.event.ValidationResult;
import client.gongqi.designer.event.ValidationResultEvent;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;

public class ResolverValidatorValue implements IValidator{

	private final String innerUrl = "/Properties/Property/";
	public ResolverValidatorValue(){
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Object> validateResolver(Element item, String url) {
		NodeGOT node = NodeFactory.getNode(item);
	
		List<Element> propertyList = item.element("Properties").elements("Property");
		
		ValidationResultEvent vre;
		
		List<Object> result = new ArrayList<>();
		
		for(Element property : propertyList){
			vre = node.validateProperty(property);
			if(vre!= null && vre.results != null){
				for (ValidationResult r : vre.results){
					result.add(url + innerUrl + property.elementText("Name") + ":" + r.errorMessage);
				}
			}

		}
		return null;
	}

}
