package client.gongqi.designer.toolsgot;

import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class GOTXMLHelper {
	
	public static String dataTypeRelationXMLString = 
			"<DataTypeRelation name='Relation' createdLayer='sys' modifiedLayer='sys'>"
			 + " <Properties>"
			 + " <Property>"
			 + "  <Name>Table</Name>"
				+ "   <Value></Value>"
				+ " </Property>"
				+ " <Property>"
				 + "  <Name>Field</Name>"
					+ "   <Value></Value>"
					+ " </Property>"
				+ " <Property>"
				  + " <Name>FilterField</Name>"
				  + " <Value/>"
				+ " </Property>"
				+ " <Property>"
				  + " <Name>RefMenuItem</Name>"
				  + " <Value/>"
				+ " </Property>"
				+ " <Property>"
				  + " <Name>ValidateDelete</Name>"
				  + " <Value>true</Value>"
				+ " </Property>"
			  + " </Properties>"
			+ " </DataTypeRelation>";
	
	public static Element dataTypeRelationXML = createElementByXMLString(dataTypeRelationXMLString);

	public static Element createElement(String name){
		String xml = "<" + name + " />";
		Document document = null;
		try {
			document = DocumentHelper.parseText(xml);
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		return root;
	}
	
	public static Element createElementByXMLString(String xml){
		Document document = null;
		try {
			document = DocumentHelper.parseText(xml);
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		return root;
	}
	
	public static void addDateAndTime(Element baseXML){
			addProperty(baseXML, "CreatedDate", "");
			addProperty(baseXML, "CreatedTime", "");
			addProperty(baseXML, "CreatedBy", "");
			addProperty(baseXML, "ModifiedDate", "");
			addProperty(baseXML, "ModifiedTime", "");
			addProperty(baseXML, "ModifiedBy", "");
	}
	
	public static void addProperty(Element baseXML, String name, String value){
		Element ps;
		if(baseXML.element("Properties") != null){
			ps = baseXML.element("Properties");
		}else{
			baseXML.addElement("Properties", "");
			ps = baseXML.element("Properties");
		}
			
		@SuppressWarnings("unchecked")
		List<Element> proList = ps.elements("Property");
		Boolean isExist = false;
		
		for(Element pro : proList){
			if(pro.elementText("Name").equals(name)){
				isExist = true ;
				if(pro.element("Value") == null ){
					pro.addElement("Value", value);
				}else{
					pro.element("Value").setText(value);
				}
				break;
			}
		}

		if(!isExist){
			 String xml = "<Property>" +
				"<Name>"+name+
				"</Name>"	 +
				"<Value>"+value+
				"</Value>"   +
				"</Property>";
			 ps.add(createElementByXMLString(xml).detach());
		}
	}
	
	@SuppressWarnings("unchecked")
	public static void setProperty(Element baseXML, String name, String value, Boolean overwrite){
		List<Element> propertyList = baseXML.element("Properties").elements("Property");
		
		for(Element property : propertyList){
			if(property.elementText("Name").equals(name)){
				if(overwrite){
					property.element("Value").setText(value);
				}else{
					if(property.elementText("Value").equals("")){
						property.element("Value").setText(value);
					}
				}
			}
		}
	}
	
	public static String getPropertyValue(Element node, String propertyName){
		return GOTHelp.getPPAttValue(node, "Name", propertyName);	
	}
	
	public static String autoTableFieldsString ="<root> " +
			"<TableField name='CreatedDate' id='7' type='Date' fixVisible='false'> " +
			   "<Properties> " +
				"<Property refentityid = '20000008'> " +
				 " <Name>Extends</Name>  " +
				  "<Value>CreatedDate</Value> " +
				"</Property>  " +
				"<Property>" +
				  "<Name>Label</Name>" +
				  "<Value/>" +
				"</Property>" +
				"<Property>" +
				  "<Name>HelpText</Name>" +
				  "<Value/>" +
				"</Property>" +
				"<Property>" +
				  "<Name>DisplayLength</Name>" +
				  "<Value/>" +
				"</Property>" +
				
				"<Property>" +
				 " <Name>AllowEdit</Name>" +
				  "<Value>Never</Value>" +
				"</Property>" +
				"<Property>" +
				  "<Name>NotNull</Name>" +
				  "<Value>false</Value>" +
				"</Property>" +
				
				"<Property>" +
				 " <Name>Regular</Name>" +
				 " <Value/>" +
				"</Property>" +
				 
		"	    <Property>" +
		"	      <Name>DisplayStyle</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
				"<Property>" +
				 " <Name>Default</Name>" +
				 " <Value/>" +
				"</Property>" +
			"  </Properties> " +
			"</TableField>  " +
			"<TableField name='CreatedTime' id='8' type='Time' fixVisible='false'> " +
			"  <Properties> " +
			"	<Property refentityid = '20000010'> " +
			"	  <Name>Extends</Name>  " +
			"	  <Value>CreatedTime</Value> " +
			"	</Property>  " +
			"	<Property>" +
			"	  <Name>Label</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>HelpText</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>DisplayLength</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>AllowEdit</Name>" +
			"	  <Value>Never</Value>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>NotNull</Name>" +
			"	  <Value>false</Value>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>Regular</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
		"	    <Property>" +
		"	      <Name>DisplayStyle</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
			"	<Property>" +
			"	  <Name>Default</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"  </Properties> " +
			"</TableField>  " +
			"<TableField name='CreatedBy' id='9' type='String' fixVisible='false'> " +
			"	<Properties> " +
			"	 <Property refentityid = '20000007'> " +
			"	  <Name>Extends</Name>  " +
			"	  <Value>CreatedBy</Value> " +
			"	 </Property>  " +
			"	<Property>" +
			"	  <Name>Label</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>HelpText</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>DisplayLength</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>AllowEdit</Name>" +
			"	  <Value>Never</Value>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>NotNull</Name>" +
			"	  <Value>false</Value>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>Regular</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
		"		  <Name>Default</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>StringSize</Name>" +
		"		  <Value>32</Value>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>FormLookup</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"	      <Name>ValidateLookup</Name>" +
		"	      <Value>false</Value>" +
		"	    </Property>" +
		"		<Property>" +
		"				<Name>FilterField</Name>" +
		"				<Value/>" +
		"			</Property>" +
		"	  </Properties> " +
		"	</TableField>" +
		"	<TableField name='ModifiedDate' id='11' type='Date' fixVisible='false'> " +
		"	  <Properties> " +
		"		<Property refentityid = '20000012'> " +
		"		  <Name>Extends</Name>  " +
		"		  <Value>ModifiedDate</Value> " +
		"		</Property>  " +
		"		<Property>" +
		"		  <Name>Label</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>HelpText</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>DisplayLength</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		
		"		<Property>" +
		"		  <Name>AllowEdit</Name>" +
		"		  <Value>Never</Value>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>NotNull</Name>" +
		"		  <Value>false</Value>" +
		"		</Property>" +
	
		"		<Property>" +
		"		  <Name>Regular</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		
		"	    <Property>" +
		"	      <Name>DisplayStyle</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
		"		<Property>" +
		"		  <Name>Default</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"	  </Properties> " +
		"	</TableField>" +
		"	<TableField name='ModifiedTime' id='12' type='Time' fixVisible='false'> " +
		"	  <Properties> " +
		"		<Property refentityid = '20000014'> " +
		"		  <Name>Extends</Name>  " +
		"		  <Value>ModifiedTime</Value> " +
		"		</Property>  " +
		"	   <Property>" +
		"		  <Name>Label</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>HelpText</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>DisplayLength</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		
		"		<Property>" +
		"		  <Name>AllowEdit</Name>" +
		"		  <Value>Never</Value>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>NotNull</Name>" +
		"		  <Value>false</Value>" +
		"		</Property>" +
		
		"		<Property>" +
		"		  <Name>Regular</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		
		"	    <Property>" +
		"	      <Name>DisplayStyle</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
		"		<Property>" +
		"		  <Name>Default</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"	  </Properties> " +
		"	</TableField>" +
		"	<TableField name='ModifiedBy' id='13' type='String' fixVisible='false'> " +
		"	  <Properties> " +
		"		<Property refentityid = '20000011'> " +
			"		<Name>Extends</Name>  " +
			"		<Value>ModifiedBy</Value> " +
			"	</Property>  " +
			"	<Property>" +
			"	  <Name>Label</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>HelpText</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>DisplayLength</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>AllowEdit</Name>" +
			"	  <Value>Never</Value>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>NotNull</Name>" +
			"	  <Value>false</Value>" +
			"	</Property>" +
			
			"	<Property>" +
			"	  <Name>Regular</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>Default</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>StringSize</Name>" +
			"	  <Value>32</Value>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>FormLookup</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"      <Name>ValidateLookup</Name>" +
			  "    <Value>false</Value>" +
			 "   </Property>" +
			"	<Property>" +
			"			<Name>FilterField</Name>" +
			"			<Value/>" +
			"		</Property>" +
			"  </Properties> " +
			"</TableField> " +
			"<TableField name='RecVersion' id='5' type='Long' fixVisible='false'> " +
			"  <Properties> " +
			"	<Property refentityid = '20000002'> " +
			"	  <Name>Extends</Name>  " +
			"	  <Value>RecVersion</Value> " +
			"	</Property>  " +
			"	<Property>" +
			"	  <Name>Label</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>HelpText</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>DisplayLength</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
			
			"	<Property>" +
			"	  <Name>AllowEdit</Name>" +
			"	  <Value>Never</Value>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>NotNull</Name>" +
			"	  <Value>false</Value>" +
			"	</Property>" +
			
			
			"	<Property>" +
			"	  <Name>Regular</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
		"	    <Property>" +
		"	      <Name>ThousandSeperator</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		"	    <Property>" +
		"	      <Name>ShowZero</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
			"	<Property>" +
			"	  <Name>Default</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"  </Properties> " +
			"</TableField> " +
			"<TableField name = 'RecId' id = '4' type = 'Long' fixVisible='false'> " +
			"	<Properties> " +
			"	  <Property refentityid = '20000001'> " +
			"		<Name>Extends</Name>  " +
			"		<Value>RecId</Value> " +
			"	  </Property>  " +
			"		<Property>" +
			"		  <Name>Label</Name>" +
			"		  <Value/>" +
			"		</Property>" +
			"		<Property>" +
			"		  <Name>HelpText</Name>" +
			"		  <Value/>" +
			"		</Property>" +
			"		<Property>" +
			"		  <Name>DisplayLength</Name>" +
			"		  <Value/>" +
			"		</Property>" +
			
			"		<Property>" +
			"		  <Name>AllowEdit</Name>" +
			"		  <Value>Never</Value>" +
			"		</Property>" +
			"		<Property>" +
			"		  <Name>NotNull</Name>" +
			"		  <Value>false</Value>" +
			"		</Property>" +
		
			
			"		<Property>" +
			"		  <Name>Regular</Name>" +
			"		  <Value/>" +
			"		</Property>" +
			
		"	    <Property>" +
		"	      <Name>ThousandSeperator</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		"	    <Property>" +
		"	      <Name>ShowZero</Name>" +
		"	      <Value/>" +
		"	    </Property>" +
		
			"		<Property>" +
			"		  <Name>Default</Name>" +
			"		  <Value/>" +
			"		</Property>" +
			"	</Properties> " +
			"</TableField>" +
			"</root>";
	
		public static String autoRecIdxTableIndexString ="<TableIndex name='RecIdx' id='14'> "+
			"	  <Properties> " +
			"		<Property> " +
			"		  <Name>Unique</Name>  " +
			"		  <Value>true</Value> " +
			"		</Property>  " +
			"	  </Properties>  " +
			"	  <TableIndexItem name='RecId' id='25'>" +
			"			<Properties>" +
			"				<Property innerid='4'>" +
			"					<Name>Field</Name>" +
			"					<Value>RecId</Value>" +
			"				</Property>" +
			"				<Property>" +
			"					<Name>ArrayItem</Name>" +
			"					<Value/>" +
			"				</Property>" +
			"				<Property>" +
			"					<Name>SortOrder</Name>" +
			"					<Value>ASC</Value>" +
			"				</Property>" +
			"			</Properties>" +
			"	  </TableIndexItem>" +
			"</TableIndex>  " ;
	
	public static String autoTableFieldGroupItemsString = "<root>" +
				"	<TableFieldGroupItem name='CreatedDate' id='16'> " +
				"	  <Properties> " +
				"		<Property innerid = '7'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>CreatedDate</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem>" +
				"	<TableFieldGroupItem name='CreatedTime' id='17'> " +
				"	  <Properties> " +
				"		<Property innerid = '8'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>CreatedTime</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem> " +
				"	<TableFieldGroupItem name='CreatedBy' id='18'> " +
				"	  <Properties> " +
				"		<Property innerid = '9'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>CreatedBy</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem>" +
				"	<TableFieldGroupItem name='ModifiedDate' id='20'> " +
				"	  <Properties> " +
				"		<Property innerid = '11'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>ModifiedDate</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem>" +
				"	<TableFieldGroupItem name='ModifiedTime' id='21'> " +
				"	  <Properties> " +
				"		<Property innerid = '12'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>ModifiedTime</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem>" +
				"	<TableFieldGroupItem name='ModifiedBy' id='22'> " +
				"	  <Properties> " +
				"		<Property innerid = '13'> " +
				"		  <Name>Field</Name>  " +
				"		  <Value>ModifiedBy</Value> " +
				"		</Property> " +
				"	  </Properties> " +
				"	</TableFieldGroupItem>" +
				"</root>";
	
	public static String autoCreatedByTableFieldGroupItemString = "<TableFieldGroupItem name='CreatedBy' id='18'> " +
			  "<Properties> " +
			"	<Property innerid = '9'> " +
			"	  <Name>Field</Name>  " +
			"	  <Value>CreatedBy</Value> " +
			"	</Property> " +
			"  </Properties> " +
			"</TableFieldGroupItem>";
	
	public static String autoCreatedTimeTableFieldGroupItemString ="<TableFieldGroupItem name='CreatedTime' id='17'> " +
		  "<Properties> " +
			"<Property innerid = '8'> " +
			"  <Name>Field</Name>  " +
			"  <Value>CreatedTime</Value> " +
			"</Property> " +
		 " </Properties> " +
		"</TableFieldGroupItem> " ;

	public static String autoCreatedDateTableFieldGroupItemString = "<TableFieldGroupItem name='CreatedDate' id='16'>" +
			"  <Properties> " +
			"	<Property innerid = '7'> " +
			"	  <Name>Field</Name>  " +
			"	  <Value>CreatedDate</Value> " +
			"	</Property> " +
			"  </Properties> " +
			"</TableFieldGroupItem>" ;
	
	public static String autoModifiedByTableFieldGroupItemString = "<TableFieldGroupItem name='ModifiedBy' id='22'>" +
			"  <Properties> " +
			"	<Property innerid = '13'> " +
			"	  <Name>Field</Name>  " +
			"	  <Value>ModifiedBy</Value> " +
			"	</Property> " +
			"  </Properties> " +
			"</TableFieldGroupItem>" ;
	
	public static String autoModifiedTimeTableFieldGroupItemString = "<TableFieldGroupItem name='ModifiedTime' id='21'>" +
			"  <Properties> " +
			"	<Property innerid = '12'> " +
			"	  <Name>Field</Name>  " +
			"	  <Value>ModifiedTime</Value> " +
			"	</Property> " +
			"  </Properties> " +
			"</TableFieldGroupItem>" ;
	
	public static String autoModifiedDateTableFieldGroupItemString = "<TableFieldGroupItem name='ModifiedDate' id='20'>" +
			"  <Properties> " +
			"	<Property innerid = '11'> " +
			"	  <Name>Field</Name>  " +
			"	  <Value>ModifiedDate</Value> " +
			"	</Property> " +
			"  </Properties> " +
			"</TableFieldGroupItem>" ;

	public static Element autoTableFields = createElementByXMLString(autoTableFieldsString);
	
	public static Element autoRecIdxTableIndex = createElementByXMLString(autoRecIdxTableIndexString);
	
	public static Element autoTableFieldGroupItems = createElementByXMLString(autoTableFieldGroupItemsString);
	
	public static Element autoCreatedByTableFieldGroupItem = createElementByXMLString(autoCreatedByTableFieldGroupItemString);
	
	public static Element autoCreatedTimeTableFieldGroupItem = createElementByXMLString(autoCreatedTimeTableFieldGroupItemString);
	
	public static Element autoCreatedDateTableFieldGroupItem = createElementByXMLString(autoCreatedDateTableFieldGroupItemString);
	
	public static Element autoModifiedByTableFieldGroupItem = createElementByXMLString(autoModifiedByTableFieldGroupItemString);
	
	public static Element autoModifiedTimeTableFieldGroupItem = createElementByXMLString(autoModifiedTimeTableFieldGroupItemString);
	
	public static Element autoModifiedDateTableFieldGroupItem = createElementByXMLString(autoModifiedDateTableFieldGroupItemString);
	
	
	public  static String autoCreatedByTableFieldString = "<TableField name='CreatedBy' id='9' type='String' fixVisible='false'> " +
		  "<Properties> " +
		"	<Property> " +
		"	  <Name>Extends</Name>  " +
		"	  <Value>CreatedBy</Value> " +
		"	</Property>  " +
        "  <Property>" +
		 "     <Name>Label</Name>" +
		 "     <Value/>" +
		"    </Property>" +
		 "   <Property>" +
		 "     <Name>HelpText</Name>" +
		 "     <Value/>" +
		  "  </Property>" +
		 "   <Property>" +
		 "     <Name>DisplayLength</Name>" +
		"      <Value/>" +
		 "   </Property>" +
		
		"    <Property>" +
		"      <Name>AllowEdit</Name>" +
		 "     <Value>Never</Value>" +
		 "   </Property>" +
		 "   <Property>" +
		 "     <Name>NotNull</Name>" +
		 "     <Value>false</Value>" +
		 "   </Property>" +
		"    <Property>" +
		"      <Name>Regular</Name>" +
		"      <Value/>" +
		 "   </Property>" +
		 "   <Property>" +
		"      <Name>Default</Name>" +
		"      <Value/>" +
		"    </Property>" +
		"    <Property>" +
		"     <Name>StringSize</Name>" +
		"      <Value />" +
		 "   </Property>" +
		  "  <Property>" +
		 "     <Name>FormLookup</Name>" +
		 "     <Value/>" +
		"    </Property>" +
		"	<Property>" +
		 "     <Name>ValidateLookup</Name>" +
		 "     <Value>false</Value>" +
		  "  </Property>" +
		"	<Property>" +
		"		<Name>FilterField</Name>" +
		"		<Value/>" +
		"	</Property>" +
		"  </Properties> " +
		"</TableField>";
	
	public  static String autoCreatedTimeTableFieldString = "<TableField name='CreatedTime' id='8' type='Time' fixVisible='false'> " +
			"  <Properties> " +
			"	<Property> " +
			"	  <Name>Extends</Name>  " +
			"	  <Value>CreatedTime</Value> " +
			"	</Property>  " +
			"    <Property>" +
			"      <Name>Label</Name>" +
			"      <Value/>" +
			"    </Property>" +
			 "   <Property>" +
			"      <Name>HelpText</Name>" +
			"      <Value/>" +
			"    </Property>" +
			"    <Property>" +
			"      <Name>DisplayLength</Name>" +
			"      <Value/>" +
			"    </Property>" +
			
			"    <Property>" +
			 "     <Name>AllowEdit</Name>" +
			 "     <Value>Never</Value>" +
			"    </Property>" +
			"    <Property>" +
			"      <Name>NotNull</Name>" +
			"      <Value>false</Value>" +
			"    </Property>" +
			"    <Property>" +
			 "     <Name>AllowEditOnCreate</Name>" +
			"      <Value>false</Value>" +
			 "   </Property>" +
			"    <Property>" +
			"      <Name>Regular</Name>" +
			"      <Value/>" +
			"    </Property>" +
			
			"	    <Property>" +
			"	      <Name>DisplayStyle</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"    <Property>" +
			"      <Name>Default</Name>" +
			"      <Value/>" +
			"    </Property>" +
			"  </Properties> " +
			"</TableField> "; 
	//TODO 此处添加TableFieldCreatedDate属性
	public static String autoCreatedDateTableFieldString = "<TableField name='CreatedDate' id='7' type='Date' fixVisible='false'> " +
			"	  <Properties> " +
			"		<Property> " +
			"		  <Name>Extends</Name>  " +
			"		  <Value>CreatedDate</Value> " +
			"		</Property>  " +
			"	    <Property>" +
			"	      <Name>Label</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>HelpText</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>DisplayLength</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	    <Property>" +
			"	      <Name>AllowEdit</Name>" +
			"	      <Value>Never</Value>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>NotNull</Name>" +
			"	      <Value>false</Value>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>Regular</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	    <Property>" +
			"	      <Name>Default</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	    <Property>" +
			"	      <Name>DisplayStyle</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	  </Properties> " +
			"	</TableField>  ";
	
	public  static String autoCreatedSessionIdTableFieldString = "<TableField name='CreatedSessionId' id='6' type='String' fixVisible='false'>" +
		"		 <Properties> " +
		"			 <Property> " +
		"				<Name>Extends</Name>  " +
		"				<Value>CreatedSessionId</Value> " +
		"			 </Property>  " +
		"		    <Property>" +
		"		      <Name>Label</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>HelpText</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>DisplayLength</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		
		"		    <Property>" +
		"		      <Name>AllowEdit</Name>" +
		"		      <Value>Never</Value>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>NotNull</Name>" +
		"		      <Value>false</Value>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>Regular</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>Default</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>StringSize</Name>" +
		"		      <Value />" +
		"		    </Property>" +
		"		    <Property>" +
		"		      <Name>FormLookup</Name>" +
		"		      <Value/>" +
		"		    </Property>" +
		"			<Property>" +
		"		      <Name>ValidateLookup</Name>" +
		"		      <Value>false</Value>" +
		"		    </Property>" +
		"			<Property>" +
		"				<Name>FilterField</Name>" +
		"				<Value/>" +
		"			</Property>" +
		"		  </Properties> " +
		"	</TableField> ";
	
	public static String autoModifiedSessionIdTableFieldString = "" +
		"<TableField name='ModifiedSessionId' id='10' type='String' fixVisible='false'> " +
		"  <Properties> " +
		"	<Property> " +
		"	  <Name>Extends</Name>  " +
		"	  <Value>ModifiedSessionId</Value> " +
		"	</Property>  " +
		"	  <Property>" +
		"		  <Name>Label</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>HelpText</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>DisplayLength</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		
		"	    <Property>" +
		"	      <Name>AllowEdit</Name>" +
		"	      <Value>Never</Value>" +
		"	    </Property>" +
		"	    <Property>" +
		"	      <Name>NotNull</Name>" +
		"	      <Value>false</Value>" +
		"	    </Property>" +
		"		<Property>" +
		"		  <Name>Regular</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>Default</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>StringSize</Name>" +
		"		  <Value />" +
		"		</Property>" +
		"		<Property>" +
		"		  <Name>FormLookup</Name>" +
		"		  <Value/>" +
		"		</Property>" +
		"		<Property>" +
		"	      <Name>ValidateLookup</Name>" +
		"	      <Value>false</Value>" +
		"	    </Property>" +
		"		<Property>" +
		"			<Name>FilterField</Name>" +
		"			<Value/>" +
		"		</Property>" +
		 " </Properties> " +
		"</TableField>  ";

	public static Element autoCreatedByTableField = createElementByXMLString(autoCreatedByTableFieldString);
	
	public static Element autoCreatedTimeTableField = createElementByXMLString(autoCreatedTimeTableFieldString);
	
	public static Element autoCreatedDateTableField = createElementByXMLString(autoCreatedDateTableFieldString);
	
	public static Element autoCreatedSessionIdTableField = createElementByXMLString(autoCreatedSessionIdTableFieldString);
	
	public static Element autoModifiedSessionIdTableField = createElementByXMLString(autoModifiedSessionIdTableFieldString);
	
		public  static String autoModifiedByTableFieldString = "<TableField name='ModifiedBy' id='13' type='String' fixVisible='false'>" +
			"  <Properties> " +
			"	<Property> " +
			"	  <Name>Extends</Name>  " +
			"	  <Value>ModifiedBy</Value> " +
			"	</Property>  " +
            " <Property>" +
			"	  <Name>Label</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>HelpText</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>DisplayLength</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			
			"    <Property>" +
			"      <Name>AllowEdit</Name>" +
			"      <Value>Never</Value>" +
			"    </Property>" +
			"   <Property>" +
			"      <Name>NotNull</Name>" +
			"      <Value>false</Value>" +
			 "   </Property>" +
			"	<Property>" +
			"	  <Name>Regular</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>Default</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>StringSize</Name>" +
			"	  <Value />" +
			"	</Property>" +
			"	<Property>" +
			"	  <Name>FormLookup</Name>" +
			"	  <Value/>" +
			"	</Property>" +
			"	<Property>" +
			"      <Name>ValidateLookup</Name>" +
			"      <Value>false</Value>" +
			 "   </Property>" +
			"	<Property>" +
			"		<Name>FilterField</Name>" +
			"		<Value/>" +
			"	</Property>" +
			"  </Properties> " +
			"</TableField> ";
		
		public static Element autoModifiedByTableField = createElementByXMLString(autoModifiedByTableFieldString);
		
		public  static String autoModifiedDateTableFieldString = "<TableField name='ModifiedDate' id='11' type='Date' fixVisible='false'> " +
			"	  <Properties> " +
			"		<Property> " +
			"		  <Name>Extends</Name>  " +
			"		  <Value>ModifiedDate</Value> " +
			"		</Property>  " +
	        "          <Property>" +
			"			  <Name>Label</Name>" +
			"			  <Value/>" +
			"			</Property>" +
			"			<Property>" +
			"			  <Name>HelpText</Name>" +
			"			  <Value/>" +
			"			</Property>" +
			"			<Property>" +
			"			  <Name>DisplayLength</Name>" +
			"			  <Value/>" +
			"			</Property>" +
			
			"		    <Property>" +
			"		      <Name>AllowEdit</Name>" +
			"		      <Value>Never</Value>" +
			"		    </Property>" +
			"		    <Property>" +
			"		      <Name>NotNull</Name>" +
			"		      <Value>false</Value>" +
			"		    </Property>" +
			"			<Property>" +
			"			  <Name>Regular</Name>" +
			"			  <Value/>" +
			"			</Property>" +
			
			"	    <Property>" +
			"	      <Name>DisplayStyle</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"			<Property>" +
			"			  <Name>Default</Name>" +
			"			  <Value/>" +
			"			</Property>" +
			"	  </Properties> " +
			"	</TableField>";
		
		public  static String autoModifiedTimeFieldString = "<TableField name='ModifiedTime' id='12' type='Time' fixVisible='false'> " +
			"	  <Properties> " +
			"		<Property> " +
			"		  <Name>Extends</Name>  " +
			"		  <Value>ModifiedTime</Value> " +
			"		</Property>  " +
	         "      <Property>" +
			"	      <Name>Label</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>HelpText</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>DisplayLength</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"		<Property>" +
			
			"	      <Name>AllowEdit</Name>" +
			"	      <Value>Never</Value>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>NotNull</Name>" +
			"	      <Value>false</Value>" +
			"	    </Property>" +
			"	    <Property>" +
			"	      <Name>Regular</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	    <Property>" +
			"	      <Name>DisplayStyle</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			
			"	    <Property>" +
			"	      <Name>Default</Name>" +
			"	      <Value/>" +
			"	    </Property>" +
			"	  </Properties> " +
			"	</TableField>";
		
	public static String recIdTableIndexString = "<TableIndex name='RecIdx' id='14' createdLayer='sys' modifiedLayer='sys'>" +
			"	  <Properties>" +
			"		<Property>" +
			"		  <Name>Unique</Name>" +
			"		  <Value>true</Value>" +
			"		</Property>" +
			"	  </Properties>" +
			"	  <TableIndexItem name='RecId' id='25' createdLayer='sys' modifiedLayer='sys'>" +
			"		<Properties>" +
			"		  <Property innerid='4'>" +
			"			<Name>Field</Name>" +
			"			<Value>RecId</Value>" +
			"		  </Property>" +
			"		  <Property>" +
			"			<Name>ArrayItem</Name>" +
			"			<Value/>" +
			"		  </Property>	" +
			"		  <Property>" +
			"			<Name>SortOrder</Name>" +
			"			<Value>ASC</Value>" +
			"		  </Property>" +
			"		</Properties>" +
			"	  </TableIndexItem>" +
			"	</TableIndex>";
	public static String recIdTableIndexHelperString = "<TableIndex name='RecIdx' id='14' createdLayer='sys' modifiedLayer='sys'>" +
				"		  <Properties>" +
				"			<Property>" +
				"			  <Name>Unique</Name>" +
				"			  <Value>true</Value>" +
				"			</Property>" +
				"		  </Properties>" +
				"		  <TableIndexItem name='RecId' id='25' createdLayer='sys' modifiedLayer='sys'>" +
				"			<Properties>" +
				"			  <Property innerid='4'>" +
				"				<Name>Field</Name>" +
				"				<Value>RecId</Value>" +
				"			  </Property>" +
				"			  <Property>" +
				"				<Name>ArrayItem</Name>" +
				"				<Value/>" +
				"			  </Property>" +
				"			  <Property>" +
				"				<Name>SortOrder</Name>" +
				"				<Value>DESC</Value>" +
				"			  </Property>" +
				"			</Properties>" +
				"		  </TableIndexItem>" +
				"		</TableIndex>" ;
							  
	public static Element autoModifiedDateTableField = createElementByXMLString(autoModifiedDateTableFieldString);
	
	public static Element autoModifiedTimeField = createElementByXMLString(autoModifiedTimeFieldString);
	
	public static Element recIdTableIndex = createElementByXMLString(recIdTableIndexString);
	
	public static Element recIdTableIndexHelper = createElementByXMLString(recIdTableIndexHelperString);
	
	public static void setPropertyByQName(Element des, String desName, Element src, String srcName){
		GOTHelp.getPPAttElement(des, "Name", desName).element("Value").setText(GOTHelp.getPPAttValue(src, "Name", srcName));
	}
	
	@SuppressWarnings("unchecked")
	public static Boolean deleteNode(Element node){
		if(node.attribute("version") != null){
			return true;
		}
		
		if(node.getParent()==null){
			node = null;
			return false;
		}else{
			Element parent = node.getParent();
			boolean b = parent.remove(node);
			GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(parent));
			return b;
//			List<Element> list = parent.elements();
//			int length = list.size();
//			for(int i=0 ; i<length; i++){
//				if(node == list.get(i)){
//
//				}
//			}
		}
	}
	
	public static void deletePropery(Element base, String proName){
		Element e = GOTHelp.getPPAttElement(base, "Name", proName);
		base.element("Properties").remove(e);
	}
	
	public static void addPropertyUnCheck(Element base, String name, String value){
		Element ps;
		if(base.element("Properties") != null){
			ps = base.element("Properties");		
		}else{
			base.element("Properties").setText("");
			ps = base.element("Properties");
		}
		String xml = "<Property>" +
			"<Name>"+name+
			"</Name>"	 +
			"<Value>"+value+
			"</Value>"   +
			"</Property>";
		ps.add(createElementByXMLString(xml).detach());
	}
	
	public static String formDataSourceField_String_TemplateStr = "<FormDataSourceField name='' id='' type='' createdLayer='' modifiedLayer=''>" +
			  "<Properties>" +
			  "<Property>" +
			  "	  <Name>Label</Name>" +
			  "  <Value/>" +
			  "	</Property>" +
			  "<Property>" +
			  "  <Name>HelpText</Name>" +
			  "  <Value/>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>DisplayLength</Name>" +
			  "  <Value/>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>AllowEdit</Name>" +
			  "  <Value/>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>NotNull</Name>" +
			  "  <Value/>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>Visible</Name>" +
			  "  <Value>true</Value>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>Regular</Name>" +
			  "  <Value/>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>Field</Name>" +
			  "  <Value></Value>" +
			  "</Property>" +
			  "<Property>" +
			  "  <Name>ValidateLookup</Name>" +
			  "  <Value></Value>" +
			  "</Property>" +
			  "</Properties>" +
			  "</FormDataSourceField>";
	public static Element formDataSourceField_String_Template = createElementByXMLString(formDataSourceField_String_TemplateStr);
	
	public static String formDataSourceFieldTemplateStr = ""+
		"<FormDataSourceField name='' id='' type='' createdLayer='' modifiedLayer=''>" +
		"  <Properties>" +
		"	<Property>" +
		"	  <Name>Label</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>HelpText</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>DisplayLength</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>AllowEdit</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>NotNull</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>Visible</Name>" +
		"	  <Value>true</Value>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>Regular</Name>" +
		"	  <Value/>" +
		"	</Property>" +
		"	<Property>" +
		"	  <Name>Field</Name>" +
		"	  <Value></Value>" +
		"	</Property>" +
		 " </Properties>" +
		"</FormDataSourceField>";
	public static Element formDataSourceFieldTemplate = createElementByXMLString(formDataSourceFieldTemplateStr);
	
}
