package gongqi.erp.gotmodel.clientcache;

import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.data.DataAreaHelper;
import gongqi.erp.framework.logging.Logger;
import gongqi.erp.gotmodel.form.load.FormObjectAuthority;
import gongqi.erp.gotmodel.form.load.FormObjectStandard;
import gongqi.erp.gotmodel.form.load.FormObjectUserSet;
import gongqi.erp.gotmodel.form.load.FormPrefetchCommandResult;
import gongqi.erp.gotmodel.userset.form.UserSetFormDAO;
import info.gongqi.got.ui.LoadXmlCore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheManager {
	
	private static Logger log = Logger.getLogger(CacheManager.class);

	//public Map<String, CacheObject> mapEntityProperty;	//key=entityId value=Map<innerId, properties>
	
	private static Map<String, FormObjectStandard> mapFormObjectStandard;	//key=formId
	
	private static void initMapFormObjectUserSet()
	{
		DataAreaHelper.put("mapFormObjectUserSet", new HashMap<String, FormObjectUserSet>());
	}
	
	private static void initMapFormObjectAuthority()
	{
		DataAreaHelper.put("mapFormObjectAuthority", new HashMap<String, Map<String,FormObjectAuthority>>());
	}
	
	private static void initMapFormPrefetchCommandResult()// key = formId
	{
		DataAreaHelper.put("mapFormPrefetchCommandResult", new HashMap<String, FormPrefetchCommandResult>());
	}
	
	//private static Map<String, FormObjectUserSet> mapFormObjectUserSet;	//key=formId.menuItemId.userId
	@SuppressWarnings("unchecked")
	private static Map<String, FormObjectUserSet> mapFormObjectUserSet()
	{
		return (Map<String, FormObjectUserSet>) DataAreaHelper.get("mapFormObjectUserSet");
	}
	
	//private static Map<String, Map<String, FormObjectAuthority>> mapFormObjectAuthority;		//key=userGroupId.menuItemId
	@SuppressWarnings("unchecked")
	private static Map<String, Map<String, FormObjectAuthority>> mapFormObjectAuthority()
	{
		return (Map<String, Map<String, FormObjectAuthority>>) DataAreaHelper.get("mapFormObjectAuthority");
	}
	
	//key=formId
	@SuppressWarnings("unchecked")
	private static Map<String, FormPrefetchCommandResult> mapFormPrefetchCommandResult()
	{
		return  (Map<String, FormPrefetchCommandResult>) DataAreaHelper.get("mapFormPrefetchCommandResult");
	}
	
	
	//private static Map<String, Map<String,Map<String,Object>>> mapItemProperty;
	
	
	
	public static void init()
	{
		
		if(FrameworkEnvironment.isDebug()==true)
			return;
		
		mapFormObjectStandard = new HashMap<String, FormObjectStandard>();
		//mapFormObjectUserSet = new HashMap<String, FormObjectUserSet>();
		//mapFormObjectAuthority = new HashMap<String, Map<String,FormObjectAuthority>>();
		
		//mapItemProperty = new HashMap<String, Map<String,Map<String,Object>>>();
	}
	
	public static void initForCurrentDataArea()
	{
		initMapFormObjectUserSet();
		initMapFormObjectAuthority();
		initMapFormPrefetchCommandResult();
	}
	
	public synchronized static void initForm(String formId)
	{
		if(formId==null)
			return;
		
		if(LoadXmlCore.gotServices.getEntity(formId) == null)
			return;
			
		if(FrameworkEnvironment.isDebug()==true)
			return;
		
		if(mapFormObjectStandard==null) mapFormObjectStandard = new HashMap<String, FormObjectStandard>();
		//if(mapFormObjectUserSet==null) mapFormObjectUserSet = new HashMap<String, FormObjectUserSet>();
		//if(mapFormObjectAuthority==null) mapFormObjectAuthority = new HashMap<String, Map<String,FormObjectAuthority>>();
		if(mapFormObjectUserSet()==null) initMapFormObjectUserSet();
		if(mapFormObjectAuthority()==null) initMapFormObjectAuthority();		
		if(mapFormPrefetchCommandResult()==null) initMapFormPrefetchCommandResult();
		
		
		//if(mapItemProperty==null) mapItemProperty = new HashMap<String, Map<String,Map<String,Object>>>();
		
		CacheManager.clearFormObjectStandard(formId);
		
		FormObjectStandard formObjectStandard = new FormObjectStandard(formId);
		log.debug(formId + "->" + formObjectStandard.md5);
				
		mapFormObjectStandard.put(formId, formObjectStandard);
		//mapItemProperty.put(formId, null);
		CacheManager.clearFormPrefetchCommandResult(formId);
	}
	
	
	public static synchronized FormObjectStandard getFormObjectStandard(String formId)
	{
		if(mapFormObjectStandard.containsKey(formId))
		{
			return mapFormObjectStandard.get(formId);
		}
		else
		{
			initForm(formId);
			return mapFormObjectStandard.get(formId);
		}
	}
	
	public static synchronized FormPrefetchCommandResult getFormPrefetchCommandResult(String formId)
	{
		if(mapFormPrefetchCommandResult()==null)
			return null;
		
		if(mapFormPrefetchCommandResult().containsKey(formId))
		{
			return mapFormPrefetchCommandResult().get(formId);
		}
		else
		{
			FormPrefetchCommandResult formPrefetchCommandResult = new FormPrefetchCommandResult(formId);
			mapFormPrefetchCommandResult().put(formId, formPrefetchCommandResult);
			return formPrefetchCommandResult;
		}
	}
	
	/**
	 * 目前没有地方引用这个方法
	 * @param formId
	 * @param menuItemId
	 * @param userId
	 * @return
	 */
	public static synchronized FormObjectUserSet getFormObjectUserSet(String formId, String menuItemId, String userId)
	{
		if(mapFormObjectUserSet()==null)
			return null;
		
		if(LoadXmlCore.gotServices.getEntity(formId)==null)
			return null;
		
		
		String key = formId + "." + menuItemId + "." + userId;
		if(mapFormObjectUserSet().containsKey(key))
		{
			return mapFormObjectUserSet().get(key);
		}
		else
		{
			FormObjectUserSet formObjectUserSet = new FormObjectUserSet(formId, menuItemId, userId);
			
			log.debug(formId+"."+menuItemId+"." + userId + "->"+formObjectUserSet.md5);
			mapFormObjectUserSet().put(key, formObjectUserSet);
			return formObjectUserSet;
		}
	}
	
	public static synchronized FormObjectAuthority getFormObjectAuthority(String menuItemId, String userGroupId)
	{
		if(mapFormObjectAuthority()==null)
			return  null;
		
		if(mapFormObjectAuthority().containsKey(userGroupId))
		{
			Map<String, FormObjectAuthority> map = mapFormObjectAuthority().get(userGroupId);
			if(map!=null && map.containsKey(menuItemId))
			{
				return map.get(menuItemId);
			}
		}
		
		FormObjectAuthority formObjectAuthority = new FormObjectAuthority(menuItemId, userGroupId, null);
		if(formObjectAuthority.allNone==false)
		{
			log.debug(menuItemId+"."+userGroupId+"->"+formObjectAuthority.md5);
			Map<String, FormObjectAuthority> map = mapFormObjectAuthority().get(userGroupId);
			if(map==null)
			{
				map = new HashMap<String, FormObjectAuthority>();
				mapFormObjectAuthority().put(userGroupId, map);
			}
			map.put(menuItemId, formObjectAuthority);
		}
		
		return formObjectAuthority;

	}

	
	public static synchronized void clearFormObjectStandard(String formId)
	{
		if(mapFormObjectStandard!=null)
			mapFormObjectStandard.remove(formId);
	}
	
	public static synchronized void clearFormObjectAuthority(String userGroupId)
	{
		if(mapFormObjectAuthority()!=null)
			mapFormObjectAuthority().remove(userGroupId);
	}
	
	public static synchronized void clearFormPrefetchCommandResult(String formId)
	{
		if(mapFormPrefetchCommandResult()!=null)
			mapFormPrefetchCommandResult().remove(formId);
	}

	public static synchronized void clearFormObjectUserSet(String formId, String menuItemId, String userId)
	{

		if(mapFormObjectUserSet()==null)
			return;
		
		String key = formId + "." + menuItemId + "." + userId;
		if(mapFormObjectUserSet().containsKey(key))
		{
			mapFormObjectUserSet().remove(key);
		}
		
		// 如果是以别人的条件作为自己的默认条件，那么当别人的变更之后，相应所有人的缓存也都应清空，目前这个还没做，要再处理
		List<String> list = ObjectContainer.getInstance(UserSetFormDAO.class).listUsersByDefaultUserId(formId, menuItemId, userId);
		for(String user:list)
		{
			String tmp = formId + "." + menuItemId + "." + user;
			if(mapFormObjectUserSet().containsKey(tmp))
			{
				mapFormObjectUserSet().remove(tmp);
			}
		}
		
	}
}
