package gongqi.erp.gotmodel.clientcache;

import edu.emory.mathcs.backport.java.util.Arrays;
import gongqi.erp.gotmodel.core.GOTHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class GOTFinalValueHelper {

	private static final String FORMITEM = "FormItem";
	private static final String TRUE = "true";
	private static final String FALSE = "false";
	private static final String ATTR_NAME = "name";
	@SuppressWarnings("unused")
	private static final String ATTR_ID = "id";
	private static final String ATTR_REFENTITYID = "refentityid";
	private static final String ATTR_REFINNERID = "refinnerid";
	private static final String ATTR_INNERID = "innerid";

	private static final String PROPERTY_X = "X";
	private static final String PROPERTY_Y = "Y";
	private static final String PROPERTY_WIDTH = "Width";
	private static final String PROPERTY_HEIGHT = "Height";
	private static final String PROPERTY_HIDEINVISIBLE = "HideInvisible";
	private static final String PROPERTY_LAYOUT = "Layout";
	private static final String PROPERTY_ICON = "Icon";
	private static final String PROPERTY_DISABLEDICON = "DisabledIcon";
	private static final String PROPERTY_SHORTCUT = "ShortCut";
	private static final String PROPERTY_DISPLAYMODE = "DisplayMode";
	private static final String PROPERTY_SAVERECORD = "SaveRecord";
	private static final String PROPERTY_MULTISELECT = "MultiSelect";
	private static final String PROPERTY_DISPLAYHEIGHT = "DisplayHeight";
	private static final String PROPERTY_SHOWLABEL = "ShowLabel";
	private static final String PROPERTY_LABELALIGNMENT = "LabelAlignment";
	private static final String PROPERTY_SEARCHMODE = "SearchMode";
	private static final String PROPERTY_RETURNLOOKUP = "ReturnLookup";
	private static final String PROPERTY_SOURCE = "Source";
	private static final String PROPERTY_DATASOURCE = "DataSource";
	private static final String PROPERTY_DATAMETHOD = "DataMethod";
	private static final String PROPERTY_EXTENDS = "Extends";
	private static final String PROPERTY_FIELDGROUP = "FieldGroup";
	private static final String PROPERTY_COMPONENT = "Component";
	private static final String PROPERTY_MENUITEM = "MenuItem";
	private static final String PROPERTY_SHOWHEADER = "ShowHeader";
	private static final String PROPERTY_SKIPTAB = "SkipTab";
	private static final String PROPERTY_LABELLENGTH = "LabelLength";
	private static final String PROPERTY_HEADERALIGN = "HeaderAlign";
	private static final String PROPERTY_ROWS = "Rows";
	private static final String PROPERTY_URL = "URL";
	private static final String PROPERTY_SUFFIX = "Suffix";
	private static final String PROPERTY_POPUP = "Popup";
	private static final String PROPERTY_LAYOUTMODE = "LayoutMode";
	private static final String PROPERTY_CONTROLTYPE = "ControlType";
	private static final String PROPERTY_CLASSNAME = "ClassName";
	private static final String PROPERTY_FAILUREIMAGE = "FailureImage";
	private static final String PROPERTY_QUERYTYPE = "QueryType";
	private static final String PROPERTY_GROUPTYPE = "GroupType";
	private static final String PROPERTY_QUERYSOURCE = "QuerySource";
	private static final String PROPERTY_QUERYFIELD = "QueryField";
	private static final String PROPERTY_QUERYFILTER = "QueryFilter";

	private static final String PROPERTY_TRIM = "Trim";
	private static final String PROPERTY_CHANGECASE = "ChangeCase";
	private static final String PROPERTY_SHOWZERO = "ShowZero";
	private static final String PROPERTY_ALLOWNEGATIVE = "AllowNegative";
	private static final String PROPERTY_THOUSANDSEPERATOR = "ThousandSeperator";
	private static final String PROPERTY_SHOWDECIMALS = "DisplayDecimals";
	private static final String PROPERTY_ROUNDOFF = "RoundOff";
	private static final String PROPERTY_SEPERATOR = "Seperator";
	private static final String PROPERTY_NUMOFYEAR = "NumOfYear";
	private static final String PROPERTY_NUMOFMONTH = "NumOfMonth";
	private static final String PROPERTY_NUMOFDAY = "NumOfDay";
	private static final String PROPERTY_SHOW1970 = "Show1970";
	private static final String PROPERTY_SHOWMINUTE = "ShowMinute";
	private static final String PROPERTY_SHOWSECOND = "ShowSecond";
	private static final String PROPERTY_SHOWHOUR = "ShowHour";
	private static final String PROPERTY_TEXTTRUE = "TextTrue";
	private static final String PROPERTY_TEXTFALSE = "TextFalse";
	private static final String PROPERTY_AUTHORITYLEVEL = "AuthorityLevel";

	private static final String PROPERTY_STRINGSIZE = "StringSize";
	private static final String PROPERTY_NUMOFDECIMALS = "NumOfDecimals";

	private static final String COLUMNS = "Columns";
	private static final String COLLAPSIBLE = "Collapsible";
	private static final String LOOKUPMODE = "LookupMode";
	private static final String ALLOWKEYIN = "AllowKeyIn";
	private static final String SHOWBORDER = "ShowBorder";
	private static final String WORKFLOW = "Workflow";
	private static final String AUTOSUM = "AutoSum";
	private static final String MAINCONTENTALIGNMENT = "MainContentAlignment";

	private static final String PROPERTY_LABEL = "Label";

	private static final String PROPERTY_HEADER_HEIGHT = "HeaderHeight";
	private static final String PROPERTY_DISABLEAUTOSAVE = "DisableAutoSave";
	private static final String PROPERTY_AUTOENTERLIST = "AutoEnterList";

	private static String[] nodeextendsproperties = null;
	private static Map<String, String> fromdatatypeproperties = null;
	private static Map<String, String> fromdatatypebutformitemalsoproperties = null;

	static {
		nodeextendsproperties = new String[] { PROPERTY_X, PROPERTY_Y, PROPERTY_WIDTH, PROPERTY_HEIGHT,
				PROPERTY_HIDEINVISIBLE, PROPERTY_LAYOUT, PROPERTY_ICON, PROPERTY_DISABLEDICON, PROPERTY_SHORTCUT,
				PROPERTY_DISPLAYMODE, PROPERTY_SAVERECORD, PROPERTY_MULTISELECT, PROPERTY_DISPLAYHEIGHT,
				PROPERTY_SHOWLABEL, PROPERTY_LABELALIGNMENT, PROPERTY_SEARCHMODE, PROPERTY_RETURNLOOKUP,
				PROPERTY_SOURCE, PROPERTY_DATASOURCE, PROPERTY_DATAMETHOD, PROPERTY_EXTENDS, PROPERTY_FIELDGROUP,
				PROPERTY_COMPONENT, PROPERTY_MENUITEM, PROPERTY_SHOWHEADER, PROPERTY_SKIPTAB, PROPERTY_LABELLENGTH,
				PROPERTY_HEADERALIGN, PROPERTY_ROWS, PROPERTY_URL, PROPERTY_SUFFIX, PROPERTY_POPUP, PROPERTY_LAYOUTMODE,
				PROPERTY_CONTROLTYPE, PROPERTY_CLASSNAME, PROPERTY_FAILUREIMAGE, PROPERTY_QUERYTYPE, PROPERTY_GROUPTYPE,
				PROPERTY_QUERYSOURCE, PROPERTY_QUERYFIELD, PROPERTY_QUERYFILTER, PROPERTY_AUTHORITYLEVEL, COLUMNS,
				COLLAPSIBLE, LOOKUPMODE, ALLOWKEYIN, SHOWBORDER, WORKFLOW, AUTOSUM, MAINCONTENTALIGNMENT,
				PROPERTY_HEADER_HEIGHT, PROPERTY_DISABLEAUTOSAVE, PROPERTY_AUTOENTERLIST };

		fromdatatypeproperties = new HashMap<String, String>();
		fromdatatypeproperties.put(PROPERTY_TRIM, "LeftRight");
		fromdatatypeproperties.put(PROPERTY_CHANGECASE, "Node");
		fromdatatypeproperties.put(PROPERTY_SHOWZERO, "true");
		fromdatatypeproperties.put(PROPERTY_ALLOWNEGATIVE, "true");
		fromdatatypeproperties.put(PROPERTY_THOUSANDSEPERATOR, "false");
		fromdatatypeproperties.put(PROPERTY_SHOWDECIMALS, "2");
		fromdatatypeproperties.put(PROPERTY_ROUNDOFF, "HalfUp");
		fromdatatypeproperties.put(PROPERTY_SEPERATOR, "-");
		fromdatatypeproperties.put(PROPERTY_NUMOFYEAR, "4");
		fromdatatypeproperties.put(PROPERTY_NUMOFMONTH, "2");
		fromdatatypeproperties.put(PROPERTY_NUMOFDAY, "2");
		fromdatatypeproperties.put(PROPERTY_SHOW1970, "false");
		fromdatatypeproperties.put(PROPERTY_SHOWMINUTE, "true");
		fromdatatypeproperties.put(PROPERTY_SHOWSECOND, "true");
		fromdatatypeproperties.put(PROPERTY_SHOWHOUR, "true");
		fromdatatypeproperties.put(PROPERTY_TEXTTRUE, "是");
		fromdatatypeproperties.put(PROPERTY_TEXTFALSE, "否");

		fromdatatypebutformitemalsoproperties = new HashMap<String, String>();
		fromdatatypebutformitemalsoproperties.put(PROPERTY_SHOWDECIMALS, "2");
		fromdatatypebutformitemalsoproperties.put(PROPERTY_SHOWZERO, "true");
		fromdatatypebutformitemalsoproperties.put(PROPERTY_SEPERATOR, "-");
		fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFYEAR, "4");
		fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFMONTH, "2");
		fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFDAY, "2");
	}

	private static boolean hasProperty(Element reportField, String property) {
		Element pro = GOTHelper.getProperty(reportField, property);
		if (pro != null)
			return true;
		else
			return false;
	}

	public static String getReprotFinalValue(Element item, String property) {
		String nodeName = item.getName();
		if ("ReportField".equals(nodeName)) {
			if ("Extends".equals(property) || "Source".equals(property))
				return GOTHelper.getPropertyValue(item, property);

			boolean hasProperty = hasProperty(item, property);

			if (hasProperty) {
				String value = GOTHelper.getPropertyValue(item, property);
				if (!"".equals(value))
					return value;
			}

			Element extendsPro = GOTHelper.getProperty(item, "Extends");

			if (null != extendsPro.attributeValue("refentityid")) {
				String refId = extendsPro.attributeValue("refentityid");
				Element entity = null;

				if ("20".equals(refId.substring(0, 2)))
					entity = GOTOverwrite.getDataType(refId);
				else
					entity = GOTOverwrite.getEnum(refId);
				return getFinalValue(entity, property);
			}

			// 如果是ReportField 并且该属性在这个ReportField上没有并且它又不继承任何DataType
			// 或者这个属性在这个ReportField上有但是值是空
			if ("Label".equals(property)) {
				return item.attributeValue("name");
			}

			if ("Regular".equals(property)) {
				return "";
			} else if ("NotNull".equals(property)) {
				return FALSE;
			} else if ("AllowEdit".equals(property)) {
				return TRUE;
			} else if ("AllowEditOnCreate".equals(property)) {
				return TRUE;
			} else if ("Default".equals(property)) {
				return "";
			} else if ("SkipTab".equals(property)) {
				return "false";
			} else if ("DisplayHeight".equals(property)) {
				return "1";
			} else if ("Seperator".equals(property)) {
				return "-";
			} else if ("NumOfYear".equals(property)) {
				return "4";
			} else if ("NumOfMonth".equals(property)) {
				return "2";
			} else if ("NumOfDay".equals(property)) {
				return "2";
			} else if ("Show1970".equals(property)) {
				return "true";
			} else if ("ShowZero".equals(property)) {
				return "true";
			} else if ("ThousandSeperator".equals(property)) {
				return ",";
			} else if ("AllowNegative".equals(property)) {
				return "true";
			} else if (PROPERTY_SHOWDECIMALS.equals(property)) {
				return "true";
			} else if ("RoundOff".equals(property)) {
				return "HalfUp";
			} else if ("Trim".equals(property)) {
				return "LeftRight";
			} else if ("ChangeCase".equals(property)) {
				return "None";
			} else if ("ShowHour".equals(property)) {
				return "true";
			} else if ("ShowMinute".equals(property)) {
				return "true";
			} else if ("ShowSecond".equals(property)) {
				return "true";
			}
			return "";

		}

		if ("ReportQuery".equals(nodeName)) {
			return GOTHelper.getPropertyValue(item, property);
		}

		if ("Report".equals(nodeName)) {
			String label = GOTHelper.getPropertyValue(item, property);
			if ("".equals(label))
				return item.attributeValue("name");
			return label;
		}

		if ("Query".equals(property) && "Title".equals(property)) {
			String value = GOTHelper.getPropertyValue(item, property);
			if ("".equals(value)) {
				Element queryTable = (Element) item.element("QueryTable");
				if (queryTable == null)
					return item.attributeValue("name");

				Element extendsPro = GOTHelper.getProperty(queryTable, "Table");
				Element table = null;
				if (null != extendsPro.attribute("refentityid"))
					table = GOTOverwrite.getTable(extendsPro.attributeValue("refentityid"));
				if (table != null) {
					value = getFinalValue(table, "Label");
					if ("".equals(value))
						value = item.attributeValue("name");
				}
			}
			return value;
		}

		return null;

	}

	private static String getFormItemDataTypePropertyValueFromFormItem(Element formItem, String propertyName) {
		String value = GOTHelper.getPropertyValue(formItem, propertyName);
		if (!"".equals(value) && null != value)
			return value;
		return getDataTypePropertyValueFromFormItem(formItem, propertyName);
	}

	private static String getDataTypePropertyValueFromFormItem(Element formItem, String propertyName) {
		// 本方法针对FormItem_Editor 但不支持Enum类型
		Element pFormItem = GOTHelper.getProperty(formItem, "Extends");
		if (pFormItem == null)
			return null;

		if (null == pFormItem.attribute(ATTR_REFENTITYID)) {
			if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
				return getFinalValue(formItem, "NumOfDecimals");
			}
			return null;
		}
		Element dataType = null;
		if (null != pFormItem.attribute(ATTR_REFINNERID)) {
			Element table = GOTOverwrite.getTable(pFormItem.attributeValue(ATTR_REFENTITYID));
			if (table != null) {
				Element tableField = (Element) table.selectSingleNode(
						String.format("TableFields/TableField[@id='%s']", pFormItem.attributeValue(ATTR_REFINNERID)));
				Element pTableField = GOTHelper.getProperty(tableField, "Extends");
				if (null == pTableField.attribute(ATTR_REFENTITYID)) {
					if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
						return getFinalValue(formItem, "NumOfDecimals");
					}
					return null;
				}
				dataType = GOTOverwrite.getDataType(pTableField.attributeValue(ATTR_REFENTITYID));
			} else {
				if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
					return getFinalValue(formItem, "NumOfDecimals");
				}
				return null;
			}
		} else {
			dataType = GOTOverwrite.getDataType(pFormItem.attributeValue(ATTR_REFENTITYID));
		}

		if ("Component".equals(dataType.attributeValue("type"))) {
			String componentfieldvalue = pFormItem.elementText("Value").split("[.]")[1];
			Element arrayItem = (Element) dataType.selectSingleNode(
					String.format("DataTypeArray/DataTypeArrayItem[@name='%s']", componentfieldvalue));
			Element refdatatypepro = GOTHelper.getProperty(arrayItem, "RefDataType");
			dataType = GOTOverwrite.getDataType(refdatatypepro.attributeValue(ATTR_REFENTITYID));
		}
		String value = GOTHelper.getProperty(dataType, propertyName).elementText("Value");
		while (value == "") {
			dataType = GOTOverwrite
					.getDataType(GOTHelper.getProperty(dataType, "Extends").attributeValue(ATTR_REFENTITYID));
			value = GOTHelper.getProperty(dataType, propertyName).elementText("Value");
		}

		if ("".equals(value)) {
			if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
				return getFinalValue(formItem, "NumOfDecimals");
			}
			return null;
		} else
			return value;
	}

	private static String getFilterFieldFromFormItem(Element item) {
		String result = null;
		if ("StringEditor".equals(item.attributeValue("type"))) {
			String dataSource = GOTHelper.getPropertyValue(item, "DataSource");
			if (!"".equals(dataSource) && null != dataSource) {
				Element extendsPro = GOTHelper.getProperty(item, "Extends");

				if (null != extendsPro.attribute(ATTR_REFENTITYID) && null != extendsPro.attribute(ATTR_REFINNERID)) {
					String entityid = extendsPro.attributeValue(ATTR_REFENTITYID);
					String innerid = extendsPro.attributeValue(ATTR_REFINNERID);
					Element table = GOTOverwrite.getTable(entityid);
					Element tableField = (Element) table
							.selectSingleNode(String.format("TableFields/TableField[@id='%s']", innerid));
					if (tableField != null) {
						String filterField = GOTHelper.getPropertyValue(tableField, "FilterField");
						if (!"".equals(filterField))
							return filterField;
					}
				}
			}
		}

		return result;
	}

	private static boolean isFindQueryField(String propertyName) {
		if (PROPERTY_LABEL.equals(propertyName) || PROPERTY_NUMOFDECIMALS.equals(propertyName)
				|| PROPERTY_STRINGSIZE.equals(propertyName)) {
			return true;
		}
		return false;
	}

	private static String getPropertyValueStepByStep(Element item, String propertyName, String validateString,
			boolean validateEquals, boolean findFormDataSourceField) {
		String value = null;
		Element pFormItem_Extends = null;
		Element pFormDataSourceField_Field = null;
		if ("FormItem".equals(item.getName())) {
			value = GOTHelper.getPropertyValue(item, propertyName);
			if(value == null)value = "";
			if (validateEquals) {
				if (validateString.equals(value))
					return value;
			} else {
				if (!validateString.equals(value))
					return value;
			}

			if ("FieldGroup".equals(item.attributeValue("type"))) {
				pFormItem_Extends = GOTHelper.getProperty(item, "Component");
				if (null == pFormItem_Extends.attribute(ATTR_REFENTITYID))
					return value;
			} else {
				pFormItem_Extends = GOTHelper.getProperty(item, "Extends");
			}

			if (null == pFormItem_Extends) {
				System.out.println("FormItem上找不到Extends");
				return "";
			}

			boolean isQueryField = false;
			Attribute attr = pFormItem_Extends.attribute(ATTR_REFENTITYID);
			Attribute attrrefentityid = attr;
			if (null == attr && isFindQueryField(propertyName)) {
				pFormItem_Extends = GOTHelper.getProperty(item, "QueryField");
				if (pFormItem_Extends == null || pFormItem_Extends.attribute(ATTR_REFENTITYID) == null)
					return value;
				isQueryField = true;
			}
			attr = pFormItem_Extends.attribute(ATTR_REFINNERID);
			if (null != attr) {
				if ("".equals(pFormItem_Extends.selectSingleNode("Value").getText()))
					return "";
				if (findFormDataSourceField) {
					Element pFormItem_DataSource = null;
					if (isQueryField == false) {
						pFormItem_DataSource = GOTHelper.getProperty(item, "DataSource");
					} else {
						pFormItem_DataSource = GOTHelper.getProperty(item, "QuerySource");
					}
					if (pFormItem_DataSource == null || pFormItem_DataSource.attribute(ATTR_INNERID) == null)
						return value;
					// Element pFormItem_DataSource =
					// GOTHelper.getProperty(item, "DataSource");
					Element form = getItemEntity(item);
					if(form == null){
						return value;
					}
					
					item = (Element) form.selectSingleNode(String.format(
							"FormDataSources/FormDataSource[@id='%s']/FormDataSourceFields/FormDataSourceField[@name='%s']",
							pFormItem_DataSource.attributeValue("innerid"), pFormItem_Extends.elementText("Value")));
					
					
				} else {
					Element table = GOTOverwrite.getTable(pFormItem_Extends.attributeValue(ATTR_REFENTITYID));
					item = (Element) table.selectSingleNode(String.format("TableFields/TableField[@id='%s']",
							pFormItem_Extends.attributeValue(ATTR_REFINNERID)));
				}
			} else if (attrrefentityid != null) {
				item = GOTOverwrite.getDataType(pFormItem_Extends.attributeValue(ATTR_REFENTITYID));
				if (item == null)
					item = GOTOverwrite.getEnum(pFormItem_Extends.attributeValue(ATTR_REFENTITYID));
			}
		}
		
		if(item == null){
			return "";
		}
		
		if ("FormDataSourceField".equals(item.getName())) {
			value = GOTHelper.getPropertyValue(item, propertyName);
			if(value == null)value = "";
			//ZSG Table上的Visible属性删掉了 如果是Visible并且找到FormDataSourceField这一级 就不再向上查找了 直接返回 因为FormDataSourceField是最高层级了
			if ("Visible".equals(propertyName)) {
				return value;
			}
			if (validateEquals) {
				if (validateString.equals(value))
					return value;
			} else {
				if (!validateString.equals(value))
					return value;
			}
			pFormDataSourceField_Field = GOTHelper.getProperty(item, "Field");
			Element table = GOTOverwrite.getTable(pFormDataSourceField_Field.attributeValue(ATTR_REFENTITYID));
			if (table == null) {
				return "";
			}
			item = (Element) table.selectSingleNode(String.format("TableFields/TableField[@id='%s']",
					pFormDataSourceField_Field.attributeValue(ATTR_REFINNERID)));
		}

		if (item == null) {
			return "";
		}

		if ("TableField".equals(item.getName())) {
			value = GOTHelper.getPropertyValue(item, propertyName);
			if(value == null)value = "";
			if ("Visible".equals(propertyName)) {
				return value;
			}

			if ("AllowEdit".equals(propertyName) || "NotNull".equals(propertyName)) {
				return value;
			}

			Element pTableField_Extends = null;
			if ("Component".equals(item.attributeValue("type"))) {
				if (null != pFormItem_Extends && pFormItem_Extends.elementText("Value").indexOf(".") != -1) {
					pTableField_Extends = GOTHelper.getProperty(item, "Extends");
					String extendsValue = pFormItem_Extends.elementText("Value");
					String extendsFieldValue = extendsValue.split("[.]")[1];
					Element datatype = GOTOverwrite.getDataType(pTableField_Extends.attributeValue(ATTR_REFENTITYID));
					Node property = datatype.selectSingleNode(String.format(
							"DataTypeArray/DataTypeArrayItem[@name='%s']/Properties/Property[Name/text()='%s']",
							extendsFieldValue, "RefDataType"));
					String refentityid = ((Element) property).attributeValue(ATTR_REFENTITYID);
					item = GOTOverwrite.getDataType(refentityid);
				} else if (null != pFormDataSourceField_Field
						&& pFormDataSourceField_Field.elementText("Value").indexOf(".") != -1) {
					pTableField_Extends = GOTHelper.getProperty(item, "Extends");
					String extendsValue = pFormDataSourceField_Field.elementText("Value");
					String extendsFieldValue = extendsValue.split("[.]")[1];
					Element datatype = GOTOverwrite.getDataType(pTableField_Extends.attributeValue(ATTR_REFENTITYID));
					Element property = (Element) datatype.selectSingleNode(String.format(
							"DataTypeArray/DataTypeArrayItem[@name='%s']/Properties/Property[Name/text()='%s']",
							extendsFieldValue, "RefDataType"));
					item = GOTOverwrite.getDataType(property.attributeValue(ATTR_REFENTITYID));
				} else {
					if (validateEquals) {
						if (value.equals(validateString))
							return value;
					} else {
						
						if (!value.equals(validateString))
							return value;
					}
					pTableField_Extends = GOTHelper.getProperty(item, "Extends");
					if (null == pTableField_Extends.attribute(ATTR_REFENTITYID))
						return value;
					item = GOTOverwrite.getDataType(pTableField_Extends.attributeValue(ATTR_REFENTITYID));
				}
			} else {
				if (value != null) {
					if (validateEquals) {
						if (value.equals(validateString))
							return value;
					} else {
						if (!value.equals(validateString))
							return value;
					}
				}
				pTableField_Extends = GOTHelper.getProperty(item, "Extends");
				if (null == pTableField_Extends.attribute(ATTR_REFENTITYID))
					return value;
				item = GOTOverwrite.getDataType(pTableField_Extends.attributeValue(ATTR_REFENTITYID));
				if (null == item)
					item = GOTOverwrite.getEnum(pTableField_Extends.attributeValue(ATTR_REFENTITYID));
			}
		}
		
		if(item == null){
			return "";
		}
		
		while ("DataType".equals(item.getName())) {
			Element tmp = GOTHelper.getProperty(item, propertyName);
			if (null == tmp)
				return value;
			value = tmp.elementText("Value");
			if (validateEquals) {
				if (value.equals(validateString))
					return value;
			} else {
				if (!value.equals(validateString))
					return value;
			}
			Element pDataType_Extends = GOTHelper.getProperty(item, "Extends");
			if (pDataType_Extends == null)// 针对循环到Component后无Extends zhen dui
											// xunhuan dao component hou wu
											// extends
				return value;
			if (null == pDataType_Extends.attribute(ATTR_REFENTITYID))
				return value;
			item = GOTOverwrite.getDataType(pDataType_Extends.attributeValue(ATTR_REFENTITYID));
			if (item == null)
				item = GOTOverwrite.getEnum(pDataType_Extends.attributeValue(ATTR_REFENTITYID));
		}

		if ("Enum".equals(item.getName())) {
			Element tmp = GOTHelper.getProperty(item, propertyName);
			if (null == tmp)
				return value;
			value = tmp.elementText("Value");
			if (validateEquals) {
				if (value.equals(validateString))
					return value;
			} else {
				if (!value.equals(validateString))
					return value;
			}
		}

		return value;

	}

	private static Element getItemEntity(Element item) {
		if (item != null && null != item.attribute("version")){
			return item;
		}else{
			if(item.getParent() != null){
				return getItemEntity(item.getParent());
			}else{
				return null;
			}
		}
			
	}

	public static String getFinalValue(Element item, String propertyName) {
		String value;
		Element p;
		String nodeName = item.getName();

		if (FORMITEM.equals(nodeName)) {
			if (Arrays.asList(nodeextendsproperties).contains(propertyName)) {
				return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue(item, propertyName);
			}

			if (fromdatatypeproperties.containsKey(propertyName)) {
				if (fromdatatypebutformitemalsoproperties.containsKey(propertyName)) {
					value = getFormItemDataTypePropertyValueFromFormItem(item, propertyName);
					return value == null ? fromdatatypebutformitemalsoproperties.get(propertyName) : value;
				} else {
					value = getDataTypePropertyValueFromFormItem(item, propertyName);
					return value == null ? fromdatatypeproperties.get(propertyName) : value;
				}

			}

			if ("FilterField".equals(propertyName)) {
				value = getFilterFieldFromFormItem(item);
				if (value != null)
					return value;
				else
					return "";
			}

			String formItemType = item.attributeValue("type");

			if ("Text".equals(formItemType)) {
				return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue(item, propertyName);
			}

			if ("Label".equals(propertyName) && "FieldGroup".equals(formItemType)) {
				// self
				value = GOTHelper.getPropertyValue(item, propertyName);
				if (!"".equals(value) && value != null)
					return value;

				// FormItem --> TableFieldGroup
				p = GOTHelper.getProperty(item, "FieldGroup");
				Attribute attr = p.attribute(ATTR_REFENTITYID);
				if (attr != null) {
					String refentityid = attr.getStringValue();
					attr = p.attribute(ATTR_REFINNERID);
					String refinnerid = attr.getStringValue();
					Element table = GOTOverwrite.getTable(refentityid);
					Node valuenode = table.selectSingleNode(String.format(
							"TableFieldGroups/TableFieldGroup[@id='%s']/Properties/Property[Name/text()='%s']/Value",
							refinnerid, propertyName));
					value = valuenode.getText();
					if (value != "" && null != value)
						return value;
					else
						return "";
				}

				// FormItem -->FormDataSourceField_Component
				p = GOTHelper.getProperty(item, "Component");
				attr = p.attribute(ATTR_REFINNERID);
				if (attr != null) {
					String refinnerid = attr.getStringValue();
					attr = p.attribute(ATTR_REFENTITYID);
					String refentityid = attr.getStringValue();
					Element table = GOTOverwrite.getTable(refentityid);
					Node tablefield = table
							.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid));
					Node valuenode = tablefield.selectSingleNode(
							String.format("Properties/Property[Name/text()='%s']/Value", propertyName));
					value = valuenode.getText();
					if (value != "" && null != value) {
						return value;
					} else {
						p = GOTHelper.getProperty((Element) tablefield, "Extends");
						attr = p.attribute(ATTR_REFENTITYID);
						refentityid = attr.getStringValue();
						p = GOTOverwrite.getDataType(refentityid);
						valuenode = p.selectSingleNode(
								String.format("Properties/Property[Name/text()='%s']/Value", propertyName));
						value = valuenode.getText();
						if (value != "" && null != value)
							return value;
						else
							return "";
					}
				}

				// FormItem --> Component
				p = GOTHelper.getProperty(item, "Component");
				attr = p.attribute(ATTR_REFENTITYID);
				if (attr != null) {
					String refentityid = attr.getStringValue();
					p = GOTOverwrite.getDataType(refentityid);
					p = GOTHelper.getProperty(p, propertyName);
					value = p.elementText("Value");
					if (value != "" && null != value)
						return value;
					else
						return "";
				}

				return value;
			}

			if (formItemType.indexOf("Editor") == -1) {
				if ("AllowEdit".equals(propertyName) || "Visible".equals(propertyName)) {
					if ("FieldGroup".equals(formItemType)) {
						return getPropertyValueStepByStep(item, propertyName, "false", true, true);
					} else {
						return GOTHelper.getPropertyValue(item, propertyName);
					}
				} else if (PROPERTY_LABEL.equals(propertyName)) {
					if(formItemType.equals("MenuItemButton")){
						Element menuItemPro = GOTHelper.getProperty(item,"MenuItem");
						if(menuItemPro.attributeValue("refentityid") != null){
							String menuItemId = menuItemPro.attributeValue("refentityid");
							Element menuItem = client.gongqi.designer.toolsgot.GOTHelper.getMenuItem(menuItemId);
							if(menuItem != null)
								return getFinalValue(menuItem,propertyName);
						}
					}
					value = GOTHelper.getPropertyValue(item, propertyName);
					if (!"".equals(value) && null != value)
						return value;
					else
						return item.attributeValue(ATTR_NAME);
				} else {
					return GOTHelper.getPropertyValue(item, propertyName);
				}
			}

			if ("AllowEditOnCreate".equals(propertyName)) {
				String allowEdit = GOTHelper.getPropertyValue(item, "AllowEdit");
				if (FALSE.equals(allowEdit))
					return FALSE;
				p = GOTHelper.getProperty(item, "Extends");
				Attribute attrentityid = p.attribute(ATTR_REFENTITYID);
				Attribute attrinnerid = p.attribute(ATTR_REFINNERID);
				if (null == attrentityid || null == attrinnerid)
					return FALSE;
				String pvalue = p.elementText("Value");
				Element pFormItem_DataSource = GOTHelper.getProperty(item, "DataSource");
				String datasourcerefid = pFormItem_DataSource.attributeValue("innerid");
				Element entity = getItemEntity(item);
				Node formdatasourcefield = entity.selectSingleNode(String.format(
						"FormDataSources/FormDataSource[@id='%s']/FormDataSourceFields/FormDataSourceField[@name='%s']",
						datasourcerefid, pvalue));
				allowEdit = GOTHelper.getPropertyValue((Element) formdatasourcefield, "AllowEdit");
				if (FALSE.equals(allowEdit))
					return FALSE;
				Element table = GOTOverwrite.getTable(attrentityid.getText());
				String istmp = GOTHelper.getPropertyValue(table, "Temporary");
				if (TRUE.equals(istmp))
					return FALSE;
				Node pronode = table.selectSingleNode(
						String.format("TableFields/TableField[@id='%s']/Properties/Property[Name/text()='%s']",
								attrinnerid.getText(), propertyName));
				return ((Element) pronode).elementText("Value");
			}

			if (PROPERTY_LABEL.equals(propertyName)) {
				value = getPropertyValueStepByStep(item, propertyName, "", false, true);
				if (!"".equals(value) && null != value)
					return value;
				else
					return item.attributeValue(ATTR_NAME);
			} else if ("HelpText".equals(propertyName) || "DisplayLength".equals(propertyName)
					|| "Regular".equals(propertyName) || "Default".equals(propertyName)) {
				return getPropertyValueStepByStep(item, propertyName, "", false, true);
			} else if ("Alignment".equals(propertyName) || "StringSize".equals(propertyName)
					|| "FormLookup".equals(propertyName) || "ValidateLookup".equals(propertyName)
					|| "NumOfDecimals".equals(propertyName)) {
				return getPropertyValueStepByStep(item, propertyName, "", false, false);
			} else if ("AllowEdit".equals(propertyName)) {
				return getPropertyValueStepByStep(item, propertyName, "false", true, true);
			} else if ("Visible".equals(propertyName)) {
				return getPropertyValueStepByStep(item, propertyName, "false", true, true);
			} else if ("NotNull".equals(propertyName)) {
				return getPropertyValueStepByStep(item, propertyName, "", false, true);
			}
			return null;
		}

		if ("FormDataSourceField".equals(nodeName) || "TableField".equals(nodeName) || "DataType".equals(nodeName)
				|| "Enum".equals(nodeName)) {
			if ("AllowEdit".equals(propertyName)) {
				value = getPropertyValueStepByStep(item, propertyName, "false", true, true);
			} else if ("Visible".equals(propertyName)) {
				value = getPropertyValueStepByStep(item, propertyName, "false", true, true);
			} else if ("NotNull".equals(propertyName)) {
				value = getPropertyValueStepByStep(item, propertyName, "", false, true);
			} else {
				value = getPropertyValueStepByStep(item, propertyName, "", false, true);
			}

			if ("".equals(value)) {
				if ("Label".equals(propertyName))
					return item.attributeValue(ATTR_NAME);
			} else {
				return null == value ? "" : value;
			}

		}

		if ("FormDataSourceFieldGroup".equals(nodeName) && "Label".equals(propertyName)) {
			Element pFormDataSourceFieldGroup_FieldGroup = GOTHelper.getProperty(item, "FieldGroup");
			String refentityid = pFormDataSourceFieldGroup_FieldGroup.attributeValue(ATTR_REFENTITYID);
			String refinnerid = pFormDataSourceFieldGroup_FieldGroup.attributeValue(ATTR_REFINNERID);
			Element table = GOTOverwrite.getTable(refentityid);
			Node valuenode = table.selectSingleNode(
					String.format("TableFieldGroups/TableFieldGroup[@id='%s']/Properties/Property[Name/text()='%s']",
							refinnerid, propertyName));
			value = valuenode.getText();
			if ("".equals(value) || null == value)
				return item.attributeValue(ATTR_NAME);
			else
				return value;
		}

		value = GOTHelper.getPropertyValue(item, propertyName);

		if ("".equals(value) || null == value) {
			/*
			 * if("Label".equals(propertyName) && !"EnumItem".equals(nodeName))
			 * return item.attributeValue(ATTR_NAME); else
			 * if("DefaultOrderBy".equals(propertyName)) return "RecIdx";
			 */
			if (propertyName.equals("Title") && nodeName.equals("Form")) {
				return getTitleByForm(item);
			}

			if (propertyName.equals("Label") && nodeName.equals("MenuItem")) {
				return getLabelByForm(item);
			} else if (propertyName.equals("Label") && nodeName.equals("MenuRefMenu")) {
				Element refMenuPro = getProperty(item, "Menu");
				if (refMenuPro.attribute("refentityid") != null) {
					Element refMenu = getMenu(refMenuPro.attributeValue("refentityid"));
					if (refMenu != null)
						return getFinalValue(refMenu, propertyName);
				}
				return item.attributeValue("name");

			} else if (propertyName.equals("Label") && nodeName.equals("MenuRefMenuItem")) {
				Element refMenuItemPro = getProperty(item, "MenuItem");
				if (refMenuItemPro.attribute("refentityid") != null) {
					Element refMenuItem = getMenuItem(refMenuItemPro.attributeValue("refentityid"));
					if (refMenuItem != null)
						return getLabelByForm(refMenuItem);
				}
				return item.attributeValue("name");
			} else if (propertyName.equals("Label") && !nodeName.equals("EnumItem")) {
				return item.attributeValue("name");
			} else if (propertyName.equals("DefaultOrderBy")) {
				if (nodeName.equals("FormDataSource")) {
					Element tablePro = getProperty(item, "Table");
					if (tablePro.attribute("refentityid") != null) {
//						String xpath = "DataDictionary/Tables/Table[@id='" + tablePro.attributeValue("refentityid")
//								+ "']";
//						Element table = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue("refentityid")) ;
						if (table != null) {
							return getFinalValue(table, propertyName);
						}
					}
				}
				return "RecIdx";
			}
		}
		return value;
	}

	public static String getTitleByForm(Element form) {
		String label = "";
		String menuItemid = form.attributeValue("menuItemId");
		Element menuItem = null;
		if (!"".equals(menuItemid) && menuItemid != null) {
			menuItem = getMenuItem(menuItemid);
			if (menuItem != null) {
				label = getPropertyValue(menuItem, "Label");
				if (label != "")
					return label;
			}
		}
		List<Element> titlePro = GOTHelp.getPPAttElementList(form, "Name", "Title");
		label = titlePro.get(0).elementText("Value");
		if (label != "")
			return label;

		List<Element> labelPro;
		Element dataSource = getTitleFormDataSource(form);
		if (dataSource != null) {
			Element tablePro = GOTHelp.getPPAttElement(dataSource, "Name", "Table");
			if (tablePro.attribute("refentityid") != null) {
				Element table = getTable(tablePro.attributeValue("refentityid"));
				if (table == null)
					throw new Error("GOT错误 在DataSource的Table上找不到Table Entity");
				labelPro = GOTHelp.getPPAttElementList(table, "Name", "Label");
				label = labelPro.get(0).elementText("Value");
				if (!label.equals(""))
					return label;
			}
		}

		Element mainSourceXML = getFirstMainSource(form);
		if (mainSourceXML != null) {
			Element tablePro = getProperty(mainSourceXML, "Table");
			if (tablePro != null && tablePro.attribute("refentityid") != null) {
				Element table = getTable(tablePro.attributeValue("refentityid"));
				if (table != null) {
					label = getPropertyValue(table, "Label");
					if (!label.equals(""))
						return label;
				}
			}
		}

		if (menuItem != null)
			return menuItem.attributeValue("name");

		return form.attributeValue("name");
	}

	@SuppressWarnings("unchecked")
	public static Element getMenuItem(String _id) {
//		String xpath = "MenuItems/MenuItem[@id='" + _id + "']";
//		List<Element> list = NodeGOT.gotXML.selectNodes(xpath);
//		if (list.size() == 0)
//			return null;
//		else
//			return list.get(0);
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("MenuItem", _id);
		return element;
	}

	public static String getPropertyValue(Element xml, String property) {
		return GOTHelp.getPPAttValue(xml, "Name", property);
	}

	@SuppressWarnings("unchecked")
	public static Element getTitleFormDataSource(Element form) {
		/*List<Element> formDesign = form.elements("FormDesign");
		List<Element> titleDataSourcePro = GOTHelp.getPPAttElementList(formDesign.get(0), "Name", "TitleDataSource");
		List<Element> formDesignDataSourcePro = GOTHelp.getPPAttElementList(formDesign.get(0), "Name", "DataSource");
		List<Element> dataSource = null;
		if (titleDataSourcePro.get(0).attribute("innerid") != null) {
			String xpath = "FormDataSources/FormDataSource[@id='" + titleDataSourcePro.get(0).attributeValue("innerid")
					+ "']";
			dataSource = form.selectNodes(xpath);
		} else 
		if (formDesignDataSourcePro.get(0).attribute("innerid") != null) {
			String xpath = "FormDataSources/FormDataSource[@id='"
					+ formDesignDataSourcePro.get(0).attributeValue("innerid") + "']";
			dataSource = form.selectNodes(xpath);
		} else {
			dataSource = form.element("FormDataSources").elements("FormDataSource");
		}*/
		List<Element>  dataSource = form.element("FormDataSources").elements("FormDataSource");
		if (dataSource != null && dataSource.size() == 1) {
			return dataSource.get(0);
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public static Element getTable(String _id) {
//		String xpath = "DataDictionary/Tables/Table[@id='" + _id + "']";
//		List<Element> list = NodeGOT.gotXML.selectNodes(xpath);
//		if (list.size() == 0)
//			return null;
//		else
//			return list.get(0);
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", _id);
		return element;
		
	}

	@SuppressWarnings("unchecked")
	private static Element getFirstMainSource(Element form) {
		List<Element> formDataSources = form.selectNodes("FormDataSources/FormDataSource");
		for (Element formDataSource : formDataSources) {
			String datasource = getPropertyValue(formDataSource, "JoinSource");
			if (datasource == null || datasource.equals("")) {
				return formDataSource;
			}
		}
		return null;
	}

	public static Element getProperty(Element xml, String property) {
		List<Element> list = GOTHelp.getPPAttElementList(xml, "Name", property);
		if (list.size() != 1)
			return null;
		return list.get(0);
	}

	@SuppressWarnings("unchecked")
	public static String getLabelByForm(Element menuItem) {
		String label = "";

		if (menuItem != null) {
			label = getPropertyValue(menuItem, "Label");
			if (!label.equals(""))
				return label;
		}

		Element refpro = getProperty(menuItem, "Source");
		String refid = refpro.attributeValue("refentityid");
		if ("".equals(refid)) {
			if (menuItem != null)
				return menuItem.attributeValue("name");
			else
				return "";
		}
//		String xpath = "Forms/Form[@id='" + refid + "']";
//		List<?> list = NodeGOT.gotXML.selectNodes(xpath);
//		Element form = list.isEmpty() ? null : (Element) list.get(0);
		Element form = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", refid);
		if (form == null) {
			if (menuItem != null)
				return menuItem.attributeValue("name");
			else
				return "";
		}
		List<Element> titlePro = GOTHelp.getPPAttElementList(form, "Name", "Title");
		label = titlePro.get(0).elementText("Value");
		if (!label.equals(""))
			return label;
		List<Element> labelPro;
		Element dataSource = getTitleFormDataSource(form);
		if (dataSource != null) {
			Element tablePro = GOTHelp.getPPAttElementList(dataSource, "Name", "Table").get(0);
			if (tablePro.attribute("refentityid") != null) {
//				xpath = "DataDictionary/Tables/Table[@id='" + tablePro.attributeValue("refentityid") + "']";
//				Element table = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
				Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue("refentityid"));
				if (table == null)
					throw new Error("GOT错误 在DataSource的Table上找不到Table Entity");
				labelPro = GOTHelp.getPPAttElementList(table, "Name", "Label");
				label = labelPro.get(0).elementText("Value");
				if (!label.equals(""))
					return label;
			}
		}

		List<Element> sources = form.selectNodes("FormDataSources/FormDataSource");
		Element mainSource = null;
		for (Element item : sources) {
			String joinType = getPropertyValue(item, "JoinType");
			if (joinType.equals("Passive") || joinType.equals("Delayed") || joinType.equals("Active")
					|| joinType.equals("")) {
				mainSource = item;
				break;
			}
		}

		if (mainSource != null) {
			Element tablePro = getProperty(mainSource, "Table");
			if (tablePro != null && tablePro.attribute("refentityid") != null) {
//				xpath = "DataDictionary/Tables/Table[@id='" + tablePro.attributeValue("refentityid") + "']";
//				Element table = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
				
				Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue("refentityid"));
				if (table != null) {
					label = getPropertyValue(table, "Label");
					if (!label.equals(""))
						return label;
				}
			}
		}
		if (menuItem != null)

			return menuItem.attributeValue("name");

		return form.attributeValue("name");
	}

	public static Element getMenu(String _id) {
		Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", _id);
		return element;
	}
}
