package gongqi.erp.gotmodel.clientcache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;

import edu.emory.mathcs.backport.java.util.Arrays;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.exception.ERPExceptionType;
import gongqi.erp.gotmodel.core.GOTHelper;

public class PropertyHelper {
	
	private static final int STRING = 0;
	private static final int INT = 1;
	private static final int BOOLEAN = 2;
	private static final int PROPERTY_XML = 3;
	
	private static Object setPropertyValue(Map<String,Object> properties,String propertyName,int type,Element item,Object ...args)
	{
		
		if(properties.containsKey(propertyName))
			return properties.get(propertyName);
		
		Object defaultValue = args.length>0?args[0]:null;
		
		if(type==PROPERTY_XML)
		{
			Element xml = GOTHelper.getProperty(item, propertyName);
			if(xml!=null)
			{
				properties.put(propertyName,xml.asXML());
				return properties.get(propertyName);
			}
			else
			{
				return null;
			}
		}
		
		String name = item.getName();
		String value = "";
		if("ReportField".equals(name) || "Report".equals(name) ||  "ReportQuery".equals(name))
			value = GOTFinalValueHelper.getReprotFinalValue(item,propertyName);
		else
			value = GOTFinalValueHelper.getFinalValue(item, propertyName);

		if(value!=null)
		{
			if("".equals(value))
			{
				if(defaultValue!=null)
				{
					properties.put(propertyName, defaultValue);
					return properties.get(propertyName);
				}
			}
			
			switch(type)
			{
				case STRING :
					properties.put(propertyName,value);
					break;
				case BOOLEAN :
					properties.put(propertyName,"true".equals(value)?true:false);
					break;
				case INT :
					properties.put(propertyName,Integer.parseInt("".equals(value)?"0":value));
					break;
				default :
					throw new ERPException(
							ERPExceptionType.WARN, "undefined PropertyValueType");
			}
			return properties.get(propertyName);
		}
		else
		{
			return null;
		}
	}
	
	public static Map< String, Object> getPropertiesObject(Element item)
	{
		if(item==null)
			return null;
		
		Map<String,Object> properties = new HashMap<String, Object>();
		
		String itemName = item.getName();
		String itemType = null;
		if(item.attribute("type") != null)
		{
			itemType = item.attributeValue("type");
		}
		String propertyName = null;
		
		if("FormDesign".equals(itemName))
		{
			propertyName = "Width";
			setPropertyValue(properties,propertyName, INT,item);
			
			propertyName = "Height";
			setPropertyValue(properties,propertyName, INT,item);
			
			propertyName = "AllowEdit";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
			
			propertyName = "TitleDataSource";
			setPropertyValue(properties,propertyName, PROPERTY_XML,item);
			
			propertyName = "AllowResize";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
			
			propertyName = "WindowType";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "DataSource";
			setPropertyValue(properties,propertyName, PROPERTY_XML,item);
			
			propertyName = "Layout";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "X";
			setPropertyValue(properties,propertyName, INT,item);
			
			propertyName = "Y";
			setPropertyValue(properties,propertyName, INT,item);
		}
		
		if("FormItem".equals(itemName))
		{
			propertyName = "Width";
			setPropertyValue(properties,propertyName, STRING,item);
			
			propertyName = "Height";
			setPropertyValue(properties,propertyName, STRING,item);
			
			propertyName = "Label";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "AllowEdit";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
			
			propertyName = "Visible";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
			
			propertyName = "HideInvisible";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "SkipTab";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
			
			if("Text".equals(itemType))
			{
				propertyName = "Alignment";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "AlignBase";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "DisplayLength";
				setPropertyValue(properties,propertyName, INT,item);
				
				propertyName = "DisplayHeight";
				setPropertyValue(properties,propertyName,INT,item);
			}
			
			if(itemType.indexOf("Editor")!=-1)
			{
				if("StringEditor".equals(itemType))
				{
					propertyName = "FilterField";
					setPropertyValue(properties,propertyName,STRING,item);
					
					propertyName = "SearchMode";
					setPropertyValue(properties,propertyName,STRING,item);
					
					propertyName = "LookupMode";
					setPropertyValue(properties,propertyName,STRING,item);
					
					propertyName = "AllowKeyIn";
					setPropertyValue(properties,propertyName,BOOLEAN,item);

				}
				
				if("LongEditor".equals(itemType) || "DecimalEditor".equals(itemType))
				{
					propertyName = "AutoSum";
					setPropertyValue(properties,propertyName,BOOLEAN,item);
				}
				
				propertyName = "HelpText";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "DisplayHeight";
				setPropertyValue(properties,propertyName, INT, item,1);
				
				propertyName = "DisplayLength";
				setPropertyValue(properties,propertyName, INT,item);
				
				propertyName = "Alignment";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "NotNull";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
				propertyName = "Regular";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "Default";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ShowLabel";
				setPropertyValue(properties,propertyName, BOOLEAN,item);
				
				propertyName = "LabelAlignment";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "DataSource";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "Extends";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "DataMethod";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "QuerySource";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "QueryField";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "QueryFilter";
				setPropertyValue(properties,propertyName,STRING,item);
				
			}
			
			if("FieldGroup".equals(itemType))
			{
				propertyName = "FieldGroup";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "Component";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "LabelLength";
				setPropertyValue(properties,propertyName,INT,item);
				
				propertyName = "DisplayLength";
				setPropertyValue(properties,propertyName,INT,item);
				
				propertyName = "HeaderAlign";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ShowLabel";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
				propertyName = "Columns";
				setPropertyValue(properties,propertyName,INT,item);
			}
			
			if(itemType.indexOf("Button")!=-1)
			{
				propertyName = "Icon";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "DisabledIcon";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ShortCut";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "DisplayMode";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "SaveRecord";
				setPropertyValue(properties,propertyName, BOOLEAN,item);
				
				propertyName = "MultiSelect";
				setPropertyValue(properties,propertyName, BOOLEAN,item);
				
				propertyName = "DataSource";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "AuthorityLevel";
				setPropertyValue(properties,propertyName,STRING,item);
				
			}
			
			if("Button".equals(itemType))
			{
				propertyName = "QueryType";
				setPropertyValue(properties,propertyName,STRING,item);
			}
			
			if("MenuItemButton".equals(itemType))
			{
				propertyName = "MenuItem";
				setPropertyValue(properties,propertyName,PROPERTY_XML,item);
			}
			
			if("ButtonGroup".equals(itemType))
			{
				propertyName = "Layout";
				setPropertyValue(properties,propertyName,STRING,item);
			}
			
			if("DataGrid".equals(itemType))
			{
				propertyName = "MultiSelect";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
				propertyName = "ShowHeader";
				setPropertyValue(properties,propertyName, BOOLEAN,item);
				
				propertyName = "Rows";
				setPropertyValue(properties,propertyName,INT,item);
				
				propertyName = "HeaderHeight";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName="DisableAutoSave";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
			}
			
			if("Image".equals(itemType))
			{
				propertyName = "URL";
				setPropertyValue(properties,propertyName, STRING,item);
				
				propertyName = "Suffix";
				setPropertyValue(properties,propertyName, STRING,item);
				
				propertyName = "Popup";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "LayoutMode";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "FailureImage";
				setPropertyValue(properties,propertyName,STRING,item);
			}
			
			if("Plugin".equals(itemType))
			{
				propertyName = "ControlType";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ClassName";
				setPropertyValue(properties,propertyName,STRING,item);
			}
			
			if("Group".equals(itemType))
			{
				propertyName = "GroupType";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "MainContentAlignment";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ShowLabel";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
				propertyName = "ShowBorder";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
				
				propertyName = "Collapsible";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
			}
			
			if("DividedBox".equals(itemType))
			{
				propertyName = "ShowBorder";
				setPropertyValue(properties,propertyName,BOOLEAN,item);
			}
			
			if("FieldGroup".equals(itemType) || "DataGrid".equals(itemType) || "Group".equals(itemType) 
				|| "DividedBox".equals(itemType) || "Tab".equals(itemType) || "TabPage".equals(itemType))
			{
				propertyName = "DataSource";
				setPropertyValue(properties,propertyName, PROPERTY_XML,item);
				
				propertyName = "Layout";
				setPropertyValue(properties,propertyName,STRING,item);
			}
		}
		
		
		String[] types = new String[]{"String", "StringEditor", 
				"Long", "LongEditor",
				"Decimal", "DecimalEditor",
				"Date", "DateEditor",
				"Time", "TimeEditor",
				"Boolean", "BooleanEditor",
				"Enum", "EnumEditor"};
		
		if(Arrays.asList(types)
			.indexOf(itemType)!=-1
		)
		{
			propertyName = "Alignment";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "Regular";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "NotNull";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "AllowEdit";
			setPropertyValue(properties,propertyName,BOOLEAN,item);

			propertyName = "AllowEditOnCreate";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "Default";
			setPropertyValue(properties,propertyName,STRING,item);

			propertyName = "SkipTab";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "DisplayHeight";
			setPropertyValue(properties,propertyName,INT,item,1);
			
			propertyName = "DisplayLength";
			setPropertyValue(properties,propertyName,INT,item);
			
			propertyName = "Label";
			setPropertyValue(properties,propertyName,STRING,item);
		}
		
		if("Date".equals(itemType) || "DateEditor".equals(itemType))
		{
			propertyName = "Seperator";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "NumOfYear";
			setPropertyValue(properties,propertyName,INT,item);
			
			propertyName = "NumOfMonth";
			setPropertyValue(properties,propertyName,INT,item);
				
			propertyName = "NumOfDay";
			setPropertyValue(properties,propertyName,INT,item);
			
			propertyName = "Show1970";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
		}
		
		if("Long".equals(itemType) || "LongEditor".equals(itemType) || "Decimal".equals(itemType) || "DecimalEditor".equals(itemType))
		{
			propertyName = "ShowZero";
			setPropertyValue(properties,propertyName, BOOLEAN,item);

			propertyName = "ThousandSeperator";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
		
			propertyName = "AllowNegative";
			setPropertyValue(properties,propertyName, BOOLEAN,item);
		}
		
		if("Decimal".equals(itemType) || "DecimalEditor".equals(itemType))
		{
			propertyName = "NumOfDecimals";
			setPropertyValue(properties,propertyName, INT, item,2);
			
			propertyName = "ShowDecimals";
			setPropertyValue(properties,propertyName, INT,item);
			
			propertyName = "RoundOff";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "ThousandSeperator";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "AllowNegative";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "ShowZero";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
		}
		
		if("String".equals(itemType) || "StringEditor".equals(itemType))
		{
			propertyName = "StringSize";
			setPropertyValue(properties,propertyName, INT, item, 20);
			
			propertyName = "Trim";
			setPropertyValue(properties,propertyName,STRING,item );
			
			propertyName = "ChangeCase";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "FormLookup";
			setPropertyValue(properties,propertyName,STRING,item);
			
			if("StringEditor".equals(itemType))
			{
				propertyName = "ReturnLookup";
				setPropertyValue(properties,propertyName,STRING,item);
				
				propertyName = "ValidateLookup";
				setPropertyValue(properties,propertyName, BOOLEAN, item);
			}
		}
		
		if("Time".equals(itemType) || "TimeEditor".equals(itemType))
		{
			propertyName = "ShowHour";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "ShowMinute";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
			
			propertyName = "ShowSecond";
			setPropertyValue(properties,propertyName,BOOLEAN,item);
		}
		
		List<Object> dataProvider = null;
		
		if("Enum".equals(itemType))
		{
			if("TableField".equals(itemType))
			{
				dataProvider = EnumSourceHelper.getDataSourceByTableField(item);
			}
			else if(itemName == "ReportField")
			{
				dataProvider = EnumSourceHelper.getDataSourceByReportField(item);
			}
			else
			{
				dataProvider = EnumSourceHelper.getDataSourceByDataType(item.attributeValue("id"));
			}
			properties.put("DataProvider", dataProvider);
		}
		
		if("EnumEditor".equals(itemType))
		{	
			Element sourcePro = GOTHelper.getProperty(item,"Source"); 
			String _type = sourcePro.elementText("Value");
			Element dataSourcePro = GOTHelper.getProperty(item, "DataSource");
			Element extendsPro = GOTHelper.getProperty(item,"Extends");
			
			if("DataSource".equals(_type))
			{
				if(null != dataSourcePro.attribute("innerid"))
				{
					dataProvider = EnumSourceHelper.getDataSourceByDataSource(extendsPro); 
				}
				else
				{
					dataProvider = EnumSourceHelper.getDataSourceByRegular(item);
				}
			}
			
			if("Enum".equals(_type))
			{
				dataProvider = EnumSourceHelper.getDataSourceByEnum(extendsPro);
			}
			
			if("DataType".equals(_type))
			{
				dataProvider = EnumSourceHelper.getDataSourceByDataType(extendsPro);
			}
			
			if("Regular".equals(_type))
			{
				dataProvider = EnumSourceHelper.getDataSourceByRegular(item);
			}
			properties.put("DataProvider", dataProvider);
		}
		
		if("Enum".equals(itemName))
		{
			dataProvider = EnumSourceHelper.getDataSourceByEnum(item.attributeValue("id"));
			properties.put("DataProvider", dataProvider);
			
			
			propertyName = "Label";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "HelpText";
			setPropertyValue(properties,propertyName,STRING,item);
			
			propertyName = "DisplayLength";
			setPropertyValue(properties,propertyName,INT,item);
		}
		
		return properties;
	}
	
	
}
