package gongqi.gdt.designer.plugin;

import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GOTPlugin extends AbstractUIPlugin {

	private static Logger log = Logger.getLogger(GOTPlugin.class);
	
	// The plug-in ID
	public static final String PLUGIN_ID = "GOT"; //$NON-NLS-1$

	// The shared instance
	private static GOTPlugin plugin;
	
	/**
	 * The constructor
	 */
	public GOTPlugin() {
		
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
//		System.setProperty("got.menus.show", "got.menus.show");
//		bear.openConsole();
		log.info("GOTPlugin start");
		
		super.start(context);
		plugin = this;

	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		log.info("GOTPlugin stop");
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static GOTPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}

	
	
}
