package gongqi.gdt.designer.plugin;

import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleConstants;

public class StartupListener implements IStartup {

	private static Logger log = Logger.getLogger(StartupListener.class);
	
	@Override
	public void earlyStartup() {
		log.info(this.getClass().getName() + " earlyStartup");
		Display.getDefault().asyncExec(()->{
			try {
				IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
				activeWorkbenchWindow.addPerspectiveListener(new PerspectiveListener());
				
				IWorkbenchPage plat = activeWorkbenchWindow.getActivePage();
				if(GOTPerspective.ID.equals(plat.getPerspective().getId())){
					try {
						plat.showView(GOTView.ID);
						plat.showView(IConsoleConstants.ID_CONSOLE_VIEW);
						plat.setPartState(plat.getActivePartReference(), IWorkbenchPage.STATE_RESTORED);
					} catch (PartInitException e) {
						log.error("初始化显示GOT视图错误", e);
					}
				}
			} catch (Exception e) {
				log.error("GOTPlugin启动错误", e);
			}
		});
	}

}
