package gongqi.gdt.designer.ui;


import java.awt.Toolkit;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public abstract class SWTUtils {

	/**
	 * 基准水平方向分辨率
	 */
	private static final double STANDARD_SCREEN_WIDTH = 1920;
	
	/**
	 * 屏幕宽度
	 */
	public static final double SCREEN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
	
	/**
	 * 屏幕高度
	 */
	public static final double SCREEN_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
	
	public final static float DPI_SCALE;
	
    static {
    	Point dpi = Display.getDefault().getDPI();
    	DPI_SCALE = dpi.x/((float)96);
    }
	
    public static int zoom(int source){
//    	return (int) (((SCREEN_WIDTH/DPI_SCALE) / STANDARD_SCREEN_WIDTH) * source);
    	if (SCREEN_WIDTH < STANDARD_SCREEN_WIDTH) {
    		return source;
		}
    	return (int) ((SCREEN_WIDTH / STANDARD_SCREEN_WIDTH) * source);
    }
    
    
}
