package info.gongqi.got.help;

import java.io.InputStream;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GOTPPHelpUtil {

	public static String getPPHelpText(String type, String path, String propertyName){
		String value = "";
		try {
			switch (propertyName) {
			case "CreatedDate":
				return "节点创建日期，格式yyyy-MM-dd，不可修改，节点在创建的时候自动生成";
			case "CreatedTime":
				return "节点创建时间，格式HH:mm:ss，不可修改，节点在创建的时候自动生成";
			case "CreatedBy":
				return "节点创建人：节点在创建的时候自动生成";
			case "ModifiedDate":
				return "节点修改日期，格式yyyy-MM-dd，不可修改，节点在修改保存的时候自动生成";
			case "ModifiedTime":
				return "节点修改时间，格式HH:mm:ss，不可修改，节点在修改保存的时候自动生成";
			case "ModifiedBy":
				return "节点修改人：节点在修改的时候自动生成";
			default:
				break;
			}
			
			InputStream inputStream = GOTPPHelpUtil.class.getResourceAsStream(type + ".xml");
			Document document = new SAXReader().read(inputStream);
			List<Element> elements = document.getRootElement().selectNodes(path);
			for (Element element : elements) {
				if(element.elementText("Name").equals(propertyName)){
					return element.elementText("Describtion");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return value;
	}
	
//	public static void main(String[] args) {
//		String a = getPPHelpText("Form", "/Form/Properties/Property", "FormType");
//		System.out.println(a);
//	}
	
}
