package info.gongqi.got.tool;

import info.gongqi.got.util.GOTMessageDialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

public class ChoseUser extends Dialog {

	protected String result;
	protected Shell shell;
	private Combo text;

	private String[] user;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public ChoseUser(Shell parent, int style, String[] user) {
		super(parent, style);
		setText("选择用户");
		this.user = user;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public String open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(300, 145);
		shell.setText(getText());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        
		Label lblNewLabel = new Label(shell, SWT.NONE);
		lblNewLabel.setBounds(10, 10, 118, 17);
		lblNewLabel.setText("请选择用户");
		
		text = new Combo(shell, SWT.BORDER);
		text.setBounds(61, 33, 201, 23);
		text.setItems(user);
		
		Label lblNewLabel_1 = new Label(shell, SWT.NONE);
		lblNewLabel_1.setBounds(48, 36, 12, 17);
		lblNewLabel_1.setText("*");
		lblNewLabel_1.setForeground(SWTResourceManager.getColor(SWT.COLOR_RED));
		
		Button btnconfirm = new Button(shell, SWT.NONE);
		btnconfirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				result = text.getText();
				if(result == null || result.equals("")){
					e.doit = false;
					return;
				}else{
//					LoadXmlCore.context.setIdentityId(text.getText());
					shell.dispose();
				}
			}
		});
		btnconfirm.setBounds(120, 80, 80, 27);
		btnconfirm.setText("确定");

		GOTMessageDialog.shells.add(shell);
	}
}
