package info.gongqi.got.tool;

import info.gongqi.got.util.GOTMessageDialog;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.swt.SWTResourceManager;

public class EnterNodeRef extends Dialog {

	protected Object result;
	protected Shell shell;

	private Element xml;
	private Tree tree;
	private Label info;
	private boolean flag; 

	/**
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public EnterNodeRef(Shell parent, int style, Element element, boolean flags) {
		super(parent, style);
		setText("ref");
		xml = element;
		flag = flags;
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(500, 320);
		shell.setText("提示");
		shell.setImage(SWTResourceManager.getImage(EnterNodeRef.class, "/resources/nodeicons/EnumItem.png"));
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		shell.setLayout(new FormLayout());
		tree = new Tree(shell, SWT.V_SCROLL | SWT.WRAP | SWT.BORDER | SWT.CLOSE);
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if(!xml.getName().equals("tempRoot")){
					List<Element> elements = xml.elements();
					Collections.sort(elements, new Comparator<Element>() {
						@Override
						public int compare(Element o1, Element o2) {
							return o1.attributeValue("nodeType").compareToIgnoreCase(o2.attributeValue("nodeType"));
						}
					});
					xml.setContent(elements);
				}
				buildTree(xml, tree, null);
			}
		});
		
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 0);
        fd_table.bottom = new FormAttachment(100, -27);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.right = new FormAttachment(100, 0);
        tree.setLayoutData(fd_table);
		
        Button button = new Button(shell, SWT.FLAT);
        button.setText("  确定  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment(tree, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData(fd_button);
        button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
        	
		});
        
        info = new Label(shell, SWT.NONE);
        FormData fd_info = new FormData();
        fd_info.top = new FormAttachment(tree, 2);
        fd_info.bottom = new FormAttachment(100,-2);
        fd_info.left = new FormAttachment(0, 2);
        fd_info.right = new FormAttachment(90, 0);
        info.setLayoutData(fd_info);
        
        
		if(flag){
	        tree.addListener(SWT.Selection, new Listener() {
	            public void handleEvent(Event event) {
	                TreeItem trtmNewTreeitem = (TreeItem) event.item;
	                //此处的element不需要从map中取
	                Element element = (Element) trtmNewTreeitem.getData();
	                String title = getAttrChain(element, "relation");
	                shell.setText(title);
	            }
	        });
	        
	        tree.addListener(SWT.MouseDoubleClick, new Listener() {
	            public void handleEvent(Event event) {
	            	int count = tree.getSelectionCount();
	                if(count != 0){
	                	Point point = new Point(event.x, event.y);
	                	TreeItem treeitem = tree.getItem(point);
	                	if(treeitem == null){
	                		event.doit = false;
	                		return;
	                	}
	                	//此处的element不需要从map中取
	                	Element element = (Element) treeitem.getData();
	                	FormDataSyn.refTreeItem(element);
	                }
	            }
	        });
		}
        
		GOTMessageDialog.shells.add(shell);
	}

	@SuppressWarnings("unchecked")
	private void buildTree(Element elementTar, Tree treeParent, TreeItem parentItem) {
		if(elementTar.getName().equals("tempRoot")){
			List<Element> elements = elementTar.elements();
			for (Element element : elements) {
				buildTree(element, treeParent, null);
			}
			return;
		}
		TreeItem trtmNewTreeitem = null;
		if(parentItem != null){
			trtmNewTreeitem = new TreeItem(parentItem, SWT.NONE);
			if(parentItem.getParentItem() == null){
				parentItem.setExpanded(true);
			}
		}else{
			trtmNewTreeitem = new TreeItem(treeParent, SWT.NONE);
			trtmNewTreeitem.setExpanded(true);
		}
		String text = "";
		if(flag){
			text = extendsChainTreeLabelFunc(elementTar);
			trtmNewTreeitem.setData(elementTar);
		}else{
			if(elementTar.getText().equals("") || elementTar.getText() == null){
				text = elementTar.getName();
			}else{
				text = elementTar.getName() + " --> " + elementTar.getText();
			}
		}
		
		trtmNewTreeitem.setText(text);
//		trtmNewTreeitem.setForeground(0, trtmNewTreeitem.getDisplay().getSystemColor(SWT.COLOR_RED));
//		trtmNewTreeitem.setExpanded(true);
		if(flag){
			trtmNewTreeitem.setImage(extendsChainTreeIconFunc(elementTar));
		}

		List<Element> elements = elementTar.elements();
		for (Element element : elements) {
			buildTree(element, null, trtmNewTreeitem);
		}
	}

	private String extendsChainTreeLabelFunc(Element item) {
		String label = item.attributeValue("name");
		if (item.attribute("relation") != null){
			label += (" --> [" + item.attributeValue("relation") + "]");
		}
		if (item.attribute("nodeType") != null) {
			String _nodeType = item.attributeValue("nodeType");
			if (_nodeType != null)
				label = "[" + _nodeType + "]   " + label;
		}
		return label;
	}

	@SuppressWarnings("unchecked")
	public String getAttrChain(Element node, String... args) {
		if (node == null)
			return "";
		
		String entityId = node.attributeValue("entityId");
		String innerId = node.attributeValue("innerId");
		String str = "entityId:" + entityId + ",innerId:" + innerId;
		Map<String, Integer> type = new HashMap<String, Integer>();
		typeMap(node, type);
		
		String msg = "";
		for (String key : type.keySet()) {
			msg += key + "[" + type.get(key) + "] " ;
		}
		info.setText(msg);
		
//		List<Element> elements = node.elements();
//		for (Element element : elements) {
//			String nodeType = element.attributeValue("nodeType");
//			if(type.containsKey(nodeType)){
//				int num = type.get(nodeType);
//				num++;
//				type.put(nodeType, num);
//			}else{
//				type.put(nodeType, 1);
//			}
//		}
		
/*		List<Attribute> attrList = node.attributes();
		Boolean flag = false;
		String name;
		for (Attribute attr : attrList) {
			flag = false;
			name = attr.getName();

			for (String key : args) {
				if (name.equals(key)) {
					flag = true;
					break;
				}
			}
			if (flag)
				continue;

			str += (attr.getName().concat("=").concat(attr.asXML()).concat(" "));
		}*/
		
		return str;
	}
	
	private void typeMap(Element node, Map<String, Integer> type){
		List<Element> elements = node.elements();
		for (Element element : elements) {
			String nodeType = element.attributeValue("nodeType");
			if(type.containsKey(nodeType)){
				int num = type.get(nodeType);
				num++;
				type.put(nodeType, num);
			}else{
				type.put(nodeType, 1);
			}
			typeMap(element, type);
		}
	}
	
	private Image extendsChainTreeIconFunc(Element item){
		String nodeName = item.attributeValue("nodeType");
		String iconClassName = nodeName;
//		if(!nodeName.equals(GOTNodesConst.DATATYPE) && !nodeName.equals(GOTNodesConst.TABLEFIELD) && nodeName.equals(GOTNodesConst.FORMDATASOURCEFIELD)){
//			if(item.attribute("type") != null){
//				iconClassName += item.attributeValue("type");
//			}
//		}
		String imgPath = "/resources/nodeicons/" + iconClassName + ".png";
		Image image = SWTResourceManager.getImage(EnterNodeRef.class, imgPath);
		if(image == null){
			imgPath = "/resources/nodeicons/Default.png";
			image = SWTResourceManager.getImage(EnterNodeRef.class, imgPath);
		}
		return image;
	}
}
