package info.gongqi.got.tool;

import gongqi.designer.core.DesignerServer;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.GOTUtil;
import info.gongqi.got.util.NumCore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.Macros;

public class FormDataSyn {
 
	public static List<TreeUi> treeUis = new ArrayList<>();

	public static int restore_treeItem_index = -1;
	
	public static TreeUi dragTreeUi;
	
	public static TreeItem current;
	
	public static TreeUi currentTreeUi;
	
	/**
	 * 
	 * @param trtmNewTreeitem
	 *            树节点对象
	 * @param treeItemId
	 *            树节点的id
	 * @param element
	 *            树节点的XML
	 * @param node
	 *            XML对应的解析器
	 * @param index
	 *            子树节点的位置
	 */
	public static void actionSyn(final TreeItem trtmNewTreeitem, final String treeItemId, final Element element, final NodeGOT node,
			final Integer index, final String action) {
		try {
			final String id = (String) trtmNewTreeitem.getData("id");
			if(action.equals("copy")){
				TreeItem item = FormDataSyn.treeUis.get(0).itemsMap.get(id);
				addTreeItemCopy(item.getParentItem(), treeItemId, element, node, index, id);
			}else if(action.contains("new") || action.contains("exchange")){
				
				Display.getDefault().asyncExec(new Runnable() {
					@Override
					public void run() {
						for (int i = 0; i < treeUis.size(); i++) {
							TreeUi treeUi = treeUis.get(i);
							TreeItem item = treeUi.itemsMap.get(id);
							if(i > 0 && item != null){
								addTreeItemSync(trtmNewTreeitem, item, treeItemId, element, node, index, action, treeUi, false);
							}else{
								if(item != null){
									treeUi.loadChildItem(item);
									addTreeItem(trtmNewTreeitem, item, treeItemId, element, node, index, action, treeUi, true);
								}
							}
						}
					}
				});
				

			}
			
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}


	}


	/**
	 * 新增树节点操作
	 * 
	 * @param treeitem
	 * @param treeItemId
	 * @param element
	 * @param node
	 * @param index
	 */
	public static void addTreeItem(TreeItem oriItem ,TreeItem treeitem, String treeItemId, Element element,
			NodeGOT node, Integer index, String action, TreeUi treeUi, boolean addChild) {
		try {
			bulidTree(element, treeitem, treeItemId, node, index, action, treeUi, false, addChild);
			if(oriItem.getParent() == treeUi.getTree()){
				TreeItem select = treeUi.itemsMap.get(treeItemId);
				if(select != null ){
					treeUi.getTree().setSelection(select);
					Element element2 = GotXmlDto.getInstance().getCurrentElement(select);
					if(element2 != null){
						treeUi.loadTableValue(treeUi.getTable(), element2, select);
						if(action.equals("new")){
//							treeUi.loadTableValue(treeUi.getTable(), element2, select);
							treeItemEditor(select, node, true, treeUi);
						}
					}
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}

	/**
	 * 新增树节点操作
	 * 
	 * @param treeitem
	 * @param treeItemId
	 * @param element
	 * @param node
	 * @param index
	 */
	public static void addTreeItemSync(TreeItem oriItem ,TreeItem treeitem, String treeItemId, Element element,
			NodeGOT node, Integer index, String action, TreeUi treeUi, boolean addChild) {
		try {
			bulidTree(element, treeitem, treeItemId, node, index, action, treeUi, false, addChild);
			TreeItem base = treeUis.get(0).itemsMap.get(treeItemId);
			TreeItem tar = treeUi.itemsMap.get(treeItemId);
			copyTreeItem(base, tar, treeUi);
			
			if(oriItem.getParent() == treeUi.getTree()){
				TreeItem select = treeUi.itemsMap.get(treeItemId);
				if(select != null ){
					treeUi.getTree().setSelection(select);
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 复制
	 * 
	 * @param treeitem
	 * @param treeItemId
	 * @param element
	 * @param node
	 * @param index
	 */
	public static void addTreeItemCopy(final TreeItem treeitem, final String treeItemId, final Element element,
			final NodeGOT node, final Integer index, final String id) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				try {
					bulidTree(element, treeitem, treeItemId, node, index, "copy", null, false, true);
					treeUis.get(0).insertMap(treeitem);
					for (int i = 0; i < FormDataSyn.treeUis.size(); i++) {
						if(i > 0){
							TreeItem _item  = FormDataSyn.treeUis.get(i).itemsMap.get(id);
							if(_item != null){
								TreeItem tar  = FormDataSyn.treeUis.get(0).itemsMap.get(treeItemId);
								TreeItem copyItem = null;
								if(_item.getParentItem() == null){
									copyItem = new TreeItem(_item.getParent(), SWT.NONE, _item.getParent().indexOf(_item) + 1);
								}else{
									copyItem = new TreeItem(_item.getParentItem(), SWT.NONE ,_item.getParentItem().indexOf(_item) + 1);
								}
								copyItem.setData("id", tar.getData("id").toString());
								copyItem.setText(tar.getText());
								copyItem.setText(1, tar.getText(1));
								Element element = GotXmlDto.getInstance().getCurrentElement(tar);
								copyItem.setData("elementName", element.getName());
						        if(element.attributeValue("id") != null){
						        	copyItem.setData("elementId", element.attributeValue("id"));
						        }
						        if(NodeGOT.getEntity(element) != null){
						        	copyItem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
						        }
								copyItem.setFont(tar.getFont());
								copyItem.setImage(tar.getImage());
								copyItem.setBackground(tar.getBackground());
								copyItem.setForeground(tar.getForeground());
								copyItem.setData("chinese", tar.getData("chinese"));
								treeUis.get(i).itemsMap.put(tar.getData("id").toString(), copyItem);
								restoreSynItems(tar, copyItem, treeUis.get(i), false);
							}
						}
					}
				} catch (final Exception e) {
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							GOTMessageDialog.alert(e);
						}
					});
					e.printStackTrace();
					TreeOperationInfo.addErrorInfo(e.getMessage());
				}
			}
		});
	}
	

	
	/**
	 * 删除树节点操作
	 * 
	 * @param trtmNewTreeitem
	 */
	public static void deleteTreeItem(TreeItem trtmNewTreeitem) {
		try {
			String id = (String) trtmNewTreeitem.getData("id");
			for (TreeUi treeUi : treeUis) {
				TreeItem item = treeUi.itemsMap.get(id);
				if(item != null){
					TreeItem parent = item.getParentItem();
					if(parent != null){
						if(!parent.isDisposed() && !trtmNewTreeitem.isDisposed()){
							if(parent != null && trtmNewTreeitem.getParent() == treeUi.getTree()){
								int index = parent.indexOf(item);
								if(index == 0){
									if(parent.getItemCount() == 1){
										treeUi.getTree().setSelection(parent);
										Element element = GotXmlDto.getInstance().getCurrentElement(parent);
										treeUi.loadTableValue(treeUi.getTable(), element, parent);
									}else{
										TreeItem select = parent.getItem(index + 1);
										treeUi.getTree().setSelection(select);
										Element element = GotXmlDto.getInstance().getCurrentElement(select);
										if(element != null){
											treeUi.loadTableValue(treeUi.getTable(), element, select);
										}
									}
								}else{
									TreeItem select = parent.getItem(index - 1);
									treeUi.getTree().setSelection(select);
									Element element = GotXmlDto.getInstance().getCurrentElement(select);
									treeUi.loadTableValue(treeUi.getTable(), element, select);
								}
							}
						}
					}
					treeUi.itemsMap.remove(id);
					deleteChild(item, treeUi);
					item.removeAll();
					item.dispose();
					//
					if(parent != null && parent.getText().equals("Menus")){
						sendList(parent);
					}
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}

	/**
	 * 删除树节点操作
	 * 
	 * @param trtmNewTreeitem
	 */
	public static void deleteOneTreeItem(TreeItem trtmNewTreeitem) {
		try {
			String id = (String) trtmNewTreeitem.getData("id");
			for (TreeUi treeUi : treeUis) {
				TreeItem item = treeUi.itemsMap.get(id);
				if(item != null){
					treeUi.itemsMap.remove(id);
					item.removeAll();
					item.dispose();
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 删除树节点的子节点
	 * @param item
	 * @param treeUi
	 */
	private static void deleteChild(TreeItem item, TreeUi treeUi){
		try {
			TreeItem[] items = item.getItems();
			for (TreeItem treeItem : items) {
				String id = (String) treeItem.getData("id");
				treeUi.itemsMap.remove(id);
				deleteChild(treeItem, treeUi);
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		
	}

	/**
	 * 同步设置树节点的名称
	 * 
	 * @param trtmNewTreeitem
	 * @param text
	 */
	public static void textSyn(TreeItem trtmNewTreeitem) {
		try {
			String id = (String) trtmNewTreeitem.getData("id");
			for (TreeUi treeUi : treeUis) {
				TreeItem item = getTreeItrmEntityById(treeUi, id);
				if(item != null){
					Element element = GotXmlDto.getInstance().getCurrentElement(item);
					String text = element.attributeValue("name");
					if(element.getName().equals("FormItem")){
						String result = element.attributeValue("type") + "::" + text;
						item.setText(result);
					}else{
						item.setText(text);
					}
					setUnSave(item);
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}


	/**
	 * 设置树节点可编辑，并设text
	 * 
	 * @param treeitem
	 * @param node
	 */
	public static void treeItemEditor(final TreeItem treeitem, final NodeGOT node, boolean edit, final TreeUi ui) {
		try {
			final TreeEditor editor = new TreeEditor(treeitem.getParent());
			Control oldEditor = editor.getEditor();
			if (oldEditor != null) {
				oldEditor.dispose();
			}

			final String oldText = treeitem.getText();
			final Text changeItemText = new Text(treeitem.getParent(), SWT.BORDER);
			changeItemText.setFont(treeitem.getFont());
			if(ConfigComposite.configComposite.DPIZOOM.compareTo(BigDecimal.ONE) > 0){
				Font fonts = changeItemText.getFont();
				FontData data = fonts.getFontData()[0];
				data.height = data.height - 1;
				fonts = new Font(changeItemText.getDisplay(), data);
				changeItemText.setFont(fonts);
			}
			changeItemText.computeSize(SWT.DEFAULT, treeitem.getParent().getItemHeight());
			editor.grabHorizontal = true;
			editor.minimumHeight = changeItemText.getSize().y;
			editor.minimumWidth = changeItemText.getSize().x;
			editor.setEditor(changeItemText, treeitem);
			changeItemText.setText(editText(oldText));
			changeItemText.setEditable(edit);
			changeItemText.forceFocus();
			changeItemText.selectAll();
			// 编辑后变回表格样式
			changeItemText.addFocusListener(new FocusAdapter() {
				@Override
				public void focusLost(FocusEvent focusevent) {
					Control defaultEditor = editor.getEditor();
					editor.setEditor(defaultEditor, treeitem);
					if (!changeItemText.getText().trim().equals(oldText.trim())) {
						if(oldText.contains("::") && changeItemText.getText().trim().equals(editText(oldText))){
							changeItemText.setText(oldText);
							changeItemText.dispose();
						}else{
							afterModifyTreeItem(treeitem, node, ui, changeItemText, oldText);
						}
					} else {
						changeItemText.setText(oldText);
						changeItemText.dispose();
					}

				}
			});
			
			changeItemText.addKeyListener(new KeyAdapter() {
				@Override
				public void keyPressed(KeyEvent e) {
					//回车
					if(e.keyCode == 13 ){
						Control defaultEditor = editor.getEditor();
						editor.setEditor(defaultEditor, treeitem);
						if (!changeItemText.getText().trim().equals(oldText.trim())) {
							if(oldText.contains("::") && changeItemText.getText().trim().equals(editText(oldText))){
								changeItemText.setText(oldText);
								changeItemText.dispose();
							}else{
								afterModifyTreeItem(treeitem, node, ui, changeItemText, oldText);
							}
						} else {
							changeItemText.setText(oldText);
							changeItemText.dispose();
						}
					}
				}
				@Override
				public void keyReleased(KeyEvent e) {
					
				}
			});
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}

	private static void afterModifyTreeItem(TreeItem treeitem,NodeGOT node,TreeUi ui, Text changeItemText, String oldText){
		try {
			if(node.xml.getName().equals("Forms")){
				Element eleForm = node.xml.element("Form");
				node = NodeFactory.getNode(eleForm);
			}
			if(node.validateNewName(changeItemText.getText())){
				node.xml.addAttribute("name", changeItemText.getText());
				if(oldText.contains("::")){
					oldText = oldText.split("::")[1];
				}
				node.doAfterNameModified(oldText);
				Element entity = NodeGOT.getEntity(node.xml);
				if(entity != null){
					GotXmlDto.getInstance().updateEntityElement(entity);
				}
				Element data = GotXmlDto.getInstance().getCurrentElement(treeitem);
				if(data.getName().equals("FormItem")){
					String result = data.attributeValue("type") + "::" + changeItemText.getText();
					changeItemText.setText(result);
				}
				treeitem.setData("chinese","false");
				ui.loadTableValue(ui.getTable(), data, treeitem);
				
				if("FieldGroup".equals(node.xml.attributeValue("type"))){
					Element componentPro = GOTHelper.getProperty(node.xml,"Component");
					if(componentPro.attribute("refentityid") != null ){
						TreeItem[] items = treeitem.getItems();
						for (TreeItem child : items) {
							textSyn(child);
						}
					}
				}
				
				textSyn(treeitem);
				changeItemText.dispose();
			}else{
				TreeOperationInfo.addErrorInfo(Macros.ERROR_VALUE_UNLAWFUL);
				ConfigComposite.configComposite.set_text_op_info(Macros.ERROR_VALUE_UNLAWFUL);
				changeItemText.setText(oldText);
				changeItemText.dispose();
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	
	/**
	 * 构建树
	 * @param elementTar
	 * @param parentTree
	 * @param treeItemId
	 * @param node
	 * @param index
	 * @param action
	 */
	@SuppressWarnings("unchecked")
	private static void bulidTree(Element elementTar, TreeItem parentTree, String treeItemId, NodeGOT node,
			Integer index, String action, TreeUi treeUi, boolean expended, boolean addChild) {
		TreeItem trtmNewTreeitem = null;
		String elName = elementTar.getName();
		if (index != null) {
			trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE, index);
		} else if ("Table".equals(elName) || "Form".equals(elName) || "MenuItem".equals(elName)
				|| "Enum".equals(elName)) {
			trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE, 0);
		} else {
			trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE);
		}

		trtmNewTreeitem.setData("id", treeItemId);
		String text = LoadXML.nodeText(elementTar);
		if ("".equals(text)) {
			text = elementTar.getName();
		}
    	trtmNewTreeitem.setData("elementName", elementTar.getName());
        if(elementTar.attributeValue("id") != null){
        	trtmNewTreeitem.setData("elementId", elementTar.attributeValue("id"));
        }
        if(NodeGOT.getEntity(elementTar) != null){
        	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(elementTar).attributeValue("id"));
        }
        trtmNewTreeitem.setData("chinese", "false");
        //TODO 更新MAP中的xml
		//更新map
		if(NodeGOT.getEntity(elementTar.getParent()) == null && elementTar.attribute("version") != null){
			GotXmlDto.getInstance().addEntityElement(elementTar);
		}else{
			Element entity = NodeGOT.getEntity(elementTar);
			if(entity != null){
				GotXmlDto.getInstance().updateEntityElement(entity);
			}
		}
		
		trtmNewTreeitem.setText(text);
		if(treeUi != null){
			trtmNewTreeitem.setData("chinese", "false");
			treeUi.setChineseLabel(trtmNewTreeitem);
		}else if(ConfigComposite.configComposite.button_label.getSelection()){
			trtmNewTreeitem.setText(1, TreeChineseLabel.commitProperties(elementTar));
		}
		
		if(expended){
			parentTree.setExpanded(expended);
		}
		
		setFont(elementTar, trtmNewTreeitem);
		
		trtmNewTreeitem.setImage(ComposeIMG.drawImg(elementTar));
		
		if(!action.equals("exchange")){
			if ("0".equals(elementTar.attributeValue("saved")) && node != null) {
				trtmNewTreeitem.setForeground(trtmNewTreeitem.getDisplay().getSystemColor(SWT.COLOR_RED));
			} else if(!"restore".equals(action)){
				setUnSave(trtmNewTreeitem);
			}
		}else{
			if(elementTar.getName().equals("Menu")){
				sendList(trtmNewTreeitem.getParentItem());
			}
		}
		
//		if(String.valueOf(parentTree.getData("autoEdit")).equals("true")){
//			treeItemEditor(trtmNewTreeitem, node, true, treeUi);
//		}
		
		if((action.equals("new") || action.equals("exchange")) && treeUi != null && elementTar.attribute("id") != null){
			treeUi.loadTableValue(treeUi.getTable(), elementTar, trtmNewTreeitem);
		}
		if(treeUi != null){
			treeUi.itemsMap.put(trtmNewTreeitem.getData("id").toString(), trtmNewTreeitem);
		}
		
		if(addChild){
			List<Element> elements = elementTar.elements();
			int childIndex = 0;
			for (Element element : elements) {
				if (LoadXML.nodeShowRule(element)) {
					String treeItemIdNext = NumCore.getId();
					if("copy".equals(action)){
						action = "new";
						node = null;
					}
					bulidTree(element,trtmNewTreeitem, treeItemIdNext, node, childIndex, action, treeUi, expended, addChild);
					childIndex++;
				}
			}
		}

	}
	
	/**
	 * 设置树节点未保存的样式,此方法没有多窗口同步
	 * @param trtmNewTreeitem
	 */
	public static void setUnSave(TreeItem trtmNewTreeitem) {
		try {
			if (trtmNewTreeitem != null) {
				Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
				Element entity = NodeGOT.getEntity(element);
				if(entity == null){
					return;
				}
				
				if(entity.attribute("saved") == null){
					entity.addAttribute("saved", "0");
				}
				if (element != null) {
					if ("0".equals(element.attributeValue("saved"))) {
						trtmNewTreeitem.setForeground(trtmNewTreeitem.getDisplay().getSystemColor(SWT.COLOR_RED));
						trtmNewTreeitem.setImage(ComposeIMG.drawImg(element));
						GotXmlDto.getInstance().updateEntityElement(entity);
						ConfigComposite.configComposite.setUnsavedText();
						return;
					} else {
						trtmNewTreeitem = trtmNewTreeitem.getParentItem();
						setUnSave(trtmNewTreeitem);
					}
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 设置树节点保存后的样式
	 * @param trtmNewTreeitem
	 */
	public static void setSaved(TreeItem trtmNewTreeitem) {
		try {
			if(trtmNewTreeitem == null){
				return;
			}
			TreeItem old = trtmNewTreeitem;
			trtmNewTreeitem = getUnsavedParent(trtmNewTreeitem);
			if(trtmNewTreeitem == null){
				trtmNewTreeitem = old;
			}
			Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
			if (element != null) {
				if(treeUis.size() == 1){
					if(element.attribute("saved") != null){
						element.remove(element.attribute("saved"));
					}
					trtmNewTreeitem.setForeground(null);
					trtmNewTreeitem.setImage(ComposeIMG.drawImg(element));
					trtmNewTreeitem.setData("chinese", "false");
					treeUis.get(0).setChineseLabel(trtmNewTreeitem);
			        String text = LoadXML.nodeText(element);
			        if("".equals(text)){
			        	text = element.getName();
			        }
			        trtmNewTreeitem.setText(text);
					setFont(element, trtmNewTreeitem);
					GotXmlDto.getInstance().updateEntityElement(element);
				}else{
					String id = trtmNewTreeitem.getData("id").toString();
					for (TreeUi treeUi : treeUis) {
						TreeItem tarTreeItem = getTreeItrmEntityById(treeUi, id);
						if(tarTreeItem != null){
							if(element.attribute("saved") != null){
								element.remove(element.attribute("saved"));
							}
							tarTreeItem.setForeground(null);
							tarTreeItem.setImage(ComposeIMG.drawImg(element));
							tarTreeItem.setData("chinese", "false");
							treeUi.setChineseLabel(tarTreeItem);
					        String text = LoadXML.nodeText(element);
					        if("".equals(text)){
					        	text = element.getName();
					        }
					        trtmNewTreeitem.setText(text);
							setFont(element, tarTreeItem);
							GotXmlDto.getInstance().updateEntityElement(element);
						}
					}
				}

			}
			ConfigComposite.configComposite.setUnsavedText();
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}

	/**
	 * 设置父树节点未保存
	 * @param trtmNewTreeitem
	 * @return
	 */
	private static TreeItem getUnsavedParent(TreeItem trtmNewTreeitem){
		try {
			if(trtmNewTreeitem == null){
				return null;
			}
			Color red = trtmNewTreeitem.getDisplay().getSystemColor(SWT.COLOR_RED);
			if(trtmNewTreeitem.getForeground() != null ){
				Color red_ = trtmNewTreeitem.getForeground();
				if(red.getGreen() == red_.getGreen() && red.getBlue() == red_.getBlue() && red.getRed() == red_.getRed()){
					return trtmNewTreeitem;
				}else if(trtmNewTreeitem.getParentItem() != null){
					return getUnsavedParent(trtmNewTreeitem.getParentItem());
				}
			}else if(trtmNewTreeitem.getParentItem() != null){
				return getUnsavedParent(trtmNewTreeitem.getParentItem());
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		return null;
	}
	
	/**
	 * 恢复操作
	 * 
	 * @param trtmNewTreeitem
	 * @param resultXML
	 */
	public static void restore(TreeItem trtmNewTreeitem, Element resultXML, boolean expended) {
		try {
			String id = (String) trtmNewTreeitem.getData("id");
			//此处的逻辑：销毁掉第一个基本UI的实体节点，然后新建，如果多窗口同步，则后面的窗口应该以第一UI的节点来创建，以保证多窗口的树节点id都相同
			for (int i = 0; i < treeUis.size(); i++) {
				trtmNewTreeitem = treeUis.get(i).itemsMap.get(id);
				if(trtmNewTreeitem == null){
					continue;
				}
				TreeItem treeItemIdParent = trtmNewTreeitem.getParentItem();
				if(i == 0){
					if (restore_treeItem_index > 0) {
						restore_treeItem_index = 0;
					}
					if(trtmNewTreeitem.getParentItem() != null){
						restore_treeItem_index = trtmNewTreeitem.getParentItem().indexOf(trtmNewTreeitem);
					}
					treeUis.get(i).cleanMaps(trtmNewTreeitem);
					
					trtmNewTreeitem.removeAll();
					trtmNewTreeitem.dispose();
					bulidTree(resultXML, treeItemIdParent, id, null, restore_treeItem_index, "restore", null, false, true);
					treeUis.get(i).insertMap(treeItemIdParent);
					if (restore_treeItem_index > 0) {
						restore_treeItem_index = 0;
					}
				}else{
					//此段逻辑选出打开的窗口中展开的节点
					for (TreeItem item : trtmNewTreeitem.getItems()) {
						treeUis.get(i).expanedMap.put(trtmNewTreeitem.getText() + "-PARENT-" + item.getText(), trtmNewTreeitem.getExpanded());
						TreeItemExpandedMap(item, treeUis.get(i));
					}
					String selectText = "";
					TreeItem selectItems = treeUis.get(i).selected;
					if(selectItems != null && !selectItems.isDisposed()){
						TreeItem it = selectItems;
						if(it.getParentItem() != null){
							selectText = it.getParentItem().getText() + "-PARENT-" + it.getText() + "-select";
							if(it.getParentItem().getParentItem() != null){
								selectText = it.getParentItem().getParentItem().getText() + "-PPARENT-" + selectText;
							}
							treeUis.get(i).expanedMap.put(selectText, true);
						}else{
							selectText = "self";
						}
					}
					//删除原有的节点
					for (TreeItem item : trtmNewTreeitem.getItems()) {
						item.removeAll();
						item.dispose();
					}
					//重新构造子节点
					restoreSyn(treeUis.get(0).itemsMap.get(id), trtmNewTreeitem, treeUis.get(i), expended);
					//第一级节点处理
					if(selectText.equals("self")){
						treeUis.get(i).getTree().setSelection(trtmNewTreeitem);
						Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
						treeUis.get(i).loadTableValue(treeUis.get(i).getTable(), element, trtmNewTreeitem);
						treeUis.get(i).selected = trtmNewTreeitem;
					}
					treeUis.get(i).expanedMap = new HashMap<>();
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	public static void TreeItemExpandedMap(TreeItem trtmNewTreeitem, TreeUi ui){
		try {
			if(trtmNewTreeitem.getItems().length > 0){
				for (TreeItem item : trtmNewTreeitem.getItems()) {
					String selectText = trtmNewTreeitem.getText() + "-PARENT-" + item.getText();
					if(trtmNewTreeitem.getParentItem() != null){
						selectText = trtmNewTreeitem.getParentItem() + "-PPARENT-" + selectText;
					}
					ui.expanedMap.put(selectText, trtmNewTreeitem.getExpanded());
					TreeItemExpandedMap(item, ui);
				}
			}else{
				ui.expanedMap.put(trtmNewTreeitem.getParentItem().getText() + "-PARENT-" + trtmNewTreeitem.getText(), trtmNewTreeitem.getParentItem().getExpanded());
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据基本树节点来copy目标树节点
	 * @param baseItem
	 * @param tarItem
	 */
	public static void copyTreeItem( TreeItem baseItem, TreeItem tarItem, final TreeUi ui) {
		try {
			tarItem.setData("id", String.valueOf(baseItem.getData("id")));
			tarItem.setText(baseItem.getText());
			tarItem.setText(1, baseItem.getText(1));
			tarItem.setData("elementName", baseItem.getData("elementName"));
			if(baseItem.getData("elementId") != null){
				tarItem.setData("elementId", baseItem.getData("elementId"));
			}
			if(baseItem.getData("elementEntityId") != null){
				tarItem.setData("elementEntityId", baseItem.getData("elementEntityId"));
			}
			
			tarItem.setFont(baseItem.getFont());
			tarItem.setImage(baseItem.getImage());
			tarItem.setBackground(baseItem.getBackground());
			tarItem.setForeground(baseItem.getForeground());
			if(baseItem.getData("items") != null){
				tarItem.setData("items", (baseItem.getData("items")));
			}
			String text = baseItem.getText();
			if(text.equals("Forms") || text.equals("Tables") || text.equals("Enums") || text.equals("DataTypes") || text.equals("Maps") || text.equals("Menus")
					|| text.equals("MenuItems")){
				copyTreeItemsPart(baseItem, tarItem, ui);
			}else{
				copyTreeItems(baseItem, tarItem, ui);
			}
			tarItem.setExpanded(true);
			
			ui.itemsMap.put(baseItem.getData("id").toString(), tarItem);
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据基本树节点来copy目标树节点的子节点
	 * @param baseItem
	 * @param tarItem
	 */
	private static void copyTreeItems(TreeItem baseItem, TreeItem tarItem, TreeUi ui){
		try {
			TreeItem[] baseItems = baseItem.getItems();
			for (TreeItem child : baseItems) {
				TreeItem trtmNewTreeitem = new TreeItem(tarItem, SWT.NONE);
				trtmNewTreeitem.setData("id", child.getData("id").toString());
				trtmNewTreeitem.setText(child.getText());
			    trtmNewTreeitem.setData("elementName", child.getData("elementName"));
				if(child.getData("elementId") != null){
					trtmNewTreeitem.setData("elementId", child.getData("elementId"));
				}
				if(child.getData("elementEntityId") != null){
					trtmNewTreeitem.setData("elementEntityId", child.getData("elementEntityId"));
				}
			    
				trtmNewTreeitem.setFont(child.getFont());
				trtmNewTreeitem.setImage(child.getImage());
				trtmNewTreeitem.setBackground(child.getBackground());
				if(child.getData("items") != null){
					trtmNewTreeitem.setData("items", (child.getData("items")));
				}
				ui.itemsMap.put(child.getData("id").toString(), trtmNewTreeitem);
				copyTreeItems(child, trtmNewTreeitem, ui);
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据基本树节点来copy目标树节点的子节点
	 * @param baseItem
	 * @param tarItem
	 */
	private static void copyTreeItemsPart(TreeItem baseItem, TreeItem tarItem, TreeUi ui){
		try {
			TreeItem[] baseItems = baseItem.getItems();
			String text = baseItem.getText();
			if(text.equals("Forms") || text.equals("Tables") || text.equals("Enums") || text.equals("DataTypes") || text.equals("Maps") || text.equals("Menus")
					|| text.equals("MenuItems")|| text.equals("Classes")){
				Arrays.sort(baseItems, new Comparator<TreeItem>() {
					@Override
					public int compare(TreeItem o1, TreeItem o2) {
						if(!GOTUtil.button_pre){
							String test1 = LoadXML.fmt(o1.getText());
							String test2 = LoadXML.fmt(o2.getText());
							return test1.compareToIgnoreCase(test2);
						}else{
							return o1.getText().compareToIgnoreCase(o2.getText());
						}
					}
				   });
			}
			
			for (TreeItem child : baseItems) {
				TreeItem trtmNewTreeitem = new TreeItem(tarItem, SWT.NONE);
				trtmNewTreeitem.setData("id", child.getData("id").toString());
				String name = GotXmlDto.getInstance().getEntityNameById(String.valueOf(child.getData("elementName")), String.valueOf(child.getData("elementEntityId")));
				if(!ConfigComposite.configComposite.button_pre.getSelection()){
					trtmNewTreeitem.setText(LoadXML.fmt(name));
				}else{
					trtmNewTreeitem.setText(name);
				}
				trtmNewTreeitem.setText(1, child.getText(1));
				trtmNewTreeitem.setData("elementName", child.getData("elementName"));
			    if(child.getData("elementId") != null){
			    	trtmNewTreeitem.setData("elementId", child.getData("elementId"));
			    }
			    if(child.getData("elementEntityId") != null){
			    	trtmNewTreeitem.setData("elementEntityId", child.getData("elementEntityId"));
			    }
				trtmNewTreeitem.setFont(child.getFont());
				trtmNewTreeitem.setImage(child.getImage());
				trtmNewTreeitem.setBackground(child.getBackground());
				trtmNewTreeitem.setData("items", "part");
				ui.itemsMap.put(child.getData("id").toString(), trtmNewTreeitem);
				TreeItem[] baseItemChild = child.getItems();
				for (TreeItem treeItem : baseItemChild) {
					TreeItem trtmNewTreeitem2 = new TreeItem(trtmNewTreeitem, SWT.NONE);
					trtmNewTreeitem2.setData("id", treeItem.getData("id").toString());
					trtmNewTreeitem2.setText(treeItem.getText());
					trtmNewTreeitem2.setText(1, treeItem.getText(1));
					trtmNewTreeitem2.setData("elementName", treeItem.getData("elementName"));
			        if(child.getData("elementId") != null){
			        	trtmNewTreeitem2.setData("elementId", treeItem.getData("elementId"));
			        }
			        if(child.getData("elementEntityId") != null){
			        	trtmNewTreeitem2.setData("elementEntityId", treeItem.getData("elementEntityId"));
			        }
					trtmNewTreeitem2.setFont(treeItem.getFont());
					trtmNewTreeitem2.setImage(treeItem.getImage());
					trtmNewTreeitem2.setBackground(treeItem.getBackground());
					ui.itemsMap.put(treeItem.getData("id").toString(), trtmNewTreeitem2);
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据基本树节点来同步目标树节点
	 * @param baseItem
	 * @param tarItem
	 */
	public static void restoreSyn(TreeItem baseItem, TreeItem tarItem, TreeUi ui, boolean expanded) {
		try {
			tarItem.setData("id", baseItem.getData("id").toString());
			tarItem.setText(baseItem.getText());
			Element element = GotXmlDto.getInstance().getCurrentElement(baseItem);
			tarItem.setData("elementName", element.getName());
			if(element.attributeValue("id") != null){
				tarItem.setData("elementId", element.attributeValue("id"));
			}
			if(NodeGOT.getEntity(element) != null){
				tarItem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
			}
			
			setFont(element, tarItem);
			tarItem.setImage(baseItem.getImage());
			tarItem.setBackground(baseItem.getBackground());
			tarItem.setForeground(baseItem.getForeground());
			if(StringUtils.isBlank(baseItem.getText(1)) || expanded){
				tarItem.setData("chinese", "false");
				ui.setChineseLabel(tarItem);
			}else{
				tarItem.setText(1, baseItem.getText(1));
			}
			restoreSynItems(baseItem, tarItem, ui, expanded);
			ui.itemsMap.put(baseItem.getData("id").toString(), tarItem);
			tarItem.setData("items", "all");
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}

	/**
	 * 根据基本树节点来同步目标树节点的子节点
	 * @param baseItem
	 * @param tarItem
	 */
	private static void restoreSynItems(TreeItem baseItem, TreeItem tarItem, TreeUi ui, boolean expanded){
		try {
			TreeItem[] baseItems = baseItem.getItems();
			for (TreeItem child : baseItems) {
				TreeItem trtmNewTreeitem = new TreeItem(tarItem, SWT.NONE);
				trtmNewTreeitem.setData("id", child.getData("id").toString());
				trtmNewTreeitem.setText(child.getText());
				Element element = GotXmlDto.getInstance().getCurrentElement(child);
				trtmNewTreeitem.setData("elementName", element.getName());
			    if(element.attributeValue("id") != null){
			    	trtmNewTreeitem.setData("elementId", element.attributeValue("id"));
			    }
			    if(NodeGOT.getEntity(element) != null){
			    	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
			    }
				trtmNewTreeitem.setFont(child.getFont());
				
				trtmNewTreeitem.setImage(child.getImage());
				trtmNewTreeitem.setBackground(child.getBackground());
				if(StringUtils.isBlank(child.getText(1)) || expanded){
					trtmNewTreeitem.setData("chinese", "false");
					ui.setChineseLabel(trtmNewTreeitem);
				}else{
					trtmNewTreeitem.setText(1, child.getText(1));
				}
				ui.itemsMap.put(child.getData("id").toString(), trtmNewTreeitem);
				//这里设置树节点展开
				String text = tarItem.getText() + "-PARENT-" + trtmNewTreeitem.getText();
				if(expanded){
					if(ui.expanedMap.get(text) != null){
						trtmNewTreeitem.setExpanded(ui.expanedMap.get(text));
					}else{
						if(tarItem.getParentItem() != null){
							text = tarItem.getParentItem().getText() + "-" + text;
						}
						if(!tarItem.getExpanded()){
							if(ui.expanedMap.isEmpty()){
								tarItem.setExpanded(expanded);
							}else if(ui.expanedMap.get(text) != null){
								tarItem.setExpanded(ui.expanedMap.get(text));
							}
						}
					}
				}
				//这里设置当前选中的节点
				if(ui.expanedMap.containsKey(text + "-select")){
					if(ui.expanedMap.get(text + "-select")){
						ui.getTree().setSelection(trtmNewTreeitem);
						Element element2 = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
						ui.loadTableValue(ui.getTable(), element2, trtmNewTreeitem);
						ui.selected = trtmNewTreeitem;
					}
					
				}
				restoreSynItems(child, trtmNewTreeitem, ui, expanded);
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		
	}
	
	private static Font font_bold;
	
	/**
	 * 设置字体颜色
	 * @param node
	 * @param trtmNewTreeitem
	 */
	public static void setFont(Element node, TreeItem trtmNewTreeitem){
		try {
			if(font_bold == null){
				Font fonts = new Font(trtmNewTreeitem.getDisplay(), "宋体", 9, SWT.NONE);
				FontData data = fonts.getFontData()[0];
				data.setStyle(SWT.BOLD);
				font_bold = new Font(trtmNewTreeitem.getParent().getShell().getDisplay(), data);
			}
			String createdLayer = node.attributeValue("createdLayer");
			String modifiedLayer = node.attributeValue("modifiedLayer");
			if(ObjectContainer.getInstance(LayerService.class).getCurrentLayer().equals(createdLayer) || ObjectContainer.getInstance(LayerService.class).getCurrentLayer().equals(modifiedLayer) ){
				trtmNewTreeitem.setFont(font_bold);
			}else{
				trtmNewTreeitem.setFont(null);
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 引用列表定位操作
	 * 
	 * @param trtmNewTreeitem
	 * @param resultXML
	 */
	public static void refTreeItem(Element eleDate) {
		try {
			String entityId = eleDate.attributeValue("entityId");
			String innerId = eleDate.attributeValue("innerId");
			TreeItem item = FormDataSyn.getEntityTreeItem(entityId);
			if(item == null){
				return;
			}
			TreeUiBean bean = new TreeUiBean(item, false, false);
			if(StringUtils.isNotBlank(innerId)){
				TreeItem child = FormDataSyn.getTreeItemById(innerId, bean.treeUip);
				if(child != null){
					bean.treeUip.getTree().setSelection(child);
					Element element = GotXmlDto.getInstance().getCurrentElement(child);
					bean.treeUip.loadTableValue(bean.treeUip.getTable(), element, child);
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据xml获取树节点
	 * @param node
	 * @return
	 */
	public static TreeItem getTreeItrmByElement(Element node, TreeUi ui){
		if(treeUis.isEmpty()){
			return null;
		}
		if(ui == null){
			ui = treeUis.get(0);
		}
		TreeItem returnItem = null;
		
		try {
			for (String id : ui.itemsMap.keySet()) {
				TreeItem item = ui.itemsMap.get(id);
				if(item.isDisposed()){
					
				}else{
					String elementId = item.getData("elementId") == null ? null : item.getData("elementId").toString();
					String elementEntityId = item.getData("elementEntityId") == null ? null : item.getData("elementEntityId").toString();
				    String elementName = item.getData("elementName").toString();
				    
				    String elementIdTar = node.attributeValue("id");
				    String elementNameTar = node.getName();
				    String elementEntityIdTar = NodeGOT.getEntity(node).attributeValue("id");
				    if(elementName.equals(elementNameTar)){
				    	//只有tables forms 等节点的实体节点id为空，而这些节点名称不会重复
				    	if(elementEntityId == null && NodeGOT.getEntity(node) == null){
				    		return item;
				    	}
				    	
				    	if(elementEntityId != null && elementEntityId.equals(elementEntityIdTar)){
				    		 if(elementId == null && StringUtils.isBlank(elementIdTar)){
				    			 return item;
				    		 }
				    		
				    		if(elementId != null && elementId.equals(elementIdTar)){
				    			return item;
				    		}
				    	}
				    }
				}
				
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		
		return returnItem;
	}
	
	public static TreeItem getEntityTreeItem(TreeItem item){
		TreeItem parentItem = null;
		try {
			if(checkEntityTreeItem(item)){
				parentItem = item;
				return parentItem;
			}else{
				parentItem = item.getParentItem();
				while(parentItem != null){
					if(checkEntityTreeItem(parentItem)){
						return parentItem;
					}
					parentItem = parentItem.getParentItem();
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		return null;
	}
	
	public static boolean checkEntityTreeItem(TreeItem treeItem){
		String elementId = treeItem.getData("elementId") == null ? "" : treeItem.getData("elementId").toString();
		String elementEntityId = treeItem.getData("elementEntityId") == null ? "" : treeItem.getData("elementEntityId").toString();
		if(StringUtils.isNotBlank(elementEntityId) && elementId.equals(elementEntityId)){
			return true;
		}
		return false;
	}
	
	
	/**
	 * 根据xml获取树节点
	 * @param node
	 * @return
	 */
	public static TreeItem getTreeItrmEntityById(TreeUi treeUi, String id){
		if(treeUis.isEmpty()){
			return null;
		}
		TreeItem returnItem = treeUi.itemsMap.get(id);
		return returnItem;
	}
	
	/**
	 * 设置树节点选中
	 * 多窗口同步
	 * @param treeItem
	 */
	public static void setItemSelection(TreeItem treeItem){
		try {
			String id = treeItem.getData("id").toString();
			for (TreeUi treeUi : treeUis) {
				TreeItem item = treeUi.itemsMap.get(id);
				if(item != null){
					treeUi.getTree().setSelection(item);
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	public static String editText(String text){
		String returnText = text;
		if(returnText.contains("::")){
			String[] temp = returnText.split("::");
			if(temp.length > 1){
				returnText = temp[1];
			}
			
		}
		return returnText;
	}
	
	/**
	 * GOT停止
	 */
	public static void stopGotConfim(){
		MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
                | SWT.YES | SWT.NO);
        messagebox.setText("关闭GOT");
        messagebox.setMessage("确定重新加载GOT吗?") ;
        int message = messagebox.open();
		if(message == SWT.YES){
			ConfigComposite.configComposite.init();
			stopGot();
		}
	}
	
	/**
	 * GOT停止
	 */
	public static void stopGot(){
		try {
			for (Shell shell : GOTMessageDialog.shells) {
				if(!shell.isDisposed()){
					shell.close();
				}
			}
			GOTMessageDialog.shells = new ArrayList<>();
			for (int i = 0; i < treeUis.size(); i++) {
				TreeUi treeUi = treeUis.get(i);
				treeUi.getTable().removeAll();
				treeUi.getTree().removeAll();
				treeUi.ds.dispose();
				treeUi.target.dispose();
				treeUi = null;
			}
			treeUis = new ArrayList<>();
			GOTMessageDialog.shells = new ArrayList<>();
			DesignerServer.stop();
			DesignerServer.status = "notStarted";
			dragTreeUi = null;
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 根据实体节点id，获取实体节点的树节点
	 * @param search
	 * @return
	 */
	public static TreeItem getEntityTreeItem(String search){
		try {
			Element node = GotXmlDto.getInstance().getEntity(search);
			if(node == null){
				return null ;
			}
			for (String id : treeUis.get(0).itemsMap.keySet()) {
				TreeItem item = treeUis.get(0).itemsMap.get(id);
				if(!item.isDisposed()){
					String elementId = item.getData("elementId") == null ? null : item.getData("elementId").toString();
					String elementEntityId = item.getData("elementEntityId") == null ? null : item.getData("elementEntityId").toString();
				    String elementName = item.getData("elementName").toString();
				    
				    String elementIdTar = node.attributeValue("id");
				    String elementNameTar = node.getName();
				    String elementEntityIdTar = NodeGOT.getEntity(node).attributeValue("id");
				    if(elementName.equals(elementNameTar)){
				    	if(elementEntityId != null && elementEntityId.equals(elementEntityIdTar)){
				    		if(elementId != null && elementId.equals(elementIdTar)){
				    			return item;
				    		}
				    	}
				    }
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		return null;
	}
	
	/**
	 * 根据文档的id来找到树节点
	 * @param search
	 * @param ui
	 * @return
	 */
	public static TreeItem getTreeItemById(String search, TreeUi ui){
		try {
			for (String id : ui.itemsMap.keySet()) {
				TreeItem treeItem = ui.itemsMap.get(id);
				if(!treeItem.isDisposed()){
					String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
					if(search.equals(elementId)){
						return treeItem;
					}
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
		return null;
	}

	public static void reset(){
		try {
			if(treeUis.size() > 0){
				Tree tree = treeUis.get(0).getTree();
				for (TreeItem item : tree.getItems()) {
					if(item.getText().equals("GOT")){
						item.setExpanded(true);
						TreeItem[] treeItems = item.getItems();
						for (TreeItem treeItem : treeItems) {
							if(treeItem.getText().equals("DataDictionary")){
								treeItem.setExpanded(true);
								TreeItem[] treeItems2 = treeItem.getItems();
								for (TreeItem treeItem2 : treeItems2) {
									treeItem2.setExpanded(false);
								}
							}else{
								treeItem.setExpanded(false);
							}
						}
								
					}
				}
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
	
	/**
	 * 显示/隐藏前缀
	 */
	public static void showPrefix(boolean pre){
		if(treeUis.size() > 0){
			for (TreeUi treeUi : treeUis) {
				for (String id : treeUi.itemsMap.keySet()) {
					TreeItem treeItem = treeUi.itemsMap.get(id);
					if(!treeItem.isDisposed()){
						String elementId = treeItem.getData("elementId") == null ? null : treeItem.getData("elementId").toString();
						String elementEntityId = treeItem.getData("elementEntityId") == null ? null : treeItem.getData("elementEntityId").toString();
						if(elementEntityId != null && elementId != null){
							if(elementEntityId.equals(elementId)){
								String text = "";
								if(!pre ){
									text = LoadXML.fmt(treeItem.getText());
								}else{
									Element element = GotXmlDto.getInstance().getEntity(elementEntityId);
									text = LoadXML.nodeText(element);
								}
								treeItem.setText(text);
							}

						}
					}
				}
			}
		}
	}
	
	public static void orderByTreeItem(Map<TreeUi, Map<TreeItem, Object>> map){
		for (TreeUi treeUi : map.keySet()) {
			Map<TreeItem, Object> list = map.get(treeUi);
			for (TreeItem treeItem : list.keySet()) {
				TreeItem parents = treeItem;
				TreeItem[] items = parents.getItems();
				Arrays.sort(items, new Comparator<TreeItem>() {
					@Override
					public int compare(TreeItem o1, TreeItem o2) {
						return o1.getText().compareToIgnoreCase(o2.getText());
					}
				   });
				
				for (TreeItem child : items) {
					TreeItem trtmNewTreeitem = new TreeItem(parents, SWT.NONE);
					copyTreeItem(child, trtmNewTreeitem, treeUi);
					child.dispose();
				}
			}
			
		}
		
	}
	
	
	/**
	 * 字体加粗
	 */
	public static void showFonts(){
		//TODO 遍历太花时间，界面会卡住
/*		if(treeUis.size() > 0){
			for (TreeUi treeUi : treeUis) {
				for (String id : treeUi.itemsMap.keySet()) {
					TreeItem treeItem = treeUi.itemsMap.get(id);
					Element element = GotXmlDto.getInstance().getCurrentElement(treeItem);
					if(ConfigComposite.configComposite.button_text.getSelection()){
						treeUi.setFont(element, treeItem);
					}else{
						treeItem.setFont(null);
					}

					
				}
			}
		}*/
	}
	
	public static void setShowTreeItemByLayerAndSolution(){
		if(treeUis.size() > 0){
			treeUis.get(0).flashTree();
		}
	}

	public static void sendList(TreeItem parent) {
		try {
			TreeItem[] items = parent.getItems();
			List<String> ids = new ArrayList<>();
			for (TreeItem treeItem : items) {
				if(treeItem.isDisposed()){
					continue;
				}
				Element data = GotXmlDto.getInstance().getCurrentElement(treeItem);
				if (!"0".equals(data.attributeValue("saved"))) {
					String id = data.attributeValue("id");
					ids.add(id);
				}

			}
			if (!ids.isEmpty()) {
				LoadXmlCore.gotServices.saveMenuOrder(ids);
			}
		} catch (final Exception e) {
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
			e.printStackTrace();
			TreeOperationInfo.addErrorInfo(e.getMessage());
		}
	}
}
