package info.gongqi.got.tool;

import gongqi.erp.gotmodel.clientcache.GOTFinalValueHelper;
import info.gongqi.got.model.GotXmlDto;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

public class GOTHelp {
	
	/**
	 * PP 表示Properties.Property
	 * @param date 
	 * @param att
	 * @param attValue
	 * @return
	 */
	public static String getPPAttValue(Element date, String att, String attValue){
		String value = "";
		if(date.element("Properties") == null){
			return "";
		}
		@SuppressWarnings("unchecked")
		List<Element> elements = date.element("Properties").elements("Property");
		for (Element element : elements) {
			String elAtt = element.element(att).getText();
			if(attValue.equals(elAtt)){
				value = element.element("Value").getText();
				return value;
			}
		}
		return value;
	}
	
	/**
	 * PP 表示Properties.Property
	 * @param date
	 * @param att
	 * @param attValue
	 * @return
	 */
	public static Element getPPAttElement(Element date, String att, String attValue){
		@SuppressWarnings("unchecked")
		List<Element> elements = date.element("Properties").elements("Property");
		for (Element element : elements) {
			String elAtt = element.element(att).getText();
			if(attValue.equals(elAtt)){
				return element;
			}
		}
		return null;
	}
	
	/**
	 * PP 表示Properties.Property
	 * @param date
	 * @param att
	 * @param attValue
	 * @return
	 */
	public static List<Element> getPPAttElementList(Element date, String att, String attValue){
		List<Element> returnList = new ArrayList<>(); 
		@SuppressWarnings("unchecked")
		List<Element> elements = date.element("Properties").elements("Property");
		for (Element element : elements) {
			String elAtt = element.element(att).getText();
			if(attValue.equals(elAtt)){
				returnList.add(element);
			}
		}
		return returnList;
	}
	
	/**
	 * DDD 表示DataDictionary.DataTypes.DataType
	 * @param date
	 * @param att
	 * @param attValue
	 * @return
	 */
	public static List<Element> getDDDAttElementList(Element date, String att, String attValue){
		List<Element> returnList = new ArrayList<>(); 
		@SuppressWarnings("unchecked")
		List<Element> elements = date.element("DataDictionary").element("DataTypes").elements("DataType");
		for (Element element : elements) {
			String elAtt = element.element(att).getText();
			if(attValue.equals(elAtt)){
				returnList.add(element);
			}
		}
		return returnList;
	}
	
	public static String getFormDataSourceLabel(Element dataSource){
		if(dataSource != null){
			Element tablePro = getPPAttElement(dataSource, "Name", "Table");
			Element table = null ;
			if(tablePro.attribute("refentityid") != null){
//				Element root = LoadXmlCore.getNode(LoadXmlCore.gotServices.getTables());
				table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue("refentityid"));
				if(table == null){
					System.out.println("---" + tablePro.attributeValue("refentityid"));
//					throw new Error("GOT错误 在DataSource的Table上找不到Table Entity");
					return "";
				}
	
				String label = getPPAttValue(table, "Name", "Label");
				if(!label.equals("")){
					return label;
				}
			}
			
			return dataSource.attributeValue("name");
		}
		
		return "";
	}

	public static String getTableIndexItemLabel(Element tableIndexItem){
		if(tableIndexItem != null){
			Element fieldPro = getProperty(tableIndexItem,"Field");
			if(fieldPro.attribute("innerid") != null){
				Element table = getEntity(tableIndexItem);
				Element fieldXML = null;
				if(table != null){
					@SuppressWarnings("unchecked")
					List<Element> elements = table.element("TableFields").elements("TableField");
					for (Element element : elements) {
						if(element.attributeValue("id").equals(fieldPro.attributeValue("innerid"))){
							fieldXML = element; break;
						}
					}
					if(fieldXML != null){
						return GOTFinalValueHelper.getFinalValue(fieldXML,"Label");
					}
				}
			}
			return tableIndexItem.attributeValue("name");
		}
		
		return "";
	}
	
	public static Element getProperty(Element xml, String property){
		@SuppressWarnings("unchecked")
		List<Element> elements = xml.element("Properties").elements("Property");
		for (Element element : elements) {
			String elAtt = element.element("Name").getText();
			if(property.equals(elAtt)){
				return element;
			}
		}
		return null;
	}
	
	public static Element getEntity(Element item){
		while(item!=null){
			if(isEntity(item)){
				return item;
			}else{
				item = item.getParent();
			}
		}
		return null;
	}
	
	public static Boolean isEntity(Element node){
		if(node.attribute("version") != null){
			return true;
		}
		return false;
	}
	
	/**
	 * PP 表示Properties.Property
	 * @param date
	 * @param att
	 * @param attValue
	 * @return
	 */
	public static List<Element> getListById(List<Element> list, String att, String value){
		List<Element> returnList = new ArrayList<>(); 
		for (Element element : list) {
			if(element.attribute(att) != null){
				if(element.attributeValue(att).equals(value)){
					returnList.add(element);
				}
			}
		}
		return returnList;
	}
	
	@SuppressWarnings("unchecked")
	public static Element prependChild(Element parent, Element tarParent){
		parent.elements().add(0, tarParent);
		return parent;
	}
	
	@SuppressWarnings("unchecked")
	public static Element insertChildBefore(Element parent, Element tarParentBefore, Element tarElement){
		List<Element> elements = parent.content();
		int index = -1;
		if(elements.indexOf(tarParentBefore) == -1){
			index = indexList(elements, tarParentBefore);
		}else{
			index = elements.indexOf(tarParentBefore);
		}
		elements.add(index, tarElement);
		parent.setContent(elements);
		return parent;
	}
	
	private static int indexList(List<Element> elements, Element tarParentBefore){
		for (int i = 0; i < elements.size(); i++) {
//			String id = tarParentBefore.attributeValue("id");
//			if(id != null && id.equals(elements.get(i).attributeValue("id"))){
//				return i;
//			}
			if(elements.get(i).asXML().equals(tarParentBefore.asXML())){
				return i;
			}
		}
		return -1;
	}
	
	@SuppressWarnings("unchecked")
	public static Element insertChildAfter(Element parent, Element tarElementAfter, Element tarElement){
		List<Element> elements = parent.content();
		elements.add(elements.indexOf(tarElementAfter) + 1, tarElement);
		parent.setContent(elements);
		return parent;
	}
}
