package info.gongqi.got.tool;

import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LayerInfoSoultion extends Dialog {

	protected Object result;
	protected Shell shell;
	private Text text_1;
	private Combo text_2;
	private Text text_3;

	private String action;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public LayerInfoSoultion(Shell parent, int style, String actions) {
		super(parent, style);
		setText("");
		action = actions;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(310, 209);
		shell.setText(getText());
		
		GOTMessageDialog.shells.add(shell);
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		
		Label text1_label = new Label(shell, SWT.NONE);
		text1_label.setBounds(36, 13, 62, 17);
		text1_label.setText("");
		
		text_1 = new Text(shell, SWT.BORDER);
		text_1.setBounds(104, 10, 129, 23);
		
		Label text2_label = new Label(shell, SWT.NONE);
		text2_label.setBounds(36, 62, 62, 17);
		text2_label.setText("");
		
		text_2 = new Combo(shell, SWT.BORDER);
		text_2.setBounds(104, 59, 129, 23);
		
		text_3 = new Text(shell, SWT.BORDER);
		text_3.setBounds(104, 59, 129, 23);
		text_3.setVisible(false);
		
		Button confirm = new Button(shell, SWT.NONE);
		confirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				/*try {
					String text = text_1.getVisible() ? text_1.getText() : text_2.getText();
					if("packSolution".equals(action)){
						if(text.equals("")){
							GOTMessageDialog.alert("请填写方案名称");
						}else{
							SolutionService solutionService = ObjectContainer.getInstance(SolutionService.class); 
							solutionService.packSolution(text);
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("createSolution".equals(action)){
						if(text.equals("")){
							GOTMessageDialog.alert("请填写方案名称");
						}else{
							SolutionService solutionService = ObjectContainer.getInstance(SolutionService.class); 
							solutionService.createSolution(text_1.getText(), text_3.getText());
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("packSolutionExtension".equals(action)){
						if(text.equals("")){
							GOTMessageDialog.alert("请填写方案名称");
						}else{
							SolutionService solutionService = ObjectContainer.getInstance(SolutionService.class); 
							solutionService.packSolutionExtension(text);
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else if("createSolutionExtension".equals(action)){
						if(text.equals("")){
							GOTMessageDialog.alert("请填写方案名称");
						}else{
							SolutionService solutionService = ObjectContainer.getInstance(SolutionService.class); 
							solutionService.createSolutionExtension(text);
							GOTMessageDialog.info("已成功执行");
							shell.close();
						}
					}else{
						shell.close();
					}

				} catch (Exception e1) {
					GOTMessageDialog.alert(e1.getMessage());
					e1.printStackTrace();
				}
				*/
				
			}
		});
		confirm.setBounds(46, 128, 80, 27);
		confirm.setText("确定");
		
		Button cancel = new Button(shell, SWT.NONE);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
		});
		cancel.setBounds(179, 128, 80, 27);
		cancel.setText("取消");

		if("packSolution".equals(action)){
            List<SolutionDefinition> solutions = ObjectContainer.getInstance(SolutionDefinitionManager.class).getSolutions(SolutionDeploymentMode.Source);
			if(solutions.size() == 0){
				text1_label.setText("方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEnabled(false);
				text_1.setVisible(true);
			}else if(solutions.size() == 1){
				text1_label.setText("方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEditable(false);
				text_1.setText(solutions.get(0).getSolutionName());
			}else{
				List<String> names = new ArrayList<String>();
	            for (SolutionDefinition solutionDefinition : solutions) {
                    names.add(solutionDefinition.getSolutionName());
	            }
				text1_label.setVisible(false);
				text_1.setVisible(false);
				text_2.setVisible(true);
				text2_label.setVisible(true);
				text2_label.setText("方案名称");
				text_2.setItems(names.toArray(new String[names.size()]));
			}

			shell.setText("打包方案");
		}else if("createSolution".equals(action)){
			text1_label.setText("方案名称");
			text_2.setVisible(false);
			text_3.setVisible(true);
			text2_label.setVisible(true);
			text2_label.setText("方案描述");
			shell.setText("创建方案");
		}else if("packSolutionExtension".equals(action)){
			List<String> names = new ArrayList<String>();
            List<SolutionExtensionDefinition> solutionExtensions = ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class).getSolutionExtensions(SolutionExtensionDeploymentMode.Source);
            for (SolutionExtensionDefinition solutionExtensionDefinition : solutionExtensions) {
                    names.add(solutionExtensionDefinition.getSolutionDefinition().getSolutionName());
            }
            if(names.size() == 0){
				text1_label.setText("未发现方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEnabled(false);
			}else if(names.size() == 1){
				text1_label.setText("方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEditable(false);
				text_1.setText(names.get(0));
			}else{
				text1_label.setVisible(false);
				text_1.setVisible(false);
				text_2.setVisible(true);
				text2_label.setVisible(true);
				text2_label.setText("方案名称");
				text_2.setItems(names.toArray(new String[names.size()]));
			}
			shell.setText("打包方案扩展包");
		}else if("createSolutionExtension".equals(action)){
			List<String> names = new ArrayList<String>();
			List<SolutionDefinition> solutions = ObjectContainer.getInstance(SolutionDefinitionManager.class).getSolutions();
            for (SolutionDefinition solutionDefinition : solutions) {
                    names.add(solutionDefinition.getSolutionName());
            }
			if(names.size() == 0){
				text1_label.setText("未发现方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEnabled(false);
			}else if(names.size() == 1){
				text1_label.setText("方案名称");
				text_2.setVisible(false);
				text2_label.setVisible(false);
				text_1.setEditable(false);
				text_1.setText(names.get(0));
			}else{
				text1_label.setVisible(false);
				text_1.setVisible(false);
				text_2.setVisible(true);
				text2_label.setVisible(true);
				text2_label.setText("方案名称");
				text_2.setItems(names.toArray(new String[names.size()]));
			}

			shell.setText("创建方案扩展包");
		}
		
	}
	
}
