package info.gongqi.got.tool;

import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class LoadXMLAndBulidTree extends Dialog {

	protected Object resultDialog = "";
	
	public Shell shell;

	public ProgressBar progressBar;
 
	public Boolean canceled = false;
	/** 
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public LoadXMLAndBulidTree(Shell parent, int style) {
		super(parent, style);
		setText("正在加载");
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open(Tree tree, Table table) {
		createContents(tree, table);
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return resultDialog;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents(final Tree tree, final Table table) {
		shell = new Shell(getParent(), getStyle());
		shell.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent arg0) {
				canceled = true;
			}
		});
		shell.setSize(600, 50);
		shell.setText(getText());
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));

		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
 
		progressBar = new ProgressBar(shell, SWT.SMOOTH);

		progressBar.setMaximum(100);
		progressBar.setMinimum(0);
		ConfigComposite.progressBar.setShellText("正在初始化GOT模型...");
		ConfigComposite.progressBar.setProgressBar(10);
		Thread thread = new Thread(new Runnable() {
			@Override
			public void run() {
				LoadXmlCore.init(tree, table);
			}
		});
		thread.start();
		GOTMessageDialog.shells.add(shell);
	}


	public void setProgressBar(final int num){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (progressBar.isDisposed())
					return;
					progressBar.setSelection(num);
				if(num == 100){
					shell.dispose();
				}
			}
		});
	}
	
	public void setShellText(final String text){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (shell.isDisposed())
					return;
				shell.setText(text);
			} 
		});
	}
	
	public void setAlert(final String text, final String title){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				GOTMessageDialog.showXmlInfo(text, title);
			}
		});
	}
	
}
