package info.gongqi.got.tool;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.toolsgot.GOTHelper;
import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class MergeCleanAllTable extends Dialog {

	protected Object resultDialog = "";
	protected Shell shell;

	public ProgressBar progressBar;
 
	private Boolean canceled = false;
	private List<Element> xmllist = new ArrayList<>();
	/** 
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public MergeCleanAllTable(Shell parent, int style) {
		super(parent, style);
		setText("正在验证");
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open(boolean all) {
		createContents(all);
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return resultDialog;
	}

	/**
	 * Create contents of the dialog.
	 */
	@SuppressWarnings("unchecked")
	private void createContents(boolean all) {
		shell = new Shell(getParent(), getStyle());
		shell.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent arg0) {
				canceled = true;
			}
		});
		shell.setSize(600, 50);
		shell.setText(getText());
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));

		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
 
		progressBar = new ProgressBar(shell, SWT.SMOOTH);

		progressBar.setMaximum(100);
		progressBar.setMinimum(0);
		
		if(all){
//			xmllist = NodeGOT.gotXML.element("DataDictionary").element("Tables").elements("Table");
			xmllist = GotXmlDto.getInstance().currentElements("Tables");
		}else{
			Tree tree = FormDataSyn.currentTreeUi.getTree();
			TreeItem[] items = tree.getSelection();
			for (TreeItem treeItem : items) {
				Element element = GotXmlDto.getInstance().getCurrentElement(treeItem);
				if(element.getName().equals("Table")){
					xmllist.add(element);
				}
			}
		}
		
		int total = xmllist.size();
		if(total > 0){
			start(0, total, xmllist, "");
		}else{
			shell.setText("没有需要清理的table");
		}
	}

	public void start(final int i, final int total, final List<Element> list, final String result) {
		Runnable runnable = new Runnable() {
			public void run() {
				stepCheckTables(i, total, list, result);
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						if (shell.isDisposed())
							return;
					}
				});
			}
		};
		// 启动这个线程
		new Thread(runnable).start();
	}
	
	public void stepCheckTables(int cur, int total, List<Element> tables, String result) {
		Element table = tables.get(cur);
		cur++;
		int percent = cur*100/total;
		setShellText("正在协同" + table.attributeValue("name") + " " + percent + "%");
		setProgressBar(percent);
		result += checkSingleTable(table);
		
		if(canceled || cur >= total){
			setProgressBar(100);
			if(result.equals("")){
				result = "已自动处理，无需手动调整";
			}
			String _title = "检查结果";
			if(canceled && cur < total){
				_title+="(已中断)";
			}
			canceled = false;
			setAlert(result, _title);
		}else{
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			stepCheckTables(cur,total,tables,result);
		}
	}


	public void setProgressBar(final int num){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (progressBar.isDisposed())
					return;
				if(num == 100){
					shell.close();
				}else{
					progressBar.setSelection(num);
				}
			}
		});
	}
	
	public void setShellText(final String text){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (shell.isDisposed())
					return;
				shell.setText(text);
			} 
		});
	}
	
	public void setAlert(final String text, final String title){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				GOTMessageDialog.showXmlInfo(text, title);
			}
		});
	}
	
	@SuppressWarnings("unchecked")
	public String checkSingleTable(Element table){
		String result = "";
		String tableId = table.attributeValue("id");
//		List<Element> forms = NodeGOT.gotXML.element("Forms").elements("Form");
		List<Element> forms = GotXmlDto.getInstance().currentElements("Forms");
		for (Element form : forms) {
			List<Element> dss = form.element("FormDataSources").elements("FormDataSource");
			for(Element ds : dss){
				Element tablePro = GOTHelper.getProperty(ds,"Table");
				if(tableId.equals(tablePro.attributeValue("refentityid"))){
					if(tableToDsChanged(ds,table)){
						result += adjustDsByTable(ds,table);
					}
				}
			}
		}

		return result;
	}
	
	private Boolean tableToDsChanged(Element ds, Element table){
		List<Element> tableFields = table.element("TableFields").elements("TableField");
		List<Element> formdatasourcefields = ds.element("FormDataSourceFields").elements("FormDataSourceField");
		int j = 0;
		for(int i = 0;i<formdatasourcefields.size();i++){
			//维度展开的节点可能在最后面 所以应在最前面跳过
			Element fdsf = formdatasourcefields.get(i);
			String fdsfName = fdsf.attributeValue("name");
			if(fdsfName.indexOf(".")!=-1)
				continue;
			Element tableField = tableFields.get(j);
			Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
			String refinnerid = fieldPro.attributeValue("refinnerid");
			if(!refinnerid.equals(tableField.attributeValue("id")))
				return true;
			String tableFieldName = tableField.attributeValue("name");
			if(!fdsfName.equals(tableFieldName))
				return true;
			if(!tableField.attributeValue("type").equals(fdsf.attributeValue("type")))
				return true;
			j++;
		}
		return false;
	}
	
	@SuppressWarnings("unchecked")
	private String adjustDsByTable(final Element ds, final Element table){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				Element form = ds.getParent().getParent();
				List<Element> tableFields = table.element("TableFields").elements("TableField");
				Element datasourcefields = ds.element("FormDataSourceFields");
				form.addAttribute("saved", "0");
				TreeItem trtmNewTreeitem = FormDataSyn.getTreeItrmByElement(form, FormDataSyn.treeUis.get(0));
				FormDataSyn.setUnSave(trtmNewTreeitem);
				
				Element base = null;
				for(Element tableField : tableFields){
					String _id = tableField.attributeValue("id");
					List<Element> fdsfList = new ArrayList<>();
					List<Element> fdsfs = datasourcefields.elements("FormDataSourceField");
					for (Element temp : fdsfs){
						Element fieldPro = GOTHelper.getProperty(temp,"Field");
						if(_id.equals(fieldPro.attributeValue("refinnerid"))){
							fdsfList.add(temp) ;
						}
					}
					if(fdsfList.size()==0){
						String nextInnerId = form.attributeValue("nextInnerId");
						Element fdsf;
						if("String".equals(tableField.attributeValue("type"))){
							fdsf = GOTXMLHelper.formDataSourceField_String_Template.createCopy();
						}else{
							fdsf = GOTXMLHelper.formDataSourceFieldTemplate.createCopy();
						}
							
						fdsf.addAttribute("id", nextInnerId);
						fdsf.addAttribute("name", tableField.attributeValue("name"));
						fdsf.addAttribute("type", tableField.attributeValue("type"));
						fdsf.addAttribute("createdLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
						fdsf.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
						int intnextinnerid = Integer.parseInt(nextInnerId);
						Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
						fieldPro.addAttribute("refentityid", table.attributeValue("id"));
						fieldPro.addAttribute("refinnerid", tableField.attributeValue("id"));
						if(fieldPro.element("Value") == null){
							fieldPro.addElement("Value");
						}
						fieldPro.element("Value").setText(tableField.attributeValue("name"));
						fdsfList.add(fdsf);
						if("Component".equals(tableField.attributeValue("type"))){
							Element extPro = GOTHelper.getProperty(tableField,"Extends");
							if(extPro.attribute("refentityid") != null){
								String dataTypeId = extPro.attributeValue("refentityid");
//								String xpath = "DataDictionary/DataTypes/DataType[@id='" + dataTypeId + "']";
//								List<Element> dataTypes = NodeGOT.gotXML.selectNodes(xpath);
								Element dataTypes = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", dataTypeId);
								
								if(dataTypes != null){
									Element dataType = dataTypes;
									List<Element> arrayItems = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
									int length = arrayItems.size();
									for(int i = 0;i<length;i++){
										if(i==0){
											if(base == null){
												datasourcefields.add(fdsf.detach());
											}else{
												GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
											}
											fdsfList.remove(fdsf);
											base = fdsf;
										}
										Element arrayItem = arrayItems.get(i);
										fdsf = GOTXMLHelper.formDataSourceField_String_Template.createCopy();
										fdsf.addAttribute("id", String.valueOf(++intnextinnerid));
										String compItem = tableField.attributeValue("name")+"."+arrayItem.attributeValue("name");
										fdsf.addAttribute("name", compItem);
										fdsf.addAttribute("type", "String");
										fdsf.addAttribute("createdLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
										fdsf.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
										fieldPro = GOTHelper.getProperty(fdsf,"Field");
										fieldPro.addAttribute("refentityid", table.attributeValue("id"));
										fieldPro.addAttribute("refinnerid", tableField.attributeValue("id"));
										if(fieldPro.element("Value") == null){
											fieldPro.addElement("Value");
										}
										fieldPro.element("Value").setText(compItem);
										GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
										base = fdsf;
									}
									
								}
							}
						}
						form.addAttribute("nextInnerId", String.valueOf(++intnextinnerid));
					}else{
						//在fdsfList中 包含了继承tableField的FormDataSourceField 如果tableField是Component 则包含了其展开项
						for(Element fdsf : fdsfList){
//							int index = fdsfs.indexOf(fdsf);
							fdsfs.remove(fdsf);
							
							Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
							String refinnerid = fieldPro.attributeValue("refinnerid");
							
							String fdsfName = fdsf.attributeValue("name");
							String tableFieldName = tableField.attributeValue("name");
							String tableFieldId = tableField.attributeValue("id");
							String fdsfType = fdsf.attributeValue("type");
							String tableFieldType = tableField.attributeValue("type");
							if(tableFieldId.equals(refinnerid)){
								if(fdsfName.indexOf(".")==-1){
									fdsf.addAttribute("name", tableFieldName);
//									Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
									if(fieldPro.element("Value") == null){
										fieldPro.addElement("Value");
									}
									fieldPro.element("Value").setText(tableFieldName);
								}else{
									String[] array = fdsfName.split("\\.");
									array[0] = tableFieldName;
									String newFdsfName = "";
									for (int i = 0; i <  array.length ; i ++) {
										if(i == 0){
											newFdsfName += array[i];
										}else{
											newFdsfName += "." + array[i] ;
										}
										
									}
									fdsf.addAttribute("name", newFdsfName);
//									Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
									if(fieldPro.element("Value") == null){
										fieldPro.addElement("Value");
									}
									fieldPro.element("Value").setText(newFdsfName);
								}
							}
							
							if(!"Component".equals(tableFieldType) && !fdsfType.equals(tableFieldType)){
								fdsf.addAttribute("type", tableFieldType);
							}
						}
					}
					
					for(Element fdsf : fdsfList){
						if(base == null){
							datasourcefields.add(fdsf.detach());
						}else{
							GOTHelp.insertChildAfter(datasourcefields, base, fdsf);
						}
						base = fdsf;
					}
					
				}
				List<Element> fdsfs = datasourcefields.elements("FormDataSourceField");
				
				for(Element fdsf : fdsfs){
					Element fieldPro = GOTHelper.getProperty(fdsf,"Field");
					String _id = fieldPro.attributeValue("refinnerid");
					Element tableField = null;
					for (Element element : tableFields) {
						if(_id.equals(element.attributeValue("id"))){
							tableField = element;
							break;
						}
					}
					if(tableField == null){
						GOTXMLHelper.deleteNode(fdsf);
					}
				}
				GotXmlDto.getInstance().updateEntityElement(form);
				FormDataSyn.restore(trtmNewTreeitem, form, false);
				
			}
		});
		String formItemPrompt = "";
		return formItemPrompt;
	}
}
