package info.gongqi.got.tool;

import java.math.BigDecimal;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

import gongqi.designer.services.ComponentDataTypeService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.util.GOTMessageDialog;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class ModifyDim extends Dialog {

	protected Object result;
	protected Shell shell;
	private Text text_dataType;
	private Text text_arrayItem;
	private Text text_origName;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public ModifyDim(Shell parent, int style) {
		super(parent, style);
		setText("修改维度");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle() | SWT.APPLICATION_MODAL);
		
		int w = ConfigComposite.configComposite.DPIZOOM.multiply(new BigDecimal(306)).intValue();
//		int h = ConfigComposite.configComposite.DPIZOOM.multiply(new BigDecimal(306)).intValue();
		shell.setSize(w, 269);
		shell.setText(getText());

		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		shell.setLayout(null);
		
		int lab_w_84 = ConfigComposite.configComposite.DPIZOOM.multiply(new BigDecimal(84)).intValue();
		Label lblNewLabel = new Label(shell, SWT.NONE);
		lblNewLabel.setBounds(21, 21, lab_w_84, 17);
		lblNewLabel.setText("dataTypeId：");
		
		int lab_w_111 = ConfigComposite.configComposite.DPIZOOM.multiply(new BigDecimal(111)).intValue();
		text_dataType = new Text(shell, SWT.BORDER);
		text_dataType.setText("");
		text_dataType.setBounds(lab_w_111, 18, lab_w_111, 23);
		
		Label lblArrayitemid = new Label(shell, SWT.NONE);
		lblArrayitemid.setText("arrayItemId：");
		lblArrayitemid.setBounds(21, 58, lab_w_84, 17);
		
		Label lblOrigname = new Label(shell, SWT.NONE);
		lblOrigname.setText("origName：");
		lblOrigname.setBounds(21, 93, lab_w_84, 17);
		
		text_arrayItem = new Text(shell, SWT.BORDER);
		text_arrayItem.setText("");
		text_arrayItem.setBounds(lab_w_111, 55, lab_w_111, 23);
		
		text_origName = new Text(shell, SWT.BORDER);
		text_origName.setText("");
		text_origName.setBounds(111, 90, lab_w_111, 23);
		
		Button btnNewButton = new Button(shell, SWT.NONE);
		btnNewButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					ComponentDataTypeService componentDataTypeService = ObjectContainer.getInstance(ComponentDataTypeService.class);
					componentDataTypeService.rename(text_dataType.getText());
					GOTMessageDialog.alert("已处理，请重新加载后显示");
					shell.close();
				} catch (Exception e1) {
					e1.printStackTrace();
					GOTMessageDialog.alert(e1.getMessage());
				}
			}
		});
		btnNewButton.setBounds(20, 146, lab_w_111, 27);
		btnNewButton.setText("重命名");
		
		int lab_w_179 = ConfigComposite.configComposite.DPIZOOM.multiply(new BigDecimal(179)).intValue();
		Button btnarrayitem = new Button(shell, SWT.NONE);
		btnarrayitem.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					ComponentDataTypeService componentDataTypeService = ObjectContainer.getInstance(ComponentDataTypeService.class);
					componentDataTypeService.renameItem(text_dataType.getText(), text_arrayItem.getText(), text_origName.getText());
					GOTMessageDialog.alert("已处理，请重新加载后显示");
					shell.close();
				} catch (Exception e1) {
					e1.printStackTrace();
					GOTMessageDialog.alert(e1.getMessage());
				}
			}
		});
		btnarrayitem.setText("重命名arrayItem");
		btnarrayitem.setBounds(lab_w_179, 146, lab_w_111, 27);
		
		Button btnarrayitem_1 = new Button(shell, SWT.NONE);
		btnarrayitem_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					ComponentDataTypeService componentDataTypeService = ObjectContainer.getInstance(ComponentDataTypeService.class);
					componentDataTypeService.addItem(text_dataType.getText(), text_arrayItem.getText());
					GOTMessageDialog.alert("已处理，请重新加载后显示");
					shell.close();
				} catch (Exception e1) {
					e1.printStackTrace();
					GOTMessageDialog.alert(e1.getMessage());
				}
			}
		});
		btnarrayitem_1.setText("增加arrayItem");
		btnarrayitem_1.setBounds(20, 192, lab_w_111, 27);
		
		Button btnarrayitem_2 = new Button(shell, SWT.NONE);
		btnarrayitem_2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					ComponentDataTypeService componentDataTypeService = ObjectContainer.getInstance(ComponentDataTypeService.class);
					componentDataTypeService.changeItemOrder(text_dataType.getText());
					GOTMessageDialog.alert("已处理，请重新加载后显示");
					shell.close();
				} catch (Exception e1) {
					e1.printStackTrace();
					GOTMessageDialog.alert(e1.getMessage());
				}
			}
		});
		btnarrayitem_2.setText("改变arrayItem顺序");
		btnarrayitem_2.setBounds(lab_w_179, 192, lab_w_111, 27);
	}
}
