package info.gongqi.got.tool;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import info.gongqi.got.util.GOTMessageDialog;

public class ModifyExtendsDialog extends Dialog {

	protected Object result;
	protected Shell shell;
	private Text text;
	private Label label_inner;
	private Text text_inner;
	private Button cancel;

	private Element xml;
	private Label label3;
	private Text text_3;
	private Label lblNewLabel;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public ModifyExtendsDialog(Shell parent, int style, Element xml) {
		super(parent, style);
		setText("修改继承关系");
		this.xml = xml;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Element open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return xml;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(322, 279);
		shell.setText(getText());
		shell.setLayout(new FormLayout());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();  
        Rectangle rect = shell.getBounds ();  
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        
		Label label_entity = new Label(shell, SWT.NONE);
		FormData fd_label_entity = new FormData();
		fd_label_entity.right = new FormAttachment(100, -10);
		fd_label_entity.top = new FormAttachment(0, 10);
		fd_label_entity.left = new FormAttachment(0, 10);
		label_entity.setLayoutData(fd_label_entity);
		label_entity.setText("所关联的实体节点ID为:");
		
		lblNewLabel = new Label(shell, SWT.NONE);
		FormData fd_lblNewLabel = new FormData();
		fd_lblNewLabel.top = new FormAttachment(label_entity, 12);
		fd_lblNewLabel.right = new FormAttachment(20, 0);
		fd_lblNewLabel.left = new FormAttachment(0, 10);
		lblNewLabel.setLayoutData(fd_lblNewLabel);
		lblNewLabel.setText("修改为：");
		
		text = new Text(shell, SWT.BORDER);
		FormData fd_text = new FormData();
		fd_text.right = new FormAttachment(100, -10);
		fd_text.top = new FormAttachment(label_entity, 10);
		fd_text.left = new FormAttachment(20, 0);
		text.setLayoutData(fd_text);
		
		label_inner = new Label(shell, SWT.NONE);
		FormData fd_label_inner = new FormData();
		fd_label_inner.top = new FormAttachment(text, 10);
		fd_label_inner.right = new FormAttachment(100, -10);
		fd_label_inner.left = new FormAttachment(0, 10);
		label_inner.setLayoutData(fd_label_inner);
		label_inner.setText("所关联的实体外内部节点ID为:");
		
		Label lblNewLabel2 = new Label(shell, SWT.NONE);
		FormData fd_lblNewLabel2 = new FormData();
		fd_lblNewLabel2.top = new FormAttachment(label_inner, 12);
		fd_lblNewLabel2.right = new FormAttachment(20, 0);
		fd_lblNewLabel2.left = new FormAttachment(0, 10);
		lblNewLabel2.setLayoutData(fd_lblNewLabel2);
		lblNewLabel2.setText("修改为：");
		
		text_inner = new Text(shell, SWT.BORDER);
		FormData fd_text_inner = new FormData();
		fd_text_inner.top = new FormAttachment(label_inner, 10);
		fd_text_inner.right = new FormAttachment(100, -10);
		fd_text_inner.left = new FormAttachment(20, 0);
		text_inner.setLayoutData(fd_text_inner);
		
		label3 = new Label(shell, SWT.NONE);
		FormData fd_label3 = new FormData();
		fd_label3.top = new FormAttachment(text_inner, 10);
		fd_label3.left = new FormAttachment(0, 10);
		fd_label3.right = new FormAttachment(100, -10);
		label3.setLayoutData(fd_label3);
		label3.setText("所关联的内部节点ID为:");
		
		Label lblNewLabel3 = new Label(shell, SWT.NONE);
		FormData fd_lblNewLabel3 = new FormData();
		fd_lblNewLabel3.top = new FormAttachment(label3, 12);
		fd_lblNewLabel3.right = new FormAttachment(20, 0);
		fd_lblNewLabel3.left = new FormAttachment(0, 10);
		lblNewLabel3.setLayoutData(fd_lblNewLabel3);
		lblNewLabel3.setText("修改为：");
		
		text_3 = new Text(shell, SWT.BORDER);
		FormData fd_text_3 = new FormData();
		fd_text_3.top = new FormAttachment(label3, 10);
		fd_text_3.left = new FormAttachment(20, 0);
		fd_text_3.right = new FormAttachment(100, -10);
		text_3.setLayoutData(fd_text_3);
		
		Button confirm = new Button(shell, SWT.NONE);
		confirm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(!text.getText().equals("")){
					xml.attribute("refentityid").setValue(text.getText());
				}
				if(!text_inner.getText().equals("")){
					xml.attribute("refinnerid").setValue(text_inner.getText());
				}
				if(!text_3.getText().equals("")){
					xml.attribute("innerid").setValue(text_3.getText());
				}
				shell.close();
			}
		});
		FormData fd_confirm = new FormData();
		fd_confirm.top = new FormAttachment(text_3, 20);
		fd_confirm.left = new FormAttachment(20,0);
		fd_confirm.right = new FormAttachment(40,0);
		confirm.setLayoutData(fd_confirm);
		confirm.setText("确定");
		
		cancel = new Button(shell, SWT.NONE);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
		});
		FormData fd_cancel = new FormData();
		fd_cancel.top = new FormAttachment(confirm, 0, SWT.TOP);
		fd_cancel.right = new FormAttachment(80, 0);
		fd_cancel.left = new FormAttachment(confirm,80);
		cancel.setLayoutData(fd_cancel);
		cancel.setText("取消");

		GOTMessageDialog.shells.add(shell);
		
		if(xml.attribute("refentityid") != null){
			label_entity.setText(label_entity.getText() + xml.attributeValue("refentityid"));
		}else{
			text.setEnabled(false);
		}
		
		if(xml.attribute("refinnerid") != null){
			label_inner.setText(label_inner.getText() + xml.attributeValue("refinnerid"));
		}else{
			text_inner.setEnabled(false);
		}

		if(xml.attribute("innerid") != null){
			label3.setText(label3.getText() + xml.attributeValue("refinnerid"));
		}else{
			text_3.setEnabled(false);
		}

	}
}
