package info.gongqi.got.tool;

import info.gongqi.got.util.GOTMessageDialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressBarExchangeLayer extends Dialog {

	protected Object resultDialog = "";
	public Shell shell;

	public ProgressBar progressBar;
	
	public static ProgressBarExchangeLayer barExchangeLayer;
	/** 
	 * Create the dialog.
	 * 
	 * @param parent
	 * @param style
	 */
	public ProgressBarExchangeLayer(Shell parent, int style) {
		super(parent, style);
		setText("正在处理...");
		if(barExchangeLayer == null){
			barExchangeLayer = this;
		}
	}

	/**
	 * Open the dialog.
	 * 
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return resultDialog;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(600, 50);
		shell.setText(getText());
		shell.setLayout(new FillLayout(SWT.HORIZONTAL));
		GOTMessageDialog.shell.setEnabled(false);
		
		Monitor monitor = shell.getMonitor();
		Rectangle bounds = monitor.getBounds();
		Rectangle rect = shell.getBounds();
		int x = bounds.x + (bounds.width - rect.width) / 2;
		int y = bounds.y + (bounds.height - rect.height) / 2;
		shell.setLocation(x, y);
		progressBar = new ProgressBar(shell, SWT.HORIZONTAL | SWT.INDETERMINATE);
		
		shell.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent arg0) {
				barExchangeLayer = null;
				GOTMessageDialog.shell.setEnabled(true);
			}
		});
		
		Thread thread = new Thread(new Runnable() {
			public void run() {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						FormDataSyn.setShowTreeItemByLayerAndSolution();
					}
				});
			}
		});
		thread.start();
		
/*		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				int num = 100;
				for (int i = 0; i < num; i++) {
					if(!shell.isDisposed()){
						try {
							Thread.sleep(50);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
						setProgressBar(i);
					}
					
				}
			}
		});*/
		
	}
	public void setProgressBar(final int num){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (progressBar.isDisposed())
					return;
					progressBar.setSelection(num);
			}
		});
	}
	
	public void setShellText(final String text){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				if (shell.isDisposed())
					return;
				shell.setText(text);
			} 
		});
	}
	
	public void setAlert(final String text, final String title){
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				GOTMessageDialog.showXmlInfo(text, title);
			}
		});
	}
	
}
