package info.gongqi.got.tool;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.ui.SWTUtils;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;

import client.gongqi.designer.got.node.NodeGOT;
public class RightKeyMethod {

	private org.eclipse.swt.widgets.List currentLayerMethod_List;
	private org.eclipse.swt.widgets.List lowerLayerMethod_List;
	private Shell shell;
	public String classId, buttonFilter;
	private Element element;
	private org.eclipse.swt.widgets.List canOverrideMethod_List;
	private Font font;
	private TextViewer methodDetail_Text;
	private List<Map<String, String>> ovList,impList;
	
	public RightKeyMethod(Composite parent, Element xml) {
		element = xml;
		
		shell = new Shell(parent.getShell(), SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE);//SWT.SHELL_TRIM | SWT.BORDER | SWT.ON_TOP
		shell.setSize(SWTUtils.zoom(800), SWTUtils.zoom(430));
        Monitor monitor = shell.getMonitor();
        Rectangle bounds = monitor.getBounds ();
        Rectangle rect = shell.getBounds ();
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        shell.setLayout(new FormLayout());
        
        font = new Font(shell.getDisplay(), "微软雅黑", 9, SWT.BOLD);
		  
        //可覆盖方法
		Label canOverrideMethod_Label = new Label(shell, SWT.NONE);
		canOverrideMethod_Label.setText("可覆盖方法");
		FormData formData = new FormData();
		formData.top = new FormAttachment(0, 10);
		formData.left = new FormAttachment(0, 10);
		canOverrideMethod_Label.setLayoutData(formData);
		
		canOverrideMethod_List = new org.eclipse.swt.widgets.List(shell, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
		canOverrideMethod_List.setFont(font);
		formData = new FormData();
		formData.left = new FormAttachment(canOverrideMethod_Label, 5, SWT.LEFT);
		formData.right = new FormAttachment(0, SWTUtils.zoom(150));
		formData.bottom = new FormAttachment(100, -40);
		formData.top = new FormAttachment(canOverrideMethod_Label, 6);
		canOverrideMethod_List.setLayoutData(formData);
		
		Button addMethod_Button = new Button(shell, SWT.NONE);
		addMethod_Button.setText("覆盖");
		formData = new FormData(40, 25);
		formData.left = new FormAttachment(canOverrideMethod_Label, 0, SWT.LEFT);
		formData.bottom = new FormAttachment(100, -5);
		addMethod_Button.setLayoutData(formData);
		addMethod_Button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				btnoverride_clickHandler();
			}
		});
		
		//当前层方法
		Label currentLayerMethod_Label = new Label(shell, SWT.NONE);
		currentLayerMethod_Label.setText("当前层方法");
		formData = new FormData();
		formData.top = new FormAttachment(canOverrideMethod_Label, 0, SWT.TOP);
		formData.left = new FormAttachment(canOverrideMethod_List, 15, SWT.RIGHT);
		currentLayerMethod_Label.setLayoutData(formData);
		
		currentLayerMethod_List = new org.eclipse.swt.widgets.List(shell, SWT.BORDER| SWT.V_SCROLL);
		currentLayerMethod_List.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		currentLayerMethod_List.setFont(font);
		formData = new FormData();
		formData.top = new FormAttachment(canOverrideMethod_List, 0, SWT.TOP);
		formData.right = new FormAttachment(50);
		formData.left = new FormAttachment(currentLayerMethod_Label, 0, SWT.LEFT);
		formData.bottom = new FormAttachment(45);
		currentLayerMethod_List.setLayoutData(formData);
		
		/*Button editorMethod_Button = new Button(shell, SWT.NONE);
		editorMethod_Button.setText("编辑");
		formData = new FormData(40, 25);
		formData.right = new FormAttachment(currentLayerMethod_List, -2, SWT.RIGHT);
		formData.top = new FormAttachment(currentLayerMethod_List, 5, SWT.BOTTOM);
		editorMethod_Button.setLayoutData(formData);
		editorMethod_Button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				btnEdit_clickHandler();
			}
		});*/
		
		//下层方法
		Label lowerLayerMethod_Label = new Label(shell, SWT.NONE);
		lowerLayerMethod_Label.setText("下层方法");
		formData = new FormData();
		formData.top = new FormAttachment(currentLayerMethod_List, 15, SWT.BOTTOM);
		formData.left = new FormAttachment(currentLayerMethod_Label, 0, SWT.LEFT);
		lowerLayerMethod_Label.setLayoutData(formData);
	
		lowerLayerMethod_List = new org.eclipse.swt.widgets.List(shell, SWT.BORDER | SWT.V_SCROLL);
		lowerLayerMethod_List.setFont(font);
		lowerLayerMethod_List.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		formData = new FormData();
		formData.bottom = new FormAttachment(canOverrideMethod_List, 0, SWT.BOTTOM);
		formData.top = new FormAttachment(lowerLayerMethod_Label, 5, SWT.BOTTOM);
		formData.right = new FormAttachment(currentLayerMethod_List, 0, SWT.RIGHT);
		formData.left = new FormAttachment(currentLayerMethod_List, 0, SWT.LEFT);
		lowerLayerMethod_List.setLayoutData(formData);
		
		/*Button overrideMethod_Button = new Button(shell, SWT.NONE);
		overrideMethod_Button.setText("覆盖");
		formData = new FormData(40, 25);
		formData.left = new FormAttachment(editorMethod_Button, 0, SWT.LEFT);
		formData.top = new FormAttachment(lowerLayerMethod_List, 5, SWT.BOTTOM);
		overrideMethod_Button.setLayoutData(formData);
		overrideMethod_Button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				textDown_doubleClickHandler();
			}
		});*/
	
		/*Button btnFlash = new Button(shell, SWT.NONE);
		FormData fd_btnFlash = new FormData();
		fd_btnFlash.bottom = new FormAttachment(100, 0);
		fd_btnFlash.right = new FormAttachment(100, -5);
		btnFlash.setLayoutData(fd_btnFlash);
		btnFlash.setText("刷新");
		btnFlash.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				open();
			}
		});*/
		
		Label methodDetail_Label = new Label(shell, SWT.NONE);
		methodDetail_Label.setText("方法内容");
		formData = new FormData();
		formData.top = new FormAttachment(canOverrideMethod_Label, 0, SWT.TOP);
		formData.left = new FormAttachment(currentLayerMethod_List, 10, SWT.RIGHT);
		methodDetail_Label.setLayoutData(formData);
		
		methodDetail_Text = new TextViewer(shell, SWT.BORDER | SWT.V_SCROLL);
		methodDetail_Text.setEditable(false);
		formData = new FormData();
		formData.left = new FormAttachment(methodDetail_Label, 0, SWT.LEFT);
		formData.right = new FormAttachment(100, -10);
		formData.bottom = new FormAttachment(canOverrideMethod_List, 0, SWT.BOTTOM);
		formData.top = new FormAttachment(canOverrideMethod_List, 0, SWT.TOP);
		methodDetail_Text.getTextWidget().setLayoutData(formData);
		methodDetail_Text.getTextWidget().addKeyListener(new org.eclipse.swt.events.KeyListener() {
			
			@Override
			public void keyReleased(org.eclipse.swt.events.KeyEvent arg0) {
				
			}
			
			@Override
			public void keyPressed(org.eclipse.swt.events.KeyEvent arg0) {
				//CTRL+ A全选
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 97){
					methodDetail_Text.getTextWidget().selectAll();
				}
			}
		});
		
		
		
		event();
		
		shell.open();
		shell.layout();
		GOTMessageDialog.shells.add(shell);
	}
	
	public void open(){
		Thread thread = new Thread(new Runnable() {
			public void run() {
				Display.getDefault().asyncExec(new Runnable() {
					@Override
					public void run() {
						//TODO 
//						init(element);
						initApp(element);
					}
				});
			}
		});
		thread.start();
	}
	
	public void init(Element node){
		String entityId;
		Element entity = NodeGOT.getEntity(node);
		entityId = entity.attributeValue("id");
		if(entityId.contains(".")){
			String[] strs = entityId.split("\\.");
			entityId = strs[strs.length - 1];
		}
		if(entityId.substring(0,2).equals("30")){
			classId = entityId;
		}else if(entityId.substring(0,2).equals("40")) {
			if(node.getName().equals("Form") || "Button".equals(node.attributeValue("type"))){
				classId = entityId + ".Form.0";	
			}else if(node.getName().equals("FormDataSource")){
				classId = entityId + ".FormDataSource." + node.attributeValue("id");
			}else{
				classId = entityId + ".Form.0";	
			}
		}
		
		if(node.getName().equals("FormItem") && "Button".equals(node.attributeValue("type")))
			buttonFilter = node.attributeValue("name");
		
		shell.setText("id = " + classId);
		
		methodDetail_Text.getTextWidget().setText("");
		this.call_getMethodsImplemented(node);
		this.call_getMethodsCanbeOverride(node);
		
	}
	
	private void initApp(Element node){
		Element entity = NodeGOT.getEntity(node);
		String entityId = entity.attributeValue("id");
		String entityTemp = entityId;
		if(entityId.contains(".")){
			String[] strs = entityId.split("\\.");
			entityId = strs[strs.length - 1];
		}
		if(entityId.substring(0,2).equals("30")){
			classId = entityTemp;
		}else if(entityId.substring(0,2).equals("40")) {
			if(node.getName().equals("Form") || "Button".equals(node.attributeValue("type"))){
				classId = entityTemp + "-Form-0";	
			}else if(node.getName().equals("FormDataSource")){
				classId = entityTemp + "-FormDataSource-" + node.attributeValue("id");
			}else{
				classId = entityTemp + "-Form-0";	
			}
		}
		
		if(node.getName().equals("FormItem") && "Button".equals(node.attributeValue("type")))
			buttonFilter = node.attributeValue("name");
		
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				shell.setText("id = " + classId);
				methodDetail_Text.getTextWidget().setText("");
			}
		});

//		Thread thread = new Thread(new Runnable() {
//			@Override
//			public void run() {
//
//			}
//		});
//		thread.start();
		
		call_getMethodsImplemented(element);
		call_getMethodsCanbeOverride(element);
		
	}

	private Object Implemented = null;
	
	private void call_getMethodsImplemented(Element node){
		final String arg2;
		if(node != null && node.getName().equals("FormItem") && node.attributeValue("type").equals("Button")){
			arg2 = node.attributeValue("name");
		}else{
			arg2 = null;
		}

		Thread thread = new Thread(new Runnable() {
			public void run() {
				try {
					Implemented = LoadXmlCore.codeServices.getMethodsImplemented(classId, arg2);
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							result_getMethodsImplemented(Implemented);
						}
					});
				} catch (Exception e) {
					e.printStackTrace();
					return;
				}
			}
		});
		thread.start();
		
		
	}
	
	@SuppressWarnings("unchecked")
	private void result_getMethodsImplemented(Object result){
		if(result == null){
			System.err.println("您要查找的文件不存在");
			return;
		}
		impList =  (List<Map<String, String>>) result;
		currentLayerMethod_List.removeAll();
		lowerLayerMethod_List.removeAll();
		for (Map<String, String> map : impList) {
			String lay = map.get("layer");
			String modifier  = map.get("modifier");
			String methodName  = map.get("methodName");
			if(lay.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
				currentLayerMethod_List.add(modifier + " " +methodName);
			}else{
				lowerLayerMethod_List.add(modifier + " " + methodName);
				
			}
		}
		
		if(currentLayerMethod_List.getItems() != null && currentLayerMethod_List.getItems().length > 0){
			currentLayerMethod_List.setSelection(0);
			setTextContent(currentLayerMethod_List.getItem(0));
		}else{
			if(lowerLayerMethod_List.getItems() != null && lowerLayerMethod_List.getItems().length > 0){
				lowerLayerMethod_List.setSelection(0);
				setTextContent(lowerLayerMethod_List.getItem(0));
			}
		}
		
		
	}
	
	private Object overRide = null;
	
	private void call_getMethodsCanbeOverride(Element node){
		final String arg2;
		if(node != null && node.getName().equals("FormItem") && node.attributeValue("type").equals("Button")){
			arg2 = node.attributeValue("name");
		}else{
			arg2 = null;
		}
		
		Thread thread = new Thread(new Runnable() {
			public void run() {
				try {
					overRide = LoadXmlCore.codeServices.getMethodsCanbeOverride(classId, arg2);
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							result_getMethodsCanbeOverride(overRide);
						}
					});
				} catch (final Exception e) {
					e.printStackTrace();
//					Display.getDefault().asyncExec(new Runnable() {
//						public void run() {
//							GOTMessageDialog.alert(e);
//						}
//					});
					return;
				}
			}
		});
		thread.start();
		
	}
	
	@SuppressWarnings("unchecked")
	private void result_getMethodsCanbeOverride(Object o){
		if(o == null){
			return ;
		}
		if(!shell.isDisposed()){
			canOverrideMethod_List.removeAll();
			ovList =  (List<Map<String, String>>) o;
			for (Map<String, String> map : ovList) {
				String methodName  = map.get("methodName");
				canOverrideMethod_List.add(methodName);
			}
		}
	}
	
	private void event(){
		canOverrideMethod_List.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
            	deal();
            }
        });
		
		currentLayerMethod_List.addListener(SWT.Selection, new Listener() {
	        public void handleEvent(Event event) {
	        	String[] count = currentLayerMethod_List.getSelection();
	        	setTextContent(count[0]);
	        }
	    });
		
		currentLayerMethod_List.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
            	btnEdit_clickHandler();
            }
        });
		
		lowerLayerMethod_List.addListener(SWT.Selection, new Listener() {
	        public void handleEvent(Event event) {
	        	String[] count = lowerLayerMethod_List.getSelection();
	        	setTextContent(count[0]);
	        }
	    });
		
		lowerLayerMethod_List.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
            	textDown_doubleClickHandler();
            }
        });

	}
	
	private void setTextContent(String selectStr){
		for (Map<String, String> map : impList) {
			String modifier  = map.get("modifier");
			String methodName  = map.get("methodName");
			String str = modifier + " " +methodName;
			if(str.equals(selectStr)){
				methodDetail_Text.getTextWidget().setText(map.get("content"));
			}
		}
	}
	
	protected void btnDel_clickHandler(){
		String[] count = currentLayerMethod_List.getSelection();
		if(count == null || count.length == 0)
			return ;
		String selectedItem = count[0].split(" ")[1];
    	String parameterTypes = null;
		for (Map<String, String> map : impList) {
			String modifier  = map.get("modifier");
			String methodName  = map.get("methodName");
			String str = modifier + " " +methodName;
			if(str.equals(count[0])){
				parameterTypes = map.get("parameterTypes");
			}
		}
		boolean b = false;
		try {
			b = LoadXmlCore.codeServices.deleteMethod(classId, selectedItem, parameterTypes);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(b){
			shell.close();
		}else{
			System.err.println("删除失败");
		}
		
	}
	
	protected void btnEdit_clickHandler(){
		String[] count = currentLayerMethod_List.getSelection();
		if(count == null || count.length == 0)
			return ;
		String selectedItem = count[0].split(" ")[1];
    	String parameterTypes = null;
		for (Map<String, String> map : impList) {
			String methodName  = map.get("methodName");
			if(methodName.equals(count[0])){
				parameterTypes = map.get("parameterTypes");
			}
		}
		try {
			LoadXmlCore.codeServices.editMethod(classId, selectedItem, parameterTypes);
		} catch (Exception e) {
			e.printStackTrace();
		}
		shell.close();
	}
	
	protected void btnoverride_clickHandler(){
		String[] count = canOverrideMethod_List.getSelection();
		if(count == null || count.length == 0)
			return ;
		
    	if(count.length > 1){
    		GOTMessageDialog.alert("请选中一行，不支持多选");
    	}
    	String parameterTypes = null;
		for (Map<String, String> map : ovList) {
			String methodName  = map.get("methodName");
			if(methodName.equals(count[0])){
				parameterTypes = map.get("parameterTypes");
			}
		}
		
		String arg2 = "";
		if(element != null && element.getName().equals("FormItem") && element.attributeValue("type").equals("Button")){
			arg2 = element.attributeValue("name");
		}else{
			arg2 = null;
		}
		
		boolean b = false;
		try {
			b = LoadXmlCore.codeServices.overrideMethod(classId, count[0], arg2, parameterTypes);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
    	if(b){
    		shell.close();
    	}else{
    		System.err.println("添加方法失败");
    	}
	}
	
	private void deal(){
    	String[] count = canOverrideMethod_List.getSelection();
    	if(count.length > 1){
    		GOTMessageDialog.alert("请选中一行，不支持多选");
    	}
    	String parameterTypes = null;
		for (Map<String, String> map : ovList) {
			String methodName  = map.get("methodName");
			if(methodName.equals(count[0])){
				parameterTypes = map.get("parameterTypes");
			}
		}
		
		String arg2 = "";
		if(element != null && element.getName().equals("FormItem") && element.attributeValue("type").equals("Button")){
			arg2 = element.attributeValue("name");
		}else{
			arg2 = null;
		}
		
		final String count_ = count[0];
		final String arg2_ = arg2;
		final String parameterTypes_ = parameterTypes;
		
		boolean b = false;
 		try {
			b = LoadXmlCore.codeServices.overrideMethod(classId, count_, arg2_, parameterTypes_);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
    	if(b){
    		shell.close();
    	}else{
    		System.err.println("添加方法失败");
    	}
//    	Display.getDefault().syncExec(new Runnable() {
//			public void run() {
//
//			}
//		});

		
	}
	
	protected void textDown_doubleClickHandler(){
		String[] count = lowerLayerMethod_List.getSelection();
		if(count == null || count.length == 0)
			return;
		String selectedItem = count[0].split(" ")[1];
    	String parameterTypes = null;
		for (Map<String, String> map : impList) {
			String modifier  = map.get("modifier");
			String methodName  = map.get("methodName");
			String str = modifier + " " +methodName;
			if(str.equals(count[0])){
				parameterTypes = map.get("parameterTypes");
			}
		}
		
		boolean b = false;
		try {
			b = LoadXmlCore.codeServices.overrideMethod(classId, selectedItem, null, parameterTypes);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		if(b){
			open();
		}
	}
}
