package info.gongqi.got.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import info.gongqi.got.util.GOTMessageDialog;

public class ShowTreeItemXML extends Dialog {

	protected Object result;
	protected Shell shell;
	private String xmls,title;
	private Text textViewer;
	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public ShowTreeItemXML(Shell parent, int style, String xml, String title) {
		super(parent, style);
		setText(title);
		xmls = xml;
		this.title = title;
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public Object open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(450, 300);
		shell.setText(getText());
		shell.setLayout(new FormLayout());
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();  
        Rectangle rect = shell.getBounds ();  
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        
		textViewer = new Text(shell, SWT.V_SCROLL | SWT.WRAP | SWT.BORDER | SWT.CLOSE);
		textViewer.setEditable(false);
		textViewer.setText(xmls);
		textViewer.selectAll();
		
        FormData fd_group = new FormData();
        fd_group.bottom = new FormAttachment(100, -30);
        fd_group.top = new FormAttachment(0, 0);
        fd_group.left = new FormAttachment(0, 5);
        fd_group.right = new FormAttachment(100, -5);
        textViewer.setLayoutData(fd_group);
        
        Button button = new Button(shell, SWT.FLAT);
        button.setText("  确定  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment(textViewer, 2);
        fd_button.bottom = new FormAttachment(100,-2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData(fd_button);
        button.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.close();
			}
        	
		});
        
		if("异常".equals(this.title)){
			textViewer.setForeground(Display.getDefault().getSystemColor(SWT.COLOR_RED));
		}
		textViewer.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent var1) {
				
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 97){
					textViewer.selectAll();
					return;
				}
			}
		});
		
		GOTMessageDialog.shells.add(shell);
	}

}
