package info.gongqi.got.tool.display;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.List;

import com.alibaba.fastjson.JSONObject;

public class TextFontComposite extends Composite {
	
	public List fontFamily, fontStyleAndWeight, fontSize;

	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public TextFontComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new FormLayout());
		this.setBackgroundMode(SWT.INHERIT_FORCE);
		
		Label lblNewLabel = new Label(this, SWT.NONE);
		FormData fd_lblNewLabel = new FormData();
		fd_lblNewLabel.top = new FormAttachment(0, 10);
		fd_lblNewLabel.left = new FormAttachment(0, 10);
		lblNewLabel.setLayoutData(fd_lblNewLabel);
		lblNewLabel.setText("字体：");
		
		fontFamily = new List(this, SWT.BORDER | SWT.V_SCROLL);
		FormData fd_list_ziti = new FormData();
		fd_list_ziti.top = new FormAttachment(lblNewLabel, 5);
		fd_list_ziti.left = new FormAttachment(0, 10);
		fd_list_ziti.right = new FormAttachment(33, 0);
		fd_list_ziti.bottom = new FormAttachment(100, -5);
		fontFamily.setLayoutData(fd_list_ziti);
		fontFamily.add("宋体");
		fontFamily.add("仿宋体");
		fontFamily.add("微软雅黑");
		
		Label lblNewLabel_1 = new Label(this, SWT.NONE);
		FormData fd_lblNewLabel_1 = new FormData();
		fd_lblNewLabel_1.top = new FormAttachment(0, 10);
		fd_lblNewLabel_1.left = new FormAttachment(fontFamily, 10,SWT.RIGHT);
		lblNewLabel_1.setLayoutData(fd_lblNewLabel_1);
		lblNewLabel_1.setText("字形：");
		
		fontStyleAndWeight = new List(this, SWT.BORDER | SWT.V_SCROLL);
		FormData fd_list_zixing = new FormData();
		fd_list_zixing.top = new FormAttachment(lblNewLabel_1, 5);
		fd_list_zixing.left = new FormAttachment(fontFamily, 10);
		fd_list_zixing.right = new FormAttachment(66, 0);
		fd_list_zixing.bottom = new FormAttachment(100, -5);
		fontStyleAndWeight.setLayoutData(fd_list_zixing);
		fontStyleAndWeight.add("常规");
		fontStyleAndWeight.add("斜体");
		fontStyleAndWeight.add("粗体");
		fontStyleAndWeight.add("斜体加粗");
		
		Label lblNewLabel_2 = new Label(this, SWT.NONE);
		FormData fd_lblNewLabel_2 = new FormData();
		fd_lblNewLabel_2.top = new FormAttachment(lblNewLabel, 0, SWT.TOP);
		fd_lblNewLabel_2.left = new FormAttachment(fontStyleAndWeight, 10, SWT.RIGHT);
		lblNewLabel_2.setLayoutData(fd_lblNewLabel_2);
		lblNewLabel_2.setText("字号：");
		
		fontSize = new List(this, SWT.BORDER | SWT.V_SCROLL);
		FormData fd_list_SIZE = new FormData();
		fd_list_SIZE.top = new FormAttachment(lblNewLabel_2, 5);
		fd_list_SIZE.left = new FormAttachment(fontStyleAndWeight, 10);
		fd_list_SIZE.right = new FormAttachment(100, -5);
		fd_list_SIZE.bottom = new FormAttachment(100, -5);
		fontSize.setLayoutData(fd_list_SIZE);
		fontSize.add("6");
		fontSize.add("8");
		fontSize.add("9");
		fontSize.add("10");
		fontSize.add("11");
		fontSize.add("12");
		fontSize.add("14");
		fontSize.add("16");
		fontSize.add("18");
		fontSize.add("20");
		fontSize.add("22");
		fontSize.add("24");
		fontSize.add("26");
		fontSize.add("28");
		fontSize.add("36");
		fontSize.add("48");
		fontSize.add("72");
		
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public JSONObject getJson(){
		JSONObject jsonObject = new JSONObject();
		String[] values = fontFamily.getSelection();
		if(values.length > 0){
			jsonObject.put("fontFamily", values[0]);
		}
		values = fontStyleAndWeight.getSelection();
		if(values.length > 0){
			if ("常规".equals(values[0])) {
				jsonObject.put("fontStyle", "normal");
				jsonObject.put("fontWeight", "");
			} else if ("斜体".equals(values[0])) {
				jsonObject.put("fontStyle", "italic");
				jsonObject.put("fontWeight", "");
			} else if ("粗体".equals(values[0])) {
				jsonObject.put("fontStyle", "");
				jsonObject.put("fontWeight", "bold");
			} else if ("斜体加粗".equals(values[0])) {
				jsonObject.put("fontStyle", "italic");
				jsonObject.put("fontWeight", "bold");
			}
		}
		values = fontSize.getSelection();
		if(values.length > 0){
			jsonObject.put("fontSize", values[0]);
		}
		return jsonObject;
	}
}
