package info.gongqi.got.ui;

import gongqi.designer.core.DesignerServer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.LoadXMLAndBulidTree;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.GOTUtil;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.validate.DoMerge;

public class ConfigComposite extends Composite {
	public static String version = "  插件版本：v3.3.5";
	//主窗口table
	public Table table;
	//主窗口树
	public Tree tree;
	//选中树节点显示信息文本框（窗口标题）
	public Text text_Label_title;
	//操作提示信息   未保存信息
	public Label text_unsave_info;
	
	private Label text_op_info;
	
	//版本信息
	public static Label text_op_info_version;
	//共有多少 画面表格信息
	public static Label text_static_info;
	//安全模式
	public static Label label_soft;
	//加载树的进度条
	public static LoadXMLAndBulidTree progressBar;
	//this
	public static ConfigComposite configComposite;
	
	public static int tableNum = 0;
	public static int fromNum = 0;
	public static int tableBusNum = 0;
	public static int selectNum = 0;
	
	private boolean onMouseModfied;
	private Point lastPos;
	private Label coolBar;
	public Button button_restart, button_label, button_pre, button_order;
	public Button button_layer;
	private Menu menu ;
	private Composite topComposite;
	
	private Composite mergeComposite;
	
	public Label layer_label;
	
	private BigDecimal DPI;
	
	public BigDecimal DPIZOOM;
	
	public Label currentLayer;
	
	
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public ConfigComposite(final Composite parent, int style) {
		super(parent, style);
		this.setLayout(new FormLayout());
		 //Windows系统默认是96dpi，Apple系统默认是72dpi。
        Point dpi = Display.getDefault().getDPI();
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                DPI = BigDecimal.valueOf(96);
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")){
                DPI=BigDecimal.valueOf(72);
        } else {
                DPIZOOM = BigDecimal.valueOf(dpi.x);
        }
        DPIZOOM = BigDecimal.valueOf(dpi.x).divide(DPI, 4, RoundingMode.HALF_UP);
        setDpi();
        
		loadTree(parent);
		GOTMessageDialog.init(parent);
		initTextLabel(parent);
		mergeButton();
		configComposite = this;
		
	}

	@Override
	protected void checkSubclass() {
		
	}
	
	//加载画面上的树和表格以及按钮
	public void loadTree(Composite parent){
		addButton(parent);
        tree = new Tree(parent, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION ^ SWT.H_SCROLL);
        
        int h = DPIZOOM.multiply(new BigDecimal(51)).intValue();
        int b = DPIZOOM.multiply(new BigDecimal(-25)).intValue();
        FormData fd_tree_1 = new FormData();
        fd_tree_1.right = new FormAttachment(51, -10);
        fd_tree_1.bottom = new FormAttachment(100, b);
        fd_tree_1.top = new FormAttachment(0, h);
        fd_tree_1.left = new FormAttachment(0, 5);
        tree.setLayoutData(fd_tree_1);
		Font fonts = new Font(tree.getDisplay(), "宋体", 9, SWT.NONE);
		tree.setFont(fonts);
		tree.getHorizontalBar().setEnabled(false);
		
        coolBar = new Label(parent, SWT.BORDER);
		FormData fd_coolBar = new FormData();
		fd_coolBar.top = new FormAttachment(0, h);
	    fd_coolBar.bottom = new FormAttachment(100, b);
		fd_coolBar.left = new FormAttachment(tree, -1);
		fd_coolBar.right = new FormAttachment(51, 0);
		coolBar.setLayoutData(fd_coolBar);
		coolBar.setBackground(new Color(coolBar.getDisplay(), 240,240,246));
		
		final Cursor CURSOR_SIZEWE = new Cursor(Display.getDefault(), SWT.CURSOR_SIZEWE);
		coolBar.setCursor(CURSOR_SIZEWE);
		
		coolBar.addMouseMoveListener(new MouseMoveListener() {
			
			Long lastTime = System.currentTimeMillis();
					
			@Override
			public void mouseMove(MouseEvent e) {
				if(onMouseModfied && (System.currentTimeMillis() -lastTime) > 50){
                    Point pos=((Control)(e.widget)).toDisplay(e.x, e.y);
                    modify(pos.x-lastPos.x, new Rectangle(1,0,1,1));
                    lastPos = pos;
                    lastTime = System.currentTimeMillis();
				}
			}
		});
		
		coolBar.addMouseListener(new MouseAdapter() { 
            @Override
            public void mouseDown(MouseEvent e) {
                // 记录当前鼠标位置，以供mouseMove消息时计算鼠标移动距离
                lastPos=((Control)(e.widget)).toDisplay(e.x, e.y);
                onMouseModfied=true;
            }
            
            @Override
            public void mouseUp(MouseEvent e) {
                onMouseModfied=false;
            }
        });
		
        table = new Table(parent,SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION | SWT.V_SCROLL);
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, h);
        fd_table.bottom = new FormAttachment(100, b);
        fd_table.left = new FormAttachment(coolBar, 0);
        fd_table.right = new FormAttachment(100, -5);
        table.setLayoutData(fd_table);
        table.setLinesVisible(true);
        table.setFont(fonts);
        table.setHeaderVisible(true);
        
//		Rectangle bound = table.getBounds();
		TableColumn Name = new TableColumn(table, SWT.NONE);
//		Name.setWidth(bound.width/2 -5);
		Name.setText("Name");
		
		TableColumn Value = new TableColumn(table, SWT.NONE);
//		Value.setWidth(bound.width/2 - 5);
		Value.setText("Value");
		
        tree.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
                TreeItem trtmNewTreeitem = (TreeItem) event.item;
                	set_text_Label_title(trtmNewTreeitem);
            }
        });
	}
	
    /**
     * 改变窗口位置和尺寸
     * @param x x轴移动距离
     * @param y y轴移动距离
     * @param mask 锚点位置计算的掩码
     */
    protected void modify(int x,Rectangle mask){
        // 计算出新的窗口位置和尺寸
        Rectangle boundTree = tree.getBounds();
        boundTree.width += x*mask.width;
        tree.setBounds(boundTree);
        
        Rectangle boundLable = coolBar.getBounds();
        boundLable.x += x*mask.x;
        coolBar.setBounds(boundLable);
        
        Rectangle boundTable = table.getBounds();
        boundTable.x += x*mask.x;
        boundTable.width += -x*mask.width;
        table.setBounds(boundTable);
        
    }
    
	public void set_text_Label_title(TreeItem trtmNewTreeitem){
		 Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
         if(element != null){
         	String titleInfo = element.getName();
         	if(element.attribute("name") != null){
         		titleInfo += " name=" + element.attributeValue("name");
         	}
         	if(element.attribute("id") != null){
         		titleInfo += " id=" + element.attributeValue("id");
         	}
         	if(element.attribute("version") != null){
         		titleInfo += " version=" + element.attributeValue("version");
         	}
         	if(element.attribute("vislble") != null){
         		titleInfo += " vislble=" + element.attributeValue("vislble");
         	}
         	if(element.attribute("locked") != null){
         		titleInfo += " locked=" + element.attributeValue("locked");
         	}
         	if(element.attribute("type") != null){
         		titleInfo += " type=" + element.attributeValue("type");
         	}
         	if(element.attribute("createdLayer") != null){
         		titleInfo += " createdLayer=" + element.attributeValue("createdLayer");
         	}
         	if(element.attribute("modifiedLayer") != null){
         		titleInfo += " modifiedLayer=" + element.attributeValue("modifiedLayer");
         	}
         	text_Label_title.setText(titleInfo);
         }
	}
	
	private void initTextLabel(final Composite parentCom){
    	FormData formData = new FormData();
    	formData.top = new FormAttachment(topComposite,-1);
    	formData.left = new FormAttachment(0,5);
    	formData.right = new FormAttachment(100, -5);
    	formData.bottom = new FormAttachment(tree, 0, SWT.TOP);
    	Composite composite = new Composite(parentCom, SWT.BORDER);
    	composite.setLayoutData(formData);
    	composite.setLayout(new FormLayout());
    	
    	FormData dataLabel = new FormData();
//    	dataLabel.top = new FormAttachment(topComposite,0);
    	dataLabel.left = new FormAttachment(0,0);
    	dataLabel.right = new FormAttachment(85,0);
		text_Label_title = new Text(composite, SWT.READ_ONLY);
		text_Label_title.setEnabled(false);
		text_Label_title.setEditable(false);
		text_Label_title.setText("");
		text_Label_title.setLayoutData(dataLabel);
		
		Font fonts = text_Label_title.getFont();
		FontData data = fonts.getFontData()[0];
		data.setStyle(SWT.BOLD);
		data.height = 10;
		fonts = new Font(parentCom.getDisplay(), data);
		text_Label_title.setFont(fonts);
		text_Label_title.setVisible(true);
    	
    	FormData dataLabelsoft = new FormData();
    	dataLabelsoft.top = new FormAttachment(composite,0);
    	dataLabelsoft.left = new FormAttachment(text_Label_title,0,0);
    	dataLabelsoft.right = new FormAttachment(100,-5);
    	label_soft = new Label(composite, SWT.RIGHT);
    	label_soft.setText("");
    	label_soft.setForeground(parentCom.getDisplay().getSystemColor(SWT.COLOR_RED));
    	label_soft.setLayoutData(dataLabelsoft);
    	label_soft.setFont(fonts);
    	label_soft.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				if(label_soft.getVisible() && LoadXmlCore.softData != null && !LoadXmlCore.softData.isEmpty()){
					GOTMessageDialog.showsoftView(LoadXmlCore.softData);
				}
			}
		});
    	
    	int buttom = -5;
    	text_op_info = new Label(parentCom,SWT.READ_ONLY );
		text_op_info.setForeground(parentCom.getDisplay().getSystemColor(SWT.COLOR_RED));
    	dataLabel = new FormData();
    	dataLabel.top = new FormAttachment(tree,0,SWT.BOTTOM);
    	dataLabel.left = new FormAttachment(0,5);
    	dataLabel.right = new FormAttachment(30,-10);
    	dataLabel.bottom = new FormAttachment(100, buttom);
    	text_op_info.setLayoutData(dataLabel);
    	
    	text_unsave_info = new Label(parentCom,SWT.READ_ONLY );
    	text_unsave_info.setText("");
    	text_unsave_info.setForeground(parentCom.getDisplay().getSystemColor(SWT.COLOR_RED));
    	dataLabel = new FormData();
//    	dataLabel.top = new FormAttachment(tree,0,SWT.BOTTOM);
    	dataLabel.left = new FormAttachment(text_op_info,0);
    	dataLabel.right = new FormAttachment(51,-10);
    	dataLabel.bottom = new FormAttachment(100, buttom);
    	text_unsave_info.setLayoutData(dataLabel);
    	
		text_static_info = new Label(parentCom,SWT.READ_ONLY );
		text_static_info.setText("");
		text_static_info.setForeground(parentCom.getDisplay().getSystemColor(SWT.COLOR_BLUE));
    	dataLabel = new FormData();
//    	dataLabel.top = new FormAttachment(tree,0,SWT.BOTTOM);
    	dataLabel.left = new FormAttachment(text_unsave_info,0,0);
    	dataLabel.right = new FormAttachment(85,-5);
    	dataLabel.bottom = new FormAttachment(100, buttom);
    	text_static_info.setLayoutData(dataLabel);
    	
    	text_op_info_version = new Label(parentCom, SWT.READ_ONLY | SWT.RIGHT );
    	text_op_info_version.setForeground(parentCom.getDisplay().getSystemColor(SWT.COLOR_BLUE));
    	text_op_info_version.setText(version);
    	dataLabel = new FormData();
//    	dataLabel.top = new FormAttachment(tree,0,SWT.BOTTOM);
    	dataLabel.left = new FormAttachment(text_static_info,0,0);
    	dataLabel.right = new FormAttachment(100,-5);
    	dataLabel.bottom = new FormAttachment(100, buttom);
    	text_op_info_version.setLayoutData(dataLabel);
	}
	
	public static void text_static_info(){
		text_static_info.setText("共有" + tableNum + "张表，" + fromNum + "画面，其中业务表" + tableBusNum + "张    当前选中" + selectNum + "节点");
	}
	
	public void init(){
		text_op_info.setText("");
		text_Label_title.setVisible(false);
		text_Label_title.setText("");
		text_static_info.setText("");
		text_unsave_info.setText("");
		tableNum = 0;
		fromNum = 0;
		tableBusNum = 0;
		selectNum = 0;
		table.removeAll();
		text_op_info_version.setText("");
		label_soft.setText("");
		label_soft.setVisible(false);
		tree.setData("Listener", "");
		LoadXmlCore.softData = new ArrayList<Map<String,Object>>();
		LoadXmlCore.softModel = false;
	}
	
	public void set_text_op_info(String text){
		text_op_info.setText(text);
		for (TreeUi treeUi : FormDataSyn.treeUis) {
			if(treeUi.getTree() != this.tree){
				if(treeUi.treeUiBean != null){
					treeUi.treeUiBean.text_op_info.setText(text);
				}
			}
		}
		if(!text.equals("")){
			Thread thread = new Thread(new Runnable() {
				@Override
				public void run() {
					try {
						Thread.sleep(5000);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							set_text_op_info("");
						}
					});
					
				}
			});
			thread.start();
		}

	}
	
	//添加按钮
	private void addButton(final Composite parent){
		topComposite = new Composite(parent, SWT.BORDER);
        FormData fd_group = new FormData();
        int h = DPIZOOM.multiply(new BigDecimal(30)).intValue();
        fd_group.bottom = new FormAttachment(0, h);
        fd_group.top = new FormAttachment(0, 0);
        fd_group.left = new FormAttachment(0, 5);
        fd_group.right = new FormAttachment(100, -5);
        topComposite.setLayoutData(fd_group);
        topComposite.setLayout(new FormLayout());
        
        initMenu(topComposite);
        
		button_restart = new Button(topComposite, SWT.FLAT);
		button_restart.setText("启动加载");
        FormData fd_tool = new FormData();
        fd_tool.left = new FormAttachment(topComposite, 0, 5);
        fd_tool.top = new FormAttachment(topComposite, 0, SWT.TOP);
        fd_tool.bottom = new FormAttachment(100,0);
        button_restart.setLayoutData(fd_tool);
        button_restart.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				if(!DesignerServer.status.equals("started")){
					text_Label_title.setText("GOT");
					configComposite.setVisible(false);
					button_restart.setEnabled(false);
					progressBar = new LoadXMLAndBulidTree(parent.getShell(), SWT.TITLE | SWT.BORDER);
					progressBar.open(tree, table);
					/*Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							progressBar = new LoadXMLAndBulidTree(parent.getShell(), SWT.TITLE | SWT.BORDER);
							progressBar.open(tree, table);
						}
					});*/
					button_restart.setText("重新加载");
				}else{
					MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
			                | SWT.YES | SWT.NO);
			        messagebox.setText("重新加载GOT");
			        messagebox.setMessage("确定重新加载GOT吗?") ;
			        int message = messagebox.open();
					if(message == SWT.YES){
						ConfigComposite.configComposite.init();
						FormDataSyn.stopGot();
						configComposite.setVisible(false);
						button_restart.setEnabled(false);
						Display.getDefault().asyncExec(new Runnable() {
							public void run() {
								progressBar = new LoadXMLAndBulidTree(parent.getShell(), SWT.TITLE | SWT.BORDER );
								progressBar.open(tree, table);
							}
						});
						buttonEnable(false);
					}
					
				}
				
			}
		});
        
        button_label = new Button(topComposite, SWT.CHECK );
        button_label.setText("显示标签");
        FormData fd_label = new FormData();
        fd_label.left = new FormAttachment(button_restart, 20);		
        fd_label.top = new FormAttachment(topComposite, 0, SWT.TOP);
        fd_label.bottom = new FormAttachment(100,0);
        button_label.setLayoutData(fd_label);
        button_label.setSelection(GOTUtil.button_label);
        button_label.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				GOTUtil.button_label = button_label.getSelection();
				if(FormDataSyn.treeUis.size() == 0){
					return ;
				}else{
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							List<TreeUi> uis = FormDataSyn.treeUis;
							for (TreeUi treeUi : uis) {
								int totle = treeUi.getTree().getBounds().width - 25;
								if(button_label.getSelection()){
									treeUi.getTree().getColumn(1).setWidth(125);
									treeUi.getTree().getColumn(0).setWidth(totle - 125);
								}else{
									treeUi.getTree().getColumn(1).setWidth(0);
									treeUi.getTree().getColumn(0).setWidth(totle);
								}
							}
						}
					});

				}
			}
		});
        
/*        button_text = new Button(group, SWT.CHECK );
        button_text.setText("当前层字体加粗");
        FormData fd_text = new FormData();
        fd_text.left = new FormAttachment(button_label, 10);		
        fd_text.bottom = new FormAttachment(0, 30);
        fd_text.top = new FormAttachment(0, 0);
        button_text.setLayoutData(fd_text);
        button_text.setSelection(GOTUtil.button_text);
        button_text.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				GOTUtil.button_text = button_text.getSelection();
				if(FormDataSyn.treeUis.size() == 0){
					return ;
				}else{
					FormDataSyn.showFonts();
				}
			}
        	
		});*/
        
        button_pre = new Button(topComposite, SWT.CHECK );
        button_pre.setText("显示应用前缀");
        FormData fd_pre = new FormData();
        fd_pre.left = new FormAttachment(button_label, 10);		
        fd_pre.top = new FormAttachment(topComposite, 0, SWT.TOP);
        fd_pre.bottom = new FormAttachment(100,0);
        button_pre.setLayoutData(fd_pre);
        button_pre.setSelection(GOTUtil.button_pre);
        button_pre.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				GOTUtil.button_pre = button_pre.getSelection();
/*				if(FormDataSyn.treeUis.size() == 0){
					return ;
				}else{
					FormDataSyn.showPrefix(button_pre.getSelection());
				}*/
			}
        	
		});
        
//        button_search = new Button(group, SWT.NONE);
//        button_search.setText("  搜索  ");
//        button_search.setBounds(400, 1, 60, 25);
//        button_search.addSelectionListener(new SelectionAdapter() {
//
//			@Override
//			public void widgetSelected(SelectionEvent e) {
//				if(FormDataSyn.treeUis.size() == 0){
//					return ;
//				}else{
//					String search = GOTMessageDialog.searchTreeItem();
//					if(search != null && !"".equals(search)){
//						FormDataSyn.treeUis.get(0).setSelect(search, false);
//					}
//				}
//			}
//		});
        
        button_order = new Button(topComposite, SWT.NONE);
        button_order.setText("  功能  ");
        FormData fd_order = new FormData();
        fd_order.left = new FormAttachment(button_pre, 10);
        fd_order.top = new FormAttachment(topComposite, 0, SWT.TOP);
        fd_order.bottom = new FormAttachment(100,0);
        button_order.setLayoutData(fd_order);
        button_order.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if(!menu.getVisible()){
					Rectangle rect = button_order.getBounds();
					Point pt = new Point(rect.x, rect.y + rect.height);
					pt = parent.toDisplay(pt);
					menu.setLocation(pt.x, pt.y);
					menu.setVisible(true);
				}else{
					menu.setVisible(false);
				}

			}
        	
		});
        
        button_layer = new Button(topComposite, SWT.NONE);
        button_layer.setText("切换编辑层");
        FormData fd_layer = new FormData();
        fd_layer.left = new FormAttachment(button_order, 10);
        fd_layer.top = new FormAttachment(topComposite, 0, SWT.TOP);
        fd_layer.bottom = new FormAttachment(100,0);
        button_layer.setLayoutData(fd_layer);
        button_layer.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				GOTMessageDialog.ChoseUser();
			}
        	
		});
        buttonEnable(false);
        
/*        Button button_resolver = new Button(group, SWT.NONE);
        button_resolver.setText("解析器 ");
        FormData fd_resolver = new FormData();
        fd_resolver.left = new FormAttachment(button_layer, 10);
        fd_resolver.top = new FormAttachment(group, 0, SWT.TOP);
        fd_resolver.bottom = new FormAttachment(100,0);
        button_resolver.setLayoutData(fd_resolver);
        button_resolver.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {

			}
		});*/
        
        layer_label = new Label(topComposite, SWT.RIGHT );
        FormData formData = new FormData();
        formData.left = new FormAttachment(80, 0);
        formData.right = new FormAttachment(100, -5);
        layer_label.setLayoutData(formData);
        layer_label.setForeground(topComposite.getDisplay().getSystemColor(SWT.COLOR_BLUE));
	}
	
	public void buttonEnable(boolean enabled){
		button_label.setEnabled(enabled);
//		button_text.setEnabled(enabled);
		button_pre.setEnabled(enabled);
		button_order.setEnabled(enabled);
		button_layer.setEnabled(enabled);
	}
	
	private void initMenu(final Composite parent){
		menu = new Menu(parent.getShell(), SWT.POP_UP);
		menu.setVisible(false);
		
		MenuItem menu_merge = new MenuItem(menu, SWT.CASCADE);
		menu_merge.setText("范式定义");
		menu_merge.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				if (mergeComposite != null && !mergeComposite.getVisible()) {
					mergeComposite.setVisible(true);
				}
			}
			
		});
		
		/***        分割                **/
		
    	MenuItem menu_log = new MenuItem(menu, SWT.CASCADE);
    	menu_log.setText("日志打印");
		
		Menu menu_log_menu = new Menu(menu_log);
		menu_log.setMenu(menu_log_menu);
		
		MenuItem log_RefGOTPrint = new MenuItem(menu_log_menu, SWT.NONE);
		log_RefGOTPrint.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.refGOTPrint();
			}
		});
		log_RefGOTPrint.setText("RefGOTPrint");
		
		/***        分割                **/
		
    	MenuItem menu_back = new MenuItem(menu, SWT.CASCADE);
    	menu_back.setText("后台操作");
		
		Menu menu_back_menu = new Menu(menu_back);
		menu_back.setMenu(menu_back_menu);
		
		MenuItem log_cleanTable = new MenuItem(menu_back_menu, SWT.NONE);
		log_cleanTable.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.cleanSplithTable();
			}
		});
		log_cleanTable.setText("清理多余表");
		
		MenuItem log_cleanField = new MenuItem(menu_back_menu, SWT.NONE);
		log_cleanField.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.cleanFieldAndIndex();
			}
		});
		log_cleanField.setText("清理多余字段索引");
		
		MenuItem log_dim = new MenuItem(menu_back_menu, SWT.NONE);
		log_dim.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.modifyDim();
			}
		});
		log_dim.setText("修改DIM");
		
		/***        分割                **/
		
/*    	MenuItem menu_GOT = new MenuItem(menu, SWT.CASCADE);
    	menu_GOT.setText("GOT协同");
		
		Menu menu_GOT_menu = new Menu(menu_GOT);
		menu_GOT.setMenu(menu_GOT_menu);
		
		MenuItem log_dealAllTable = new MenuItem(menu_GOT_menu, SWT.NONE);
		log_dealAllTable.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.checkAllTable();
			}
		});
		log_dealAllTable.setText("处理所有Table变更");
		
		MenuItem log_dealSelectTable = new MenuItem(menu_GOT_menu, SWT.NONE);
		log_dealSelectTable.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.checkSelectTable();
			}
		});
		log_dealSelectTable.setText("处理选中Table变更");
		
		MenuItem log_saveChangeForm = new MenuItem(menu_GOT_menu, SWT.NONE);
		log_saveChangeForm.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.saveModifiedForm();
			}
		});
		log_saveChangeForm.setText("保存变更的Form");
		
		MenuItem log_check = new MenuItem(menu_GOT_menu, SWT.NONE);
		log_check.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.checkFormDataSourceFieldRate();
			}
		});
		log_check.setText("检查FormDataSourceField利用率");*/
		
		/***        分割                **/
		
    	/*MenuItem menu_layer = new MenuItem(menu, SWT.CASCADE);
    	menu_layer.setText("层控制");
		
		Menu menu_layer_menu = new Menu(menu_layer);
		menu_layer.setMenu(menu_layer_menu);
		
		MenuItem log_cellGet = new MenuItem(menu_layer_menu, SWT.NONE);
		log_cellGet.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.getCurrentLayer();
			}
		});
		log_cellGet.setText("获得层");
		
		MenuItem log_cellCreate = new MenuItem(menu_layer_menu, SWT.NONE);
		log_cellCreate.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.createLayer();
			}
		});
		log_cellCreate.setText("创建层");
		
		MenuItem log_cellDistory = new MenuItem(menu_layer_menu, SWT.NONE);
		log_cellDistory.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.recycleLayer();
			}
		});
		log_cellDistory.setText("销毁层");
		
		MenuItem log_cellPickup = new MenuItem(menu_layer_menu, SWT.NONE);
		log_cellPickup.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.packLayer();
			}
		});
		log_cellPickup.setText("打包层");
		
		*//***        分割                **//*
		
    	MenuItem menu_soultion = new MenuItem(menu, SWT.CASCADE);
    	menu_soultion.setText("解决方案");
		
		Menu menu_soultion_menu = new Menu(menu_soultion);
		menu_soultion.setMenu(menu_soultion_menu);
		
		MenuItem soultion_createSolution = new MenuItem(menu_soultion_menu, SWT.NONE);
		soultion_createSolution.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.createSolution();
			}
		});
		soultion_createSolution.setText("创建方案");
		
		MenuItem soultion_packSolution = new MenuItem(menu_soultion_menu, SWT.NONE);
		soultion_packSolution.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.packSolution();
			}
		});
		soultion_packSolution.setText("打包方案");
		
		MenuItem soultion_createSolutionExtension = new MenuItem(menu_soultion_menu, SWT.NONE);
		soultion_createSolutionExtension.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.createSolutionExtension();
			}
		});
		soultion_createSolutionExtension.setText("创建方案扩展包");
		
		MenuItem soultion_packSolutionExtension = new MenuItem(menu_soultion_menu, SWT.NONE);
		soultion_packSolutionExtension.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.packSolutionExtension();
			}
		});
		soultion_packSolutionExtension.setText("打包方案扩展包");
		
		*//***        分割                **//*
		
    	MenuItem menu_model = new MenuItem(menu, SWT.CASCADE);
    	menu_model.setText("模块插拔");
		
		Menu menu_model_menu = new Menu(menu_model);
		menu_model.setMenu(menu_model_menu);
		
		MenuItem soultion_modelInput = new MenuItem(menu_model_menu, SWT.NONE);
		soultion_modelInput.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.moduleImport();
			}
		});
		soultion_modelInput.setText("模块导入");
		
		MenuItem soultion_modelOutput = new MenuItem(menu_model_menu, SWT.NONE);
		soultion_modelOutput.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.moduleExport();
			}
		});
		soultion_modelOutput.setText("模块导出");
		
		MenuItem soultion_modelDelete = new MenuItem(menu_model_menu, SWT.NONE);
		soultion_modelDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.moduleDelete();
			}
		});
		soultion_modelDelete.setText("模块删除");*/
		
		/***        分割                **/
		
    	MenuItem menu_other = new MenuItem(menu, SWT.CASCADE);
    	menu_other.setText("其他");
		
		Menu menu_other_menu = new Menu(menu_other);
		menu_other.setMenu(menu_other_menu);
		
		MenuItem soultion_otherReset = new MenuItem(menu_other_menu, SWT.NONE);
		soultion_otherReset.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.resetEnum();
			}
		});
		soultion_otherReset.setText("重置选中Enum中EnumItem的值");
		
		MenuItem soultion_otherField = new MenuItem(menu_other_menu, SWT.NONE);
		soultion_otherField.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.synchronizeColumnOrder();
			}
		});
		soultion_otherField.setText("同步字段顺序");
		
		MenuItem soultion_jxq = new MenuItem(menu_other_menu, SWT.NONE);
		soultion_jxq.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Shell shell = new Shell(GOTMessageDialog.shell, SWT.SHELL_TRIM | SWT.BORDER );
				shell.setSize(1600, 900);
				shell.setText("解析器");
		        Monitor monitor = shell.getMonitor();
		        Rectangle bounds = monitor.getBounds();
		        Rectangle rect = shell.getBounds();
		        int x = bounds.x + (bounds.width - rect.width) / 2;  
		        int y = bounds.y + (bounds.height - rect.height) / 2;  
		        shell.setLocation (x, y);
		        shell.setLayout(new FormLayout());
	        	StartUpResolver cc = new StartUpResolver(shell, SWT.BORDER);
	        	cc.layout();
	        	shell.open();
			}
		});
		soultion_jxq.setText("解析器");
	}
	
	public void loadGot(){
		MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
                | SWT.YES | SWT.NO);
        messagebox.setText("重新加载GOT");
        messagebox.setMessage("确定重新加载GOT吗?") ;
        int message = messagebox.open();
		if(message == SWT.YES){
			ConfigComposite.configComposite.init();
			FormDataSyn.stopGot();
			configComposite.setVisible(false);
			button_restart.setEnabled(false);
			Display.getDefault().asyncExec(new Runnable() {
				public void run() {
					progressBar = new LoadXMLAndBulidTree(GOTMessageDialog.shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE);
					progressBar.open(tree, table);
					button_restart.setEnabled(true);
				}
			});
			
			buttonEnable(false);
		}
		
	}
	
//	Map<String, Integer> unsavedMap = new HashMap<>();
	
	public void setUnsavedText(){
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				String text = GotXmlDto.getInstance().getUnsaveText();
				text_unsave_info.setText(text);
			}
		});
	}
	
//	public void initMenuLayer(){
//		LayerService layerService = ObjectContainer.getInstance(LayerService.class);
//		List<Map<String, String>> maps = layerService.getLayerList();
//		for (final Map<String, String> map : maps) {
//			String LayerName = map.get("LayerName");
//			String DeploymentMode = map.get("DeploymentMode");
//			if(LayerName.equals(LayerConstants.SOLUTION_LAYER)){
//		    	MenuItem menu_other = new MenuItem(menu_layer, SWT.CASCADE);
//		    	menu_other.setText(LayerConstants.SOLUTION_LAYER);
//				Menu menu_other_menu = new Menu(menu_other);
//				menu_other.setMenu(menu_other_menu);
//				List<Map<String, String>> maps_solution = layerService.getSolutionList();
//				for (Map<String, String> mapSolution : maps_solution) {
//					String SolutionName = mapSolution.get("mapSolution");
//					String DeploymentMode_ = mapSolution.get("DeploymentMode");
//					addMenuItem(menu_other_menu, munuText(SolutionName, DeploymentMode_), LayerName, SolutionName, isBinary(DeploymentMode));
//				}
//			}else if(LayerName.equals(LayerConstants.SOLUTION_EXTENSION_LAYER)){
//		    	MenuItem menu_other = new MenuItem(menu_layer, SWT.CASCADE);
//		    	menu_other.setText(LayerConstants.SOLUTION_EXTENSION_LAYER);
//				Menu menu_other_menu = new Menu(menu_other);
//				menu_other.setMenu(menu_other_menu);
//				List<Map<String, String>> maps_solution = layerService.getExtensionList();
//				for (Map<String, String> mapSolution : maps_solution) {
//					String SolutionName = mapSolution.get("mapSolution");
//					String DeploymentMode_ = mapSolution.get("DeploymentMode");
//					addMenuItem(menu_other_menu, munuText(SolutionName, DeploymentMode_), LayerName, SolutionName, isBinary(DeploymentMode));
//				}
//				
//			} else{
//				addMenuItem(menu_layer, munuText(LayerName, DeploymentMode), LayerName, null, isBinary(DeploymentMode));
//			}
//
//		}
//		
//	}
	
//	private void addMenuItem(Menu meunTemp, String text, final String layerName, final String SolutionName, final boolean isBinary){
//		MenuItem menu_item = new MenuItem(meunTemp, SWT.NONE);
//		menu_item.addSelectionListener(new SelectionAdapter() {
//			@Override
//			public void widgetSelected(SelectionEvent e) {
//				menuLayerSelectMethod(layerName, SolutionName, isBinary);
//			}
//		});
//		menu_item.setText(text);
//	}
//	
//	private boolean isBinary(String DeploymentMode){
//		if(DeploymentMode.equals("Package")){
//			return true;
//		}else{
//			return false;
//		}
//	}
//	
//	private String munuText(String text, String DeploymentMode){
//		if(DeploymentMode.equals("Package")){
//			text += "（二进制）";
//		}else if(DeploymentMode.equals("Source")){
//			text += "（源码）";
//		}
//		return text;
//	} 
//	
//	private void menuLayerSelectMethod(String layerName, String SolutionName, boolean isBinary){
//		System.out.println(layerName);
//		System.out.println(SolutionName);
//		System.out.println(isBinary);
//	}
	private int X_1920 = 1920;
//	private int Y_1080 = 1080;
	private void setDpi(){
		int screenWidth = java.awt.Toolkit.getDefaultToolkit().getScreenSize().width;
//		int screenHeight = java.awt.Toolkit.getDefaultToolkit().getScreenSize().height;
		if(screenWidth > 1920){
			DPIZOOM = DPIZOOM.multiply(new BigDecimal(screenWidth/X_1920));
		}
//		System.out.println(screenWidth + "--" + screenHeight);
		
	}
	
	public Button service_Tipst, service_doMatching, service_doOrderByTips, service_doOrderBy, service_doCheckProperty, service_doCheckAttr, service_doSaveAll;
	
	public void mergeButton(){
		mergeComposite = new Composite(topComposite, SWT.NONE);
		mergeComposite.setLayout(new FormLayout());
		FormData formData = new FormData();
		formData.top = new FormAttachment(0);
		formData.left = new FormAttachment(button_layer,20, SWT.RIGHT);
		formData.bottom = new FormAttachment(100);
		mergeComposite.setLayoutData(formData);
		mergeComposite.setVisible(false);
		
    	FormData com = new FormData();
    	com.left = new FormAttachment(0,5);
    	com.bottom = new FormAttachment(100, 0);
		service_Tipst = new Button(mergeComposite, SWT.NONE);
		service_Tipst.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doMatchingTips(service_Tipst);
			}
		});
		service_Tipst.setText("匹配提示");
		service_Tipst.setLayoutData(com);
		
		com = new FormData();
    	com.left = new FormAttachment(service_Tipst, 10);
    	com.bottom = new FormAttachment(100, 0);
		service_doMatching = new Button(mergeComposite, SWT.NONE);
		service_doMatching.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doMatching(service_doMatching);
			}
		});
		service_doMatching.setText("匹配");
		service_doMatching.setLayoutData(com);
		
		service_doOrderByTips = new Button(mergeComposite, SWT.NONE);
		service_doOrderByTips.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doOrderByTips(service_doOrderByTips);
			}
		});
		service_doOrderByTips.setText("顺序提示");
		com = new FormData();
    	com.left = new FormAttachment(service_doMatching, 10);
    	com.bottom = new FormAttachment(100, 0);
    	service_doOrderByTips.setLayoutData(com);
    	
		service_doOrderBy = new Button(mergeComposite, SWT.NONE);
		service_doOrderBy.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doOrderBy(service_doOrderBy);
			}
		});
		service_doOrderBy.setText("顺序调整");
		com = new FormData();
    	com.left = new FormAttachment(service_doOrderByTips, 10);
    	com.bottom = new FormAttachment(100, 0);
    	service_doOrderBy.setLayoutData(com);
    	
		service_doCheckProperty = new Button(mergeComposite, SWT.NONE);
		service_doCheckProperty.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doCheckProperty(service_doCheckProperty);
			}
		});
		service_doCheckProperty.setText("验证Property");
		com = new FormData();
    	com.left = new FormAttachment(service_doOrderBy, 10);
    	com.bottom = new FormAttachment(100, 0);
    	service_doCheckProperty.setLayoutData(com);
    	
		service_doCheckAttr = new Button(mergeComposite, SWT.NONE);
		service_doCheckAttr.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doCheckAttr(service_doCheckAttr);
			}
		});
		service_doCheckAttr.setText("验证Attribute");
		com = new FormData();
    	com.left = new FormAttachment(service_doCheckProperty, 10);
    	com.bottom = new FormAttachment(100, 0);
    	service_doCheckAttr.setLayoutData(com);
    	
		service_doSaveAll = new Button(mergeComposite, SWT.NONE);
		service_doSaveAll.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DoMerge.doSaveAll();
			}
		});
		service_doSaveAll.setText("保存所有");
		com = new FormData();
    	com.left = new FormAttachment(service_doCheckAttr, 10);
    	com.bottom = new FormAttachment(100, 0);
    	service_doSaveAll.setLayoutData(com);
	}
	
//	public void setButtonColor(int color){
//		service_Tipst.setBackground(Display.getDefault().getSystemColor(color));
//		, service_doMatching, service_doOrderByTips, service_doOrderBy, service_doCheckProperty, service_doCheckAttr, service_doSaveAll
//	}
}
