package info.gongqi.got.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ConsoleViewerOp extends TextViewer implements IDocumentListener {

	private int maxLines = 500;
	
	public static ConsoleViewerOp consoleViewerOp;
	
	private Composite parentComposite;
	
	private Color selectColor;
	
	private StyleRange[] ranges = new StyleRange[1];
	
	private StyledText styledText;
	
	private Color red = new Color(null,255,0,0);
	
	public static synchronized ConsoleViewerOp getInstance(Composite parent){
		if(consoleViewerOp == null){
			consoleViewerOp = new ConsoleViewerOp(parent);
			consoleViewerOp.parentComposite = parent;
		}
		return consoleViewerOp;
	}
	
	public void addText(String text, boolean error){
		try {
			IDocument document = consoleViewerOp.getDocument();
			if(document != null){
				document.replace(document.getLength(), 0, text);
				checkOverflow();
				int start = styledText.getText().length();
				if(error){
					ranges[0] = new StyleRange(start- text.length(), text.length(), red, null);
					styledText.replaceStyleRanges(0, text.length(), ranges);
				}
				Thread.sleep(50);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void checkOverflow(){
		if (maxLines <= 0) {
			return;
		}
		IDocument document = ConsoleViewerOp.this.getDocument();
		int numberOfLines = document.getNumberOfLines();
		if (numberOfLines > maxLines + 1) {
			try {
				int overflow = document.getLineOffset(numberOfLines - maxLines);
				document.replace(0, overflow, "");
			} catch (BadLocationException e) {
				e.printStackTrace();
			}
			
		}
	}
	
	private ConsoleViewerOp(Composite parent) {
		super(parent, SWT.V_SCROLL | SWT.WRAP );
		this.initialization(parent);
	}
	
	private void initialization(Composite parent){
//		TabFolder tabFolder = new TabFolder(parent, SWT.NONE);
    	FormData data2 = new FormData();
    	data2.top = new FormAttachment(0, 2);
    	data2.bottom = new FormAttachment(100, -2);
    	data2.left = new FormAttachment(0, 2);
    	data2.right = new FormAttachment(100, -2);
//    	tabFolder.setLayoutData(data2);
//		TabItem info = new TabItem(tabFolder, SWT.NONE);
//		info.setText("操作信息");
//		TabItem model = new TabItem(tabFolder, SWT.NONE);
//		model.setText("安全模式");
		
		styledText = this.getTextWidget();
		styledText.setLayout(new FormLayout());
		styledText.setParent(parent);

    	styledText.setLayoutData(data2);
		styledText.setAlwaysShowScrollBars(false);
		Font font = new Font(null, "微软雅黑", 10, SWT.NORMAL);
//		styledText.setForeground(new Color(null,0,0,255));
//		styledText.setSelectionForeground(new Color(null,255,0,0));
		styledText.setFont(font);
		styledText.setEditable(false);
		styledText.setWordWrap(true);
		styledText.setVisible(true);
		Document document = new Document();
		document.addDocumentListener(this);
		this.setDocument(document);
		
		styledText.addMouseListener(new MouseAdapter() {
			public void mouseDown(MouseEvent e) {
				if (e.button == 3) {
					Menu menu = new Menu(styledText);
					styledText.setMenu(menu);
					MenuItem item = new MenuItem(menu, SWT.PUSH);
					item.setText("清空");
					item.addSelectionListener(new SelectionAdapter() {
			            public void widgetSelected(SelectionEvent event) {
			            	cleanText();
			            }
			        });
					
					MenuItem itemBack = new MenuItem(menu, SWT.PUSH);
					itemBack.setText("选择文字颜色");
					itemBack.addSelectionListener(new SelectionAdapter() {
			            public void widgetSelected(SelectionEvent event) {
							ColorDialog colorDialog = new ColorDialog(parentComposite.getShell());
							final RGB rgb = colorDialog.open();
							Display.getDefault().asyncExec(new Runnable() {
								@Override
								public void run() {
									selectColor = new Color(parentComposite.getShell().getDisplay(), rgb);
									styledText.setForeground(selectColor);
								}
							});
			            }
			        });
					
					MenuItem itemBackGround = new MenuItem(menu, SWT.PUSH);
					itemBackGround.setText("选择背景颜色");
					itemBackGround.addSelectionListener(new SelectionAdapter() {
			            public void widgetSelected(SelectionEvent event) {
							ColorDialog colorDialog = new ColorDialog(parentComposite.getShell());
							final RGB rgb = colorDialog.open();
							Display.getDefault().asyncExec(new Runnable() {
								@Override
								public void run() {
									styledText.setBackground(new Color(parentComposite.getShell().getDisplay(), rgb));
								}
							});
			            }
			        });
					
				}

			}
			
		});
//		info.setControl(styledText);
	}

	@Override
	public void documentAboutToBeChanged(DocumentEvent event) {
		
	}

	@Override
	public void documentChanged(final DocumentEvent event) {
		Display.getDefault().asyncExec(new Runnable() {
			
			@Override
			public void run() {
				try {
					StyledText styledText = ConsoleViewerOp.this.getTextWidget();
					IDocument document = ConsoleViewerOp.this.getDocument();
					if(document != null){
						int numberOfLines = document.getNumberOfLines();
						int lineStartOffset = document.getLineOffset(numberOfLines-1);
						int lineEndOffset = lineStartOffset + document.getLineLength(numberOfLines-1);
						if (lineEndOffset > 0) {
							styledText.setCaretOffset(lineEndOffset);
							styledText.showSelection();
						}
					}
				} catch (BadLocationException e) {
				}
			}
		});
	}
	
	public void cleanText(){
		IDocument document = ConsoleViewerOp.this.getDocument();
		int numberOfLines = document.getNumberOfLines();
		try {
			int overflow = document.getLineOffset(numberOfLines - 1);
			document.replace(0, overflow, "");
		} catch (BadLocationException e) {
		}
	}
}
