package info.gongqi.got.ui;

import gongqi.designer.core.DesignerServer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MainFormGOT {

	protected Shell shell;
	
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			MainFormGOT window = new MainFormGOT();
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
                                                                                 
	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		createContents();
		shell.open();
		shell.layout();
		while (!shell.isDisposed()) {
			if (!display.isDisposed() && !display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the window.123 
	 */
	protected void createContents() {
		shell = new Shell(SWT.SHELL_TRIM | SWT.BORDER );
		shell.setSize(1600, 900);
		shell.setText("GOT");

        Monitor monitor = shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        shell.setLayout(new FormLayout());
        try {
        	ConfigComposite cc = new ConfigComposite(shell, SWT.BORDER);
        	cc.layout();
        	
//        	StartUpResolver resolver = new StartUpResolver(shell, SWT.BORDER);
//        	resolver.layout();
        	
//        	DisplayStyleDialog dialog = new DisplayStyleDialog(shell, SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE);
//        	dialog.open();
//        	GotLayerAndUserDialog andUserDialog = new GotLayerAndUserDialog(shell, SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE);
//        	andUserDialog.open();
        			
		} catch (Exception e1) {
			e1.printStackTrace();
		}
//        cc.init();
//        new ConsoleViewer(shell);
		shell.addShellListener(new ShellAdapter() {
            public void shellClosed(ShellEvent e) {
				if(DesignerServer.status.equals("started")){
					DesignerServer.stop();
				}
            	
            }
		});
		
		shell.addListener(SWT.Move, new Listener() {
			
			@Override
			public void handleEvent(Event arg0) {
				arg0.doit = false;
				return;
			}
		});
		
	}
	
}
