package info.gongqi.got.ui;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ResolverEdit {

	public Table table1;
	
	public Table table2;
	

	public ResolverEdit(Table table1, Table table2, Table table) {
		super();
		this.table1 = table1;
		this.table2 = table2;
//		this.table = table;
	}
	
	public void mouseDoubleClickEvent(){
/*		this.table.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseDoubleClick(MouseEvent e) {
				int count = table.getSelectionCount();
				if(count != 0 ){
					final TableItem item = table.getItem(table.getSelectionIndex());
					//获取鼠标点击的位置
					Point point = new Point(e.x, e.y);
					//鼠标点击所在cell的列
					int tmpCol = 0;
					//获取所点击的cell
					for(int i = 0; i < table.getColumnCount(); i++){
						Rectangle rect = item.getBounds(i);
						if (rect.contains(point)) {
							tmpCol = i;
							break;
						}
					}
					int selectCol = tmpCol;
					//第三列和第四列不能编辑
					if(selectCol == 3 || selectCol == 4){
						textEdit(table, item, selectCol);
						return;
					}
					
					if(selectCol == 7){
						List<String> array = new ArrayList<String>();
						array.add("");
						Element element = (Element) item.getData("Info");
						List<Element> elements = element.getParent().selectNodes("//node");
						for (Element node : elements) {
							String str = node.element("Info").elementText("NodeType");
							if(str != null && !"Abstract".equals(node.attributeValue("name")) && str.equals("abstract")){
								array.add(node.attributeValue("name"));
							}
						}
						String[] comItem = array.toArray(new String[array.size()]);
						comboEdit(comItem, table, item, selectCol);
					}else if(selectCol > 7){
						comboEdit((String[])combox_table[8], table, item, selectCol);
					}else{
						comboEdit((String[])combox_table[selectCol], table, item, selectCol);
					}
					
				}
			}
			
		});*/
		
		this.table1.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseDoubleClick(MouseEvent e) {
				int count = table1.getSelectionCount();
				if(count != 0 ){
					final TableItem item = table1.getItem(table1.getSelectionIndex());
					//获取鼠标点击的位置
					Point point = new Point(e.x, e.y);
					//鼠标点击所在cell的列
					int tmpCol = 0;
					//获取所点击的cell
					for(int i = 0; i < table1.getColumnCount(); i++){
						Rectangle rect = item.getBounds(i);
						if (rect.contains(point)) {
							tmpCol = i;
							break;
						}
					}
					int selectCol = tmpCol;
					//第三列和第四列不能编辑
					if(selectCol == 0 || selectCol == 4 || selectCol == 7 || selectCol == 5){
						textEdit(table1, item, selectCol);
						return;
					}
					
					if(selectCol == 1){
						comboEdit(new String[]{"", "string", "boolean", "enum", "comboBox", "Integer", 
								"positiveInteger", "negativeInteger", "nonPositiveInteger", "nonNegativeInteger"}, table1, item, selectCol);
					}else if(selectCol == 2){
						comboEdit(new String[]{"", "none", "brother", "outer", "inner"}, table1, item, selectCol);
					}else if(selectCol == 3){
						comboEdit(new String[]{"", "true", "false", "ifExtends", "fetch"}, table1, item, selectCol);
					}else if(selectCol == 6){
						comboEdit(new String[]{"", "required", "optional"}, table1, item, selectCol);
					}
				}
			}
			
		});
		
		this.table2.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseDoubleClick(MouseEvent e) {
				int count = table2.getSelectionCount();
				if(count != 0 ){
					final TableItem item = table2.getItem(table2.getSelectionIndex());
					//获取鼠标点击的位置
					Point point = new Point(e.x, e.y);
					//鼠标点击所在cell的列
					int tmpCol = 0;
					//获取所点击的cell
					for(int i = 0; i < table2.getColumnCount(); i++){
						Rectangle rect = item.getBounds(i);
						if (rect.contains(point)) {
							tmpCol = i;
							break;
						}
					}
					int selectCol = tmpCol;
					//第三列和第四列不能编辑
					if(selectCol == 0 || selectCol == 4 || selectCol == 6 || selectCol == 5 || selectCol == 7){
						textEdit(table2, item, selectCol);
						return;
					}
					
					if(selectCol == 1){
						comboEdit(new String[]{"", "string", "boolean", "enum", "comboBox", "Integer", 
								"positiveInteger", "negativeInteger", "nonPositiveInteger", "nonNegativeInteger"}, table2, item, selectCol);
					}else if(selectCol == 2){
						comboEdit(new String[]{"", "none", "brother", "outer", "inner"}, table2, item, selectCol);
					}else if(selectCol == 3){
						comboEdit(new String[]{"", "true", "false", "ifExtends", "fetch"}, table2, item, selectCol);
					}
				}
			}
			
		});
	}
	
	private void comboEdit(String[] comItem, final Table tarTable, final TableItem item, final int selectCol){
		final TableEditor editor = new TableEditor(tarTable); 
		Control oldEditor = editor.getEditor();
		if (oldEditor != null){
			oldEditor.dispose();
		}
		final String allComItemStr = StringUtils.join(comItem);
		final Combo comOptionValue = new Combo(tarTable, SWT.BORDER);
		comOptionValue.setFont(tarTable.getFont());
		comOptionValue.setItems(comItem);
		comOptionValue.computeSize(SWT.DEFAULT, tarTable.getItemHeight());
		editor.grabHorizontal = true;
		editor.minimumHeight = comOptionValue.getSize().y - 2;
		editor.minimumWidth = comOptionValue.getSize().x;
		editor.setEditor(comOptionValue, item, selectCol);
		comOptionValue.setText(item.getText(selectCol));
		comOptionValue.forceFocus();
		comOptionValue.setListVisible(true);
		comOptionValue.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(!comOptionValue.getListVisible()){
					Control defaultEditor = editor.getEditor();
					editor.setEditor(defaultEditor, item, selectCol);
					if(comOptionValue.getText().equals(item.getText(selectCol)) || !allComItemStr.contains(comOptionValue.getText())){
						item.setText(selectCol, item.getText(selectCol));
					}else{
						String newStr = comOptionValue.getText();
						item.setText(selectCol, newStr);
						Element data = null;
						if(tarTable.getColumns().length > 8){
							if(selectCol > 7){
								data = (Element) item.getData("ContextMenu");
							}else{
								data = (Element) item.getData("Info");
							}
						}else{
							data = (Element) item.getData();
						}
						
						if(data.getName().equals("Info")){
							switch (selectCol) {
							case 0:
								data.element("NodeType").setText(newStr);
								break;
							case 1:
								data.element("MinOccurs").setText(newStr);
								break;
							case 2:
								data.element("MaxOccurs").setText(newStr);
								break;
							case 3:
								data.element("Icon").setText(newStr);
								break;
							case 4:
								data.element("Type").setText(newStr);
								break;
							case 5:
								data.element("InsertAt").setText(newStr);
								break;
							case 6:
								data.element("Editable").setText(newStr);
								break;
							case 7:
								data.element("Extends").setText(newStr);
								break;
							default:
								break;
							}
						}else if(data.getName().equals("ContextMenu")){
							switch (selectCol) {
							case 0:
								data.element("New").setText(newStr);
								break;
							case 1:
								data.element("Save").setText(newStr);
								break;
							case 2:
								data.element("Delete").setText(newStr);
								break;
							case 3:
								data.element("Sync").setText(newStr);
								break;
							case 4:
								data.element("Restore").setText(newStr);
								break;
							case 5:
								data.element("Duplicate").setText(newStr);
								break;
							case 6:
								data.element("NewWindow").setText(newStr);
								break;
							case 7:
								data.element("ShowXML").setText(newStr);
								break;
							default:
								break;
							}
						}else if(data.getName().equals("Attribute")){
							switch (selectCol) {
							case 0:
								data.element("Name").setText(newStr);
								break;
							case 1:
								data.element("Type").setText(newStr);
								break;
							case 2:
								data.element("Unique").setText(newStr);
								break;
							case 3:
								data.element("Nonblank").setText(newStr);
								break;
							case 4:
								data.element("Default").setText(newStr);
								break;
							case 5:
								data.element("Regular").setText(newStr);
								break;
							case 6:
								data.element("Use").setText(newStr);
								break;
							case 7:
								data.element("Remark").setText(newStr);
								break;
							default:
								break;
							}
						}else if(data.getName().equals("Property")){
							switch (selectCol) {
							case 0:
								data.element("Name").setText(newStr);
								break;
							case 1:
								data.element("Type").setText(newStr);
								break;
							case 2:
								data.element("Unique").setText(newStr);
								break;
							case 3:
								data.element("Nonblank").setText(newStr);
								break;
							case 4:
								data.element("Default").setText(newStr);
								break;
							case 5:
								data.element("Regular").setText(newStr);
								break;
							case 6:
								data.element("Trigger").setText(newStr);
								break;
							case 7:
								data.element("Remark").setText(newStr);
								break;
							default:
								break;
							}
						}
						
						comOptionValue.dispose();
					}
				}
			}
		});
		
		comOptionValue.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent focusevent) {
				comOptionValue.dispose();
			}

			@Override
			public void focusGained(FocusEvent e) {
				comOptionValue.setListVisible(true);
			}
			
		});	
	}
	
	public void textEdit(final Table tarTable, final TableItem item, final int selectCol){
		final TableEditor editor = new TableEditor(tarTable); 
		Control oldEditor = editor.getEditor();
		if (oldEditor != null){
			oldEditor.dispose();
		}
		final Text changeItemText = new Text(tarTable, SWT.NONE);
		changeItemText.computeSize(SWT.DEFAULT, tarTable.getItemHeight());
		editor.grabHorizontal = true;
		editor.minimumHeight = changeItemText.getSize().y;
		editor.minimumWidth = changeItemText.getSize().x;
		editor.setEditor(changeItemText, item, selectCol);
		String labelText = item.getText(selectCol);
		changeItemText.setFont(item.getFont());
		changeItemText.setText(labelText);
		changeItemText.forceFocus();
		changeItemText.selectAll();
		
		//编辑后变回表格样式
		changeItemText.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent focusevent) {
				Control defaultEditor = editor.getEditor();
				editor.setEditor(defaultEditor, item, selectCol);
				String cT = changeItemText.getText();
				String iT = item.getText(selectCol);
				if(cT.equals(iT) || ("【" + cT+ "】").equals(iT)){
					item.setText(selectCol, item.getText(selectCol));
				}else{
					String newStr = changeItemText.getText();
					item.setText(selectCol, newStr);
					
					Element data = null;
					if(tarTable.getColumns().length > 8){
						if(selectCol > 7){
							data = (Element) item.getData("ContextMenu");
						}else{
							data = (Element) item.getData("Info");
						}
					}else{
						data = (Element) item.getData();
					}
					
					if(data.getName().equals("Info")){
						switch (selectCol) {
						case 0:
							data.element("NodeType").setText(newStr);
							break;
						case 1:
							data.element("MinOccurs").setText(newStr);
							break;
						case 2:
							data.element("MaxOccurs").setText(newStr);
							break;
						case 3:
							data.element("Icon").setText(newStr);
							break;
						case 4:
							data.element("Type").setText(newStr);
							break;
						case 5:
							data.element("InsertAt").setText(newStr);
							break;
						case 6:
							data.element("Editable").setText(newStr);
							break;
						case 7:
							data.element("Extends").setText(newStr);
							break;
						default:
							break;
						}
					}else if(data.getName().equals("ContextMenu")){
						switch (selectCol) {
						case 0:
							data.element("New").setText(newStr);
							break;
						case 1:
							data.element("Save").setText(newStr);
							break;
						case 2:
							data.element("Delete").setText(newStr);
							break;
						case 3:
							data.element("Sync").setText(newStr);
							break;
						case 4:
							data.element("Restore").setText(newStr);
							break;
						case 5:
							data.element("Duplicate").setText(newStr);
							break;
						case 6:
							data.element("NewWindow").setText(newStr);
							break;
						case 7:
							data.element("ShowXML").setText(newStr);
							break;
						default:
							break;
						}
					}else if(data.getName().equals("Attribute")){
						switch (selectCol) {
						case 0:
							data.element("Name").setText(newStr);
							break;
						case 1:
							data.element("Type").setText(newStr);
							break;
						case 2:
							data.element("Unique").setText(newStr);
							break;
						case 3:
							data.element("Nonblank").setText(newStr);
							break;
						case 4:
							data.element("Default").setText(newStr);
							break;
						case 5:
							data.element("Regular").setText(newStr);
							break;
						case 6:
							data.element("Use").setText(newStr);
							break;
						case 7:
							data.element("Remark").setText(newStr);
							break;
						default:
							break;
						}
					}else if(data.getName().equals("Property")){
						switch (selectCol) {
						case 0:
							data.element("Name").setText(newStr);
							break;
						case 1:
							data.element("Type").setText(newStr);
							break;
						case 2:
							data.element("Unique").setText(newStr);
							break;
						case 3:
							data.element("Nonblank").setText(newStr);
							break;
						case 4:
							data.element("Default").setText(newStr);
							break;
						case 5:
							data.element("Regular").setText(newStr);
							break;
						case 6:
							if(data.element("Trigger") != null){
								data.element("Trigger").setText(newStr);
							}else{
								data.addElement("Trigger").setText(newStr);
							}
							break;
						case 7:
							data.element("Remark").setText(newStr);
							break;
						default:
							break;
						}
					}
				}
				changeItemText.dispose();
			}
			
		});
		
	}
	
}
