package info.gongqi.got.ui;

import gongqi.erp.framework.tools.io.FileIO;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.toolsgot.GOTXMLHelper;
import core.util.Dom4jUtil;

public class StartUpResolver extends Composite {
	// 主窗口table
	public Table table1;

	public Table table2;

	// public Table table;

	// 主窗口树
	public Tree tree;

	private boolean onMouseModfied;

	private Point lastPos;

	private Label coolBar;

	public Label layer_label;

	private BigDecimal DPI;

	public BigDecimal DPIZOOM;

	public Element element;

	public boolean allowAdvanceModify = false;

	public String xmlPath;

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */
	public StartUpResolver(final Composite parent, int style) {
		super(parent, style);
		this.setLayout(new FormLayout());
		// Windows系统默认是96dpi，Apple系统默认是72dpi。
		Point dpi = Display.getDefault().getDPI();
		if (System.getProperty("os.name").toLowerCase().contains("windows")) {
			DPI = BigDecimal.valueOf(96);
		} else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
			DPI = BigDecimal.valueOf(72);
		} else {
			DPIZOOM = BigDecimal.valueOf(dpi.x);
		}
		DPIZOOM = BigDecimal.valueOf(dpi.x)
				.divide(DPI, 4, RoundingMode.HALF_UP);
		setDpi();
		loadTree(parent);

	}

	@Override
	protected void checkSubclass() {

	}

	public Document document;

	private void loadXML(String file) throws DocumentException {
		SAXReader sa = new SAXReader();
		document = sa.read(file);
		element = document.getRootElement();
	}

	private Combo combo_NodeType, combo_MinOccurs, combo_MaxOccurs, combo_InsertAt, combo_Editable, combo_Extends;

	private Combo combo_New, combo_Save, combo_Delete, combo_Sync, combo_Restore, combo_Duplicate, combo_NewWindow, combo_ShowXML;
	
	private Text text_Icon, text_Type;

	private Label label_path;
	
	// 加载画面上的树和表格以及按钮
	public void loadTree(Composite parent) {
		Label label = new Label(parent, SWT.NONE);
		label.setText("路径:");
		FormData fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 5);
		fd_btn.bottom = new FormAttachment(0, 26);
		fd_btn.left = new FormAttachment(0, 5);
		fd_btn.right = new FormAttachment(0, 40);
		label.setLayoutData(fd_btn);

		label_path = new Label(parent, SWT.NONE);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 5);
		fd_btn.bottom = new FormAttachment(0, 26);
		fd_btn.left = new FormAttachment(label, 0);
		fd_btn.right = new FormAttachment(80, 0);
		label_path.setLayoutData(fd_btn);

		Button choseFile = new Button(parent, SWT.NONE);
		choseFile.setText("选择文件");
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 2);
		fd_btn.bottom = new FormAttachment(0, 26);
		// fd_btn.left = new FormAttachment(80, 5);
		fd_btn.right = new FormAttachment(100, -95);
		choseFile.setLayoutData(fd_btn);
		choseFile.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog dialog = new FileDialog(StartUpResolver.this
						.getShell(), SWT.OPEN);
				dialog.setText("请选择解析器文件");// 设置对话框的标题
				dialog.setFileName("");// 设置默认的文件名
				dialog.setFilterNames(new String[] { "文本文件 (*.xml)" });// 设置扩展名
				dialog.setFilterExtensions(new String[] { "*.xml" });// 设置文件扩展名
				String path = dialog.open();//
				if (path == null) {
					return;
				}
				label_path.setText(path);
				
				try {
					tree.removeAll();
					// table.removeAll();
					table1.removeAll();
					table2.removeAll();
					xmlPath = path;
					loadXML(path);
					bulidTree(element, tree);
				} catch (DocumentException e1) {
					e1.printStackTrace();
				}
				ResolverEdit edit = new ResolverEdit(table1, table2, null);
				edit.mouseDoubleClickEvent();
			}

		});

		Button saveFile = new Button(parent, SWT.NONE);
		saveFile.setText("保存文件");
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(0, 2);
		fd_btn.bottom = new FormAttachment(0, 26);
		fd_btn.left = new FormAttachment(choseFile, 5);
		saveFile.setLayoutData(fd_btn);
		saveFile.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				try {
					if (xmlPath != null) {
						Dom4jUtil.saveDocument(xmlPath,
								StartUpResolver.this.document);
						GOTMessageDialog.alert("保存成功");
					}
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}

		});
		Font fonts = new Font(this.getDisplay(), "宋体", 9, SWT.NONE);

		tree = new Tree(parent, SWT.BORDER | SWT.MULTI | SWT.FULL_SELECTION
				^ SWT.H_SCROLL);
		int h = 30;
		int b = -5;
		FormData fd_tree_1 = new FormData();
		fd_tree_1.right = new FormAttachment(31, -10);
		fd_tree_1.bottom = new FormAttachment(100, b);
		fd_tree_1.top = new FormAttachment(0, h);
		fd_tree_1.left = new FormAttachment(0, 5);
		tree.setLayoutData(fd_tree_1);
		tree.setFont(fonts);
		tree.getHorizontalBar().setEnabled(false);
		tree.addMouseListener(new MouseAdapter() {

			@Override
			public void mouseDown(MouseEvent e) {
				if (e.button != 3) {
					return;
				}
				Point point = new Point(e.x, e.y);
				TreeItem treeItem = tree.getItem(point);
				Menu menu = new Menu(tree);
				if ("GOT".equals(treeItem.getText())) {
					MenuItem save = new MenuItem(menu, SWT.PUSH);
					save.setText("保存解析器");
					save.addSelectionListener(new RightKeyMenuEvent("save",
							treeItem));
				}

				MenuItem add = new MenuItem(menu, SWT.PUSH);
				add.setText("添加子节点");
				add.addSelectionListener(new RightKeyMenuEvent("add", treeItem));

/*				if (allowAdvanceModify) {
					MenuItem delete = new MenuItem(menu, SWT.PUSH);
					delete.setText("删除子节点");
					delete.addSelectionListener(new RightKeyMenuEvent("delete",
							treeItem));
				}*/

				MenuItem delete = new MenuItem(menu, SWT.PUSH);
				delete.setText("删除子节点");
				delete.addSelectionListener(new RightKeyMenuEvent("delete",
						treeItem));
				
				MenuItem show = new MenuItem(menu, SWT.PUSH);
				show.setText("显示xml");
				show.addSelectionListener(new RightKeyMenuEvent("show",
						treeItem));

				if (treeItem.getText().equals("GOT")) {
					MenuItem modify = new MenuItem(menu, SWT.PUSH);
					modify.setText("高级修改");
					modify.addSelectionListener(new RightKeyMenuEvent("modify",
							treeItem));
				}

				tree.setMenu(menu);
			}

			@Override
			public void mouseDoubleClick(MouseEvent e) {
				Point point = new Point(e.x, e.y);
				final TreeItem treeitem = tree.getItem(point);
				if (treeitem == null) {
					return;
				}
				final TreeEditor editor = new TreeEditor(treeitem.getParent());
				Control oldEditor = editor.getEditor();
				if (oldEditor != null) {
					oldEditor.dispose();
				}

				final String oldText = treeitem.getText();
				final Text changeItemText = new Text(treeitem.getParent(),
						SWT.BORDER);
				changeItemText.setFont(treeitem.getFont());
				if (DPIZOOM.compareTo(BigDecimal.ONE) > 0) {
					Font fonts = changeItemText.getFont();
					FontData data = fonts.getFontData()[0];
					data.height = data.height - 1;
					fonts = new Font(changeItemText.getDisplay(), data);
					changeItemText.setFont(fonts);
				}
				changeItemText.computeSize(SWT.DEFAULT, treeitem.getParent()
						.getItemHeight());
				editor.grabHorizontal = true;
				editor.minimumHeight = changeItemText.getSize().y;
				editor.minimumWidth = changeItemText.getSize().x;
				editor.setEditor(changeItemText, treeitem);
				changeItemText.setText(oldText);
				changeItemText.forceFocus();
				changeItemText.selectAll();
				// 编辑后变回表格样式
				changeItemText.addFocusListener(new FocusAdapter() {
					@Override
					public void focusLost(FocusEvent focusevent) {
						Control defaultEditor = editor.getEditor();
						editor.setEditor(defaultEditor, treeitem);
						if (!changeItemText.getText().trim()
								.equals(oldText.trim())) {
							String newText = changeItemText.getText();
							treeitem.setText(newText);
							Element element = (Element) treeitem.getData();
							element.addAttribute("name", newText);
							changeItemText.dispose();
						} else {
							changeItemText.setText(oldText);
							changeItemText.dispose();
						}

					}
				});

			}

		});

		coolBar = new Label(parent, SWT.BORDER);
		FormData fd_coolBar = new FormData();
		fd_coolBar.top = new FormAttachment(0, h);
		fd_coolBar.bottom = new FormAttachment(100, b);
		fd_coolBar.left = new FormAttachment(tree, -1);
		fd_coolBar.right = new FormAttachment(31, 0);
		coolBar.setLayoutData(fd_coolBar);
		coolBar.setBackground(new Color(coolBar.getDisplay(), 240, 240, 246));

		final Cursor CURSOR_SIZEWE = new Cursor(Display.getDefault(),
				SWT.CURSOR_SIZEWE);
		coolBar.setCursor(CURSOR_SIZEWE);

		coolBar.addMouseMoveListener(new MouseMoveListener() {

			Long lastTime = System.currentTimeMillis();

			@Override
			public void mouseMove(MouseEvent e) {
				if (onMouseModfied && (System.currentTimeMillis() - lastTime) > 50) {
					Point pos = ((Control) (e.widget)).toDisplay(e.x, e.y);
					modify(pos.x - lastPos.x, new Rectangle(1, 0, 1, 1));
					lastPos = pos;
					lastTime = System.currentTimeMillis();
				}
			}
		});

		coolBar.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				// 记录当前鼠标位置，以供mouseMove消息时计算鼠标移动距离
				lastPos = ((Control) (e.widget)).toDisplay(e.x, e.y);
				onMouseModfied = true;
			}

			@Override
			public void mouseUp(MouseEvent e) {
				onMouseModfied = false;
			}
		});

		// Info
		groupInfo(parent, h);
		//
		groupContextMenu(parent, h);
		//
		groupAttribute(parent, h);
		//
		groupProperty(parent, b);

		tree.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				TreeItem trtmNewTreeitem = (TreeItem) event.item;
				treeSelectEvent(trtmNewTreeitem);
			}
		});
	}

	private void addHeadTable1() {

		TableColumn Name = new TableColumn(table1, SWT.NONE);
		Name.setText("Name");

		TableColumn Type = new TableColumn(table1, SWT.NONE);
		Type.setText("Type");

		TableColumn Unique = new TableColumn(table1, SWT.NONE);
		Unique.setText("Unique");

		TableColumn Nonblank = new TableColumn(table1, SWT.NONE);
		Nonblank.setText("Nonblank");

		TableColumn Default = new TableColumn(table1, SWT.NONE);
		Default.setText("Default");

		TableColumn Regular = new TableColumn(table1, SWT.NONE);
		Regular.setText("Regular");

		TableColumn Use = new TableColumn(table1, SWT.NONE);
		Use.setText("Use");

		TableColumn Remark = new TableColumn(table1, SWT.NONE);
		Remark.setText("Remark");

	}

	private void addHeadTable2() {

		TableColumn Name = new TableColumn(table2, SWT.NONE);
		Name.setText("Name");

		TableColumn Type = new TableColumn(table2, SWT.NONE);
		Type.setText("Type");

		TableColumn Unique = new TableColumn(table2, SWT.NONE);
		Unique.setText("Unique");

		TableColumn Nonblank = new TableColumn(table2, SWT.NONE);
		Nonblank.setText("Nonblank");

		TableColumn Default = new TableColumn(table2, SWT.NONE);
		Default.setText("Default");

		TableColumn Regular = new TableColumn(table2, SWT.NONE);
		Regular.setText("Regular");

		TableColumn Trigger = new TableColumn(table2, SWT.NONE);
		Trigger.setText("Trigger");

		TableColumn Remark = new TableColumn(table2, SWT.NONE);
		Remark.setText("Remark");

	}

	/*
	 * private void addHeadTable(){ Rectangle bound = table.getBounds();
	 * 
	 * TableColumn NodeType = new TableColumn(table, SWT.NONE);
	 * NodeType.setWidth(bound.width/16); NodeType.setText("NodeType");
	 * 
	 * TableColumn MinOccurs = new TableColumn(table, SWT.NONE);
	 * MinOccurs.setWidth(bound.width/16); MinOccurs.setText("MinOccurs");
	 * 
	 * TableColumn MaxOccurs = new TableColumn(table, SWT.NONE);
	 * MaxOccurs.setWidth(bound.width/16); MaxOccurs.setText("MaxOccurs");
	 * 
	 * TableColumn Icon = new TableColumn(table, SWT.NONE);
	 * Icon.setWidth(bound.width/16); Icon.setText("Icon");
	 * 
	 * TableColumn Type = new TableColumn(table, SWT.NONE);
	 * Type.setWidth(bound.width/16); Type.setText("Type");
	 * 
	 * TableColumn InsertAt = new TableColumn(table, SWT.NONE);
	 * InsertAt.setWidth(bound.width/16); InsertAt.setText("InsertAt");
	 * 
	 * TableColumn Editable = new TableColumn(table, SWT.NONE);
	 * Editable.setWidth(bound.width/16); Editable.setText("Editable");
	 * 
	 * TableColumn Extends = new TableColumn(table, SWT.NONE);
	 * Extends.setWidth(bound.width/16); Extends.setText("Extends");
	 * 
	 * TableColumn New = new TableColumn(table, SWT.NONE);
	 * New.setWidth(bound.width/16); New.setText("New");
	 * 
	 * TableColumn Save = new TableColumn(table, SWT.NONE);
	 * Save.setWidth(bound.width/16); Save.setText("Save");
	 * 
	 * TableColumn Delete = new TableColumn(table, SWT.NONE);
	 * Delete.setWidth(bound.width/16); Delete.setText("Delete");
	 * 
	 * TableColumn Sync = new TableColumn(table, SWT.NONE);
	 * Sync.setWidth(bound.width/16); Sync.setText("Sync");
	 * 
	 * TableColumn Restore = new TableColumn(table, SWT.NONE);
	 * Restore.setWidth(bound.width/16); Restore.setText("Restore");
	 * 
	 * TableColumn Duplicate = new TableColumn(table, SWT.NONE);
	 * Duplicate.setWidth(bound.width/16); Duplicate.setText("Duplicate");
	 * 
	 * TableColumn NewWindow = new TableColumn(table, SWT.NONE);
	 * NewWindow.setWidth(bound.width/16); NewWindow.setText("NewWindow");
	 * 
	 * TableColumn ShowXML = new TableColumn(table, SWT.NONE);
	 * ShowXML.setWidth(bound.width/16); ShowXML.setText("ShowXML"); }
	 */

	private void setWith(Table tarTable) {
		TableColumn[] columns = tarTable.getColumns();
		int all = columns.length;
		Rectangle bound = tarTable.getBounds();
		for (TableColumn tableColumn : columns) {
			tableColumn.setWidth(bound.width / all - 1);
		}
	}

	/**
	 * 改变窗口位置和尺寸
	 * 
	 * @param x
	 *            x轴移动距离
	 * @param y
	 *            y轴移动距离
	 * @param mask
	 *            锚点位置计算的掩码
	 */
	protected void modify(int x, Rectangle mask) {
		
		// 计算出新的窗口位置和尺寸  group_Attribute, group_Info, group_Property, group_ContextMenu
		
		Rectangle boundLable = coolBar.getBounds();
		boundLable.x += x * mask.x;
		coolBar.setBounds(boundLable);
		
		Rectangle boundTree = group_Attribute.getBounds();
		boundTree.x += x * mask.x;
		boundTree.width += -x * mask.width;
		group_Attribute.setBounds(boundTree);

		Rectangle boundTable = group_Info.getBounds();
		boundTable.x += x * mask.x;
		boundTable.width += -x * mask.width;
		group_Info.setBounds(boundTable);

		Rectangle boundTable2 = group_Property.getBounds();
		boundTable2.x += x * mask.x;
		boundTable2.width += -x * mask.width;
		group_Property.setBounds(boundTable2);

		Rectangle boundTable3 = group_ContextMenu.getBounds();
		boundTable3.x += x * mask.x;
		boundTable3.width += -x * mask.width;
		group_ContextMenu.setBounds(boundTable3);
		
		Rectangle boundTree2 = tree.getBounds();
		boundTree2.width += x * mask.width;
		tree.setBounds(boundTree2);
	}

	private int X_1920 = 1920;

	private void setDpi() {
		int screenWidth = java.awt.Toolkit.getDefaultToolkit().getScreenSize().width;
		if (screenWidth > 1920) {
			DPIZOOM = DPIZOOM.multiply(new BigDecimal(screenWidth / X_1920));
		}

	}

	public void bulidTree(final Element element, Tree parent) {
		if (element == null) {
			return;
		}

		TreeItem trtmNewTreeitem = new TreeItem(parent, SWT.NONE);
		trtmNewTreeitem.setText(element.attributeValue("name"));
		trtmNewTreeitem.setImage(ComposeIMG.drawImgDef(element));
		trtmNewTreeitem.setData(element);
		bulidTree(element, trtmNewTreeitem, true);

	}

	/**
	 * 根据xml来创建树的子节点
	 * 
	 * @param e
	 *            文档
	 * @param parentTree
	 *            父节点
	 * @param flag
	 *            循环子节点
	 */
	public void bulidTree(Element e, TreeItem parentTree, boolean flag) {
		@SuppressWarnings("unchecked")
		List<Element> list = e.elements();
		for (Element element : list) {
			if (nodeShowRule(element)) {
				TreeItem trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE);
				String text = element.attributeValue("name");
				trtmNewTreeitem.setText(text);
				trtmNewTreeitem.setExpanded(true);
				trtmNewTreeitem.setImage(ComposeIMG.drawImgDef(text));
				trtmNewTreeitem.setData(element);
				// parentTree.setExpanded(true);
				if (flag) {
					bulidTree(element, trtmNewTreeitem, flag);
				}
			}
		}
	}

	private boolean nodeShowRule(Element element) {
		if (element.attribute("name") != null) {
			return true;
		}
		return false;
	}

	private void treeSelectEvent(TreeItem item) {
		Element element = (Element) item.getData();
		// String[] table0_str = new String[16];
		String[] table1_str = new String[8];
		String[] table2_str = new String[8];

		if(element.element("Info") != null){
			Element Info = element.element("Info");
			combo_NodeType.setText(Info.elementText("NodeType") == null ? "" : Info.elementText("NodeType"));
			combo_NodeType.setData(Info.element("NodeType"));
			
			combo_MinOccurs.setText(Info.elementText("MinOccurs") == null ? "" : Info.elementText("MinOccurs") );
			combo_MinOccurs.setData(Info.element("MinOccurs"));
			
			combo_MaxOccurs.setText(Info.elementText("MaxOccurs") == null ? "" : Info.elementText("MaxOccurs"));
			combo_MaxOccurs.setData(Info.element("MaxOccurs"));
			
			text_Icon.setText(Info.elementText("Icon") == null ? "" : Info.elementText("Icon"));
			text_Icon.setData(Info.element("Icon"));
			
			text_Type.setText(Info.elementText("Type") == null ? "" : Info.elementText("Type"));
			text_Type.setData(Info.element("Type"));
			
			combo_InsertAt.setText(Info.elementText("InsertAt") == null ? "" : Info.elementText("InsertAt"));
			combo_InsertAt.setData(Info.element("InsertAt"));
			
			combo_Editable.setText(Info.elementText("Editable") == null ? "" : Info.elementText("Editable"));
			combo_Editable.setData(Info.element("Editable"));
			
			List<String> array = new ArrayList<String>();
			array.add("");
			List<Element> elements = Info.getParent().selectNodes("//node");
			for (Element node : elements) {
				String str = node.element("Info").elementText("NodeType");
				if(str != null && !"Abstract".equals(node.attributeValue("name")) && str.equals("abstract")){
					array.add(node.attributeValue("name"));
				}
			}
			String[] comItem = array.toArray(new String[array.size()]);
			combo_Extends.setItems(comItem);
			combo_Extends.setText(Info.elementText("Extends") == null ? "" : Info.elementText("Extends"));
			combo_Extends.setData(Info.element("Extends"));
		}
		
		if(element.element("ContextMenu") != null){
			Element ContextMenu = element.element("ContextMenu");
			combo_New.setText(ContextMenu.elementText("New") == null ? "" : ContextMenu.elementText("New"));
			combo_New.setData(ContextMenu.element("New"));
			
			combo_Save.setText(ContextMenu.elementText("Save") == null ? "" : ContextMenu.elementText("Save"));
			combo_Save.setData(ContextMenu.element("Save"));
			
			combo_Delete.setText(ContextMenu.elementText("Delete") == null ? "" : ContextMenu.elementText("Delete"));
			combo_Delete.setData(ContextMenu.element("Delete"));
			
			combo_Sync.setText(ContextMenu.elementText("Sync") == null ? "" : ContextMenu.elementText("Sync"));
			combo_Sync.setData(ContextMenu.element("Sync"));
			
			combo_Restore.setText(ContextMenu.elementText("Restore") == null ? "" : ContextMenu.elementText("Restore"));
			combo_Restore.setData(ContextMenu.element("Restore"));
			
			combo_Duplicate.setText(ContextMenu.elementText("Duplicate") == null ? "" : ContextMenu.elementText("Duplicate"));
			combo_Duplicate.setData(ContextMenu.element("Duplicate"));
			
			combo_NewWindow.setText(ContextMenu.elementText("NewWindow") == null ? "" : ContextMenu.elementText("NewWindow"));
			combo_NewWindow.setData(ContextMenu.element("NewWindow"));
			
			combo_ShowXML.setText(ContextMenu.elementText("ShowXML") == null ? "" : ContextMenu.elementText("ShowXML"));
			combo_ShowXML.setData(ContextMenu.element("ShowXML"));
		}
		
		table1.removeAll();
		if (element.element("Attributes") != null) {
			List<Element> Attributes = element.element("Attributes").elements();
			for (Element attr : Attributes) {
				TableItem temp = new TableItem(table1, SWT.NONE);
				table1_str[0] = attr.elementText("Name");
				table1_str[1] = attr.elementText("Type");
				table1_str[2] = attr.elementText("Unique");
				table1_str[3] = attr.elementText("Nonblank");
				table1_str[4] = attr.elementText("Default");
				table1_str[5] = attr.elementText("Regular");
				table1_str[6] = attr.elementText("Use");
				table1_str[7] = attr.elementText("Remark");
				temp.setText(table1_str);
				temp.setData(attr);
			}

		}

		table2.removeAll();
		if (element.element("Properties") != null) {
			List<Element> Properties = element.element("Properties").elements();
			for (Element pro : Properties) {
				TableItem temp = new TableItem(table2, SWT.NONE);
				table2_str[0] = pro.elementText("Name");
				table2_str[1] = pro.elementText("Type");
				table2_str[2] = pro.elementText("Unique");
				table2_str[3] = pro.elementText("Nonblank");
				table2_str[4] = pro.elementText("Default");
				table2_str[5] = pro.elementText("Regular");
				table2_str[6] = pro.elementText("Trigger");
				table2_str[7] = pro.elementText("Remark");
				temp.setText(table2_str);
				temp.setData(pro);
			}

		}

	}

	class RightKeyMenuEvent extends SelectionAdapter {

		private String action;

		private TreeItem treeItem;

		public RightKeyMenuEvent(String action, TreeItem treeItem) {
			super();
			this.action = action;
			this.treeItem = treeItem;
		}

		public String getAction() {
			return action;
		}

		public void setAction(String action) {
			this.action = action;
		}

		@Override
		public void widgetSelected(SelectionEvent e) {
			if (action.equals("add")) {
				addChild();
			} else if (action.equals("delete")) {
				Element data = (Element) this.treeItem.getData();
				Element parent = data.getParent();
				parent.remove(data);
				treeItem.removeAll();
				treeItem.dispose();
			} else if (action.equals("show")) {
				Element item = (Element) treeItem.getData();
				GOTMessageDialog.showXmlInfo(formatXml(item.asXML()),
						item.attributeValue("name"));
			} else if (action.equals("save")) {
				try {
					Dom4jUtil.saveDocument(xmlPath,
							StartUpResolver.this.document);
					GOTMessageDialog.alert("保存成功");
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			} else if (action.equals("modify")) {
				StartUpResolver.this.allowAdvanceModify = !StartUpResolver.this.allowAdvanceModify;
			}
		}

		public void addChild() {
			Element node = GOTXMLHelper.createElement("node");
			Element info = GOTXMLHelper.createElement("Info");
			info.add(GOTXMLHelper.createElement("NodeType").detach());
			info.add(GOTXMLHelper.createElement("MinOccurs").detach());
			info.add(GOTXMLHelper.createElement("MaxOccurs").detach());
			info.add(GOTXMLHelper.createElement("Icon").detach());
			info.add(GOTXMLHelper.createElement("Type").detach());
			info.add(GOTXMLHelper.createElement("InsertAt").detach());
			info.add(GOTXMLHelper.createElement("Editable").detach());
			info.add(GOTXMLHelper.createElement("Extends").detach());

			Element contextmenu = GOTXMLHelper.createElement("ContextMenu");
			contextmenu.add(GOTXMLHelper.createElement("New").detach());
			contextmenu.add(GOTXMLHelper.createElement("Save").detach());
			contextmenu.add(GOTXMLHelper.createElement("Delete").detach());
			contextmenu.add(GOTXMLHelper.createElement("Sync").detach());
			contextmenu.add(GOTXMLHelper.createElement("Restore").detach());
			contextmenu.add(GOTXMLHelper.createElement("Duplicate").detach());
			contextmenu.add(GOTXMLHelper.createElement("NewWindow").detach());
			contextmenu.add(GOTXMLHelper.createElement("ShowXML").detach());

			node.addAttribute("name", "newNode");
			node.add(info.detach());
			node.add(contextmenu.detach());
			node.add(GOTXMLHelper.createElement("Attributes").detach());
			node.add(GOTXMLHelper.createElement("Properties").detach());

			TreeItem newItem = new TreeItem(treeItem, SWT.NONE);
			newItem.setText("newNode");
			newItem.setData(node);
			newItem.setImage(ComposeIMG.drawImgDef("Default"));

			Element data = (Element) this.treeItem.getData();
			data.add(node.detach());
			StartUpResolver.this.allowAdvanceModify = true;
		}
	}

	public String formatXml(String str) {
		Document document = null;
		StringWriter writer;
		try {
			document = DocumentHelper.parseText(str);
			// 格式化输出格式
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding(FileIO.UTF8);
			writer = new StringWriter();
			// 格式化输出流
			XMLWriter xmlWriter = new XMLWriter(writer, format);
			// 将document写入到输出流
			xmlWriter.write(document);
			xmlWriter.close();
			str = writer.toString();
		} catch (DocumentException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return str;
	}

	private void groupInfo(Composite parent, int h) {
		group_Info = new Group(parent, SWT.BORDER);
		group_Info.setText("Info");
		FormData fd_table = new FormData();
		fd_table.top = new FormAttachment(0, h);
		fd_table.bottom = new FormAttachment(15, 0);
		fd_table.left = new FormAttachment(coolBar, 0);
		fd_table.right = new FormAttachment(100, -30);
		group_Info.setLayoutData(fd_table);
		group_Info.setLayout(new FormLayout());

		Label label_NodeType = new Label(group_Info, SWT.NONE);
		label_NodeType.setText("NodeType:");
		FormData fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(0, 2);
		fd_label.right = new FormAttachment(0, 80);
		label_NodeType.setLayoutData(fd_label);

		combo_NodeType = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(label_NodeType, 2);
		fd_label.right = new FormAttachment(label_NodeType, 150, SWT.RIGHT);
		combo_NodeType.setLayoutData(fd_label);
		combo_NodeType.setItems(new String[] { "outer", "entity", "inner",
				"branch", "ref", "abstract" });
		combo_NodeType.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_NodeType.getData();
				if (data != null) {
					data.setText(combo_NodeType.getText());
				}
			}
		});

		Label lable_MinOccurs = new Label(group_Info, SWT.NONE);
		lable_MinOccurs.setText("MinOccurs:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_NodeType, 20);
		fd_label.right = new FormAttachment(combo_NodeType, 100, SWT.RIGHT);
		lable_MinOccurs.setLayoutData(fd_label);

		combo_MinOccurs = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(lable_MinOccurs, 2);
		fd_label.right = new FormAttachment(lable_MinOccurs, 150, SWT.RIGHT);
		combo_MinOccurs.setLayoutData(fd_label);
		combo_MinOccurs.setItems(new String[] { "", "0", "1" });
		combo_MinOccurs.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_MinOccurs.getData();
				if (data != null) {
					data.setText(combo_MinOccurs.getText());
				}
			}
		});

		Label lable_MaxOccurs = new Label(group_Info, SWT.NONE);
		lable_MaxOccurs.setText("MaxOccurs:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_MinOccurs, 20);
		fd_label.right = new FormAttachment(combo_MinOccurs, 100, SWT.RIGHT);
		lable_MaxOccurs.setLayoutData(fd_label);

		combo_MaxOccurs = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(lable_MaxOccurs, 2);
		fd_label.right = new FormAttachment(lable_MaxOccurs, 150, SWT.RIGHT);
		combo_MaxOccurs.setLayoutData(fd_label);
		combo_MaxOccurs.setItems(new String[] { "", "1", "unbounded" });
		combo_MaxOccurs.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_MaxOccurs.getData();
				if (data != null) {
					data.setText(combo_MaxOccurs.getText());
				}
			}
		});

		Label lable_Icon = new Label(group_Info, SWT.NONE);
		lable_Icon.setText("Icon:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_MaxOccurs, 20);
		fd_label.right = new FormAttachment(combo_MaxOccurs, 100, SWT.RIGHT);
		lable_Icon.setLayoutData(fd_label);

		text_Icon = new Text(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 0);
		fd_label.left = new FormAttachment(lable_Icon, 2);
		fd_label.right = new FormAttachment(lable_Icon, 150, SWT.RIGHT);
		fd_label.bottom = new FormAttachment(0, 26);
		text_Icon.setLayoutData(fd_label);
		text_Icon.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				Element data = (Element) text_Icon.getData();
				if (data != null) {
					data.setText(text_Icon.getText());
				}
			}

		});
		
		Label label_Type = new Label(group_Info, SWT.NONE);
		label_Type.setText("Type:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(0, 2);
		fd_label.right = new FormAttachment(0, 80);
		label_Type.setLayoutData(fd_label);
		
		text_Type = new Text(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(label_Type, 2);
		fd_label.right = new FormAttachment(label_Type, 150, SWT.RIGHT);
		fd_label.bottom = new FormAttachment(label_NodeType, 40, SWT.BOTTOM);
		text_Type.setLayoutData(fd_label);
		text_Type.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				Element data = (Element) text_Type.getData();
				if (data != null) {
					data.setText(text_Type.getText());
				}
			}

		});
		
		Label label_InsertAt = new Label(group_Info, SWT.NONE);
		label_InsertAt.setText("InsertAt:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(text_Type, 20);
		fd_label.right = new FormAttachment(text_Type, 100, SWT.RIGHT);
		label_InsertAt.setLayoutData(fd_label);
		
		combo_InsertAt = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(label_InsertAt, 2);
		fd_label.right = new FormAttachment(label_InsertAt, 150, SWT.RIGHT);
		combo_InsertAt.setLayoutData(fd_label);
		combo_InsertAt.setItems(new String[] {"", "append", "prepend", "before", "after", "dictioanry"});
		combo_InsertAt.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_InsertAt.getData();
				if (data != null) {
					data.setText(combo_InsertAt.getText());
				}
			}
		});
		
		Label label_Editable = new Label(group_Info, SWT.NONE);
		label_Editable.setText("Editable:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(combo_InsertAt, 20);
		fd_label.right = new FormAttachment(combo_InsertAt, 100, SWT.RIGHT);
		label_Editable.setLayoutData(fd_label);
		
		combo_Editable = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(label_Editable, 2);
		fd_label.right = new FormAttachment(label_Editable, 150, SWT.RIGHT);
		combo_Editable.setLayoutData(fd_label);
		combo_Editable.setItems(new String[] {"", "append", "prepend", "before", "after", "dictioanry"});
		combo_Editable.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Editable.getData();
				if (data != null) {
					data.setText(combo_Editable.getText());
				}
			}
		});
		
		Label label_Extends = new Label(group_Info, SWT.NONE);
		label_Extends.setText("Extends:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(combo_Editable, 20);
		fd_label.right = new FormAttachment(combo_Editable, 100, SWT.RIGHT);
		label_Extends.setLayoutData(fd_label);
		
		combo_Extends = new Combo(group_Info, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_NodeType, 15);
		fd_label.left = new FormAttachment(label_Extends, 2);
		fd_label.right = new FormAttachment(label_Extends, 150, SWT.RIGHT);
		combo_Extends.setLayoutData(fd_label);
		combo_Extends.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Extends.getData();
				if (data != null) {
					data.setText(combo_Extends.getText());
				}
			}
		});
		
	}

	private Group group_Attribute, group_Info, group_Property, group_ContextMenu;

	private void groupContextMenu(Composite parent, int h) {
		group_ContextMenu = new Group(parent, SWT.BORDER);
		group_ContextMenu.setText("ContextMenu");
		FormData fd_table = new FormData();
		fd_table.top = new FormAttachment(group_Info, 5);
		fd_table.bottom = new FormAttachment(30, 0);
		fd_table.left = new FormAttachment(coolBar, 0);
		fd_table.right = new FormAttachment(100, -30);
		group_ContextMenu.setLayoutData(fd_table);
		group_ContextMenu.setLayout(new FormLayout());

		Label label_New = new Label(group_ContextMenu, SWT.NONE);
		label_New.setText("New:");
		FormData fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(0, 2);
		fd_label.right = new FormAttachment(0, 80);
		label_New.setLayoutData(fd_label);

		combo_New = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(label_New, 2);
		fd_label.right = new FormAttachment(label_New, 150, SWT.RIGHT);
		combo_New.setLayoutData(fd_label);
		combo_New.setItems(new String[] { "", "Y", "N" });
		combo_New.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_New.getData();
				if (data != null) {
					data.setText(combo_New.getText());
				}
			}
		});

		Label lable_Save = new Label(group_ContextMenu, SWT.NONE);
		lable_Save.setText("Save:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_New, 20);
		fd_label.right = new FormAttachment(combo_New, 100, SWT.RIGHT);
		lable_Save.setLayoutData(fd_label);

		combo_Save = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(lable_Save, 2);
		fd_label.right = new FormAttachment(lable_Save, 150, SWT.RIGHT);
		combo_Save.setLayoutData(fd_label);
		combo_Save.setItems(new String[] { "", "Y", "N" });
		combo_Save.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Save.getData();
				if (data != null) {
					data.setText(combo_Save.getText());
				}
			}
		});

		Label lable_Delete = new Label(group_ContextMenu, SWT.NONE);
		lable_Delete.setText("Delete:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_Save, 20);
		fd_label.right = new FormAttachment(combo_Save, 100, SWT.RIGHT);
		lable_Delete.setLayoutData(fd_label);

		combo_Delete = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(lable_Delete, 2);
		fd_label.right = new FormAttachment(lable_Delete, 150, SWT.RIGHT);
		combo_Delete.setLayoutData(fd_label);
		combo_Delete.setItems(new String[] { "", "Y", "N" });
		combo_Delete.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Delete.getData();
				if (data != null) {
					data.setText(combo_Delete.getText());
				}
			}
		});

		Label lable_Sync = new Label(group_ContextMenu, SWT.NONE);
		lable_Sync.setText("Sync:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(0, 2);
		fd_label.left = new FormAttachment(combo_Delete, 20);
		fd_label.right = new FormAttachment(combo_Delete, 100, SWT.RIGHT);
		lable_Sync.setLayoutData(fd_label);

		combo_Sync = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.left = new FormAttachment(lable_Sync, 2);
		fd_label.right = new FormAttachment(lable_Sync, 150, SWT.RIGHT);
		combo_Sync.setLayoutData(fd_label);
		combo_Sync.setItems(new String[] { "", "Y", "N" });
		combo_Sync.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Sync.getData();
				if (data != null) {
					data.setText(combo_Sync.getText());
				}
			}
		});
		
		Label label_Restore = new Label(group_ContextMenu, SWT.NONE);
		label_Restore.setText("Restore:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(0, 2);
		fd_label.right = new FormAttachment(0, 80);
		label_Restore.setLayoutData(fd_label);
		
		combo_Restore = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(label_Restore, 2);
		fd_label.right = new FormAttachment(label_Restore, 150, SWT.RIGHT);
		combo_Restore.setLayoutData(fd_label);
		combo_Restore.setItems(new String[] { "", "Y", "N" });
		combo_Restore.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Restore.getData();
				if (data != null) {
					data.setText(combo_Restore.getText());
				}
			}
		});
		
		Label label_Duplicate = new Label(group_ContextMenu, SWT.NONE);
		label_Duplicate.setText("Duplicate:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(combo_Restore, 20);
		fd_label.right = new FormAttachment(combo_Restore, 100, SWT.RIGHT);
		label_Duplicate.setLayoutData(fd_label);
		
		combo_Duplicate = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(label_Duplicate, 2);
		fd_label.right = new FormAttachment(label_Duplicate, 150, SWT.RIGHT);
		combo_Duplicate.setLayoutData(fd_label);
		combo_Duplicate.setItems(new String[] {"", "Y", "N"});
		combo_Duplicate.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_Duplicate.getData();
				if (data != null) {
					data.setText(combo_Duplicate.getText());
				}
			}
		});
		
		Label label_NewWindow = new Label(group_ContextMenu, SWT.NONE);
		label_NewWindow.setText("NewWindow:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(combo_Duplicate, 20);
		fd_label.right = new FormAttachment(combo_Duplicate, 100, SWT.RIGHT);
		label_NewWindow.setLayoutData(fd_label);
		
		combo_NewWindow = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(label_NewWindow, 2);
		fd_label.right = new FormAttachment(label_NewWindow, 150, SWT.RIGHT);
		combo_NewWindow.setLayoutData(fd_label);
		combo_NewWindow.setItems(new String[] {"", "Y", "N"});
		combo_NewWindow.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_NewWindow.getData();
				if (data != null) {
					data.setText(combo_NewWindow.getText());
				}
			}
		});
		
		Label label_ShowXML = new Label(group_ContextMenu, SWT.NONE);
		label_ShowXML.setText("ShowXML:");
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(combo_NewWindow, 20);
		fd_label.right = new FormAttachment(combo_NewWindow, 100, SWT.RIGHT);
		label_ShowXML.setLayoutData(fd_label);
		
		combo_ShowXML = new Combo(group_ContextMenu, SWT.BORDER);
		fd_label = new FormData();
		fd_label.top = new FormAttachment(label_New, 15);
		fd_label.left = new FormAttachment(label_ShowXML, 2);
		fd_label.right = new FormAttachment(label_ShowXML, 150, SWT.RIGHT);
		combo_ShowXML.setLayoutData(fd_label);
		combo_ShowXML.setItems(new String[] {"", "Y", "N"});
		combo_ShowXML.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				Element data = (Element) combo_ShowXML.getData();
				if (data != null) {
					data.setText(combo_ShowXML.getText());
				}
			}
		});
		
	}
	
	private void groupAttribute(Composite parent, int h) {
		group_Attribute = new Group(parent, SWT.BORDER);
		group_Attribute.setText("Attribute");
		FormData fd_table = new FormData();
		fd_table.top = new FormAttachment(30, 2);
		fd_table.bottom = new FormAttachment(65, 0);
		fd_table.left = new FormAttachment(coolBar, 0);
		fd_table.right = new FormAttachment(100, -30);
		group_Attribute.setLayoutData(fd_table);
		group_Attribute.setLayout(new FillLayout());
		Font fonts = new Font(this.getDisplay(), "宋体", 9, SWT.NONE);
		table1 = new Table(group_Attribute, SWT.BORDER | SWT.MULTI
				| SWT.FULL_SELECTION | SWT.V_SCROLL);
		table1.setLinesVisible(true);
		table1.setFont(fonts);
		table1.setHeaderVisible(true);
		addHeadTable1();
		table1.addControlListener(new ControlListener() {

			@Override
			public void controlMoved(ControlEvent arg0) {

			}

			@Override
			public void controlResized(ControlEvent arg0) {
				setWith(table1);
			}

		});
		setDropSource(table1);
		setDropTarget(table1);
		
		Button btnAdd = new Button(parent, SWT.NONE);
		FormData fd_btn = new FormData();
		fd_btn.top = new FormAttachment(30, 20);
		fd_btn.left = new FormAttachment(group_Attribute, 2);
		fd_btn.right = new FormAttachment(100, -2);
		btnAdd.setLayoutData(fd_btn);
		btnAdd.setText("+");
		btnAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TreeItem[] treeItems = tree.getSelection();
				if (treeItems.length > 0) {
					Element data = (Element) treeItems[0].getData();
					Element attribute = GOTXMLHelper.createElement("Attribute");
					attribute.addElement("Name").setText("att");
					attribute.addElement("Type").setText("");
					attribute.addElement("Unique").setText("");
					attribute.addElement("Nonblank").setText("");
					attribute.addElement("Default").setText("");
					attribute.addElement("Regular").setText("");
					attribute.addElement("Use").setText("required");
					attribute.addElement("Remark").setText("");
					data.element("Attributes").add(attribute.detach());

					TableItem tableItem = new TableItem(table1, SWT.NONE);
					tableItem.setText(new String[] { "att", "", "", "", "", "",
							"required", "" });
					tableItem.setData(attribute);
				}

			}

		});

		Button btnDelete = new Button(parent, SWT.NONE);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(btnAdd, 5);
		fd_btn.left = new FormAttachment(group_Attribute, 2);
		fd_btn.right = new FormAttachment(100, -2);
		btnDelete.setLayoutData(fd_btn);
		btnDelete.setText("-");
		btnDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] tableItems = table1.getSelection();
				if (tableItems.length > 0) {
					Element data = (Element) tableItems[0].getData();
					Element parent = data.getParent();
					parent.remove(data);
					tableItems[0].dispose();
				}
			}

		});
		
	}

	private void groupProperty(Composite parent, int b) {
		Font fonts = new Font(this.getDisplay(), "宋体", 9, SWT.NONE);
		group_Property = new Group(parent, SWT.BORDER);
		group_Property.setText("Property");
		FormData fd_table2 = new FormData();
		fd_table2.top = new FormAttachment(group_Attribute, 0);
		fd_table2.bottom = new FormAttachment(100, b);
		fd_table2.left = new FormAttachment(coolBar, 0);
		fd_table2.right = new FormAttachment(100, -30);
		group_Property.setLayoutData(fd_table2);
		group_Property.setLayout(new FillLayout());
		table2 = new Table(group_Property, SWT.BORDER | SWT.MULTI
				| SWT.FULL_SELECTION | SWT.V_SCROLL);
		table2.setLinesVisible(true);
		table2.setFont(fonts);
		table2.setHeaderVisible(true);
		addHeadTable2();
		table2.addControlListener(new ControlListener() {

			@Override
			public void controlMoved(ControlEvent arg0) {

			}

			@Override
			public void controlResized(ControlEvent arg0) {
				setWith(table2);
			}

		});
		setDropSource(table2);
		setDropTarget(table2);
		
		Button btnAdd2 = new Button(parent, SWT.NONE);
		FormData fd_btn = new FormData();
		fd_btn.top = new FormAttachment(group_Attribute, 15);
		fd_btn.left = new FormAttachment(group_Property, 2);
		fd_btn.right = new FormAttachment(100, -2);
		btnAdd2.setLayoutData(fd_btn);
		btnAdd2.setText("+");
		btnAdd2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TreeItem[] treeItems = tree.getSelection();
				if (treeItems.length > 0) {
					Element data = (Element) treeItems[0].getData();
					Element attribute = GOTXMLHelper.createElement("Property");
					attribute.addElement("Name").setText("pro");
					attribute.addElement("Type").setText("");
					attribute.addElement("Unique").setText("");
					attribute.addElement("Nonblank").setText("");
					attribute.addElement("Default").setText("");
					attribute.addElement("Regular").setText("");
					attribute.addElement("Remark").setText("");
					data.element("Properties").add(attribute.detach());

					TableItem tableItem = new TableItem(table2, SWT.NONE);
					tableItem.setText(new String[] { "pro", "", "", "", "", "","", "" });
					tableItem.setData(attribute);
				}

			}

		});

		Button btnDelete2 = new Button(parent, SWT.NONE);
		fd_btn = new FormData();
		fd_btn.top = new FormAttachment(btnAdd2, 5);
		fd_btn.left = new FormAttachment(group_Property, 2);
		fd_btn.right = new FormAttachment(100, -2);
		btnDelete2.setLayoutData(fd_btn);
		btnDelete2.setText("-");
		btnDelete2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TableItem[] tableItems = table2.getSelection();
				if (tableItems.length > 0) {
					Element data = (Element) tableItems[0].getData();
					Element parent = data.getParent();
					parent.remove(data);
					tableItems[0].dispose();
				}
			}

		});
		
	}
	
	public void setDropSource(final Table table){
        /*创建拖放源*/
		DragSource ds = new DragSource(table, DND.DROP_MOVE | DND.DROP_COPY);
        /*设置传输的数据为文本型String类型*/
        ds.setTransfer(new Transfer[] { TextTransfer.getInstance() });
        /*注册当拖动源时触发的事件*/
        
        ds.addDragListener(new DragSourceListener() {
        	/*当开始拖动源控件时*/
			@Override
			public void dragFinished(DragSourceEvent arg0) {
				
			}

			/*设置拖放过程中传输的数据*/
			@Override
			public void dragSetData(DragSourceEvent arg0) {
				//这里必须设置拖动的传输的数据
				if(TextTransfer.getInstance().isSupportedType(arg0.dataType)){
					TableItem[] treeitems = table.getSelection();
					if(treeitems.length > 0){
						arg0.data = treeitems[0].getText();
					}
					
				}
				
			}

			@Override
			public void dragStart(DragSourceEvent arg0) {
				
			}
        	
        });
	}
	
	public void setDropTarget(final Table table){
        /*定义拖放的目标控件*/
		DropTarget target = new DropTarget(table, DND.DROP_MOVE | DND.DROP_COPY);
        /*设置目标控件所接受的传输数据*/
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener(new DropTargetListener() {
			
        	TableItem overItem = null;
        	
        	boolean dropFlag = false;
        	
			@Override
			public void dropAccept(DropTargetEvent arg0) {
				
				
			}
			
			@Override
			public void drop(DropTargetEvent arg0) {
				if(dropFlag){
					TableItem[] treeitems = table.getSelection();
					if(treeitems.length > 0){
						TableItem dropItem = treeitems[0];
						Element element = (Element) dropItem.getData();
						if(element != null){
							Element copy = element.createCopy();
							Element parent = element.getParent();
							parent.remove(element);
							Element dropTarget = (Element) overItem.getData();
							GOTHelp.insertChildBefore(dropTarget.getParent(), dropTarget, copy);
							treeSelectEvent(tree.getSelection()[0]);
						}
					}
				}
				
			}
			
			@Override
			public void dragOver(DropTargetEvent arg0) {
				arg0.detail = DND.DROP_NONE;
				if(arg0.item != null){
					overItem = (TableItem) arg0.item;
					TableItem[] treeitems = table.getSelection();
					if(treeitems.length > 0){
						TableItem dropItem = treeitems[0];
						if(dropItem.getParent() == overItem.getParent()){
							arg0.feedback = DND.FEEDBACK_INSERT_BEFORE | DND.FEEDBACK_EXPAND;
							arg0.detail = DND.DROP_COPY;
							dropFlag = true;
							return;
						}
					}
				}
				dropFlag = false;
			}
			
			@Override
			public void dragOperationChanged(DropTargetEvent arg0) {
				
				
			}
			
			@Override
			public void dragLeave(DropTargetEvent arg0) {
				
				
			}
			
			@Override
			public void dragEnter(DropTargetEvent arg0) {
				
				
			}
		});
        
    }
}
