package info.gongqi.got.ui;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.GetPropertieValue;
import info.gongqi.got.tool.ProgressBarExchangeLayer;
import info.gongqi.got.tool.TreeChineseLabel;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.event.MouseRightMenuEvent;
import info.gongqi.got.ui.event.TableMouseEvent;
import info.gongqi.got.ui.event.TreeMouseRigthMenuEvent;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.FromToMapping;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.NumCore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class TreeUi {

	private static Logger log = Logger.getLogger(TreeUi.class);
	
	private Table table;
	
	private Tree tree;
	
	private Font font_bold;
	
	public TreeColumn trclmnNewColumnLabel, trclmnNewColumnText;

	private TreeMouseRigthMenuEvent menuEvent; 
	
	//子节点map
	public Map<String, TreeItem> itemsMap = new HashMap<String, TreeItem>();
	
	public DragSource ds;
	
	public DropTarget target;
	
	//展开MAP
	public Map<String, Boolean> expanedMap = new HashMap<>();
	
	//选中的树节点，用来处理多窗口同步的问题
	public TreeItem selected = null;
	
	public List<TreeItem> selects = new ArrayList<TreeItem>();
	
	public boolean ctrl = false;
	
	public TreeUiBean treeUiBean;
	
	/**
	 * 根据xml来创建树
	 * @param t
	 * @param tab
	 * @param targetEl
	 */
	public TreeUi(Tree t, Table tab, final Element targetEl){
		this.table = tab;
		this.tree = t;
		new Thread(new Runnable() {
			
			@Override
			public void run() {
				final Element root = initXML(targetEl);
				Display.getDefault().syncExec(new Runnable() {
					
					@Override
					public void run() {
						initFont();
						if(tree.getListeners(SWT.MouseDoubleClick).length == 0 ){
							addListener();
						}else{
					        menuEvent = new TreeMouseRigthMenuEvent(TreeUi.this);
					        tree.addMouseListener(menuEvent);
						}
						bulidTree(root, tree);
						insertMap(tree);
					}
				});
				LoadXmlCore.softModel();
			}
		}).start();
		
	}
	
	private Element initXML(Element targetEl){
		Element root = null;
		if(targetEl == null){
			LoadXmlCore.load();
			Element document = GotXmlDto.getInstance().getGotXMl(); 
			if(document == null){
				return root;
			}
			root = document;
		}else{
			root = targetEl;
		}
		return root;
	}
	
	public void flashTree(){
		tree.removeAll();
		table.removeAll();
		for (Shell shell : GOTMessageDialog.shells) {
			if(!shell.isDisposed()){
				shell.close();
			}
		}
		itemsMap = new HashMap<String, TreeItem>();
		ConfigComposite.tableNum = 0;
		ConfigComposite.fromNum = 0;
		itemsMap = new HashMap<String, TreeItem>();
		if(tree.getListeners(SWT.MouseDoubleClick).length == 0 ){
			addListener();
		}else{
	        menuEvent = new TreeMouseRigthMenuEvent(this);
	        tree.addMouseListener(menuEvent);
		}
		
		Thread thread = new Thread(new Runnable() {
			
			@Override
			public void run() {
				final Element root = initXML(null);
				Display.getDefault().syncExec(new Runnable() {
					@Override
					public void run() {
						bulidTree(root, tree);
						insertMap(tree);
						ConfigComposite.configComposite.text_Label_title.setText("切换方案加载完成");
						ProgressBarExchangeLayer.barExchangeLayer.shell.close();
					}
				});
				LoadXmlCore.softModel();
			}
		});
		thread.start();
	}
	
	public void afterInit(){
		if(!ConfigComposite.progressBar.getParent().isDisposed()){
			ConfigComposite.progressBar.setShellText("加载完成");
			ConfigComposite.progressBar.setProgressBar(100);
			ConfigComposite.configComposite.buttonEnable(true);
			ConfigComposite.configComposite.text_Label_title.setVisible(true);
			ConfigComposite.text_static_info();
			log.info("加载完成");
			if(LoadXmlCore.softModel){
				GOTMessageDialog.alert("进入安全模式");
			}
		}
	}
	
	private void initFont(){
		Font fonts = tree.getFont();
		FontData data = fonts.getFontData()[0];
		data.setStyle(SWT.BOLD);
		font_bold = new Font(tree.getShell().getDisplay(), data);
		int width = 25;
		int width_label = 125;
		if(!ConfigComposite.configComposite.button_label.getSelection()){
			width_label = 0;
		}
		int w = tree.getBounds().width - width;
		trclmnNewColumnText = new TreeColumn(tree, SWT.LEFT);
		trclmnNewColumnText.setWidth(w-width_label);
		trclmnNewColumnText.setText("text");
		
		trclmnNewColumnLabel = new TreeColumn(tree, SWT.RIGHT);
		trclmnNewColumnLabel.setResizable(true);
		trclmnNewColumnLabel.setWidth(width_label);
		trclmnNewColumnLabel.setText("label");
		
		tree.addControlListener(new ControlListener(){

			@Override
			public void controlMoved(ControlEvent arg0) {
				
			}

			@Override
			public void controlResized(ControlEvent arg0) {
				if(ConfigComposite.configComposite.button_label.getSelection()){
					int width = 25;
					int width_label = 125;
					int w = tree.getBounds().width - width;
					trclmnNewColumnText.setWidth(w - width_label);
					trclmnNewColumnLabel.setWidth(width_label);
				}
			}
			
		});
        setDropSource(TreeUi.this);
        setDropTarget(TreeUi.this);
	}
	
	private void initFontBean(){
		Font fonts = tree.getFont();
		FontData data = fonts.getFontData()[0];
		data.setStyle(SWT.BOLD);
		font_bold = new Font(tree.getShell().getDisplay(), data);
		int width = 5;
		if(tree.getVerticalBar().getVisible()){
			width = 25;
		}
		int width_label = 125;
		if(!ConfigComposite.configComposite.button_label.getSelection()){
			width_label = 0;
		}
		int w = tree.getBounds().width - width;
		trclmnNewColumnText = new TreeColumn(tree, SWT.LEFT);
		trclmnNewColumnText.setWidth(w-width_label);
		trclmnNewColumnText.setText("text");
		
		trclmnNewColumnLabel = new TreeColumn(tree, SWT.RIGHT);
		trclmnNewColumnLabel.setResizable(true);
		trclmnNewColumnLabel.setWidth(width_label);
		trclmnNewColumnLabel.setText("label");
		
		tree.addControlListener(new ControlListener(){

			@Override
			public void controlMoved(ControlEvent arg0) {
				
			}

			@Override
			public void controlResized(ControlEvent arg0) {
				if(ConfigComposite.configComposite.button_label.getSelection()){
					int width = 5;
					if(tree.getVerticalBar().getVisible()){
						width = 25;
					}
					int width_label = 125;
					if(!ConfigComposite.configComposite.button_label.getSelection()){
						width_label = 0;
					}
					int w = tree.getBounds().width - width;
					trclmnNewColumnText.setWidth(w - width_label);
					trclmnNewColumnLabel.setWidth(width_label);
				}
			}
			
		});
	}
	
	/**
	 * 
	 * @param 根据树节点来创建树结构
	 * @param tab
	 * @param treeItem
	 * @param expanded
	 */
	public TreeUi(Tree t, Table tab, TreeItem treeItem, boolean expanded){
		table = tab;
		tree = t;
		initFontBean();
		bulidTree(treeItem, tree, expanded);
		addListener();
        setDropSource(this);
        setDropTarget(this);
	}
	
	/**
	 * 
	 * @param 根据树节点来创建树结构
	 * @param tab
	 * @param treeItem
	 * @param expanded
	 */
	public TreeUi(Tree t, Table tab, TreeItem treeItem){
		table = tab;
		tree = t;
		initFontBean();
		bulidTree(treeItem, tree);
		addListener();
        setDropSource(this);
        setDropTarget(this);
	}
	
	/**
	 * 根据xml来创建树的子节点
	 * @param e 文档
	 * @param parentTree 父节点
	 * @param flag 循环子节点
	 */
	public void bulidTree(Element e, TreeItem parentTree, boolean flag){
		@SuppressWarnings("unchecked")
		List<Element> list = e.elements();
		for (Element element : list) {
			if(LoadXML.nodeShowRule(element)){
				TreeItem trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE);;
		        trtmNewTreeitem.setText(getTreeItemTextByXML(element));
		        trtmNewTreeitem.setExpanded(true);
	        	trtmNewTreeitem.setData("id", getTreeItemId(element));
	            if(element.attributeValue("id") != null){
	            	trtmNewTreeitem.setData("elementId", element.attributeValue("id"));
	            }
	            if(NodeGOT.getEntity(element) != null){
	            	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
	            }
	            trtmNewTreeitem.setData("elementName", element.getName());
		        trtmNewTreeitem.setImage(ComposeIMG.drawImgDef(element));
		        trtmNewTreeitem.setData("chinese","false");
		        setFont(element, trtmNewTreeitem);
		        String eName = e.getName();
		        setNumInfo(element);
		        if(eName.equals("GOT") || eName.equals("DataDictionary")){
		        	parentTree.setExpanded(true);
		        }
//		        if(e.attribute("version") != null){
//		        	parentTree.setData("items", "part");
//		        	flag = false;
//		        }
		        
		        if(flag){
		        	bulidTree(element, trtmNewTreeitem, flag);
		        }
			}
		} 
	}
	
	public void bulidChildTree(Element e, TreeItem parentTree){
		@SuppressWarnings("unchecked")
		List<Element> list = e.elements();
		for (Element element : list) {
			if(LoadXML.nodeShowRule(element)){
				TreeItem trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE);;
		        trtmNewTreeitem.setText(getTreeItemTextByXML(element));
		        trtmNewTreeitem.setExpanded(true);
	        	trtmNewTreeitem.setData("id", getTreeItemId(element));
	            if(element.attributeValue("id") != null){
	            	trtmNewTreeitem.setData("elementId", element.attributeValue("id"));
	            }
	            if(NodeGOT.getEntity(element) != null){
	            	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
	            }
	            trtmNewTreeitem.setData("elementName", element.getName());
		        trtmNewTreeitem.setImage(ComposeIMG.drawImg(element));
		        setFont(element, trtmNewTreeitem);
		        setNumInfo(element);
		        //加入map
		        this.itemsMap.put(trtmNewTreeitem.getData("id").toString(), trtmNewTreeitem);
		        bulidChildTree(element, trtmNewTreeitem);
			}
		} 
	}
	
//	public void bulidChildTreeChild(Element e, TreeItem parentTree){
//		@SuppressWarnings("unchecked")
//		List<Element> list = e.elements();
//		for (Element element : list) {
//			if(LoadXML.nodeShowRule(element)){
//				TreeItem trtmNewTreeitem = new TreeItem(parentTree, SWT.NONE);;
//		        trtmNewTreeitem.setText(getTreeItemTextByXML(element));
//		        trtmNewTreeitem.setExpanded(true);
//	        	trtmNewTreeitem.setData("id", getTreeItemId(element));
//	            if(element.attributeValue("id") != null){
//	            	trtmNewTreeitem.setData("elementId", element.attributeValue("id"));
//	            }
//	            if(NodeGOT.getEntity(element) != null){
//	            	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
//	            }
//	            trtmNewTreeitem.setData("elementName", element.getName());
//		        trtmNewTreeitem.setImage(ComposeIMG.drawImg(element));
//	        	String text = TreeChineseLabel.commitProperties(element);
//		        trtmNewTreeitem.setText(1, text);
//		        setFont(element, trtmNewTreeitem);
//		        setNumInfo(element);
//		        //加入map
//		        this.itemsMap.put(trtmNewTreeitem.getData("id").toString(), trtmNewTreeitem);
//		        bulidChildTreeChild(element, trtmNewTreeitem);
//			}
//		} 
//	}
	
	public String getTreeItemTextByXML(Element element){
        String text = LoadXML.nodeText(element);
        if("".equals(text)){
        	text = element.getName();
        }
        return text;
	}
	
	public String getTreeItemId(Element element){
		String treeItemId = "";
        TreeItem oldTreeItem = FormDataSyn.getTreeItrmByElement(element, this);
        if(oldTreeItem != null){
        	treeItemId = oldTreeItem.getData("id").toString();
        }else{
        	treeItemId = NumCore.getId();
        }
        return treeItemId;
	}
	
	public void bulidTree(final Element element, Tree parent){
		if(element == null){
			return;
		}
		
		if(!ConfigComposite.progressBar.getParent().isDisposed()){
			ConfigComposite.progressBar.setShellText("正在加载树");
			ConfigComposite.progressBar.setProgressBar(80);
		}
        final TreeItem trtmNewTreeitem = new TreeItem(parent, SWT.NONE);
        String text = LoadXML.nodeText(element);
        if("".equals(text)){
        	text = element.getName();
        }
        trtmNewTreeitem.setText(text);
        trtmNewTreeitem.setExpanded(true);
        String treeItemId = "";
        TreeItem oldTreeItem = FormDataSyn.getTreeItrmByElement(element, this);
        if(oldTreeItem != null){
        	treeItemId = oldTreeItem.getData("id").toString();
        }else{
        	treeItemId = NumCore.getId();
        }
    	trtmNewTreeitem.setData("id", treeItemId);
    	trtmNewTreeitem.setData("elementName", element.getName());
        if(element.attributeValue("id") != null){
        	trtmNewTreeitem.setData("elementId", element.attributeValue("id"));
        }
        if(NodeGOT.getEntity(element) != null){
        	trtmNewTreeitem.setData("elementEntityId", NodeGOT.getEntity(element).attributeValue("id"));
        }
        setFont(element, trtmNewTreeitem);
        trtmNewTreeitem.setImage(ComposeIMG.drawImgDef(element));
        
        bulidTree(element, trtmNewTreeitem, true);
       
	}
	
	private void bulidTree(TreeItem baseItem, Tree parent, boolean expended){
        TreeItem trtmNewTreeitem = new TreeItem(parent, SWT.NONE);
        trtmNewTreeitem.setExpanded(expended);
        FormDataSyn.restoreSyn(baseItem, trtmNewTreeitem, this, expended);
	}
	
	private void bulidTree(TreeItem baseItem, Tree parent){
        TreeItem trtmNewTreeitem = new TreeItem(parent, SWT.NONE);
        FormDataSyn.copyTreeItem(baseItem, trtmNewTreeitem, this);
	}
	
	public void loadTableValue(Table table, Element node, TreeItem trtmNewTreeitem){
		setChineseLabel(trtmNewTreeitem);
		String nodeString = node.getUniquePath();
		if(nodeString.equals(table.getData())){
			return;
		}
		table.removeAll();
		Rectangle bound = table.getBounds();
        TableColumn column = table.getColumn(0);
        column.setWidth(bound.width/2 - 5);
        column = table.getColumn(1);
        column.setWidth(bound.width/2);
        
		if(node.element("Properties") != null){
			@SuppressWarnings("unchecked")
			List<Element> elements = node.element("Properties").elements("Property");
			for (Element element : elements) {
				TableItem item = new TableItem(table, SWT.NONE);
				Element elementName = element.element("Name");
				String elementValue = GetPropertieValue.getValue(element);
//				item.setFont(font);
				item.setData(element);
				item.setData("treeItem", trtmNewTreeitem);
				item.setText(new String[]{elementName.getText(), elementValue});
			}
		}
	}
	
	public void setFont(Element node, TreeItem trtmNewTreeitem){
		String createdLayer = node.attributeValue("createdLayer");
		String modifiedLayer = node.attributeValue("modifiedLayer");
		if(createdLayer == null || modifiedLayer == null){
			return;
		}
		if(ObjectContainer.getInstance(LayerService.class).getCurrentLayer() == null){
			return;
		}
		if(createdLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()) || 
				modifiedLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())){
			trtmNewTreeitem.setFont(font_bold);
		}else{
			TreeItem item =trtmNewTreeitem.getParentItem();
			if(item != null){
				Font font = item.getFont();
				FontData data = font.getFontData()[0];
				if(data.getStyle() == SWT.BOLD){
					trtmNewTreeitem.setFont(font);
				}
			}
		}
	}

	public Tree getTree() {
		return tree;
	}

	public void setTree(Tree tree) {
		this.tree = tree;
	}

	public Table getTable() {
		return table;
	}

	public void setTable(Table table) {
		this.table = table;
	}
	
	public TreeColumn getTrclmnNewColumnLabel() {
		return trclmnNewColumnLabel;
	}

	public void setTrclmnNewColumnLabel(TreeColumn trclmnNewColumnLabel) {
		this.trclmnNewColumnLabel = trclmnNewColumnLabel;
	}
    
	//自适应宽度
/*    private void packColumns() {
		tree.getShell().getDisplay().asyncExec(new Runnable() {
			public void run() {
				TreeColumn[] treeColumns = tree.getColumns();
				for (TreeColumn treeColumn: treeColumns) {
					treeCol0umn.pack();
				}						
			}
		});
	}*/
    
	private void addListener(){
		
        tree.addListener(SWT.Selection, new Listener() {
            public void handleEvent(Event event) {
            	FormDataSyn.currentTreeUi = TreeUi.this;
                TreeItem trtmNewTreeitem = (TreeItem) event.item;
                Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                if(element != null){
                	loadChildItem(trtmNewTreeitem);
                	loadTableValue(table, element, trtmNewTreeitem);
                }
                
                int count = tree.getSelectionCount();
                if(!ctrl && count == 1){
        			selects.clear();
        			selects.add(trtmNewTreeitem);
                }
                ConfigComposite.selectNum = count;
                ConfigComposite.text_static_info();
                selected = trtmNewTreeitem;
            }
        });
        
        tree.addListener(SWT.MouseDoubleClick, new Listener() {
            public void handleEvent(Event event) {
            	int count = tree.getSelectionCount();
                if(count != 0){
                	Point point = new Point(event.x, event.y);
                	final TreeItem treeitem = tree.getItem(point);
                	if(treeitem == null){
                		event.doit = false;
                		return;
                	}
                	Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                	NodeGOT node = NodeFactory.getNode(element);
                	boolean enter = false;
                	boolean edit = false;
                	if(node.allowDcEnter().equals("true")){
                		enter = true;
                	}
                	if(node.allowEdit().equals("true")){
                		edit = true;
                	}
                	if(enter){
                		FormDataSyn.treeItemEditor(treeitem, node, edit, TreeUi.this);
                	}
                	
                }
            }
        });
        
        tree.addListener(SWT.Expand, new Listener() {
            public void handleEvent(Event event) {
            	TreeItem trtmNewTreeitem = (TreeItem) event.item;
            	if(trtmNewTreeitem == null){
            		event.doit = false;
            		return;
            	}
            	loadChildItem(trtmNewTreeitem);
            	
            	setChineseLabel(trtmNewTreeitem);
            }
            
        });
        
        tree.addListener(SWT.DefaultSelection, new Listener() {
            public void handleEvent(Event event) {
                TreeItem trtmNewTreeitem = (TreeItem) event.item;
                if(trtmNewTreeitem.getItems().length == 0){
                	Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                    bulidTree(element, trtmNewTreeitem, true);
                }
            }  
        });
        
        menuEvent = new TreeMouseRigthMenuEvent(this);
        tree.addMouseListener(menuEvent);
        
        tree.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent arg0) {
				
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				
				//切换上一个窗体
				if(arg0.stateMask == (SWT.CTRL | SWT.SHIFT) && arg0.keyCode == SWT.PAGE_UP){
					for (int i= 0; i < FormDataSyn.treeUis.size(); i ++) {
						if(FormDataSyn.treeUis.get(i).getTree() == tree){
							if(i > 0){
								FormDataSyn.treeUis.get(i - 1).getTree().setFocus();
							}
						}
					}
					TreeOperationInfo.addInfo("切换上一个窗体");
					return ;
				}
				//切换下一个窗体
				if(arg0.stateMask == (SWT.CTRL | SWT.SHIFT) && arg0.keyCode == SWT.PAGE_DOWN){
					for (int i= 0; i < FormDataSyn.treeUis.size(); i ++) {
						if(FormDataSyn.treeUis.get(i).getTree() == tree){
							if(i < FormDataSyn.treeUis.size() -1){
								FormDataSyn.treeUis.get(i + 1).getTree().setFocus();
							}
						}
					}
					TreeOperationInfo.addInfo("切换下一个窗体");
					return ;
				}
				//切换table和tree
				if(arg0.stateMask == SWT.TAB){
					String msg = "当前焦点在：";
					if(tree.forceFocus()){
						table.setFocus();
						if(table.getSelection().length == 0){
							table.setSelection(0);
						}
						
						msg += "table";
					}else{
						tree.setFocus();
						msg += "tree";
					}
					TreeOperationInfo.addInfo("切换焦点：" + msg);
					return ;
				}
				//回车编辑
				if(arg0.keyCode == 13){
					TreeItem[] items = tree.getSelection();
					if(items.length <1){
						arg0.doit = false;
						return;
					}
                 	Element element = GotXmlDto.getInstance().getCurrentElement(items[0]);
                	NodeGOT node = NodeFactory.getNode(element);
                	if(!node.allowDcEnter().equals("true")){
                		arg0.doit = false;
                		return;
                	}
                	if(!node.allowEdit().equals("true")){
                		arg0.doit = false;
                		return;
                	}
                	TreeOperationInfo.addInfo("进入编辑" + items[0].getText());
                	FormDataSyn.treeItemEditor(items[0], node, true, TreeUi.this);
				}
				//tab切换
				if(arg0.keyCode == 32){
					TreeItem[] items = tree.getSelection();
					if(items.length <1){
						arg0.doit = false;
						return;
					}
					items[0].setExpanded(!items[0].getExpanded());
				}
				//搜索Ctrl + F
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 102){
					String search = GOTMessageDialog.searchTreeItem();
					if(search != null && !"".equals(search)){
						setSelect(search, false);
					}
					TreeOperationInfo.addInfo("搜索:" + search);
					return;
				}
				
				//+W打开新窗体 
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 119){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "newWindow")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.openNewFrom(false);
							TreeOperationInfo.addInfo("打开新窗体 ");
						}
					}
					return ;
				}
				
				//+N新增 
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 110){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "new")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.AddHandle();
							TreeOperationInfo.addInfo("新增: " + treeitem.getText() + "子节点");
						}
					}
					return ;
				}
				
				//+R恢复
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 114){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "restore")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.restoreNode();
//							TreeOperationInfo.addInfo("恢复:" + treeitem.getText());	
							TreeOperationInfo.addInfo(treeitem.getText() + "恢复：" + Macros.INFO_OPR_SUCCESS);
						}
					}
					return ;
				}
				
				//+Y同步
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 121){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "sync")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.syncNodes();
							TreeOperationInfo.addInfo("同步:" + treeitem.getText());
						}
					}
					return ;
				}
				
				//+R恢复
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 121){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "restore")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.restoreNode();
							TreeOperationInfo.addInfo("恢复:" + treeitem.getText());
						}
					}
					return ;
				}
				
				//+Delete
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 127){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						String text = treeitem.getText();
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "delete")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.deleteNodeCMI(true);
							TreeOperationInfo.addInfo("删除:" + text);
						}
					}
					return ;
				}
				
				//+M方法
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 109){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "method")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.methodSet();
							TreeOperationInfo.addInfo("M恢复:" + treeitem.getText());
						}
					}
					return ;
				}
				
				//+S保存
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 115){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
						mouseRightMenuEvent.saveHandle(true);
						TreeOperationInfo.addInfo("保存:" + treeitem.getText());
					}
					return ;
				}
				
				//+Q引用列表
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 113){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						if(alowShortCut(element, "quote")){
							MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
							mouseRightMenuEvent.enterNodeRef();
							TreeOperationInfo.addInfo("引用列表:" + treeitem.getText());
						}
					}
					return ;
				}
				
				//+O命令列表
//				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 111){
//					if(tree.getSelection().length > 0){
//						GOTMessageDialog.menuSelector(tree);
//						TreeOperationInfo.addInfo("命令列表:调试隐藏功能");
//					}
//					return ;
//				}
				ConfigComposite.configComposite.setUnsavedText();
			}
		});
        
        final TableMouseEvent tableMouseEvent = new TableMouseEvent(this);
        table.addMouseListener(tableMouseEvent);
		
        table.addControlListener(new ControlListener(){

			@Override
			public void controlMoved(ControlEvent arg0) {
				
			}

			@Override
			public void controlResized(ControlEvent arg0) {
				if(table.getVisible()){
					int w = table.getBounds().width;
					if(table.getVerticalBar().getVisible()){
						w = w -25;
					}
					
					table.getColumn(0).setWidth((int)(w * 0.5) - 5);
					table.getColumn(1).setWidth((int)(w * 0.5) - 5);
				}
			}
			
		});
		
        table.addKeyListener(new KeyListener() {
			@Override
			public void keyReleased(KeyEvent arg0) {
				
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				//回车编辑
				if(arg0.keyCode == 13){
					int selectCol = table.getSelectionCount();
					if(selectCol > 0){
						final TableItem item = table.getItem(table.getSelectionIndex());
						tableMouseEvent.eidtTableItem(table, item, selectCol);
					}
				}
				
				//保存
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 115){
					if(tree.getSelection().length > 0){
						TreeItem treeitem = tree.getSelection()[0];
						Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
						MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
						mouseRightMenuEvent.saveHandle(true);
					}
					return ;
				}
				
				//进入关联
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 49){
					tableMouseEvent.enterRelation();
				}
				
				//进入追溯
				if(arg0.stateMask == SWT.CTRL && arg0.keyCode == 50){
					tableMouseEvent.enterNodeExtends();
				}
				
			}
		});
	}
	
	public void setDropSource(final TreeUi treeUi){
        /*创建拖放源*/
		ds = new DragSource(treeUi.getTree(), DND.DROP_MOVE | DND.DROP_COPY);
        /*设置传输的数据为文本型String类型*/
        ds.setTransfer(new Transfer[] { TextTransfer.getInstance() });
        /*注册当拖动源时触发的事件*/
        
        ds.addDragListener(new DragSourceListener() {
        	/*当开始拖动源控件时*/
			@Override
			public void dragFinished(DragSourceEvent arg0) {
//				System.out.println("完成");
			}

			/*设置拖放过程中传输的数据*/
			@Override
			public void dragSetData(DragSourceEvent arg0) {
				//这里必须设置拖动的传输的数据
				if(TextTransfer.getInstance().isSupportedType(arg0.dataType)){
					TreeItem[] treeitems = treeUi.getTree().getSelection();
					arg0.data = "" + FormDataSyn.treeUis.indexOf(treeUi);
					TreeOperationInfo.addInfo("当前选中：" + treeitems.length + "条");
				}
				
			}

			@Override
			public void dragStart(DragSourceEvent arg0) {
				TreeOperationInfo.addInfo("拖动开始");
	    		//拖动逻辑
	    		if(!allowDragOpr()){
	    			TreeOperationInfo.addInfo("禁止拖动");
	    			arg0.doit = false;
	    		}
	    		FormDataSyn.dragTreeUi = treeUi;
			}
        	
        });
        
//        ds.reskin(DND.ERROR_CANNOT_INIT_DROP);
	}
	
	public void setDropTarget(TreeUi treeUi){
        /*定义拖放的目标控件*/
		target = new DropTarget(treeUi.getTree(), DND.DROP_MOVE | DND.DROP_COPY);
        /*设置目标控件所接受的传输数据*/
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener(new DropTargetListener() {
        TreeItem overItem = null;
        TreeItem overItemLast = null;
        int times = 0;
        int lastY = 0;
        boolean dir = true;//true表示向下
        boolean dropFlag = false;
			@Override
			public void dragEnter(DropTargetEvent arg0) {
//				System.out.println("enter");
			}

			@Override
			public void dragLeave(DropTargetEvent arg0) {
				
			}

			@Override
			public void dragOperationChanged(DropTargetEvent arg0) {
//				System.out.println("change");
			}

			@Override
			public void dragOver(DropTargetEvent arg0) {
//				System.out.println("over");
				arg0.detail = DND.DROP_NONE;
				if((arg0.y - lastY) > 0){
					dir = true;
				}else if((arg0.y - lastY) < 0){
					dir = false;
				}
				
		        int treeY = tree.getParent().getBounds().y;
		        int up = (int) ((treeY + tree.getParent().getBounds().height) * 0.6);
		        int down = (int) ((treeY + tree.getParent().getBounds().height) * 0.8);
		        
				TreeItem[] treeitems = FormDataSyn.dragTreeUi.getTree().getSelection();
				if(treeitems == null || treeitems.length ==0){
					return;
				}
//				if(treeitems[0] == overItem){
//					arg0.feedback = DND.FEEDBACK_NONE;
//					dropFlag = false;
//					return;
//				}
				
				Element element = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
				if(element.getName().equals("TableFieldGroupItem") ){
					Element parentEl = element.getParent();
					if(parentEl != null && "RecordCM".equals(parentEl.attributeValue("name"))){
						arg0.feedback = DND.FEEDBACK_NONE;
						dropFlag = false;
						return;
					}
				}
				
				if(arg0.item != null){
					overItem = (TreeItem) arg0.item;
					if(overItemLast == null){
						overItemLast = overItem;
					}
					if(overItemLast == overItem){
						times++;
					}else{
//						times = times + 3;
						overItemLast = overItem;
						lastY = arg0.y;
					}
					
					if(times > 12 && dir && (arg0.y >= down)){
						setTopItem(dir);
						times = 12;
					}else if(times > 12 && !dir && (arg0.y <= up)){
						setTopItem(dir);
						times = 8;
					}
					
					Element hoverTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
					if(hoverTarget == null){
						arg0.feedback = DND.FEEDBACK_NONE;
						dropFlag = false;
						return;
					}
					if(allowDropOpr(element, hoverTarget) && validateDrop(element, hoverTarget, null)){
						arg0.feedback = DND.FEEDBACK_INSERT_BEFORE | DND.FEEDBACK_EXPAND;
						if(element.getName().equals("Menu")){
							arg0.detail = DND.DROP_MOVE;
						}else{
							arg0.detail = DND.DROP_COPY;
						}
						
						dropFlag = true;
						return;
					}
				}
				dropFlag = false;
				arg0.feedback = DND.FEEDBACK_SELECT ;
				TreeOperationInfo.addInfo("拖动结束");
			}
			
			/* 拖放完后触发的事件 */
			@Override
			public void drop(DropTargetEvent arg0) {
				try {
					if (dropFlag) {
//						LayerDefinationManager s = ObjectContainer.getInstance(LayerDefinationManager.class);
//						String layerDeploymentMode = s.getLayer(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()).getDeploymentMode().name();

						/*if (layerDeploymentMode.equals(LayerType.PACKAGE)) {
							GOTMessageDialog.alert("当前层为二进制层，不支持该操作");
							return;
						}*/
						
						TreeItem[] treeitems = null;
						if(FormDataSyn.dragTreeUi.selects.size() > 1 && FormDataSyn.dragTreeUi.selects.size() == FormDataSyn.dragTreeUi.getTree().getSelectionCount()){
							treeitems = FormDataSyn.dragTreeUi.selects.toArray(new TreeItem[FormDataSyn.dragTreeUi.selects.size()]);
						}else{
							FormDataSyn.dragTreeUi.selects.clear();
							treeitems = FormDataSyn.dragTreeUi.getTree().getSelection();
						}
						
						if (treeitems == null || treeitems.length == 0) {
							GOTMessageDialog.alert("未找到选中的节点");
							return;
						}
						
						TreeItem[] srcItemsNew = reverse(treeitems);
						Element srcItem = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
						
						ResolverNode rNode = ResolverNode.getNode(srcItem);
						Element dropTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
						NodeGOT node = NodeFactory.getNode(dropTarget);

						String moveType = node.moveType(srcItem, menuEvent.dragEvent);
						if (moveType.equals("append")) {
							nodeMoveHandler(treeitems, overItem, dropTarget);
							return;
						} else if (moveType.equals("switch")) {
							int index = overItem.getParentItem().indexOf(overItem);
							String treeItemId = NumCore.getId();
							Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
							Element copy = item;
							FormDataSyn.actionSyn(overItem.getParentItem(), treeItemId, copy, null, index, "new");
							FormDataSyn.deleteTreeItem(treeitems[0]);
							FormDataSyn.setUnSave(overItem);
							return;
						}
						String validateInfo = "";
						boolean isEntity = false;
						if(dropTarget.getName().equals("Menu")){
							isEntity = true;
						}else{
							isEntity = !rNode.getInfoValue("NodeType").equals("entity");
						}
						if (node.isSibling(srcItem) && isEntity) {
							// 此处为同级节点内部拖动，调整顺序
							if (treeitems[0].getParent() == overItem.getParent()) {
								String baseValidateInfo = node.validateAccpDragMove(srcItem, menuEvent.dragEvent);
								for (TreeItem treeItem : srcItemsNew) {
									srcItem = GotXmlDto.getInstance().getCurrentElement(treeItem);
									validateInfo = node.validateAccpDragMove(srcItem, menuEvent.dragEvent);
									if ((!validateInfo.equals("true") && !validateInfo.equals("down"))) {
										ConfigComposite.configComposite.set_text_op_info(srcItem.attributeValue("name") + Macros.INFO_OPR_FAIL );
										TreeOperationInfo.addInfo(srcItem.attributeValue("name") + Macros.INFO_OPR_FAIL);
										return;
									}

									if (!validateInfo.equals(baseValidateInfo)) {
										TreeOperationInfo.addErrorInfo("操作不一致");
										ConfigComposite.configComposite.set_text_op_info("操作不一致");
										return;
									}

								}
								
								if (validateInfo.equals("down")) {
									nodeMoveHandler(treeitems, overItem, dropTarget);
									return;
								}

								if (!nodeMoveHandler1(treeitems, overItem, dropTarget)) {
									return;
								}
								
							}else{
								return;
							}

						} else {
							// 可以拖放 节点逻辑 invoke
							srcItemsNew = treeitems;//此处不需要反转顺序
							node = NodeFactory.getNode(dropTarget);
							for(int i = 0; i < srcItemsNew.length ; i ++){
//						for (TreeItem treeItem : srcItemsNew) {
								srcItem = GotXmlDto.getInstance().getCurrentElement(srcItemsNew[i]);
								
								if (srcItem.equals(","))
									continue;
								if (srcItem == dropTarget)
									continue;
								validateInfo = node.validateAccpDragNew(srcItem);
								if ((!validateInfo.equals("true") && !validateInfo.equals("down"))) {
									ConfigComposite.configComposite.set_text_op_info(srcItem.attributeValue("name") + Macros.INFO_OPR_FAIL);
									TreeOperationInfo.addInfo(srcItem.attributeValue("name") + Macros.INFO_OPR_FAIL);
									return;
								}

								NodeGOT newNode = node.getAccpDragNewNode(srcItem);
								String parent = node.getAccpDragNewInsertBase();
								Element childBefore;
								Integer index = null;
								boolean addTreeItem = false;
								TreeItem parentItem = null;
								if (parent.equals("self")) {
									childBefore = newNode.getInsertChildBefore(dropTarget);
									if(overItem.getParentItem() == srcItemsNew[i].getParentItem()){
										index = overItem.getParentItem().indexOf(overItem);
									}
									if(overItem.getText().equals("Forms") || overItem.getText().equals("MenuItems") || overItem.getText().equals("Menus")){
										index = 0;
									}
									insertNode(newNode, dropTarget, childBefore, false, overItem, index);
									if(childBefore == null){
										String insertAt = newNode.getInsertAt();
										if(insertAt.equals("append")){
											index = null;
										}else{
											index = 0;
										}
									}
									parentItem = overItem;
									addTreeItem = true;
								} else if (parent.equals("parent")) {
									insertNode(newNode, dropTarget.getParent(), dropTarget, false, overItem.getParentItem(), overItem.getParentItem().indexOf(overItem) + i);
									index = overItem.getParentItem().indexOf(overItem) + i;
									parentItem = overItem.getParentItem();
									addTreeItem = true;
								} else if (parent.equals("false")) {
									return;
								}
								//执行此方法才会设置id
								newNode.doAfterDragDroped();
								
								//更新map
								if(NodeGOT.getEntity(newNode.xml.getParent()) == null){
									GotXmlDto.getInstance().addEntityElement(newNode.xml);
								}else{
									GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(newNode.xml));
								}
								
								//渲染画面
								if(addTreeItem){
								 	String treeItemId = NumCore.getId();
									FormDataSyn.actionSyn(parentItem, treeItemId, newNode.xml, node, index, "new");
								}
							}

							return;
						}
					}
				} catch (final Exception e) {
					Display.getDefault().asyncExec(new Runnable() {
						@Override
						public void run() {
							GOTMessageDialog.alert(e);
						}
					});
					e.printStackTrace();
				}
				
				
			}
			@Override
			public void dropAccept(DropTargetEvent arg0) {
//				System.out.println("accept");
			}
        	
        });
	}
	
	private Boolean allowDragOpr(){
		TreeItem[] treeSelectedItems = tree.getSelection();
		if(treeSelectedItems == null || treeSelectedItems.length == 0){
			return false;
		}
		
		Element temp = GotXmlDto.getInstance().getCurrentElement(treeSelectedItems[0]);
		String subForm = GOTHelp.getPPAttValue(temp, "Name", "SubForm");
		if("true".equals(subForm)){
			return false;
		}
		
		TreeItem parentItem = treeSelectedItems[0].getParentItem();
//		Element tempParent = temp.getParent();
		
		if(isInDragMapping(temp.getName(), null, true, false)){
			for (TreeItem item : treeSelectedItems){
				Element obj = GotXmlDto.getInstance().getCurrentElement(item);
				if(item.getParentItem() != parentItem){
					return false ; 
				}
//				if(!obj.getParent().asXML().equals(tempParent.asXML())){
//					return false ; 
//				}
				
				if(obj.attribute("saved") != null )
					return false;
			}
			
			return true ;
		}
		
		return false ;
	}
	
	public  Boolean isInDragMapping(String src, String des, Boolean checkFrom, Boolean checkTo){
		if(checkFrom == null){
			checkFrom = true;
		}
		if(checkTo == null){
			checkTo = true;
		}
		if(checkFrom && checkTo){
			return FromToMapping.fromToMap.containsKey(src + des);
		}else if(checkFrom){
			for (String key : FromToMapping.fromToMap.keySet()) {
				if(key.contains(src)){
					return true;
				}
			}

		}else if(checkTo){
			for (String key : FromToMapping.fromToMap.keySet()) {
				if(key.contains(des)){
					return true;
				}
			}
		}

		return false ;
	}
	
	private Boolean allowDropOpr(Element src, Element target){
		if(src == null){
			return false;
		}
		Boolean allow = isInDragMapping(src.getName(), target.getName(), null, null);
		if(allow){
			if(src.getName().equals("Table") || src.getName().equals("DataType")){
				if(!checkClobAndBlobField(src, target.getName())){
					TreeOperationInfo.addInfo("包含有Clob或Blob属性的实体节点或子节点，不能被拖动到" + target.getName());
					ConfigComposite.configComposite.set_text_op_info("包含有Clob或Blob属性的实体节点或子节点，不能被拖动到" + target.getName());
					return false;
				}
			}
			
			//这里是防止TableField拖动到RecIdx，导致后台报错
			if(src.getName().equals("TableField") && target.getName().equals("TableIndex") && "RecIdx".equals(target.attributeValue("name"))){
				return false;
			}
			if(target.getParent() != null){
				if(src.getName().equals("TableField") && target.getParent().getName().equals("TableIndex") && "RecIdx".equals(target.getParent().attributeValue("name"))){
					return false;
				}
			}

			String result = FromToMapping.fromToMap.get(src.getName() + target.getName());
			if( "true".equals(result)){
//				if(src.getName().equals("Menu") && !src.asXML().equals(target.asXML())){
//					return true;
//				}
				if(NodeGOT.getEntity(src).asXML().equals(NodeGOT.getEntity(target).asXML())){
					return true;
				}else{
					return false;
				}
			}else if("ref".equals(result)){
				if(src.getParent().asXML().equals(target.getParent().asXML())){
					return true;
				}else{
					return false;
				}
			}else{
				return true ;
			}
		}
		
		return false ;
	}
	
	private boolean checkClobAndBlobField(Element xml, String tarName){
		String name = xml.getName();
		if(name.equals("Table")){
			List<Element> tableFields = xml.element("TableFields").elements("TableField");
			for (Element element : tableFields) {
				String type = element.attributeValue("type");
				if(type.equals("Clob") || type.equals("Blob")){
					return false;
				}
			}
		}else if(name.equals("DataType")){
			String type = xml.attributeValue("type");
			if(type.equals("Clob") || type.equals("Blob")){
				if(tarName.startsWith("Form")){
					return false;
				}
			}
		}

		
		return true;
	}
	private Boolean validateDrop(Element item, Element dropItem, Boolean down){
		down = down == null ? true : down;
		if(down == false && dropItem.getParent() == item.getParent() && dropItem.getParent().indexOf(dropItem) == (item.getParent().indexOf(dropItem)+1))
			return false;
		Element parent = dropItem;
		while(parent!=null && !NodeGOT.isEntity(parent)){
			if(parent.asXML().equals(item.asXML()))
				return false;
			parent = parent.getParent();
		}
		return true;
	}
	

	public TreeItem[] reverse(TreeItem[] array){
		TreeItem [] newArray = new TreeItem[array.length];
        for(int i=0; i<newArray.length; i++){
            newArray[i] = array[array.length - i - 1];
        }
        return newArray;
	}
	
	private boolean nodeMoveHandler(TreeItem[] treeitems, TreeItem overItem, Element dropTarget){
		for (int i = 0; i < treeitems.length; i++) {
			Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
			if(!validateDrop(item, dropTarget, null)){
				return false;
			}
		}
		for (int i = 0; i < treeitems.length; i++) {
			Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
			Element copy = item.createCopy();
			GOTXMLHelper.deleteNode(item);
			//TODO 此处删除节点之后要重新拉取节点，坑！！！！
			dropTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
			dropTarget.add(copy.detach());
			GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(dropTarget));
		 	String treeItemId = NumCore.getId();
			FormDataSyn.actionSyn(overItem, treeItemId, copy, null, null, "new");
			FormDataSyn.deleteTreeItem(treeitems[i]);
		}
		return true;
	}
	
	private boolean nodeMoveHandler1(TreeItem[] treeitems, TreeItem overItem, Element dropTarget){
		for (int i = 0; i < treeitems.length; i++) {
			Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
			if(!validateDrop(item, dropTarget, null)){
				return false;
			}
		}
		TreeItem itemParent = treeitems[0].getParentItem();
		boolean after = itemParent == null ? true : false;
		int index = overItem.getParentItem().indexOf(overItem);
		TreeItem overItemParent = overItem.getParentItem();
		for (int i = 0; i < treeitems.length; i++) {
			Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
			Element copy = item;
			GOTXMLHelper.deleteNode(item);
			//TODO 此处删除节点之后要重新拉取节点
			dropTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
		 	String treeItemId = NumCore.getId();
		 	if(after){
		 		if(!item.getName().equals("Menu")){
		 			FormDataSyn.actionSyn(overItemParent, treeItemId, copy, null, null, "new");
		 			dropTarget.getParent().add(copy.detach());
		 		}else{
		 			FormDataSyn.actionSyn(overItemParent, treeItemId, copy, null, null, "exchange");
		 		}
		 	}else{
		 		if(!item.getName().equals("Menu")){
		 			GOTHelp.insertChildBefore(dropTarget.getParent(), dropTarget, copy);
		 			GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(dropTarget));
		 			FormDataSyn.actionSyn(overItemParent, treeItemId, copy, null, i + index, "new");
		 		}else{
		 			FormDataSyn.actionSyn(overItemParent, treeItemId, copy, null, i + index, "exchange");
		 		}
		 	}
			FormDataSyn.deleteTreeItem(treeitems[i]);
			
		}
		return true;
	}
	
	@SuppressWarnings("unchecked")
	private void insertNode(NodeGOT node, Element parent, Element childBefore, Boolean autoEnterEdit, TreeItem overItem, Integer index){
		node.doBeforeInsert();
		Element xml = node.xml;
		if(parent == null){
			parent = GotXmlDto.getInstance().getCurrentElement(overItem);
		}
		
		if(childBefore == null){
			String insertAt = node.getInsertAt();
			if(insertAt.equals("append")){
				parent.add(xml.detach());
				index = null;
			}else{
				parent.elements().add(0, xml);
				index = 0;
			}
		}else{
			Element parentChild = null;
			if(childBefore.getParent() == null){
				//TODO 当父节点是s节点的时候，这里没必要写入父节点
//				parentChild = GotXmlDto.getInstance().getCurrentEntytyElement(childBefore.getName() + "s");
			}else{
				parentChild = childBefore.getParent();
				GOTHelp.insertChildBefore(parentChild, childBefore, xml);
			}
			
		}
		node.doAfterInsert();
	}
	
	public void setSelect(String search, boolean openWin){
		Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
		Matcher m = p.matcher(search);
		TreeItem[] items = null;
		TreeItem entityItem = getSearchEntityTreeItem(search);
		if(entityItem == null){
			items = tree.getItems();
		}else{
			items = entityItem.getItems();
		}
		//匹配中文
		if(m.find()){
			TreeItem item = tree.getSelection()[0];
			String itText = item.getText();
			if(itText.equals("Enums") || itText.equals("DataTypes") || itText.equals("Tables") || itText.equals("Maps")
					|| itText.equals("Menus") || itText.equals("MenuItems") || itText.equals("Forms") || itText.equals("Classes")){
				items = item.getItems();
			}
			
			for (int i = 0; i < items.length; i++) {
				String Label = items[i].getText(1);
				if(Label.equals(search) || (search.contains("*") && Label.contains(search.replace("*", ""))) || Label.equals("【" + search + "】")){
					if(openWin){
						new TreeUiBean(items[i], false, true);
					}else{
						tree.setSelection(items[i]);
						Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
						this.loadTableValue(table, temp, items[i]);
						ConfigComposite.configComposite.set_text_Label_title(items[i]);
						break;
					}
					return;
				}else{
					findTreeItemEntity(items[i], search, openWin);
				}
			}
			
		}else{
			String childId = null;
			if(search.contains(".")){
				String[] temp = search.split("\\.");
				if(temp.length == 2){
					search = temp[0];
					childId = temp[1];
				}
			}
			for (int i = 0; i < items.length; i++) {
				Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
				if(search.equals(element.attributeValue("id"))){
					if(childId != null){
						findTreeItemChild(items[i], childId);
					}else{
						if(openWin){
							new TreeUiBean(items[i], false, true);
						}else{
							tree.setSelection(items[i]);
							Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
							this.loadTableValue(table, temp, items[i]);
							ConfigComposite.configComposite.set_text_Label_title(items[i]);
						}
					}
					return;
				}else{
					findTreeItem(items[i], search, childId, openWin);
				}

			}
		}
	}
	
	public void openEntityShell(String search){
		TreeItem[] items = FormDataSyn.treeUis.get(0).getTree().getItems();
		for (int i = 0; i < items.length; i++) {
			Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
			if(element.attribute("version") != null){
				if(search.equals(element.attributeValue("id"))){
					new TreeUiBean(items[i], false, true);
					return;
				}
			}else{
				findTreeItem(items[i], search, null, true);
			}
		}
	}
	
	private void findTreeItem(TreeItem treeItemParent, String search, String childId, boolean openWin){
		TreeItem[] items = treeItemParent.getItems();
		for (int i = 0; i < items.length; i++) {
			Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
			if(search.equals(element.attributeValue("id"))){
				if(childId != null){
					findTreeItemChild(items[i], childId);
				}else{
					if(openWin){
						new TreeUiBean(items[i], false, true);
					}else{
						tree.setSelection(items[i]);
						Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
						this.loadTableValue(table, temp, items[i]);
						ConfigComposite.configComposite.set_text_Label_title(items[i]);
					}
				}
				return;
			}else{
				findTreeItem(items[i], search, childId, openWin);
			}
		}
	}
	
	private void findTreeItemChild(TreeItem treeItemParent, String search){
		TreeItem[] items = treeItemParent.getItems();
		for (int i = 0; i < items.length; i++) {
			Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
			if(search.equals(element.attributeValue("id"))){
				tree.setSelection(items[i]);
				Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
				this.loadTableValue(table, temp, items[i]);
				ConfigComposite.configComposite.set_text_Label_title(items[i]);
				return;
			}else{
				findTreeItemChild(items[i], search);
			}
		}
	}
	
	private void findTreeItemEntity(TreeItem treeItemParent, String search, boolean openWin){
		TreeItem[] items = treeItemParent.getItems();
		for (int i = 0; i < items.length; i++) {
			String Label = items[i].getText(1);
			if(Label.equals(search) || (search.contains("*") && Label.contains(search.replace("*", ""))) || Label.equals("【" + search + "】")){
				if(openWin){
					new TreeUiBean(items[i], false, true);
				}else{
					tree.setSelection(items[i]);
					Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
					this.loadTableValue(table, temp, items[i]);
					ConfigComposite.configComposite.set_text_Label_title(items[i]);
					break;
				}
				return;
			}else{
				findTreeItemEntity(items[i], search, openWin);
			}
		}
	}
	
	private void setNumInfo(Element element){
		if(element.getName().equals("Table")){
			ConfigComposite.tableNum++;
			String createBy = gongqi.designer.utils.GOTHelper.getPropertyValue(element, "CreatedBy");
			if(!"sys".equals(createBy)){
				ConfigComposite.tableBusNum++;
			}
		}else if(element.getName().equals("Form")){
			ConfigComposite.fromNum ++;
		}
	}
	
	public void setChineseLabel(TreeItem treeitem){
    	if(treeitem == null){
    		return;
    	}
    	
    	if(StringUtils.isNotBlank(treeitem.getText(1))){
        	if(!"false".equals(String.valueOf(treeitem.getData("chinese")))){
        		return;
        	}
    	}

    	String itemName = treeitem.getText();
    	if(itemName.equals("GOT") || itemName.equals("DataDictionary") || itemName.equals("Enums")
    			|| itemName.equals("DataTypes") || itemName.equals("Tables")|| itemName.equals("Menus") || itemName.equals("Forms")){
        	TreeItem[] treeitems = treeitem.getItems();
        	for (TreeItem child : treeitems) {
            	Element element = GotXmlDto.getInstance().getCurrentElement(child);
            	if(child.getText(1) == null || child.getText(1).equals("")){
            		child.setText(1, TreeChineseLabel.commitProperties(element));
//            		child.setData("chinese", "true");
            	}
    		}
    	}else if(ConfigComposite.configComposite.button_label.getSelection()){
        	Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
        	String text = TreeChineseLabel.commitProperties(element);
        	treeitem.setText(1, text);
        	if(!"".equals(text)){
        		treeitem.setData("chinese", "true");
        	}
        	TreeItem[] treeitems = treeitem.getItems();
        	for (TreeItem child : treeitems) {
        		setChineseLabel(child);
    		}
    	}

 	}
	
	public void cleanMaps(TreeItem treeItem){
		TreeItem[] items = treeItem.getItems();
		for (TreeItem treeItem2 : items) {
			String id = treeItem2.getData("id").toString();
			itemsMap.remove(id);
			cleanMaps(treeItem2);
		}
	}
	
	public void insertMap(Tree tree_){
		TreeItem[] items = tree_.getItems();
		for (TreeItem treeItem : items) {
			this.itemsMap.put(treeItem.getData("id").toString(), treeItem);
			insertMap(treeItem);
		}
	}
	
	public void insertMap(TreeItem treeItems){
		TreeItem[] items = treeItems.getItems();
		for (TreeItem treeItem : items) {
			this.itemsMap.put(treeItem.getData("id").toString(), treeItem);
			if(treeItem.getItems().length > 0){
				insertMap(treeItem);
			}
		}
	}
	
	public TreeItem getSearchEntityTreeItem(String search){
		TreeItem[] items = tree.getSelection();
		if(items.length == 0){
			return null;
		}
		Element itemData = GotXmlDto.getInstance().getCurrentElement(items[0]);
		Element eneity = NodeGOT.getEntity(itemData);
		if(eneity == null){
			return null;
		}
		if(eneity.attributeValue("id").equals(itemData.attributeValue("id")) && search.length() > 5){
			return null;
		}
		TreeItem item = FormDataSyn.getTreeItrmByElement(eneity, this);
		return item;
	}
	
	private void setTopItem(boolean dir){
		TreeItem item = tree.getTopItem();
		if(dir){
			//自己是否展开
			if(item.getExpanded()){
				TreeItem[] child = item.getItems();
				tree.setTopItem(child[0]);
			}else{
				topItem(item, dir);
			}
		}else{
			topItem(item, dir);
		}
		
	}
	
	private void topItem(TreeItem item, boolean dir){
		if(dir){
			TreeItem parentItem = item.getParentItem();
			if(parentItem != null){
				TreeItem[] child = parentItem.getItems();
				int index = parentItem.indexOf(item);
				if(index < child.length - 1){
					tree.setTopItem(child[index + 1]);
				}else{
					topItem(parentItem, dir);
				}
			}
		}else{
			TreeItem parentItem = item.getParentItem();
			if(parentItem != null){
				TreeItem[] child = parentItem.getItems();
				int index = parentItem.indexOf(item);
				if(index > 0){
					tree.setTopItem(child[index - 1]);
				}else{
					tree.setTopItem(parentItem);
				}
			}
		}
	}
	
	public boolean alowShortCut(Element node, String op){
    	NodeGOT.setContextMenu(node);
        @SuppressWarnings("unchecked")
		List<Element> elements = NodeGOT.treeRightMenuData.elements("menuitem");
        for (Element element : elements) {
        	if(op.equals(element.attributeValue("func")) && "true".equals(element.attributeValue("visible"))){
        		return true;
        	}
		}
		return false;
	}

	public void loadChildItem(TreeItem trtmNewTreeitem){
    	if(trtmNewTreeitem.getData("items") != null && trtmNewTreeitem.getData("items").equals("part")){
    		trtmNewTreeitem.removeAll();
    		String treeItemId = String.valueOf(trtmNewTreeitem.getData("id"));
    		TreeItem base = FormDataSyn.treeUis.get(0).itemsMap.get(treeItemId);
//        	Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
//        	bulidChildTreeChild(element, trtmNewTreeitem);
    		FormDataSyn.copyTreeItem(base, trtmNewTreeitem, this);
        	trtmNewTreeitem.setData("items", "all");
    	}
	}
}
