package info.gongqi.got.ui;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

import info.gongqi.got.util.GOTMessageDialog;

public class TypeSelector extends Dialog {

	protected String result = "";
	protected Shell shell;
	
	private List<String> array;
	private org.eclipse.swt.widgets.List list;

	/**
	 * Create the dialog.
	 * @param parent
	 * @param style
	 */
	public TypeSelector(Shell parent, int style, List<String> list) {
		super(parent, style);
		array = list;
		setText("选择类型");
	}

	/**
	 * Open the dialog.
	 * @return the result
	 */
	public String open() {
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return result;
	}

	/**
	 * Create contents of the dialog.
	 */
	private void createContents() {
		shell = new Shell(getParent(), getStyle());
		shell.setSize(300, 500);
		shell.setText(getText());
		
        Monitor monitor = shell.getMonitor();  
        Rectangle bounds = monitor.getBounds ();  
        Rectangle rect = shell.getBounds ();  
        int x = bounds.x + (bounds.width - rect.width) / 2;  
        int y = bounds.y + (bounds.height - rect.height) / 2;  
        shell.setLocation (x, y);
        shell.setLayout(new FormLayout());
        
        list = new org.eclipse.swt.widgets.List(shell, SWT.BORDER | SWT.V_SCROLL);
        FormData fd_list = new FormData();
        fd_list.bottom = new FormAttachment(100, -25);
        fd_list.right = new FormAttachment(100, 0);
        fd_list.top = new FormAttachment(0);
        fd_list.left = new FormAttachment(0);
        list.setLayoutData(fd_list);
		Font font = new Font(shell.getDisplay(), "微软雅黑", 9, SWT.BOLD);
		list.setFont(font);
		list.addKeyListener(new KeyListener() {
			
			@Override
			public void keyReleased(KeyEvent var1) {
				
			}
			
			@Override
			public void keyPressed(KeyEvent var1) {
				if(var1.keyCode == 13){
        			int num = list.getSelectionIndex();
        			result = array.get(num);
        			shell.dispose();
				}
			}
		});
		
		list.addMouseListener(new MouseListener() {
			
			@Override
			public void mouseUp(MouseEvent var1) {
				
			}
			
			@Override
			public void mouseDown(MouseEvent var1) {
				
			}
			
			@Override
			public void mouseDoubleClick(MouseEvent var1) {
    			int num = list.getSelectionIndex();
    			result = array.get(num);
    			shell.dispose();
			}
		});
		
        Button btnNewButton = new Button(shell, SWT.NONE);
        btnNewButton.addSelectionListener(new SelectionAdapter() {
        	@Override
        	public void widgetSelected(SelectionEvent e) {
        		if(list.getSelection().length >0){
        			int num = list.getSelectionIndex();
        			result = array.get(num);
        			shell.close();
        		}
        	}
        });
        FormData fd_btnNewButton = new FormData();
        fd_btnNewButton.left = new FormAttachment(0);
        fd_btnNewButton.right = new FormAttachment(50, 0);
        fd_btnNewButton.top = new FormAttachment(list,0);
        fd_btnNewButton.bottom = new FormAttachment(100,0);
        btnNewButton.setLayoutData(fd_btnNewButton);
        btnNewButton.setText("确定");
        
        Button btnCancel = new Button(shell, SWT.NONE);
        btnCancel.addSelectionListener(new SelectionAdapter() {
        	@Override
        	public void widgetSelected(SelectionEvent e) {
        		shell.close();
        	}
        });
        FormData ce_btnNewButton = new FormData();
        ce_btnNewButton.left = new FormAttachment(btnNewButton,0);
        ce_btnNewButton.right = new FormAttachment(100, 0);
        ce_btnNewButton.top = new FormAttachment(list,0);
        ce_btnNewButton.bottom = new FormAttachment(100,0);
        btnCancel.setLayoutData(ce_btnNewButton);
        btnCancel.setText("取消");
        
		for (String string : array) {
			String[] temp = string.split("\\.");
			if(temp.length == 2){
				list.add(temp[1]);
			}else if(temp.length == 1){
				list.add(temp[0]);
			}
			
		}

		if(list.getItems().length > 0){
			list.setSelection(0);
		}
		GOTMessageDialog.shells.add(shell);
	}
}
