package info.gongqi.got.ui.event;

import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.help.GOTPPHelpUtil;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.TreeChineseLabel;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.NumCore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.event.ValidationResult;
import client.gongqi.designer.event.ValidationResultEvent;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTHelper;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

public class TableMouseEvent extends MouseAdapter{
	
	public TreeUi treeUi;

	@Override
	public void mouseDoubleClick(MouseEvent e) {
		Table table = treeUi.getTable();
		int count = table.getSelectionCount();
		if(count != 0 ){
			final TableItem item = table.getItem(table.getSelectionIndex());
			//获取鼠标点击的位置
			Point point = new Point(e.x, e.y);
			//鼠标点击所在cell的列
			int tmpCol = 0;
			//获取所点击的cell
			for(int i = 0; i < table.getColumnCount(); i++){
				Rectangle rect = item.getBounds(i);
				if (rect.contains(point)) {
					tmpCol = i;
					break;
				}
			}
			final int selectCol = tmpCol;
			if(selectCol == 0){//名称不允许修改
				return;
			}
			if(first){
				first = false;
			}
			
			eidtTableItem(table, item, selectCol);
		}
	}

	@Override
	public void mouseDown(MouseEvent e) {
    	if(e.button == 3){
    		Menu menu=new Menu(treeUi.getTable());
    		@SuppressWarnings("unchecked")
			List<Element> lists = NodeGOT.gridRightMenuData.elements();
    		for (final Element element : lists) {
    			MenuItem enterRelation=new MenuItem(menu, SWT.PUSH);
        		enterRelation.setText(element.attributeValue("label"));
        		enterRelation.addSelectionListener(new SelectionListener() {
    				
    				@Override
    				public void widgetSelected(SelectionEvent arg0) {
    					if(element.attributeValue("func").equals("showXML")){
    						Element item = (Element) treeUi.getTable().getSelection()[0].getData();
    						GOTMessageDialog.showXmlInfo(MouseRightMenuEvent.formatXml(item.asXML()), "信息");
    					}else if(element.attributeValue("func").equals("enterRelation")){
    						enterRelation();
    					}else if(element.attributeValue("func").equals("enterNodeExtends")){
    						enterNodeExtends();
    					}else if(element.attributeValue("func").equals("modifyExtends")){
    						modifyExtends();
    					}else if(element.attributeValue("func").equals("help")){
    						help();
    					}
    					
    				}
    				
    				@Override
    				public void widgetDefaultSelected(SelectionEvent arg0) {
    					
    				}
    			});
			}
    		
    		treeUi.getTable().setMenu(menu);
    	}
	}

	@Override
	public void mouseUp(MouseEvent e) {
		super.mouseUp(e);
	}

	public TableMouseEvent(TreeUi treeUi) {
		super();
		this.treeUi = treeUi;
	}
	
	private void handle(Element element, NodeGOT node, String newStr, String oldStr, TableItem item){
		try {
			String name = item.getText();
			element.element("Value").setText(newStr);
			String refentityId = element.attributeValue("refentityid");
			node.setRefentityId(refentityId);
			List<ValidationResult> array = null ;
			ValidationResultEvent resultEvent = node.validateProperty(element);
			if(resultEvent!=null){
				array = resultEvent.results;
			}
			if(array == null){
				resultEvent = node.validatePropertyChanged(element);
				if(resultEvent != null)
					array = resultEvent.results;
			}
			
			if(array==null){
				node.doAfterPropertyModified(element, oldStr);
				node.setRefentityId("");
				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(node.xml));
				if(!element.elementText("Value").equals(oldStr)){
					ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_MODIFIEDSUCCESS);
					item.setText(1, newStr);
					TreeItem treeItem = (TreeItem) item.getData("treeItem");
					Element elementTar = GotXmlDto.getInstance().getCurrentElement(treeItem);
					String id = treeItem.getData("id").toString();
					if(name.equals("Extends")){//继承要修改关联继承
						Element entity = NodeGOT.getEntity(elementTar);
						String label = TreeChineseLabel.commitProperties(elementTar);
						if("0".equals(entity.attributeValue("saved"))){
							if(entity.getName().equals("Table")){
								if(checkIsNewItem(elementTar.attributeValue("id"), entity.attributeValue("id"))){
									if(newStr.contains(".")){
										String[] names = newStr.split("\\.");
										newStr = names[names.length - 1];
									}
									String newName = setUniqueName(newStr, elementTar);
									elementTar.addAttribute("name", newName);
									updateInnerItemName(entity, elementTar.attributeValue("id"), newName, label);
								}
							}
						}
						GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(elementTar));
					}else if(name.equals("GroupType") && "Group".equals(element.getParent().getParent().attributeValue("type"))){
						TableItem[] items = item.getParent().getItems();
						for (TableItem tableItem : items) {
							if(tableItem.getText().equals("Layout")){
								Element eleItem = (Element) tableItem.getData();
								tableItem.setText(1,eleItem.elementText("Value"));
							}
						}
					}else if(name.equals("DataSource") && "FieldGroup".equals(element.getParent().getParent().attributeValue("type"))){
						TableItem[] items = item.getParent().getItems();
						for (TableItem tableItem : items) {
							if(tableItem.getText().equals("FieldGroup")){
								Element eleItem = (Element) tableItem.getData();
								tableItem.setText(1,eleItem.elementText("Value"));
							}else if(tableItem.getText().equals("Component")){
								Element eleItem = (Element) tableItem.getData();
								tableItem.setText(1,eleItem.elementText("Value"));
							}
						}
					}else if(name.equals("Component") && "FieldGroup".equals(element.getParent().getParent().attributeValue("type"))){
						String fgId = treeItem.getData("id").toString();
						for (TreeUi treeUi : FormDataSyn.treeUis){
							TreeItem itemTar = treeUi.itemsMap.get(fgId);
							if(itemTar != null){
								itemTar.removeAll();
							}
						}
						List<Element> elements = elementTar.elements("FormItem");
						for (int i = 0; i < elements.size(); i++) {
							FormDataSyn.actionSyn(treeItem, NumCore.getId(), elements.get(i), null, i, "new");
						}
					}
					
					//TODO 此处的逻辑是：刷新所有窗口的树节点和table，并设置未保存
					for (TreeUi treeUi : FormDataSyn.treeUis) {
						TreeItem item2 = treeUi.itemsMap.get(id);
						if(item2 != null && item2 == treeItem){
							//必须重新获取xml
							Element element2 = GotXmlDto.getInstance().getCurrentElement(item2);
							item2.setText(treeUi.getTreeItemTextByXML(element2));
							//刷新选中节点的属性和标签
							if(treeUi.getTree().getSelection().length > 0){
								if(treeUi.getTree().getSelection()[0] == item2){
									item2.setData("chinese", "false");
									treeUi.loadTableValue(treeUi.getTable(), elementTar, item2);
								}
							}
							
							TreeItem item_ = FormDataSyn.getEntityTreeItem(item2);
							if(item_ != null){
								FormDataSyn.setUnSave(item_);
							}
						}
					}
					
				}else{
					ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
				}
			}else{
				element.element("Value").setText(oldStr);
				String info = element.elementText("Name") + ": ";
				for(ValidationResult r: array){
					info += r.errorMessage;
				}
				ConfigComposite.configComposite.set_text_op_info(info);
			}
		} catch (final Exception e) {
			e.printStackTrace();
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					GOTMessageDialog.alert(e);
				}
			});
		}
	}
	
	public void enterRelation(){
		TableItem[] item = treeUi.getTable().getSelection();
		if(item.length == 0){
			return ;
		}
		Element selectedItem = (Element) item[0].getData();
		if(selectedItem != null){
			String innerId = null;
			Element entity = null;
			if(selectedItem.attribute("innerid")!= null){
				innerId = selectedItem.attributeValue("innerid");
				entity = NodeGOT.getEntity(selectedItem);
			}else if(selectedItem.attribute("refinnerid")!= null ){
				innerId = selectedItem.attributeValue("refinnerid");
				entity = GOTHelper.getEntity(selectedItem.attributeValue("refentityid"), null);
			}else if(selectedItem.attribute("refentityid") != null){
				entity = GOTHelper.getEntity(selectedItem.attributeValue("refentityid"), null);
				innerId = null;
			}
			
			
			if(entity != null){
				if("false".equals(entity.attributeValue("fixVisible"))){
					return;
				}
				if(!entity.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()) && 
						entity.attribute("visible") != null && entity.attributeValue("visible").equals("false")){
					return;
				}
				TreeUiBean bean = new TreeUiBean(FormDataSyn.getTreeItrmByElement(entity, null), false, false);
				for (TreeItem iterable_element : bean.tree.getItems()) {
					expendItems(iterable_element, innerId, bean);
				}
			}

		}
	}
	
	public void expendItems(TreeItem item, String innerId, TreeUiBean bean){
		item.setExpanded(true);
		if(innerId != null && !innerId.equals("")){
			Element element = GotXmlDto.getInstance().getCurrentElement(item);
			if(innerId.equals(element.attributeValue("id"))){
				item.getParent().setSelection(item);
				bean.treeUip.loadTableValue(bean.table, element, item);
			}
		}
		for (TreeItem temp : item.getItems()) {
			expendItems(temp, innerId, bean);
		}
	}
	
	public void enterNodeExtends(){
		TableItem itemTable = treeUi.getTable().getSelection()[0];
		TreeItem treeItem = (TreeItem) itemTable.getData("treeItem");
		Element item = GotXmlDto.getInstance().getCurrentElement(treeItem);
		Element _entity = NodeGOT.getEntity(item);
		
		if(_entity==null)
			return;
		
		String _entityId = _entity.attributeValue("id");
		String _innerId;
		if(_entityId.equals(item.attributeValue("id"))){
			_innerId = null;
		}else{
			_innerId = item.attributeValue("id");
		}

		String result = "";
		try {
			result = LoadXmlCore.gotServices.getNodeExtends(item.getName(), _entityId, _innerId);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		rpc_result_getNodeRef(result);
	}
	
	private void rpc_result_getNodeRef(String result){
		if(result!=null){
			Element xml = GOTXMLHelper.createElementByXMLString(result);
			GOTMessageDialog.showEnterNodeRef(xml);
		}
		
	}
	
	private void modifyExtends(){
		TableItem tableitem = treeUi.getTable().getSelection()[0];
		Element selectedItem = (Element) tableitem.getData();
		TreeItem node =  (TreeItem) tableitem.getData("treeItem");
		if(selectedItem != null && (selectedItem.attribute("refentityid") != null || selectedItem.attribute("refinnerid") != null  
				|| selectedItem.attribute("innerid") != null )){
			GOTMessageDialog.modifyExtendsDialog(selectedItem);
			Element element = GotXmlDto.getInstance().getCurrentElement(node);
			treeUi.loadTableValue(treeUi.getTable(), element, node);
		}
		
	}
	
	private void help(){
		TableItem tableitem = treeUi.getTable().getSelection()[0];
		Element selectedItem = (Element) tableitem.getData();
		Element entity = NodeGOT.getEntity(selectedItem);
		String path = selectedItem.getPath();
		String propertyName = selectedItem.elementText("Name");
		String type = entity.getName();
		if(type.equals("DataType")){
			String type_ = entity.attributeValue("type");
			type += "-" + type_;
		}
		String xml = GOTPPHelpUtil.getPPHelpText(type, path, propertyName);
//		if(entity != null){
//			String xml = "";
//			if(entity == selectedItem){
//				xml = "实体节点：" + entity.getName() + "\r\n" + 
//						"属性：" + selectedItem.elementText("Name");
//			}else{
//				xml = "实体节点：" + entity.getName() + "\r\n" + 
//						"内部节点：" + node.getData("elementName") + "\r\n" +
//						"属性：" + selectedItem.elementText("Name");
//			}
//			System.out.println(selectedItem.getPath());
//			
//		}
		GOTMessageDialog.showXmlInfo(xml, "帮助");
		
	}
	
	public void eidtTableItem(final Table table, final TableItem item, final int selectCol){
		final Element element = (Element) item.getData();
		String propertyName = element.elementText("Name");
		final NodeGOT node = NodeFactory.getNode(element.getParent().getParent());
		String allowInfo = node.allowPropertyEdit(propertyName);
		if(!allowInfo.equals(Macros.INFO_TRUE)){
			if(!allowInfo.equals(Macros.INFO_FALSE)){
				TreeOperationInfo.addErrorInfo(allowInfo);
				ConfigComposite.configComposite.set_text_op_info(allowInfo);
			}
			return ;
		}
		
		String proType = node.rNode.getPropertyValue(propertyName,"Type");
		
		final TableEditor editor = new TableEditor(table); 
		Control oldEditor = editor.getEditor();
		if (oldEditor != null){
			oldEditor.dispose();
		}
		
		if(proType.equals("enum") || proType.equals("comboBox") || proType.equals("boolean") || propertyName.equals("DataMethod")){
			Element parent = element.getParent().getParent();
			List<String> array = node.getPropertyItemEditorArray(propertyName, "", parent);
			if(array != null){
				//排序
				Collections.sort(array);
				comboEdit(table, item, selectCol, element, editor, array, node);
			}
			return;
		}else{
			textEdit(table, item, selectCol, element, editor, node);
		}
		
	}
	
	public boolean first = true;
	
	public String[] selectItems(String[] strs, String tar){
		tar = tar.trim();
		List<String> lists = new ArrayList<>();
		for (String temp : strs) {
			String last = "";
			if(temp.contains(".")){
				String[] name = temp.split("\\.");
				last = name[name.length - 1];
			}
			if(temp.toLowerCase().startsWith(tar.toLowerCase()) || temp.equals("") || last.toLowerCase().startsWith(tar.toLowerCase())){
				lists.add(temp);
			}
		}
		return lists.toArray(new String[lists.size()]);
	}
	
	public void textEdit(final Table table, final TableItem item, final int selectCol, final Element element, final TableEditor editor,final NodeGOT node){
		final int selectionIndex = table.getSelectionIndex();
		if(item.getText().equals("DisplayStyle")){
			String orgText = item.getText(1);
			String aValue = GOTMessageDialog.displayStyleDialog(orgText);
			if(StringUtils.isNotBlank(aValue) && !aValue.equals(orgText)){
				element.element("Value").setText(aValue);
				item.setText(1, aValue);
				Element entity = NodeGOT.getEntity(element);
				GotXmlDto.getInstance().updateEntityElement(entity);
				
				TreeItem treeItem = (TreeItem) item.getData("treeItem");
				Element elementTar = GotXmlDto.getInstance().getCurrentElement(treeItem);
				String id = treeItem.getData("id").toString();
				for (TreeUi treeUi : FormDataSyn.treeUis) {
					TreeItem item2 = treeUi.itemsMap.get(id);
					if(item2 != null && item2 == treeItem){
						//必须重新获取xml
						Element element2 = GotXmlDto.getInstance().getCurrentElement(item2);
						item2.setText(treeUi.getTreeItemTextByXML(element2));
						//刷新选中节点的属性和标签
						if(treeUi.getTree().getSelection().length > 0){
							if(treeUi.getTree().getSelection()[0] == item2){
								item2.setData("chinese", "false");
								treeUi.loadTableValue(treeUi.getTable(), elementTar, item2);
							}
						}
						
						TreeItem item_ = FormDataSyn.getEntityTreeItem(item2);
						if(item_ != null){
							FormDataSyn.setUnSave(item_);
						}
					}
				}
			}
			return ;
		}
		
		final Text changeItemText = new Text(table, SWT.NONE);
		changeItemText.computeSize(SWT.DEFAULT, table.getItemHeight());
		editor.grabHorizontal = true;
		editor.minimumHeight = changeItemText.getSize().y;
		editor.minimumWidth = changeItemText.getSize().x;
		editor.setEditor(changeItemText, item, selectCol);
		String labelText = item.getText(selectCol);
		if(labelText.startsWith("【") && labelText.endsWith("】")){
			labelText = labelText.replace("【", "").replace("】", "");
		}
		changeItemText.setFont(item.getFont());
		changeItemText.setText(labelText);
		changeItemText.forceFocus();
		changeItemText.selectAll();
		
		//编辑后变回表格样式
		changeItemText.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent focusevent) {
				Control defaultEditor = editor.getEditor();
				editor.setEditor(defaultEditor, item, selectCol);
				String cT = changeItemText.getText();
				String iT = item.getText(selectCol);
				if(cT.equals(iT) || ("【" + cT+ "】").equals(iT)){
					ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
					item.setText(selectCol, item.getText(selectCol));
				}else{
					String newValue = changeItemText.getText();
					handle(element, node, newValue, item.getText(selectCol), item);
				}
				changeItemText.dispose();
				table.select(selectionIndex);
				first = true;
			}
			
		});
		
		changeItemText.addKeyListener(new KeyAdapter() {

			@Override
			public void keyPressed(KeyEvent e) {
				
			}

			@Override
			public void keyReleased(KeyEvent e) {
				if(e.keyCode == 13 ){//回车键
					table.forceFocus();
//					if(!first){
////						table.forceFocus();
//						table.select(selectionIndex);
//						table.setSelection(item);
//						first = true;
//					}else{
//						first = false;
//					}
				}
			}
		});
	}
	
	public void comboEdit(final Table table, final TableItem item, final int selectCol, final Element element, final TableEditor editor, List<String> array,final NodeGOT node ){
		final int selectionIndex = table.getSelectionIndex();
		if(item.getText().equals("AttachmentFileType")){
			String aValue = GOTMessageDialog.fileTypeSelect(item.getText(selectCol));
			String orgText = item.getText(1);
			if(aValue != null && !aValue.equals(orgText)){
				element.element("Value").setText(aValue);
				item.setText(1, aValue);
				Element entity = NodeGOT.getEntity(element);
				GotXmlDto.getInstance().updateEntityElement(entity);
				
				TreeItem treeItem = (TreeItem) item.getData("treeItem");
				Element elementTar = GotXmlDto.getInstance().getCurrentElement(treeItem);
				String id = treeItem.getData("id").toString();
				for (TreeUi treeUi : FormDataSyn.treeUis) {
					TreeItem item2 = treeUi.itemsMap.get(id);
					if(item2 != null && item2 == treeItem){
						//必须重新获取xml
						Element element2 = GotXmlDto.getInstance().getCurrentElement(item2);
						item2.setText(treeUi.getTreeItemTextByXML(element2));
						//刷新选中节点的属性和标签
						if(treeUi.getTree().getSelection().length > 0){
							if(treeUi.getTree().getSelection()[0] == item2){
								item2.setData("chinese", "false");
								treeUi.loadTableValue(treeUi.getTable(), elementTar, item2);
							}
						}
						
						TreeItem item_ = FormDataSyn.getEntityTreeItem(item2);
						if(item_ != null){
							FormDataSyn.setUnSave(item_);
						}
					}
				}
			}
			return ;
		}
		//ZSG 如果array中没有东西  则加入一个“” 如果有东西并且第一项不是“” 则加入一个“”
		if(array.size()<1)
		{
			array.add(0,"");
		}
		else if(!array.get(0).equals("")){
			array.add(0, "");
		}
		
		final String[] comItem = array.toArray(new String[array.size()]);
		final String allComItemStr = StringUtils.join(comItem);
		final Combo comOptionValue = new Combo(table, SWT.BORDER);
		comOptionValue.setFont(table.getFont());
		comOptionValue.setItems(comItem);
		comOptionValue.computeSize(SWT.DEFAULT, table.getItemHeight());
		editor.grabHorizontal = true;
		editor.minimumHeight = comOptionValue.getSize().y - 2;
		editor.minimumWidth = comOptionValue.getSize().x;
		editor.setEditor(comOptionValue, item, selectCol);
		comOptionValue.setText(item.getText(selectCol));
		comOptionValue.forceFocus();
		comOptionValue.setListVisible(true);
		comOptionValue.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(!comOptionValue.getListVisible()){
					Control defaultEditor = editor.getEditor();
					editor.setEditor(defaultEditor, item, selectCol);
					if(comOptionValue.getText().equals(item.getText(selectCol)) || !allComItemStr.contains(comOptionValue.getText())){
						ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
						item.setText(selectCol, item.getText(selectCol));
					}else{
						String newValue = comOptionValue.getText();
//						if(newValue.contains("_")){
//							if("DataTypeArrayItem".equals(node.xml.getName())){
//								newValue = newValue.replace("_", "");
//							}
//						}
						handle(element, node, newValue, item.getText(selectCol), item);
						comOptionValue.dispose();
						
					}
				}
				table.select(selectionIndex);
			}
		});
		
		comOptionValue.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent focusevent) {
				comOptionValue.dispose();
				table.select(selectionIndex);
				first = true;
			}

			@Override
			public void focusGained(FocusEvent e) {
				comOptionValue.setListVisible(true);
			}
			
		});	
		
		comOptionValue.addKeyListener(new KeyAdapter() {

			@Override
			public void keyPressed(KeyEvent e) {
				
			}

			@Override
			public void keyReleased(KeyEvent e) {
				if(e.keyCode == SWT.PAGE_UP || e.keyCode == SWT.PAGE_DOWN || e.keyCode == 16777217 || e.keyCode == 16777218){
					e.doit = false;
					return;
				}else if(e.keyCode == 13){
					if(e.keyCode == 13 ){
						if(!first){
							Control defaultEditor = editor.getEditor();
							editor.setEditor(defaultEditor, item, selectCol);
							if(comOptionValue.getText().equals(item.getText(selectCol)) || !allComItemStr.contains(comOptionValue.getText())){
								ConfigComposite.configComposite.set_text_op_info(Macros.INFO_VALUE_NOTCHANGED);
								item.setText(selectCol, item.getText(selectCol));
							}else{
								handle(element, node, comOptionValue.getText(), item.getText(selectCol), item);
							}
//							table.forceFocus();
//							table.setSelection(item);
							table.select(selectionIndex);
							first = true;
						}else{
							first = false;
						}
					}
				}else if((String.valueOf(e.character).matches("[a-zA-Z0-1]")) || e.keyCode == 8){//8是退格
					String newStr = comOptionValue.getText();
					if(StringUtils.isNotBlank(newStr)){
						String[] items = selectItems(comItem, newStr);
						comOptionValue.setItems(items);
						if(items.length < 10){
							comOptionValue.setVisibleItemCount(items.length);
						}else{
							comOptionValue.setVisibleItemCount(10);
						}
						comOptionValue.setListVisible(true);
						comOptionValue.setText(newStr);
						comOptionValue.setSelection(comOptionValue.getSize());
						comOptionValue.forceFocus();
						
					}else{
						comOptionValue.setItems(comItem);
						if(comItem.length < 10){
							comOptionValue.setVisibleItemCount(comItem.length);
						}else{
							comOptionValue.setVisibleItemCount(10);
						}
						comOptionValue.setListVisible(true);
					}

				}
			}
		});
	}
	
	/**
	 * 检查这个节点是不是一个新建的节点
	 * @param itemId
	 * @param id
	 * @return
	 */
	private boolean checkIsNewItem(String itemId, String id){
		String result = LoadXmlCore.gotServices.getEntity(id);
		if(result == null || "".equals(result) || result.startsWith("false")){
			return true;
		}
		Element resultXML = GOTXMLHelper.createElementByXMLString(result);
		String xpath = "TableFields/TableField[@id='" + itemId + "']";
		List<?> list = resultXML.selectNodes(xpath);
		if(list == null || list.isEmpty()){
			return true;
		}
		return false;
	}
	
	/**
	 * 这个方法用来修改table上的关联item的text和label
	 * 场景：已有字段1，并加入到索引中，然后修改字段1的继承，字段的属性改变、同时索引中的字段的文本和label都应该改变
	 * @param entity
	 * @param id
	 * @param name
	 * @param lable
	 */
	private void updateInnerItemName(Element entity, String id, String name, String lable){
		String xpath = "//Properties/Property[@innerid='" + id + "']";
		List<Element> elements = entity.selectNodes(xpath);
		for (Element element : elements) {
			element = element.getParent().getParent();
			for (TreeUi ui : FormDataSyn.treeUis) {
				TreeItem item = FormDataSyn.getTreeItrmByElement(element, ui);
				if(item != null){
					item.setText(name);
					item.setText(1, lable);
					element.addAttribute("name", name);
				}
			}
		}
	}
	
	private String setUniqueName(String name, Element element){
		List<Element> elements = element.getParent().elements();
		int i = -1;
		for (Element element2 : elements) {
			if(element2.attributeValue("name").startsWith(name)){
				i ++;
			}
		}
		if(i > 0){
			name = name + i;
		}
		return name;
	}
}
