package info.gongqi.got.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.dom4j.Element;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import info.gongqi.got.tool.EnterNodeRef;
import info.gongqi.got.tool.EnterNodeReset;
import info.gongqi.got.tool.EnterNodeResetFormDataSource;
import info.gongqi.got.tool.FileTypeSelect;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GotLayerAndUserDialog;
import info.gongqi.got.tool.ModifyDim;
import info.gongqi.got.tool.ModifyExtendsDialog;
import info.gongqi.got.tool.ProgressBarExchangeLayer;
import info.gongqi.got.tool.RightKeyMethod;
import info.gongqi.got.tool.SearchTreeItem;
import info.gongqi.got.tool.ShowTreeItemXML;
import info.gongqi.got.tool.SofeView;
import info.gongqi.got.tool.display.DisplayStyleDialog;
import info.gongqi.got.ui.TypeSelector;

public class GOTMessageDialog {
	
	public static Shell shell;
	
	public static Composite parents;
	
	public static List<Shell> shells = new ArrayList<>();
	
	public static void init(Composite parent){
		shell = parent.getShell();
		parents = parent;
	}
	
	public static void alert(String text){
        MessageDialog.openWarning(shell, "异常", text);
	}

	public static void alert(Exception e){
        MessageDialog.openError(shell, "异常", e.getMessage());
	}
	
	public static void info(String text){
        MessageDialog.openInformation(shell, "信息", text);
	}
	
	public static void showXmlInfo(String xml, String title){
		ShowTreeItemXML showTreeItemXML = new ShowTreeItemXML(shell, SWT.RESIZE | SWT.BORDER | SWT.CLOSE, xml, title);
		showTreeItemXML.open();
	}
	
	public static String typeSelector(List<String> list){
		TypeSelector selector = new TypeSelector(shell, SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE, list);
		String re = selector.open();
		return re;
	}
	
	public static void showEnterNodeRef(Element xml){
		EnterNodeRef enterNodeRef = new EnterNodeRef(shell,  SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE , xml, true);
		enterNodeRef.open();
	}
	
	public static void showEnterNodeReset(Element xml){
		EnterNodeReset enterNodeRef = new EnterNodeReset(shell,  SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE , xml);
		enterNodeRef.open();
	}
	
	public static void showEnterNodeResetFormDataSource(List<Element> lists, Element xml){
		EnterNodeResetFormDataSource enterNodeRef = new EnterNodeResetFormDataSource(shell,  SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE , lists, xml);
		enterNodeRef.open();
	}
	
	public static void showSynResult(Element xml){
		EnterNodeRef enterNodeRef = new EnterNodeRef(shell,  SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE , xml, false);
		enterNodeRef.open();
	}
	
	public static void showExchangeLayer(){
		ProgressBarExchangeLayer enterNodeRef = new ProgressBarExchangeLayer(shell,  SWT.TITLE | SWT.BORDER);
		enterNodeRef.open();
	}
	
	public static void showModifyDim(){
		ModifyDim enterNodeRef = new ModifyDim(shell,   SWT.TITLE | SWT.BORDER | SWT.CLOSE );
		enterNodeRef.open();
	}
	
	public static void showMethod(Element xml){
		RightKeyMethod keyMethod = new RightKeyMethod(shell, xml);
		keyMethod.open();
	}
	
	public static String searchTreeItem(){
		SearchTreeItem search = new SearchTreeItem(shell, SWT.TITLE | SWT.BORDER);
		String re = search.open();
		return re;
	}
	
	public static String fileTypeSelect(String val){
		FileTypeSelect fileType = new FileTypeSelect(shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, val);
		String re = fileType.open();
		return re;
	}
	
	public static String displayStyleDialog(String orgText){
//		DisplayStyleDialog fileType = new DisplayStyleDialog(shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, orgText);
//		String re = fileType.open();
		DisplayStyleDialog displayst = new DisplayStyleDialog(shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE, orgText);
		String re = displayst.open();
		return re;
	}
	
	public static void showsoftView(List<Map<String, Object>> data){
		if(SofeView.sofeView == null || SofeView.sofeView.shell.isDisposed()){
			SofeView soft = new SofeView(shell,  SWT.RESIZE | SWT.TITLE | SWT.BORDER | SWT.CLOSE , data);
			SofeView.sofeView = soft;
			soft.open();
		}else{
			SofeView.sofeView.shell.setVisible(true);
		}

	}
	
	public static boolean ChoseUser(){
		GotLayerAndUserDialog andUserDialog = new GotLayerAndUserDialog(shell, SWT.TITLE | SWT.BORDER);
		boolean re = andUserDialog.open();
		return re;
	}
	
	public static Element modifyExtendsDialog(Element xml){
		ModifyExtendsDialog fileType = new ModifyExtendsDialog(shell, SWT.TITLE | SWT.BORDER | SWT.CLOSE , xml);
		return fileType.open();
	}
	
	
	public static void hideShells(){
		for (Shell shell : shells) {
			if(!shell.isDisposed()){
				shell.setVisible(false);
			}
			
		}
		for (int i = 0; i < FormDataSyn.treeUis.size(); i++) {
			if(i > 0){
				FormDataSyn.treeUis.get(i).getTree().getShell().setVisible(false);
			}
		}
	}
	
	public static void showShells(){
		for (Shell shell : shells) {
			if(!shell.isDisposed()){
				shell.setVisible(true);
			}
		}
		for (int i = 0; i < FormDataSyn.treeUis.size(); i++) {
			if(i > 0){
				FormDataSyn.treeUis.get(i).getTree().getShell().setVisible(true);
			}
		}
	}
	
	public static void colse(){
		for (Shell shell : shells) {
			if(!shell.isDisposed()){
				shell.close();
			}
		}
	}
}
