/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.toolsgot;

import com.alibaba.fastjson.JSONObject;
import gongqi.gdt.designer.core.got.node.NodeType;
import gongqi.gdt.designer.utils.cache.GOTFinalValueHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class GOTHelper {
    public static Boolean isEnumDefault(Element item) {
        if (item != null) {
            String qname = item.getName();
            String type = item.attributeValue("type");
            if (type.equals("Enum") && qname.equals("TableField") || type.equals("EnumEditor") && qname.equals("FormItem") || type.equals("Enum") && qname.equals("ReportField")) {
                return true;
            }
        }
        return false;
    }

    public static List<String> getDataSourceByTableField(Element tableField) {
        Element sourcePro = gongqi.designer.utils.GOTHelper.getProperty((Element)tableField, (String)"Source");
        Element extendsPro = gongqi.designer.utils.GOTHelper.getProperty((Element)tableField, (String)"Extends");
        if (extendsPro.attribute("refentityid") == null) {
            return GOTHelper.getDataSourceByRegular(tableField);
        }
        if (sourcePro.elementText("Value").equals("Enum")) {
            return GOTHelper.getDataSourceByEnum(extendsPro);
        }
        return GOTHelper.getDataSourceByDataType(extendsPro);
    }

    public static List<String> getDataSourceByRegular(Element node) {
        Element regularPro = gongqi.designer.utils.GOTHelper.getProperty((Element)node, (String)"Regular");
        if (regularPro == null) {
            return null;
        }
        String regular = regularPro.elementText("Value");
        ArrayList<String> collection = new ArrayList<String>();
        if (!regular.equals("")) {
            String[] array;
            String[] stringArray = array = regular.split("|");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String label;
                String value;
                String item = stringArray[n2];
                if (item.indexOf(":") > -1) {
                    value = item.split(":")[0];
                    label = item.split(":")[1];
                } else {
                    value = item;
                    label = item;
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", (Object)label);
                jsonObject.put("value", (Object)value);
                collection.add(jsonObject.toJSONString());
                ++n2;
            }
        }
        return collection;
    }

    public static List<String> getDataSourceByEnum(Element extendsPro) {
        if (extendsPro.attribute("refentityid") == null) {
            return new ArrayList<String>();
        }
        String enumId = extendsPro.attributeValue("refentityid");
        Element entityEnum = GOTHelper.getEnum(enumId);
        ArrayList<String> collection = new ArrayList<String>();
        if (entityEnum == null) {
            return new ArrayList<String>();
        }
        List elements = entityEnum.elements("EnumItem");
        for (Element item : elements) {
            String label = GOTHelp.getPPAttValue(item, "Name", "Label");
            String value = GOTHelp.getPPAttValue(item, "Name", "Value");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", (Object)label);
            jsonObject.put("value", (Object)value);
            collection.add(jsonObject.toJSONString());
        }
        return collection;
    }

    public static Element getEnum(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Enum", _id);
        return element;
    }

    public static List<String> getDataSourceByDataType(Element extendsPro) {
        if (extendsPro.attribute("refentityid") == null) {
            return new ArrayList<String>();
        }
        Element dataType = GOTHelper.getDataType(extendsPro.attributeValue("refentityid"));
        extendsPro = gongqi.designer.utils.GOTHelper.getProperty((Element)dataType, (String)"Extends");
        while (extendsPro.attribute("refentityid") != null) {
            List<Element> sourcePro = GOTHelp.getPPAttElementList(dataType, "Name", "Source");
            if (sourcePro.size() == 0) {
                throw new Error("\u4eceEnumEditor\u5230DataType\u7684\u7ee7\u627f\u94fe\u4e0a\u5b58\u5728\u975eEnum\u7c7b\u578b\u7684DataType");
            }
            if (sourcePro.get(0).elementText("Value").equals("Enum")) {
                return GOTHelper.getDataSourceByEnum(extendsPro);
            }
            dataType = GOTHelper.getDataType(extendsPro.attributeValue("refentityid"));
            extendsPro = gongqi.designer.utils.GOTHelper.getProperty((Element)dataType, (String)"Extends");
        }
        return GOTHelper.getDataSourceByRegular(dataType);
    }

    public static Element getDataType(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", _id);
        return element;
    }

    private static Boolean hasProperty(Element reportField, String property) {
        List<Element> pro = GOTHelp.getDDDAttElementList(reportField, "Name", property);
        if (pro.size() > 0) {
            return true;
        }
        return false;
    }

    private static String getPropertyValue(Element item, String property) {
        return gongqi.designer.utils.GOTHelper.getPropertyValue((Element)item, (String)property);
    }

    public static Element getProperty(Element xml, String property) {
        List<Element> list = GOTHelp.getPPAttElementList(xml, "Name", property);
        if (list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public static Element getTable(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", _id);
        return element;
    }

    public static Element getMenuItem(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("MenuItem", _id);
        return element;
    }

    public static Element getMenu(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", _id);
        return element;
    }

    public static Element getReport(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Report", _id);
        return element;
    }

    public static Element getForm(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", _id);
        return element;
    }

    public static String getReprotFinalValue(Element item, String property) {
        String nodeName = item.getName();
        if (nodeName.equals("ReportField")) {
            String value;
            if (property.equals("Extends") || property.equals("Source")) {
                return GOTHelper.getPropertyValue(item, property);
            }
            Boolean hasProperty = GOTHelper.hasProperty(item, property);
            if (hasProperty.booleanValue() && !(value = GOTHelper.getPropertyValue(item, property)).equals("")) {
                return value;
            }
            Element entity = null;
            Element extendsPro = GOTHelper.getProperty(item, "Extends");
            if (extendsPro.attribute("refentityid") != null) {
                String refId = extendsPro.attributeValue("refentityid");
                if (refId != null && refId.indexOf(".") != -1) {
                    int lastIndex = refId.lastIndexOf(".");
                    refId = refId.substring(lastIndex + 1);
                }
                entity = refId.substring(0, 2).equals("20") ? GOTHelper.getDataType(refId) : GOTHelper.getEnum(refId);
                return GOTFinalValueHelper.getFinalValue(entity, property);
            }
            if (property.equals("Label")) {
                return item.attributeValue("name");
            }
            return "";
        }
        if (nodeName.equals("ReportQuery")) {
            return GOTHelper.getPropertyValue(item, property);
        }
        if (nodeName.equals("Report")) {
            String label = GOTHelper.getPropertyValue(item, property);
            if (label.equals("") && property.equals("Label")) {
                return item.attributeValue("name");
            }
            return label;
        }
        Element table = null;
        if (nodeName.equals("Query") && property.equals("Title")) {
            String value = GOTHelper.getPropertyValue(item, property);
            if (value.equals("")) {
                List queryTable = item.elements("QueryTable");
                if (queryTable.size() == 0) {
                    return item.attributeValue("name");
                }
                Element extendsPro = GOTHelper.getProperty((Element)queryTable.get(0), "Table");
                if (extendsPro.attribute("refentityid") != null) {
                    table = GOTHelper.getTable(extendsPro.attributeValue("refentityid"));
                }
                if (table != null && (value = GOTFinalValueHelper.getFinalValue(table, "Label")).equals("")) {
                    value = item.attributeValue("name");
                }
            }
            return value;
        }
        return "";
    }

    public static Element getEntity(String id, String type) {
        if (type == null) {
            type = GOTHelper.getEntityTypeById(id);
        }
        switch (type) {
            case "Enum": {
                return GOTHelper.getEnum(id);
            }
            case "DataType": {
                return GOTHelper.getDataType(id);
            }
            case "Table": {
                return GOTHelper.getTable(id);
            }
            case "MenuItem": {
                return GOTHelper.getMenuItem(id);
            }
            case "Menu": {
                return GOTHelper.getMenu(id);
            }
            case "Form": {
                return GOTHelper.getForm(id);
            }
            case "Report": {
                return GOTHelper.getReport(id);
            }
        }
        throw new Error("\u975e\u6cd5\u7684Entity Type");
    }

    public static String getEntityTypeById(String entityId) {
        String c;
        if (entityId != null && entityId.indexOf(".") != -1) {
            int lastIndex = entityId.lastIndexOf(".");
            entityId = entityId.substring(lastIndex + 1);
        }
        if ((c = entityId.substring(0, 2)).equals("10")) {
            return NodeType.ENUM;
        }
        if (c.equals("20")) {
            return NodeType.DATATYPE;
        }
        if (c.equals("30")) {
            return NodeType.TABLE;
        }
        if (c.equals("40")) {
            return NodeType.FORM;
        }
        if (c.equals("50")) {
            return NodeType.MENUITEM;
        }
        if (c.equals("60")) {
            return NodeType.MENU;
        }
        if (c.equals("70")) {
            return NodeType.MAP;
        }
        if (c.equals("80")) {
            return NodeType.QUERY;
        }
        if (c.equals("90")) {
            return NodeType.REPORT;
        }
        return null;
    }
}

