/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.analysis.Analysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseAnalysis
implements Analysis {
    protected Logger log = Logger.getLogger(this.getClass());
    private static List<String> ignoreAnalysisPropertys = Arrays.asList("CreatedDate", "CreatedTime", "CreatedBy", "ModifiedDate", "ModifiedTime", "ModifiedBy");
    protected GOTModel sourceGOT;
    protected GOTModel targetGOT;
    protected GOTModel originalTargetGOT;

    public BaseAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        this.sourceGOT = sourceGOT;
        this.targetGOT = targetGOT;
        this.originalTargetGOT = originalGOT;
    }

    @Override
    public final void analysis(ProgressMonitor monitor) {
        EntityType entityType = this.getSupportEntityType();
        this.forwardAnalysis(this.targetGOT.getEntitys(entityType).values(), monitor);
        this.backwardAnalysis(this.sourceGOT.getEntitys(entityType).values(), monitor);
    }

    private void forwardAnalysis(Collection<GOTEntity> entitys, ProgressMonitor monitor) {
        for (GOTEntity targetEntity : entitys) {
            monitor.worked(1, String.format("\u6b63\u5728\u5206\u6790%s\u3010%s\u3011...", targetEntity.getEntityType().name(), targetEntity.getName()));
            try {
                List<Element> modifyItems = this.analysisEntityNode(targetEntity);
                GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
                if (sourceEntity != null) {
                    modifyItems.addAll(this.analysisEntityInnerModify(sourceEntity, targetEntity));
                }
                if (modifyItems.size() <= 0) continue;
                Element entityResult = this.aggregationEntityResult(targetEntity, modifyItems);
                monitor.reportResult(entityResult);
            }
            catch (VTDException e) {
                this.log.warn((Object)String.format("\u5206\u6790%s\u5b9e\u4f53%s\u9519\u8bef", targetEntity.getEntityType().name(), targetEntity.getId()), (Throwable)e);
            }
        }
    }

    private void backwardAnalysis(Collection<GOTEntity> entitys, ProgressMonitor monitor) {
        for (GOTEntity sourceEntity : entitys) {
            try {
                String solutionPluginName;
                String solutionName;
                if ("ent".equals(sourceEntity.getCreatedLayer()) || this.targetGOT.getLayerDefination(sourceEntity.getCreatedLayer()) == null || ("app".equals(sourceEntity.getCreatedLayer()) ? this.targetGOT.getSolutionDefinition(solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null : ("plg".equals(sourceEntity.getCreatedLayer()) ? this.targetGOT.getSolutionPluginDefinition(solutionPluginName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null : "ext".equals(sourceEntity.getCreatedLayer()) && this.targetGOT.getSolutionExtensionDefinition(solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null))) continue;
                monitor.worked(1, String.format("\u6b63\u5728\u53cd\u5411\u5206\u6790%s\u3010%s\u3011...", sourceEntity.getEntityType().name(), sourceEntity.getName()));
                List<Element> modifyItems = this.analysisReverseEntityNode(sourceEntity);
                GOTEntity targetEntity = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
                if (targetEntity != null) {
                    modifyItems.addAll(this.analysisEntityInnerDelete(sourceEntity, targetEntity));
                }
                if (modifyItems.size() <= 0) continue;
                Element entityResult = this.aggregationEntityResult(sourceEntity, modifyItems);
                monitor.reportResult(entityResult);
            }
            catch (VTDException e) {
                this.log.warn((Object)String.format("\u5206\u6790%s\u5b9e\u4f53%s\u9519\u8bef", sourceEntity.getEntityType().name(), sourceEntity.getId()), (Throwable)e);
            }
        }
    }

    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        return Collections.EMPTY_LIST;
    }

    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        return Collections.EMPTY_LIST;
    }

    protected abstract EntityType getSupportEntityType();

    private List<Element> analysisEntityNode(GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        if (sourceEntity != null) {
            if (!targetEntity.getName().equals(sourceEntity.getName())) {
                GOTEntity entity = this.sourceGOT.getEntityByName(targetEntity.getEntityType(), targetEntity.getName());
                if (entity != null && !entity.getId().equals(targetEntity.getId()) && this.sourceGOT.isSourceDeployment(entity.getCreatedLayer(), entity.getId())) {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Cannot, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u5f53\u524d\u5c42\u5b9e\u4f53\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceEntity.getName(), targetEntity.getName()));
                    modifyItems.add(modifyItem);
                } else if (this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity.getId())) {
                    if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                        Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Must, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceEntity.getName(), targetEntity.getName()));
                        modifyItems.add(modifyItem);
                    } else {
                        Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Cannot, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u5f53\u524d\u5c42\u5b9e\u4f53\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceEntity.getName(), targetEntity.getName()));
                        modifyItems.add(modifyItem);
                    }
                } else {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Must, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceEntity.getName(), targetEntity.getName()));
                    modifyItems.add(modifyItem);
                }
            }
            GOTEntity transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
            modifyItems.addAll(this.analysisProperty(targetEntity, sourceEntity, transitionEntity));
        } else {
            sourceEntity = this.sourceGOT.getEntityByName(targetEntity.getEntityType(), targetEntity.getName());
            if (sourceEntity != null) {
                if (this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity.getId())) {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Cannot, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u3010%s\u3011\u5c42\u65b0\u589e%s\u3010 %s\u3011\u5b9e\u4f53\u8282\u70b9\uff0c\u4e0e\u5f53\u524d\u5b9e\u4f53\u8282\u70b9\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", targetEntity.getModifiedLayer(), targetEntity.getEntityType().name(), targetEntity.getName()));
                    modifyItems.add(modifyItem);
                } else {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Must, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u3010%s\u3011\u5c42\u65b0\u589e%s\u3010 %s\u3011\u5b9e\u4f53\u8282\u70b9", targetEntity.getModifiedLayer(), targetEntity.getEntityType().name(), targetEntity.getName()));
                    modifyItems.add(modifyItem);
                }
            } else {
                Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Must, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u3010%s\u3011\u5c42\u65b0\u589e%s\u3010 %s\u3011\u5b9e\u4f53\u8282\u70b9", targetEntity.getModifiedLayer(), targetEntity.getEntityType().name(), targetEntity.getName()));
                modifyItems.add(modifyItem);
            }
        }
        return modifyItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Element> analysisInnerNode(GOTNode targetNode) throws VTDException {
        Element modifyItem;
        GOTNode node2;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetEntity = targetNode.getEntity();
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        GOTNode sourceNode = sourceEntity.selectSingleNode(targetNode.getEntityXPath());
        if (sourceNode == null && "FormItem".equals(targetNode.getNodeType())) {
            sourceNode = sourceEntity.selectSingleNode(String.format(".//FormItem[@id='%s']", targetNode.getId()));
        }
        if ("EnumItem".equals(targetNode.getNodeType())) {
            for (GOTNode node2 : sourceEntity.selectNodes("./EnumItem")) {
                if (!targetNode.getProperty("Value").getValue().equals(node2.getProperty("Value").getValue()) || targetNode.getId().equals(node2.getId()) || !this.sourceGOT.isSourceDeployment(node2.getModifiedLayer(), sourceEntity.getId())) continue;
                modifyItem = sourceNode != null ? this.createModifyItem(ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("Enum\u3010%s\u3011\u5b9e\u4f53EnumItem\u3010%s %s\u3011\u5185\u90e8\u8282\u70b9Value\u503c\u51b2\u7a81\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getName(), sourceNode.getName(), node2.getName())) : this.createModifyItem(ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, targetNode.getNodeType(), targetNode.getId(), null, String.format("Enum\u3010%s\u3011\u5b9e\u4f53\u65b0\u589eEnumItem\u3010%s\u3011\u4e0eEnumItem\u3010%s\u3011\u5c5e\u6027Value\u503c\u51b2\u7a81\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getName(), targetNode.getName(), node2.getName()));
                modifyItems.add(modifyItem);
            }
        }
        if (sourceNode != null) {
            GOTEntity transitionEntity;
            GOTNode transitionNode;
            if (!targetNode.getName().equals(sourceNode.getName())) {
                node2 = sourceEntity.selectSingleNode(String.format("%s/%s[@name='%s']", targetNode.getParent().getEntityXPath(), targetNode.getNodeType(), targetNode.getName()));
                if (node2 != null && !node2.getId().equals(sourceNode.getId()) && this.sourceGOT.isSourceDeployment(node2.getCreatedLayer(), sourceEntity.getId()) && this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity.getId())) {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Rename, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u5f53\u524d\u65b0\u5efa\u7684\u5b9e\u4f53\u8282\u70b9\u3010%s\u3011\u91cd\u540d,\u65e0\u6cd5\u5347\u7ea7!", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getName(), targetNode.getName(), node2.getId()));
                    modifyItems.add(modifyItem);
                } else {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Rename, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getEntityType().name(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getName(), targetNode.getName()));
                    modifyItems.add(modifyItem);
                }
            }
            if ((transitionNode = (transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId())).selectSingleNode(sourceNode.getEntityXPath())) == null && "FormItem".equals(sourceNode.getNodeType())) {
                transitionNode = transitionEntity.selectSingleNode(String.format("/Form[@id='%s']/FormDesign[@name='Design']//FormItem[@id='%s']", sourceEntity.getId(), sourceNode.getId()));
            }
            if (transitionNode == null) throw new ERPException(String.format("%s\u3010%s\u3011\u8fc7\u6e21\u5c42\u4e2d\u672a\u627e\u5230%s\u3010%s %s\u3011\u5bf9\u5e94\u8282\u70b9\u3010%s\u3011", targetEntity.getEntityType().name(), targetEntity.getName(), targetNode.getNodeType(), targetNode.getId(), targetNode.getName(), sourceNode.getEntityXPath()));
            modifyItems.addAll(this.analysisProperty(targetNode, sourceNode, transitionNode));
            return modifyItems;
        } else {
            node2 = sourceEntity.selectSingleNode(String.format("%s/%s[@name='%s']", targetNode.getParent().getEntityXPath(), targetNode.getNodeType(), targetNode.getName()));
            if (node2 != null && this.sourceGOT.getLayerLevel(node2.getCreatedLayer()) > this.targetGOT.getTopLayerLevel() && this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) > this.targetGOT.getTopLayerLevel()) {
                modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Cannot, targetNode.getNodeType(), targetNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\uff0c\u4e14\u4e0e\u5f53\u524d\u5c42\u5185\u90e8\u8282\u70b9\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7!", sourceEntity.getEntityType().name(), sourceEntity.getName(), targetNode.getNodeType(), targetNode.getName()));
                modifyItems.add(modifyItem);
                return modifyItems;
            } else if ("TableIndexItem".equals(targetNode.getNodeType())) {
                node2 = sourceEntity.selectSingleNode(String.format("%s/%s/Properties/Property[@innerid='%s']/Name[text()='Field']/../../..", targetNode.getParent().getEntityXPath(), targetNode.getNodeType(), targetNode.getProperty("Field").getAttributeValue("innerid")));
                if (node2 != null && !node2.getId().equals(targetNode.getId()) && this.sourceGOT.getLayerLevel(node2.getModifiedLayer()) > this.targetGOT.getTopLayerLevel()) {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Cannot, targetNode.getNodeType(), targetNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\uff0c\u4e14\u4e0e%s\u3010%s %s\u3011\u5173\u8054\u76f8\u540c\u7684TableField\uff0c\u65e0\u6cd5\u5347\u7ea7!", sourceEntity.getEntityType().name(), sourceEntity.getName(), targetNode.getNodeType(), targetNode.getName(), node2.getNodeType(), node2.getId()));
                    modifyItems.add(modifyItem);
                    return modifyItems;
                } else {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Must, targetNode.getNodeType(), targetNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9", sourceEntity.getEntityType().name(), sourceEntity.getName(), targetNode.getNodeType(), targetNode.getName()));
                    modifyItems.add(modifyItem);
                }
                return modifyItems;
            } else {
                if ("FormItem".equals(targetNode.getNodeType()) || "MenuRefMenu".equals(targetNode.getNodeType()) || "MenuRefMenuItem".equals(targetNode.getNodeType()) || "MenuSeperator".equals(targetNode.getNodeType()) || "MenuSub".equals(targetNode.getNodeType())) return modifyItems;
                modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Must, targetNode.getNodeType(), targetNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9", sourceEntity.getEntityType().name(), sourceEntity.getName(), targetNode.getNodeType(), targetNode.getName()));
                modifyItems.add(modifyItem);
            }
        }
        return modifyItems;
    }

    protected List<Element> analysisProperty(GOTNode targetNode, GOTNode sourceNode, GOTNode transitionNode) throws VTDException {
        Element modifyItem;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        for (GOTProperty targetProperty : targetNode.getPropertys()) {
            if (ignoreAnalysisPropertys.contains(targetProperty.getName())) continue;
            if (sourceNode.hasProperty(targetProperty.getName())) {
                GOTEntity sourceEntity = sourceNode.getEntity();
                GOTProperty sourceProperty = sourceNode.getProperty(targetProperty.getName());
                GOTProperty transitionProperty = transitionNode.getProperty(targetProperty.getName());
                if (transitionProperty == null) continue;
                if (!(targetProperty.getValue() == sourceProperty.getValue() || targetProperty.getValue() != null && targetProperty.getValue().equals(sourceProperty.getValue()) || sourceProperty.getValue() != null && sourceProperty.getValue().equals(targetProperty.getValue()))) {
                    if (sourceProperty.getValue() == transitionProperty.getValue() || sourceProperty.getValue() != null && sourceProperty.getValue().equals(transitionProperty.getValue()) || transitionProperty.getValue() != null && transitionProperty.getValue().equals(sourceProperty.getValue())) {
                        String description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue());
                        if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                            if (("DataType".equals(sourceNode.getNodeType()) || "TableField".equals(sourceNode.getNodeType())) && "StringSize".equals(sourceProperty.getName()) || "NumOfDecimals".equals(sourceProperty.getName())) {
                                if (StringUtils.isNotBlank((String)targetProperty.getValue()) && StringUtils.isNotBlank((String)sourceProperty.getValue()) && Integer.parseInt(targetProperty.getValue()) < Integer.parseInt(sourceProperty.getValue())) continue;
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                                continue;
                            }
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                            continue;
                        }
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    if (("DataType".equals(sourceNode.getNodeType()) || "TableField".equals(sourceNode.getNodeType())) && ("StringSize".equals(sourceProperty.getName()) || "NumOfDecimals".equals(sourceProperty.getName()))) {
                        boolean analysis = true;
                        if ("TableField".equals(sourceNode.getNodeType())) {
                            GOTProperty targetExtends = targetNode.getProperty("Extends");
                            GOTProperty sourceExtends = sourceNode.getProperty("Extends");
                            if (StringUtils.isNotBlank((String)targetExtends.getValue()) && StringUtils.isNotBlank((String)sourceExtends.getValue())) {
                                analysis = false;
                            }
                        }
                        if (analysis && StringUtils.isNotBlank((String)targetProperty.getValue()) && StringUtils.isNotBlank((String)sourceProperty.getValue()) && Integer.parseInt(targetProperty.getValue()) > Integer.parseInt(sourceProperty.getValue())) {
                            String description;
                            if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel() || this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                                description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue());
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                                continue;
                            }
                            description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), sourceProperty.getValue(), targetProperty.getValue(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                            continue;
                        }
                    }
                }
                for (Map.Entry<String, String> targetEntry : targetProperty.getAttributes().entrySet()) {
                    String description;
                    if (sourceProperty.hasAttribute(targetEntry.getKey())) {
                        if (targetEntry.getValue().equals(sourceProperty.getAttributeValue(targetEntry.getKey()))) continue;
                        if (sourceProperty.getAttributeValue(targetEntry.getKey()).equals(transitionProperty.getAttributeValue(targetEntry.getKey()))) {
                            if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                                description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                                continue;
                            }
                            if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                                description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                                continue;
                            }
                            description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                            continue;
                        }
                        if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source || this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                            description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                            continue;
                        }
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                    modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                }
                for (Map.Entry<String, String> sourceEntry : sourceProperty.getAttributes().entrySet()) {
                    String description;
                    if (targetProperty.hasAttribute(sourceEntry.getKey()) || !transitionProperty.hasAttribute(sourceEntry.getKey()) || !transitionProperty.getAttributeValue(sourceEntry.getKey()).equals(sourceEntry.getValue())) continue;
                    if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                        continue;
                    }
                    description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName(), targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                    modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), description));
                }
                continue;
            }
            modifyItem = this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Add : ModifyType.InnerNode_Property_Add, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), targetProperty.getName(), String.format("\u3010%s %s\u3011\u8282\u70b9\u589e\u52a0\u3010%s\u3011\u5c5e\u6027", sourceNode.getNodeType(), sourceNode.getName(), targetProperty.getName()));
            modifyItems.add(modifyItem);
        }
        for (GOTProperty sourceProperty : sourceNode.getPropertys()) {
            if (targetNode.hasProperty(sourceProperty.getName())) continue;
            modifyItem = this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Delete : ModifyType.InnerNode_Property_Delete, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), sourceProperty.getName(), String.format("\u3010%s %s\u3011\u8282\u70b9\u5220\u9664\u3010%s\u3011\u5c5e\u6027", sourceNode.getNodeType(), sourceNode.getName(), sourceProperty.getName()));
            modifyItems.add(modifyItem);
        }
        return modifyItems;
    }

    protected List<Element> analysisReverseEntityNode(GOTEntity sourceEntity) throws VTDException {
        if (this.sourceGOT.getLayerLevel(sourceEntity.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetDataType = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        if (targetDataType == null) {
            boolean validRef = false;
            List<GOTProperty> refPropertys = this.sourceGOT.getRefEntityPropertys(sourceEntity.getId());
            for (GOTProperty refProperty : refPropertys) {
                GOTProperty property;
                GOTNode node;
                GOTNode refNode = refProperty.getGOTNode();
                GOTEntity refEntity = refNode.getEntity();
                if (this.sourceGOT.getLayerLevel(refEntity.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("\u5347\u7ea7\u5c42\u5220\u9664\u5b9e\u4f53%s\u3010%s\u3011,\u3010%s\u3011\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getNodeType(), sourceEntity.getName(), refEntity.getCreatedLayer(), refEntity.getEntityType().name(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName())));
                    validRef = true;
                    continue;
                }
                GOTEntity entity = this.targetGOT.getEntityById(refEntity.getEntityType(), refEntity.getId());
                if (entity == null || (node = entity.selectSingleNode(refNode.getEntityXPath())) == null || (property = node.getProperty(refProperty.getName())) == null || !refProperty.getRefEntityId().equals(property.getRefEntityId())) continue;
                modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("\u5347\u7ea7\u5c42\u5220\u9664\u5b9e\u4f53%s\u3010%s\u3011,%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getNodeType(), sourceEntity.getName(), refEntity.getCreatedLayer(), refEntity.getEntityType().name(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName())));
                validRef = true;
            }
            if (!validRef) {
                if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Must, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("\u5347\u7ea7\u5c42\u5220\u9664%s\u3010%s\u3011\u5b9e\u4f53", sourceEntity.getNodeType(), sourceEntity.getName())));
                } else {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("\u5347\u7ea7\u5c42\u5220\u9664%s\u3010%s\u3011\u5b9e\u4f53,\u5728\u3010%s\u3011\u5c42\u63d0\u5347\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer())));
                }
            }
        }
        return modifyItems;
    }

    protected List<Element> analysisReverseInnerNode(GOTNode sourceNode) throws VTDException {
        GOTNode targetNode;
        if (sourceNode == null || this.sourceGOT.getLayerLevel(sourceNode.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
            return Collections.EMPTY_LIST;
        }
        if ("ent".equals(sourceNode.getCreatedLayer())) {
            return Collections.EMPTY_LIST;
        }
        GOTEntity sourceEntity = sourceNode.getEntity();
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetEntity = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        if (targetEntity != null && (targetNode = targetEntity.selectSingleNode(sourceNode.getEntityXPath())) == null) {
            boolean validRef = false;
            List<GOTProperty> refPropertys = this.sourceGOT.getRefInnerPropertys(targetEntity.getId(), sourceNode.getId());
            for (GOTProperty refProperty : refPropertys) {
                GOTNode refNode = refProperty.getGOTNode();
                GOTEntity refEntity = refNode.getEntity();
                if ("TableField".equals(sourceNode.getNodeType()) && "FormDataSourceField".equals(refNode.getNodeType())) continue;
                if (this.sourceGOT.getLayerLevel(refEntity.getCreatedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                    if (this.targetGOT.getEntityById(refEntity.getEntityType(), refEntity.getId()) == null || this.sourceGOT.getLayerLevel(refNode.getCreatedLayer()) <= this.targetGOT.getTopLayerLevel()) continue;
                    modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5220\u9664%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9,%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c42\u65b0\u5efa\u7684%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), refEntity.getNodeType(), refEntity.getName(), refNode.getCreatedLayer(), refNode.getNodeType(), refNode.getName(), refProperty.getName())));
                    validRef = true;
                    continue;
                }
                modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5220\u9664%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9,\u3010%s\u3011\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName(), refEntity.getCreatedLayer(), refEntity.getNodeType(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName())));
                validRef = true;
            }
            if (!validRef) {
                modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u5220\u9664%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getNodeType(), sourceNode.getName())));
            }
        }
        return modifyItems;
    }

    protected Element createModifyItem(ModifyType modifyType, ModifyLevel modifyLevel, String nodeType, String innerId, String propertyName, String description) {
        Element modifyItem = DocumentHelper.createElement((String)"Item");
        modifyItem.addAttribute("modifyType", modifyType.name());
        modifyItem.addAttribute("modifyLevel", modifyLevel.name());
        modifyItem.addAttribute("nodeType", StringUtils.isNotBlank((String)nodeType) ? nodeType : "");
        modifyItem.addAttribute("innerId", StringUtils.isNotBlank((String)innerId) ? innerId : "");
        modifyItem.addAttribute("propertyName", StringUtils.isNotBlank((String)propertyName) ? propertyName : "");
        modifyItem.addAttribute("description", StringUtils.isNotBlank((String)description) ? description : "");
        modifyItem.addAttribute("select", Boolean.toString(modifyLevel == ModifyLevel.Must));
        return modifyItem;
    }

    protected Element aggregationEntityResult(GOTEntity enntity, List<Element> items) {
        Element entityResult = DocumentHelper.createElement((String)enntity.getEntityType().name());
        entityResult.addAttribute("id", enntity.getId());
        entityResult.addAttribute("name", enntity.getName());
        for (Element element : items) {
            entityResult.add(element);
        }
        return entityResult;
    }
}

