/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.analysis.BaseAnalysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class FormAnalysis
extends BaseAnalysis {
    public FormAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        super(sourceGOT, targetGOT, originalGOT);
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Form;
    }

    @Override
    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        String nodeBaseXPath = "FormDataSources";
        GOTNode targetFormDataSources = targetEntity.selectSingleNode(nodeBaseXPath);
        modifyItems.addAll(this.analysisInnerNode(targetFormDataSources));
        nodeBaseXPath = "FormDataSources/FormDataSource";
        for (GOTNode targetFormDataSource : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetFormDataSource));
            if (sourceEntity.selectSingleNode(targetFormDataSource.getEntityXPath()) == null) continue;
            nodeBaseXPath = "FormDataSourceFields/FormDataSourceField";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
            nodeBaseXPath = "FormDataSourceFieldGroups/FormDataSourceFieldGroup";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
            nodeBaseXPath = "FormDataSourceRelation/FormDataSourceRelationItem";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
        }
        nodeBaseXPath = "FormDesign";
        GOTNode targetFormDesign = targetEntity.selectSingleNode(nodeBaseXPath);
        modifyItems.addAll(this.analysisInnerNode(targetFormDesign));
        nodeBaseXPath = ".//FormItem";
        for (GOTNode targetFormItem : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetFormItem));
        }
        GOTNode transitionFormDesign = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId()).selectSingleNode("FormDesign");
        List<GOTNode> list = targetFormDesign.getChildNodeBFS(true);
        List<GOTNode> transitionFormItems = transitionFormDesign.getChildNodeBFS(true);
        if (list.size() == transitionFormItems.size()) {
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).getId() != null && !list.get(i).getId().equals(transitionFormItems.get(i).getId())) {
                    modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetFormDesign.getNodeType(), null, null, String.format("Form\u3010%s %s\u3011\u753b\u9762\u7ed3\u6784\u8c03\u6574", sourceEntity.getId(), sourceEntity.getName())));
                    break;
                }
                ++i;
            }
        } else {
            modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetFormDesign.getNodeType(), null, null, String.format("Form\u3010%s %s\u3011\u753b\u9762\u7ed3\u6784\u8c03\u6574", sourceEntity.getId(), sourceEntity.getName())));
        }
        return modifyItems;
    }

    @Override
    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> items = new ArrayList<Element>();
        for (GOTNode sourceFormDataSource : sourceEntity.selectNodes("FormDataSources/FormDataSource")) {
            items.addAll(this.analysisReverseInnerNode(sourceFormDataSource));
            GOTNode targetFormDataSource = targetEntity.selectSingleNode(sourceFormDataSource.getEntityXPath());
            if (targetFormDataSource == null) continue;
            for (GOTNode sourceFormDataSourceFieldGroup : sourceFormDataSource.selectNodes("FormDataSourceFieldGroups/FormDataSourceFieldGroup")) {
                items.addAll(this.analysisReverseInnerNode(sourceFormDataSourceFieldGroup));
            }
            for (GOTNode sourceFormDataSourceRelationItem : sourceFormDataSource.selectNodes("FormDataSourceRelation/FormDataSourceRelationItem")) {
                items.addAll(this.analysisReverseInnerNode(sourceFormDataSourceRelationItem));
            }
        }
        for (GOTNode sourceFormItem : sourceEntity.selectNodes("//FormItem")) {
            if (this.sourceGOT.isSourceDeployment(sourceFormItem.getCreatedLayer(), sourceEntity.getId())) continue;
            GOTNode targetFormItem = targetEntity.selectSingleNode(String.format("%s[@id='%s']", "//FormItem", sourceFormItem.getId()));
            if (targetFormItem != null) continue;
            items.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, "FormDesign", null, null, String.format("Form\u3010%s %s\u3011\u753b\u9762\u7ed3\u6784\u8c03\u6574", sourceEntity.getId(), sourceEntity.getName())));
            break;
        }
        return items;
    }
}

