/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.node;

import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class GOTEntity
extends GOTNode {
    private VTDNav entityNav;
    private XMLModifier modifier;
    private boolean modify = false;
    private ReentrantLock navLock = new ReentrantLock();

    public GOTEntity(VTDNav entityNav) throws VTDException {
        this.entityNav = entityNav;
        this.modifier = new XMLModifier();
        this.modifier.bind(entityNav);
        this.setEntity(this);
        this.setNodeIndex(entityNav.getRootIndex());
    }

    public VTDNav acquireEntityNav() {
        return this.acquireEntityNav(true);
    }

    VTDNav acquireEntityNav(boolean lock) {
        if (lock) {
            this.navLock.lock();
        }
        return this.entityNav;
    }

    public void releaseEntityNav() {
        if (this.navLock.isHeldByCurrentThread()) {
            this.navLock.unlock();
        }
    }

    synchronized XMLModifier getEntityModifier() {
        return this.modifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void applyModifier() throws VTDException, IOException {
        VTDNav vTDNav = this.entityNav;
        synchronized (vTDNav) {
            this.entityNav = this.modifier.outputAndReparse();
            this.setNodeIndex(this.entityNav.getRootIndex());
            this.modifier.reset();
            this.modifier.bind(this.entityNav);
            this.modify = true;
        }
    }

    public boolean hasModify() {
        return this.modify;
    }

    public EntityType getEntityType() {
        return EntityType.valueOf((String)this.getNodeType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GOTNode getChildNode(String nodeId) throws VTDException {
        VTDNav vTDNav = this.entityNav;
        synchronized (vTDNav) {
            this.recoverNode();
            if (VTDUtils.toXPathElement(this.entityNav, String.format("//*[@id='%s']", nodeId))) {
                return new GOTNode(this, this.entityNav.getCurrentIndex());
            }
        }
        return null;
    }

    public GOTEntity clone() {
        try {
            return new GOTEntity(this.entityNav.cloneNav());
        }
        catch (VTDException e) {
            throw new ERPException("clone GOTEntity Error", (Throwable)e);
        }
    }
}

