/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.node;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GOTProperty {
    public static final String ATTRIBUTE_INNERID = "innerid";
    public static final String ATTRIBUTE_REFENTITYID = "refentityid";
    public static final String ATTRIBUTE_REFINNERID = "refinnerid";
    private GOTNode node;
    private int propertyIndex;

    public GOTProperty(GOTNode node, int propertyIndex) throws NavException {
        this.node = node;
        this.propertyIndex = propertyIndex;
    }

    public String getName() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toFirstChildElement(entityNav, "Name")) {
                String string = entityNav.toString(entityNav.getText());
                return string;
            }
            throw new ERPException("\u89e3\u6790Proper\u5931\u8d25!");
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String getValue() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toFirstChildElement(entityNav, "Value")) {
                String value = null;
                int valueIndex = entityNav.getText();
                if (valueIndex != -1) {
                    value = entityNav.toString(valueIndex);
                }
                String string = value;
                return string;
            }
            throw new ERPException(String.format("\u89e3\u6790\u5b9e\u4f53\u3010%s %s\u3011\u8282\u70b9\u3010%s\u3011Property\u3010%s\u3011\u5931\u8d25\uff1a%s", this.node.getEntity().getId(), this.node.getEntity().getName(), this.node.getId(), this.getName(), this.node.dumpFragment()));
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValue(String value) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (StringUtils.isNotBlank((String)value)) {
                    value = VTDUtils.escapeChar(value);
                }
                if (VTDUtils.toFirstChildElement(entityNav, "Value")) {
                    int textIndex = entityNav.getText();
                    if (textIndex != -1) {
                        if (StringUtils.isNotBlank((String)value)) {
                            modifier.updateToken(textIndex, value);
                        } else {
                            modifier.removeToken(textIndex);
                        }
                    } else if (StringUtils.isNotBlank((String)value)) {
                        modifier.insertAfterHead(value);
                    }
                } else {
                    throw new ERPException("Property\u7ed3\u6784\u9519\u8bef\uff0c\u7f3a\u5c11Value\u8282\u70b9");
                }
            }
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public GOTNode getGOTNode() {
        return this.node;
    }

    public String getInnerId() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_INNERID);
            return string;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInnerId(String innerId) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_INNERID)) {
                    if (StringUtils.isNotBlank((String)innerId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_INNERID), innerId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_INNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)innerId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_INNERID, innerId));
                }
            }
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String getRefEntityId() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_REFENTITYID);
            return string;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRefEntityId(String entityId) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_REFENTITYID)) {
                    if (StringUtils.isNotBlank((String)entityId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_REFENTITYID), entityId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_REFENTITYID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)entityId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_REFENTITYID, entityId));
                }
            }
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String getRefInnerId() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.getAttributeValue(entityNav, ATTRIBUTE_REFINNERID);
            return string;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRefInnerId(String innerId) throws VTDException, IOException {
        try {
            XMLModifier modifier;
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            XMLModifier xMLModifier = modifier = this.node.getEntity().getEntityModifier();
            synchronized (xMLModifier) {
                this.recoverNode();
                if (entityNav.hasAttr(ATTRIBUTE_REFINNERID)) {
                    if (StringUtils.isNotBlank((String)innerId)) {
                        modifier.updateToken(entityNav.getAttrVal(ATTRIBUTE_REFINNERID), innerId);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_REFINNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)innerId)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\" ", ATTRIBUTE_REFINNERID, innerId));
                }
            }
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public void setAttribute(String innerId, String refEntityId, String refInnerId) {
        throw new RuntimeException("\u529f\u80fd\u672a\u5b9e\u73b0");
    }

    public boolean hasAttribute(String name) throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            boolean bl = VTDUtils.hasAttribute(entityNav, name);
            return bl;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String getAttributeValue(String name) throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.getAttributeValue(entityNav, name);
            return string;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String getAttributeValue(String name, String defaultValue) throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String value = VTDUtils.getAttributeValue(entityNav, name);
            String string = value == null ? defaultValue : value;
            return string;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(String name, String value) throws VTDException, IOException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            XMLModifier modifier = this.node.getEntity().getEntityModifier();
            this.recoverNode();
            XMLModifier xMLModifier = modifier;
            synchronized (xMLModifier) {
                if (VTDUtils.hasAttribute(entityNav, name)) {
                    if (StringUtils.isNotBlank((String)value)) {
                        modifier.updateToken(entityNav.getAttrVal(name), value);
                    } else {
                        AutoPilot pilot = new AutoPilot(entityNav);
                        pilot.selectAttr(ATTRIBUTE_INNERID);
                        int attrNameIndex = pilot.iterateAttr();
                        modifier.removeAttribute(attrNameIndex);
                    }
                } else if (StringUtils.isNotBlank((String)value)) {
                    modifier.insertAttribute(String.format(" %s=\"%s\"", name, value));
                }
            }
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public Map<String, String> getAttributes() throws PilotException, NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            Map<String, String> map = VTDUtils.getAttributes(entityNav);
            return map;
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    protected void recoverNode() throws NavException {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            entityNav.recoverNode(this.propertyIndex);
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String dumpFragment() {
        try {
            VTDNav entityNav = this.node.getEntity().acquireEntityNav();
            this.recoverNode();
            String string = VTDUtils.dumpFragment(entityNav);
            return string;
        }
        catch (NavException | IOException throwable) {
            throw new ERPException("GOTNode\u83b7\u53d6XML\u6bb5\u5931\u8d25!");
        }
        finally {
            this.node.getEntity().releaseEntityNav();
        }
    }

    public String toString() {
        return this.dumpFragment();
    }
}

