/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool.display;

import com.alibaba.fastjson.JSONObject;
import edu.emory.mathcs.backport.java.util.Arrays;
import info.gongqi.got.tool.display.AlignmentComposite;
import info.gongqi.got.tool.display.StyleComposit;
import info.gongqi.got.tool.display.TextFontComposite;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DisplayStyleDialog
extends Dialog {
    protected String result = "";
    protected Shell shell;
    private StyleComposit styleComposit;
    private AlignmentComposite alignmentComposite;
    private TextFontComposite textFontComposite;
    public String displayJsonText;

    public DisplayStyleDialog(Shell parent, int style, String displayJson) {
        super(parent, style);
        this.displayJsonText = displayJson;
    }

    public String open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(501, 405);
        this.shell.setText("DisplayStyle");
        this.shell.setLayout((Layout)new FormLayout());
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -45);
        tabFolder.setLayoutData((Object)formData);
        tabFolder.setLayout((Layout)new FormLayout());
        TabItem styleTabItem = new TabItem(tabFolder, 0);
        styleTabItem.setText("\u683c\u5f0f");
        this.styleComposit = new StyleComposit((Composite)tabFolder, 0);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.styleComposit.setLayoutData(formData);
        this.styleComposit.setBackground(Display.getDefault().getSystemColor(1));
        styleTabItem.setControl((Control)this.styleComposit);
        TabItem alignmentTabItem = new TabItem(tabFolder, 0);
        alignmentTabItem.setText("\u5bf9\u9f50");
        this.alignmentComposite = new AlignmentComposite((Composite)tabFolder, 0);
        this.alignmentComposite.setLayoutData(formData);
        this.alignmentComposite.setBackground(Display.getDefault().getSystemColor(1));
        alignmentTabItem.setControl((Control)this.alignmentComposite);
        TabItem fontTabItem = new TabItem(tabFolder, 0);
        fontTabItem.setText("\u5b57\u4f53");
        this.textFontComposite = new TextFontComposite((Composite)tabFolder, 0);
        this.textFontComposite.setLayoutData(formData);
        this.textFontComposite.setBackground(Display.getDefault().getSystemColor(1));
        fontTabItem.setControl((Control)this.textFontComposite);
        Button reset_Button = new Button((Composite)this.shell, 0);
        reset_Button.setText("\u91cd\u7f6e");
        formData = new FormData(60, 30);
        formData.right = new FormAttachment(100, -10);
        formData.bottom = new FormAttachment(100, -10);
        reset_Button.setLayoutData((Object)formData);
        Button cancel_Button = new Button((Composite)this.shell, 0);
        cancel_Button.setText("\u53d6\u6d88");
        formData = new FormData(60, 30);
        formData.bottom = new FormAttachment((Control)reset_Button, 0, 1024);
        formData.right = new FormAttachment((Control)reset_Button, -20, 16384);
        cancel_Button.setLayoutData((Object)formData);
        Button confirm_Button = new Button((Composite)this.shell, 0);
        formData = new FormData(60, 30);
        formData.bottom = new FormAttachment((Control)cancel_Button, 0, 1024);
        formData.right = new FormAttachment((Control)cancel_Button, -20, 16384);
        confirm_Button.setLayoutData((Object)formData);
        confirm_Button.setText("\u786e\u5b9a");
        confirm_Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSONObject obj = DisplayStyleDialog.this.styleComposit.getJson();
                obj.putAll((Map)DisplayStyleDialog.this.alignmentComposite.getJson());
                JSONObject cssStyleJson = DisplayStyleDialog.this.textFontComposite.getJson();
                RGB colorValue = ((DisplayStyleDialog)DisplayStyleDialog.this).alignmentComposite.colorEditor.getColorValue();
                if (colorValue != null) {
                    cssStyleJson.put("color", (Object)String.format("#%02X%02X%02X", colorValue.red, colorValue.green, colorValue.blue));
                }
                obj.put("cssStyle", (Object)cssStyleJson);
                DisplayStyleDialog.this.result = obj.toJSONString();
                DisplayStyleDialog.this.shell.close();
            }
        });
        cancel_Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplayStyleDialog.this.result = DisplayStyleDialog.this.displayJsonText;
                DisplayStyleDialog.this.shell.close();
            }
        });
        reset_Button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.styleComposit.reset();
            this.alignmentComposite.reset();
            this.textFontComposite.reset();
        }));
        if (StringUtils.isNotBlank((String)this.displayJsonText)) {
            JSONObject cssStyleJson;
            JSONObject displayJson = JSONObject.parseObject((String)this.displayJsonText);
            this.styleComposit.after(displayJson);
            if (displayJson.containsKey((Object)"HorizontalAlignment")) {
                String horizontalAlignment = displayJson.getString("HorizontalAlignment");
                if ("Left".equals(horizontalAlignment)) {
                    this.alignmentComposite.horizontalAlignment_combo.setText("\u9760\u5de6");
                } else if ("Right".equals(horizontalAlignment)) {
                    this.alignmentComposite.horizontalAlignment_combo.setText("\u9760\u53f3");
                } else if ("Center".equals(horizontalAlignment)) {
                    this.alignmentComposite.horizontalAlignment_combo.setText("\u5c45\u4e2d");
                } else if ("Top".equals(horizontalAlignment)) {
                    this.alignmentComposite.horizontalAlignment_combo.setText("\u9760\u4e0a");
                } else if ("Bottom".equals(horizontalAlignment)) {
                    this.alignmentComposite.horizontalAlignment_combo.setText("\u9760\u4e0b");
                }
            }
            if (displayJson.containsKey((Object)"VerticalAlignment")) {
                String verticalAlignment = displayJson.getString("VerticalAlignment");
                if ("Left".equals(verticalAlignment)) {
                    this.alignmentComposite.verticalAlignment_combo.setText("\u9760\u5de6");
                } else if ("Right".equals(verticalAlignment)) {
                    this.alignmentComposite.verticalAlignment_combo.setText("\u9760\u53f3");
                } else if ("Center".equals(verticalAlignment)) {
                    this.alignmentComposite.verticalAlignment_combo.setText("\u5c45\u4e2d");
                } else if ("Top".equals(verticalAlignment)) {
                    this.alignmentComposite.verticalAlignment_combo.setText("\u9760\u4e0a");
                } else if ("Bottom".equals(verticalAlignment)) {
                    this.alignmentComposite.verticalAlignment_combo.setText("\u9760\u4e0b");
                }
            }
            if ((cssStyleJson = displayJson.getJSONObject("cssStyle")) != null) {
                if (cssStyleJson.containsKey((Object)"Color")) {
                    String colorText = cssStyleJson.getString("Color");
                    int red = Integer.valueOf(colorText.substring(1, 3), 16);
                    int green = Integer.valueOf(colorText.substring(3, 5), 16);
                    int blue = Integer.valueOf(colorText.substring(5, 7), 16);
                    this.alignmentComposite.colorEditor.setColorValue(new RGB(red, green, blue));
                }
                if (cssStyleJson.containsKey((Object)"fontFamily")) {
                    String fontFamily = cssStyleJson.getString("fontFamily");
                    int index = Arrays.asList((Object[])this.textFontComposite.fontFamily.getItems()).indexOf(fontFamily);
                    if (index >= 0) {
                        this.textFontComposite.fontFamily.select(index);
                    }
                }
                if (cssStyleJson.containsKey((Object)"fontStyle") && cssStyleJson.containsKey((Object)"fontWeight")) {
                    String fontStyle = cssStyleJson.getString("fontStyle");
                    String fontWeight = cssStyleJson.getString("fontWeight");
                    String fontStyleAndWeight = null;
                    if ("normal".equals(fontStyle) && StringUtils.isBlank((String)fontWeight)) {
                        fontStyleAndWeight = "\u5e38\u89c4";
                    } else if ("italic".equals(fontStyle) && StringUtils.isBlank((String)fontWeight)) {
                        fontStyleAndWeight = "\u659c\u4f53";
                    } else if (StringUtils.isBlank((String)fontStyle) && "bold".equals(fontWeight)) {
                        fontStyleAndWeight = "\u7c97\u4f53";
                    } else if ("italic".equals(fontStyle) && "bold".equals(fontWeight)) {
                        fontStyleAndWeight = "\u659c\u4f53\u52a0\u7c97";
                    }
                    int index = Arrays.asList((Object[])this.textFontComposite.fontStyleAndWeight.getItems()).indexOf(fontStyleAndWeight);
                    if (index >= 0) {
                        this.textFontComposite.fontStyleAndWeight.select(index);
                    }
                }
                if (cssStyleJson.containsKey((Object)"fontSize")) {
                    String fontSize = cssStyleJson.getString("fontSize");
                    int index = Arrays.asList((Object[])this.textFontComposite.fontSize.getItems()).indexOf(fontSize);
                    if (index >= 0) {
                        this.textFontComposite.fontSize.select(index);
                    }
                }
            }
        }
    }
}

